/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.elements;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.wipo.xsd2json.schema.builders.elements.EnumElementBuilder;
import org.wipo.xsd2json.schema.builders.elements.SimpleRestrictionElementBuilder;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;

public class AttributeElementBuilder {
    XmlSchemaAttribute attribute;
    long parentMaxOccurs;
    boolean createDefsOnlyEntry;
    File xsdFile;
    Map<String, String> typeRefAnnex;
    String jsonSchemaExt;
    String versionTxt;

    public AttributeElementBuilder(XmlSchemaAttribute attribute, long parentMaxOccurs, boolean createDefsOnlyEntry, File xsdFile, Map<String, String> typeRefAnnex, String jsonSchemaExt, String versionTxt) {
        this.attribute = attribute;
        this.parentMaxOccurs = parentMaxOccurs;
        this.createDefsOnlyEntry = createDefsOnlyEntry;
        this.xsdFile = xsdFile;
        this.typeRefAnnex = typeRefAnnex;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    public BaseJsonElement build() {
        return this.addAttributeToDefinitions(this.attribute);
    }

    private BaseJsonElement addAttributeToDefinitions(XmlSchemaAttribute attribute) {
        XmlSchemaSimpleTypeContent simpleTypeContent;
        String name;
        String string = name = attribute.getName() != null ? attribute.getName() : attribute.getRefBase().getTargetQName().getLocalPart();
        String type = attribute.getSchemaTypeName() != null && attribute.getSchemaTypeName().getLocalPart() != null ? attribute.getSchemaTypeName().getLocalPart() : (attribute.getRefBase() != null && attribute.getRefBase().getTargetQName() != null ? attribute.getRefBase().getTargetQName().getLocalPart() : "anySimpleType");
        boolean required = this.typeRefAnnex.size() <= 1 ? true : "required".equalsIgnoreCase(attribute.getUse().toString());
        String fixedVal = attribute.getFixedValue();
        XmlSchemaAnnotation annotation = attribute.getAnnotation();
        XmlSchemaSimpleType simpleType = attribute.getSchemaType();
        if (simpleType != null && simpleType.isAnonymous() && (simpleTypeContent = simpleType.getContent()) instanceof XmlSchemaSimpleTypeRestriction) {
            boolean enumType = false;
            List<XmlSchemaFacet> facets = ((XmlSchemaSimpleTypeRestriction)simpleTypeContent).getFacets();
            if (!facets.isEmpty()) {
                ArrayList enumList = new ArrayList();
                for (XmlSchemaFacet facet : facets) {
                    if (!(facet instanceof XmlSchemaEnumerationFacet)) continue;
                    enumType = true;
                    break;
                }
            }
            BaseJsonElement bje = null;
            simpleType.setName(name);
            if (enumType) {
                EnumElementBuilder eeb = new EnumElementBuilder(simpleType, 1L, fixedVal, this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
                bje = eeb.build();
            } else {
                SimpleRestrictionElementBuilder sreb = new SimpleRestrictionElementBuilder(simpleType, this.parentMaxOccurs, fixedVal, this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
                bje = sreb.build();
            }
            return bje;
        }
        BaseJsonElement bjs = new BaseJsonElement(name, type, required ? 1L : 0L, 1L, this.parentMaxOccurs, this.typeRefAnnex, annotation, null, fixedVal, this.createDefsOnlyEntry, this.xsdFile.getPath(), this.jsonSchemaExt, this.versionTxt);
        return bjs;
    }
}

