<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:tmk="http://www.wipo.int/standards/XMLSchema/ST96/Trademark" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:mathml="http://www.w3.org/1998/Math/MathML" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:WIPO="http://www.altova.com/MapForce/UDF/WIPO" xmlns:vmf="http://www.altova.com/MapForce/UDF/vmf" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:ns0="http://www.wipo.int/standards/XMLSchema/trademarks" exclude-result-prefixes="WIPO vmf xs fn ns0">
	<xsl:param name="st66model-V1-13" select="'st66model-V1-1.xml'"/>
	<xsl:param name="st66model-V1-14" select="'st66model-V1-1.xml'"/>
	<xsl:param name="st66model-V1-15" select="'st66model-V1-1.xml'"/>
	<xsl:param name="st66model-V1-16" select="'st66model-V1-1.xml'"/>
	<xsl:template name="WIPO:MappingST66ApplicantToST96Applicant">
		<xsl:param name="Applicant" select="()"/>
		<xsl:variable name="var8_operationCode" as="node()?" select="$Applicant/@operationCode"/>
		<tmk:Applicant>
			<xsl:if test="fn:exists($var8_operationCode)">
				<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf47_inputtoresult">
						<xsl:with-param name="input" select="fn:string($var8_operationCode)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="fn:exists($var1_resultof_vmf___inputtoresult)">
					<xsl:attribute name="com:operationCategory" select="$var1_resultof_vmf___inputtoresult"/>
				</xsl:if>
			</xsl:if>
			<xsl:for-each select="$Applicant/ns0:ApplicantSequenceNumber">
				<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:ApplicantLegalEntity">
				<com:LegalEntityName>
					<xsl:sequence select="fn:string(.)"/>
				</com:LegalEntityName>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:ApplicantNationalityCode">
				<com:NationalityCode>
					<xsl:sequence select="fn:string(.)"/>
				</com:NationalityCode>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:ApplicantIncorporationCountryCode">
				<com:IncorporationCountryCode>
					<xsl:sequence select="fn:string(.)"/>
				</com:IncorporationCountryCode>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:ApplicantIncorporationState">
				<com:IncorporationState>
					<xsl:sequence select="fn:string(.)"/>
				</com:IncorporationState>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:Comment">
				<xsl:variable name="var2_languageCode" as="node()?" select="@languageCode"/>
				<com:CommentText>
					<xsl:if test="fn:exists($var2_languageCode)">
						<xsl:attribute name="com:languageCode" select="fn:string($var2_languageCode)"/>
					</xsl:if>
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:ApplicantEntitlement">
				<tmk:Entitlement>
					<xsl:for-each select="ns0:EntitlementNationalityCode">
						<com:EntitlementNationalityCode>
							<xsl:sequence select="fn:string(.)"/>
						</com:EntitlementNationalityCode>
					</xsl:for-each>
					<xsl:for-each select="ns0:EntitlementEstablishment">
						<com:EntitlementEstablishment>
							<xsl:for-each select="ns0:EntitlementEstablishmentCode">
								<com:EntitlementEstablishmentCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:EntitlementEstablishmentCode>
							</xsl:for-each>
							<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
								<xsl:variable name="var3_resultof_MappingST__AddressBookToST__Contact" as="node()?">
									<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
										<xsl:with-param name="AddressBook" as="node()">
											<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
												<xsl:sequence select="(./@node(), ./node())"/>
											</AddressBookType>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var3_resultof_MappingST__AddressBookToST__Contact">
									<com:Contact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:Contact>
								</xsl:for-each>
							</xsl:for-each>
						</com:EntitlementEstablishment>
					</xsl:for-each>
					<xsl:for-each select="ns0:EntitlementDomiciled">
						<com:EntitlementDomiciled>
							<xsl:for-each select="ns0:EntitlementDomiciledCode">
								<com:EntitlementDomiciledCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:EntitlementDomiciledCode>
							</xsl:for-each>
							<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
								<xsl:variable name="var4_resultof_MappingST__AddressBookToST__Contact" as="node()?">
									<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
										<xsl:with-param name="AddressBook" as="node()">
											<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
												<xsl:sequence select="(./@node(), ./node())"/>
											</AddressBookType>
										</xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:for-each select="$var4_resultof_MappingST__AddressBookToST__Contact">
									<com:Contact>
										<xsl:sequence select="(./@node(), ./node())"/>
									</com:Contact>
								</xsl:for-each>
							</xsl:for-each>
						</com:EntitlementDomiciled>
					</xsl:for-each>
				</tmk:Entitlement>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:ApplicantVersion">
				<com:Version>
					<xsl:for-each select="ns0:Comment">
						<xsl:variable name="var5_languageCode" as="node()?" select="@languageCode"/>
						<com:CommentText>
							<xsl:if test="fn:exists($var5_languageCode)">
								<xsl:attribute name="com:languageCode" select="fn:string($var5_languageCode)"/>
							</xsl:if>
							<xsl:sequence select="fn:string(.)"/>
						</com:CommentText>
					</xsl:for-each>
					<xsl:for-each select="ns0:VersionNumber">
						<com:VersionNumber>
							<xsl:sequence select="fn:string(.)"/>
						</com:VersionNumber>
					</xsl:for-each>
					<xsl:for-each select="ns0:VersionDate">
						<com:VersionDate>
							<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
						</com:VersionDate>
					</xsl:for-each>
					<xsl:for-each select="ns0:VersionDateTime">
						<com:VersionDateTime>
							<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
						</com:VersionDateTime>
					</xsl:for-each>
				</com:Version>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:ApplicantIdentifier">
				<xsl:variable name="var6_identifierKindCode" as="node()?" select="@identifierKindCode"/>
				<com:PartyIdentifier>
					<xsl:if test="fn:exists($var6_identifierKindCode)">
						<xsl:attribute name="com:officeCode" select="fn:string($var6_identifierKindCode)"/>
					</xsl:if>
					<xsl:sequence select="fn:string(.)"/>
				</com:PartyIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Applicant/ns0:ApplicantAddressBook">
				<xsl:variable name="var7_resultof_MappingST__AddressBookToST__Contact" as="node()?">
					<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
						<xsl:with-param name="AddressBook" as="node()">
							<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
								<xsl:sequence select="(./@node(), ./node())"/>
							</AddressBookType>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var7_resultof_MappingST__AddressBookToST__Contact">
					<com:Contact>
						<xsl:sequence select="(./@node(), ./node())"/>
					</com:Contact>
				</xsl:for-each>
			</xsl:for-each>
		</tmk:Applicant>
	</xsl:template>
	<xsl:template name="WIPO:MappingST66RepresentativeToST96Representative">
		<xsl:param name="Representative" select="()"/>
		<xsl:variable name="var8_operationCode" as="node()?" select="$Representative/@operationCode"/>
		<com:Representative>
			<xsl:if test="fn:exists($var8_operationCode)">
				<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
					<xsl:call-template name="vmf:vmf48_inputtoresult">
						<xsl:with-param name="input" select="fn:string($var8_operationCode)" as="xs:string"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:if test="fn:exists($var1_resultof_vmf___inputtoresult)">
					<xsl:attribute name="operationCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="$var1_resultof_vmf___inputtoresult"/>
				</xsl:if>
			</xsl:if>
			<xsl:for-each select="$Representative/ns0:RepresentativeSequenceNumber">
				<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:integer(fn:string(.)))"/>
			</xsl:for-each>
			<xsl:for-each select="$Representative/ns0:RepresentativeLegalEntity">
				<com:LegalEntityName>
					<xsl:sequence select="fn:string(.)"/>
				</com:LegalEntityName>
			</xsl:for-each>
			<xsl:for-each select="$Representative/ns0:RepresentativeNationalityCode">
				<com:NationalityCode>
					<xsl:sequence select="fn:string(.)"/>
				</com:NationalityCode>
			</xsl:for-each>
			<xsl:for-each select="$Representative/ns0:RepresentativeIncorporationCountryCode">
				<com:IncorporationCountryCode>
					<xsl:sequence select="fn:string(.)"/>
				</com:IncorporationCountryCode>
			</xsl:for-each>
			<xsl:for-each select="$Representative/ns0:RepresentativeIncorporationState">
				<com:IncorporationState>
					<xsl:sequence select="fn:string(.)"/>
				</com:IncorporationState>
			</xsl:for-each>
			<xsl:variable name="var3_resultof_filter" as="node()*">
				<xsl:for-each select="$Representative/ns0:RepresentativeKindCode">
					<xsl:variable name="var2_resultof_vmf___inputtoresult" as="xs:string?">
						<xsl:call-template name="vmf:vmf49_inputtoresult">
							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="fn:exists($var2_resultof_vmf___inputtoresult)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:for-each select="$var3_resultof_filter">
				<com:RepresentativeCategory>
					<xsl:call-template name="vmf:vmf49_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</com:RepresentativeCategory>
			</xsl:for-each>
			<xsl:for-each select="$Representative/ns0:Comment">
				<xsl:variable name="var4_languageCode" as="node()?" select="@languageCode"/>
				<com:CommentText>
					<xsl:if test="fn:exists($var4_languageCode)">
						<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string($var4_languageCode)"/>
					</xsl:if>
					<xsl:sequence select="fn:string(.)"/>
				</com:CommentText>
			</xsl:for-each>
			<xsl:for-each select="$Representative/ns0:RepresentativeVersion">
				<com:Version>
					<xsl:for-each select="ns0:Comment">
						<xsl:variable name="var5_languageCode" as="node()?" select="@languageCode"/>
						<com:CommentText>
							<xsl:if test="fn:exists($var5_languageCode)">
								<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string($var5_languageCode)"/>
							</xsl:if>
							<xsl:sequence select="fn:string(.)"/>
						</com:CommentText>
					</xsl:for-each>
					<xsl:for-each select="ns0:VersionNumber">
						<com:VersionNumber>
							<xsl:sequence select="fn:string(.)"/>
						</com:VersionNumber>
					</xsl:for-each>
					<xsl:for-each select="ns0:VersionDate">
						<com:VersionDate>
							<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
						</com:VersionDate>
					</xsl:for-each>
					<xsl:for-each select="ns0:VersionDateTime">
						<com:VersionDateTime>
							<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
						</com:VersionDateTime>
					</xsl:for-each>
				</com:Version>
			</xsl:for-each>
			<xsl:for-each select="$Representative/ns0:RepresentativeIdentifier">
				<xsl:variable name="var6_identifierKindCode" as="node()?" select="@identifierKindCode"/>
				<com:PartyIdentifier>
					<xsl:if test="fn:exists($var6_identifierKindCode)">
						<xsl:attribute name="officeCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string($var6_identifierKindCode)"/>
					</xsl:if>
					<xsl:sequence select="fn:string(.)"/>
				</com:PartyIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Representative/ns0:RepresentativeAddressBook">
				<xsl:variable name="var7_resultof_MappingST__AddressBookToST__Contact" as="node()?">
					<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
						<xsl:with-param name="AddressBook" as="node()">
							<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
								<xsl:sequence select="(./@node(), ./node())"/>
							</AddressBookType>
						</xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:for-each select="$var7_resultof_MappingST__AddressBookToST__Contact">
					<com:Contact>
						<xsl:sequence select="(./@node(), ./node())"/>
					</com:Contact>
				</xsl:for-each>
			</xsl:for-each>
		</com:Representative>
	</xsl:template>
	<xsl:template name="WIPO:MappingST66OppositionToST96Opposition">
		<xsl:param name="Opposition" select="()"/>
		<tmk:Opposition>
			<xsl:for-each select="$Opposition/ns0:OppositionIdentifier">
				<com:OppositionIdentifier>
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionIdentifier>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OppositionDate">
				<com:OppositionDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:OppositionDate>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OppositionReference">
				<com:OppositionReference>
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionReference>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OppositionLanguageCode">
				<com:OppositionLanguageCode>
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionLanguageCode>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:ProceedingLanguageCode">
				<com:ProceedingLanguageCode>
					<xsl:sequence select="fn:string(.)"/>
				</com:ProceedingLanguageCode>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:EarlierRightDate">
				<com:EarlierRightDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:EarlierRightDate>
			</xsl:for-each>
			<xsl:variable name="var2_resultof_filter" as="node()*">
				<xsl:for-each select="$Opposition/ns0:EarlierRightKind">
					<xsl:variable name="var1_resultof_vmf___inputtoresult" as="xs:string?">
						<xsl:call-template name="vmf:vmf50_inputtoresult">
							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="fn:exists($var1_resultof_vmf___inputtoresult)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:for-each select="$var2_resultof_filter">
				<com:EarlierRightCategory>
					<xsl:call-template name="vmf:vmf50_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</com:EarlierRightCategory>
			</xsl:for-each>
			<xsl:variable name="var4_resultof_filter" as="node()*">
				<xsl:for-each select="$Opposition/ns0:OppositionBasisCode">
					<xsl:variable name="var3_resultof_vmf___inputtoresult" as="xs:string?">
						<xsl:call-template name="vmf:vmf51_inputtoresult">
							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="fn:exists($var3_resultof_vmf___inputtoresult)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:for-each select="$var4_resultof_filter">
				<tmk:OppositionBasisCategory>
					<xsl:call-template name="vmf:vmf51_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</tmk:OppositionBasisCategory>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OppositionGroundText">
				<xsl:variable name="var5_languageCode" as="node()?" select="@languageCode"/>
				<com:OppositionGroundText>
					<xsl:if test="fn:exists($var5_languageCode)">
						<xsl:attribute name="com:languageCode" select="fn:string($var5_languageCode)"/>
					</xsl:if>
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionGroundText>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OppositionExtentText">
				<xsl:variable name="var6_languageCode" as="node()?" select="@languageCode"/>
				<com:OppositionExtentText>
					<xsl:if test="fn:exists($var6_languageCode)">
						<xsl:attribute name="com:languageCode" select="fn:string($var6_languageCode)"/>
					</xsl:if>
					<xsl:sequence select="fn:string(.)"/>
				</com:OppositionExtentText>
			</xsl:for-each>
			<xsl:variable name="var8_resultof_filter" as="node()*">
				<xsl:for-each select="$Opposition/ns0:OppositionCurrentStatusCode">
					<xsl:variable name="var7_resultof_vmf___inputtoresult" as="xs:string?">
						<xsl:call-template name="vmf:vmf52_inputtoresult">
							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
						</xsl:call-template>
					</xsl:variable>
					<xsl:if test="fn:exists($var7_resultof_vmf___inputtoresult)">
						<xsl:sequence select="."/>
					</xsl:if>
				</xsl:for-each>
			</xsl:variable>
			<xsl:for-each select="$var8_resultof_filter">
				<tmk:OppositionCurrentStatusCategory>
					<xsl:call-template name="vmf:vmf52_inputtoresult">
						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
					</xsl:call-template>
				</tmk:OppositionCurrentStatusCategory>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OppositionCurrentStatusDate">
				<com:OppositionCurrentStatusDate>
					<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
				</com:OppositionCurrentStatusDate>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:EarlierMarkDetails">
				<tmk:EarlierMarkBag>
					<xsl:for-each select="ns0:EarlierMark">
						<tmk:EarlierMark>
							<xsl:for-each select="ns0:EarlierMarkCountryCode">
								<tmk:EarlierMarkCountryCode>
									<xsl:sequence select="fn:string(.)"/>
								</tmk:EarlierMarkCountryCode>
							</xsl:for-each>
							<xsl:variable name="var10_resultof_filter" as="node()*">
								<xsl:for-each select="ns0:EarlierMarkKind">
									<xsl:variable name="var9_resultof_vmf___inputtoresult" as="xs:string?">
										<xsl:call-template name="vmf:vmf53_inputtoresult">
											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:if test="fn:exists($var9_resultof_vmf___inputtoresult)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:for-each select="$var10_resultof_filter">
								<tmk:EarlierMarkCategory>
									<xsl:call-template name="vmf:vmf53_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</tmk:EarlierMarkCategory>
							</xsl:for-each>
							<tmk:BaseGoodsServicesBag>
								<xsl:for-each select="ns0:BaseGoodsServicesDetails/ns0:GoodsServices">
									<tmk:GoodsServices>
										<xsl:for-each select="ns0:ClassificationKindCode">
											<tmk:ClassificationKindCode>
												<xsl:sequence select="fn:string(.)"/>
											</tmk:ClassificationKindCode>
										</xsl:for-each>
										<xsl:for-each select="ns0:ClassificationVersion">
											<com:ClassificationVersion>
												<xsl:sequence select="fn:string(.)"/>
											</com:ClassificationVersion>
										</xsl:for-each>
										<xsl:for-each select="ns0:Comment">
											<xsl:variable name="var11_languageCode" as="node()?" select="@languageCode"/>
											<com:CommentText>
												<xsl:if test="fn:exists($var11_languageCode)">
													<xsl:attribute name="com:languageCode" select="fn:string($var11_languageCode)"/>
												</xsl:if>
												<xsl:sequence select="fn:string(.)"/>
											</com:CommentText>
										</xsl:for-each>
										<xsl:for-each select="ns0:ProposedLeadingClassNumber">
											<tmk:ProposedLeadingClassNumber>
												<xsl:sequence select="fn:string(.)"/>
											</tmk:ProposedLeadingClassNumber>
										</xsl:for-each>
										<xsl:for-each select="ns0:ClassDescriptionDetails">
											<tmk:ClassDescriptionBag>
												<xsl:for-each select="ns0:ClassDescription">
													<tmk:ClassDescription>
														<xsl:for-each select="ns0:ClassNumber">
															<tmk:ClassNumber>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:ClassNumber>
														</xsl:for-each>
														<xsl:for-each select="ns0:ClassNumberStatusCode">
															<tmk:ClassNumberStatusCategory>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:ClassNumberStatusCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:GoodsServicesDescription">
															<xsl:variable name="var12_languageCode" as="node()?" select="@languageCode"/>
															<xsl:variable name="var13_sequenceNumber" as="node()?" select="@sequenceNumber"/>
															<tmk:GoodsServicesDescriptionText>
																<xsl:if test="fn:exists($var12_languageCode)">
																	<xsl:attribute name="com:languageCode" select="fn:string($var12_languageCode)"/>
																</xsl:if>
																<xsl:if test="fn:exists($var13_sequenceNumber)">
																	<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var13_sequenceNumber)))"/>
																</xsl:if>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:GoodsServicesDescriptionText>
														</xsl:for-each>
														<xsl:for-each select="ns0:UseNiceHeadingIndicator">
															<tmk:UseNiceHeadingIndicator>
																<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
															</tmk:UseNiceHeadingIndicator>
														</xsl:for-each>
														<xsl:for-each select="ns0:ClassificationTermDetails">
															<tmk:ClassificationTermBag>
																<xsl:for-each select="ns0:ClassificationTerm">
																	<xsl:variable name="var17_operationCode" as="node()?" select="@operationCode"/>
																	<tmk:ClassificationTerm>
																		<xsl:if test="fn:exists($var17_operationCode)">
																			<xsl:attribute name="com:operationCategory" select="fn:string($var17_operationCode)"/>
																		</xsl:if>
																		<xsl:for-each select="ns0:ClassificationTermIdentifier">
																			<xsl:variable name="var14_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<tmk:ClassificationTermIdentifier>
																				<xsl:if test="fn:exists($var14_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var14_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermOffice">
																			<tmk:ClassificationTermOfficeCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermOfficeCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																			<tmk:ClassificationTermOfficeIdentification>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermOfficeIdentification>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermSource">
																			<tmk:ClassificationTermSourceCategory>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermSourceCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermEntryDate">
																			<tmk:ClassificationTermEntryDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</tmk:ClassificationTermEntryDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassNumber">
																			<tmk:ClassNumber>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassNumber>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermText">
																			<xsl:variable name="var15_languageCode" as="node()?" select="@languageCode"/>
																			<tmk:ClassificationTermText>
																				<xsl:if test="fn:exists($var15_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var15_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																			<tmk:ClassificationTermEquivalentGroup>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermEquivalentGroup>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																			<tmk:ClassificationTermReferenceGroup>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermReferenceGroup>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																			<tmk:ClassificationTermTranslationGroup>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermTranslationGroup>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationTermStatus">
																			<xsl:variable name="var16_officeCode" as="node()?" select="@officeCode"/>
																			<tmk:ClassificationTermStatus>
																				<xsl:if test="fn:exists($var16_officeCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var16_officeCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationTermStatus>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:WIPOBasicNumber">
																			<tmk:WIPOBasicNumber>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:WIPOBasicNumber>
																		</xsl:for-each>
																	</tmk:ClassificationTerm>
																</xsl:for-each>
															</tmk:ClassificationTermBag>
														</xsl:for-each>
													</tmk:ClassDescription>
												</xsl:for-each>
											</tmk:ClassDescriptionBag>
										</xsl:for-each>
									</tmk:GoodsServices>
								</xsl:for-each>
							</tmk:BaseGoodsServicesBag>
							<xsl:for-each select="ns0:ApplicationNumber">
								<com:ApplicationNumber>
									<com:ApplicationNumberText>
										<xsl:sequence select="fn:string(.)"/>
									</com:ApplicationNumberText>
								</com:ApplicationNumber>
							</xsl:for-each>
							<xsl:for-each select="ns0:RegistrationNumber">
								<com:RegistrationNumber>
									<xsl:sequence select="fn:string(.)"/>
								</com:RegistrationNumber>
							</xsl:for-each>
							<xsl:for-each select="ns0:ApplicationDate">
								<tmk:ApplicationDate>
									<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
								</tmk:ApplicationDate>
							</xsl:for-each>
							<xsl:for-each select="ns0:RegistrationDate">
								<com:RegistrationDate>
									<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
								</com:RegistrationDate>
							</xsl:for-each>
							<xsl:variable name="var19_resultof_filter" as="node()*">
								<xsl:for-each select="ns0:MarkFeature">
									<xsl:variable name="var18_resultof_vmf___inputtoresult" as="xs:string?">
										<xsl:call-template name="vmf:vmf54_inputtoresult">
											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:if test="fn:exists($var18_resultof_vmf___inputtoresult)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:for-each select="$var19_resultof_filter">
								<tmk:MarkFeatureCategory>
									<xsl:call-template name="vmf:vmf54_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</tmk:MarkFeatureCategory>
							</xsl:for-each>
							<xsl:for-each select="ns0:MarkImageDetails">
								<tmk:MarkImageBag>
									<xsl:for-each select="ns0:MarkImage">
										<xsl:variable name="var37_MarkImageRepresentationSize" as="node()*" select="ns0:MarkImageRepresentationSize"/>
										<tmk:MarkImage>
											<xsl:for-each select="ns0:MarkImageFilename">
												<com:FileName>
													<xsl:sequence select="fn:string(.)"/>
												</com:FileName>
											</xsl:for-each>
											<xsl:variable name="var21_resultof_filter" as="node()*">
												<xsl:for-each select="ns0:MarkImageFileFormat">
													<xsl:variable name="var20_resultof_vmf___inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf11_inputtoresult">
															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<xsl:if test="fn:exists($var20_resultof_vmf___inputtoresult)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:for-each>
											</xsl:variable>
											<xsl:for-each select="$var21_resultof_filter">
												<com:ImageFormatCategory>
													<xsl:call-template name="vmf:vmf11_inputtoresult">
														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
													</xsl:call-template>
												</com:ImageFormatCategory>
											</xsl:for-each>
											<xsl:for-each select="ns0:MarkImageColourClaimedText">
												<xsl:variable name="var22_sequenceNumber" as="node()?" select="@sequenceNumber"/>
												<xsl:variable name="var23_languageCode" as="node()?" select="@languageCode"/>
												<tmk:MarkImageColourClaimedText>
													<xsl:if test="fn:exists($var23_languageCode)">
														<xsl:attribute name="com:languageCode" select="fn:string($var23_languageCode)"/>
													</xsl:if>
													<xsl:if test="fn:exists($var22_sequenceNumber)">
														<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var22_sequenceNumber)))"/>
													</xsl:if>
													<xsl:sequence select="fn:string(.)"/>
												</tmk:MarkImageColourClaimedText>
											</xsl:for-each>
											<xsl:for-each select="ns0:MarkImageColourPartClaimedText">
												<xsl:variable name="var24_sequenceNumber" as="node()?" select="@sequenceNumber"/>
												<xsl:variable name="var25_languageCode" as="node()?" select="@languageCode"/>
												<tmk:MarkImageColourPartClaimedText>
													<xsl:if test="fn:exists($var25_languageCode)">
														<xsl:attribute name="com:languageCode" select="fn:string($var25_languageCode)"/>
													</xsl:if>
													<xsl:if test="fn:exists($var24_sequenceNumber)">
														<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var24_sequenceNumber)))"/>
													</xsl:if>
													<xsl:sequence select="fn:string(.)"/>
												</tmk:MarkImageColourPartClaimedText>
											</xsl:for-each>
											<xsl:for-each select="$var37_MarkImageRepresentationSize">
												<xsl:variable name="var26_current" as="node()" select="."/>
												<xsl:for-each select="ns0:Height">
													<com:HeightMeasure>
														<xsl:for-each select="$var26_current/ns0:Unit">
															<xsl:attribute name="com:measureUnitCode">
																<xsl:call-template name="vmf:vmf12_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</xsl:attribute>
														</xsl:for-each>
														<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
													</com:HeightMeasure>
												</xsl:for-each>
											</xsl:for-each>
											<xsl:for-each select="$var37_MarkImageRepresentationSize">
												<xsl:variable name="var27_current" as="node()" select="."/>
												<xsl:for-each select="ns0:Width">
													<com:WidthMeasure>
														<xsl:for-each select="$var27_current/ns0:Unit">
															<xsl:attribute name="com:measureUnitCode">
																<xsl:call-template name="vmf:vmf12_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</xsl:attribute>
														</xsl:for-each>
														<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
													</com:WidthMeasure>
												</xsl:for-each>
											</xsl:for-each>
											<xsl:for-each select="ns0:MarkImageCategory">
												<tmk:MarkImageClassification>
													<com:FigurativeElementClassificationBag>
														<com:NationalFigurativeElementClassificationBag>
															<xsl:for-each select="ns0:CategoryVersion">
																<com:NationalClassificationEdition>
																	<xsl:sequence select="fn:string(.)"/>
																</com:NationalClassificationEdition>
															</xsl:for-each>
															<xsl:for-each select="ns0:CategoryCodeDetails/ns0:CategoryCode">
																<com:NationalFigurativeElementClassification>
																	<xsl:sequence select="fn:string(.)"/>
																</com:NationalFigurativeElementClassification>
															</xsl:for-each>
														</com:NationalFigurativeElementClassificationBag>
													</com:FigurativeElementClassificationBag>
												</tmk:MarkImageClassification>
											</xsl:for-each>
											<xsl:for-each select="ns0:MarkImageQualityIndicator">
												<tmk:MarkImageQualityIndicator>
													<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
												</tmk:MarkImageQualityIndicator>
											</xsl:for-each>
											<xsl:for-each select="ns0:MarkImageRenditionDetails">
												<tmk:MarkImageRenditionBag>
													<xsl:for-each select="ns0:MarkImageRendition">
														<xsl:variable name="var34_MarkImageRenditionRepresentati" as="node()*" select="ns0:MarkImageRenditionRepresentationSize"/>
														<tmk:MarkImageRendition>
															<xsl:variable name="var29_resultof_filter" as="node()*">
																<xsl:for-each select="ns0:MarkImageRenditionKind">
																	<xsl:variable name="var28_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf13_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:if test="fn:exists($var28_resultof_vmf___inputtoresult)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:for-each>
															</xsl:variable>
															<xsl:for-each select="$var29_resultof_filter">
																<tmk:MarkImageRenditionCategory>
																	<xsl:call-template name="vmf:vmf13_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</tmk:MarkImageRenditionCategory>
															</xsl:for-each>
															<xsl:for-each select="ns0:MarkImageRenditionFilename">
																<com:FileName>
																	<xsl:sequence select="fn:string(.)"/>
																</com:FileName>
															</xsl:for-each>
															<xsl:variable name="var31_resultof_filter" as="node()*">
																<xsl:for-each select="ns0:MarkImageRenditionFileFormat">
																	<xsl:variable name="var30_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf14_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:if test="fn:exists($var30_resultof_vmf___inputtoresult)">
																		<xsl:sequence select="."/>
																	</xsl:if>
																</xsl:for-each>
															</xsl:variable>
															<xsl:for-each select="$var31_resultof_filter">
																<com:ImageFormatCategory>
																	<xsl:call-template name="vmf:vmf14_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</com:ImageFormatCategory>
															</xsl:for-each>
															<xsl:for-each select="ns0:MarkImageRenditionColourMode">
																<com:ColourModeCategory>
																	<xsl:sequence select="fn:string(.)"/>
																</com:ColourModeCategory>
															</xsl:for-each>
															<xsl:for-each select="$var34_MarkImageRenditionRepresentati">
																<xsl:variable name="var32_current" as="node()" select="."/>
																<xsl:for-each select="ns0:Height">
																	<com:HeightMeasure>
																		<xsl:for-each select="$var32_current/ns0:Unit">
																			<xsl:attribute name="com:measureUnitCode">
																				<xsl:call-template name="vmf:vmf15_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</xsl:attribute>
																		</xsl:for-each>
																		<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																	</com:HeightMeasure>
																</xsl:for-each>
															</xsl:for-each>
															<xsl:for-each select="$var34_MarkImageRenditionRepresentati">
																<xsl:variable name="var33_current" as="node()" select="."/>
																<xsl:for-each select="ns0:Width">
																	<com:WidthMeasure>
																		<xsl:for-each select="$var33_current/ns0:Unit">
																			<xsl:attribute name="com:measureUnitCode">
																				<xsl:call-template name="vmf:vmf15_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</xsl:attribute>
																		</xsl:for-each>
																		<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																	</com:WidthMeasure>
																</xsl:for-each>
															</xsl:for-each>
														</tmk:MarkImageRendition>
													</xsl:for-each>
												</tmk:MarkImageRenditionBag>
											</xsl:for-each>
											<xsl:for-each select="ns0:MarkImageColourIndicator">
												<com:ColourIndicator>
													<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
												</com:ColourIndicator>
											</xsl:for-each>
											<xsl:variable name="var36_resultof_filter" as="node()*">
												<xsl:for-each select="ns0:MarkImageColourMode">
													<xsl:variable name="var35_resultof_vmf___inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf16_inputtoresult">
															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<xsl:if test="fn:exists($var35_resultof_vmf___inputtoresult)">
														<xsl:sequence select="."/>
													</xsl:if>
												</xsl:for-each>
											</xsl:variable>
											<xsl:for-each select="$var36_resultof_filter">
												<com:ColourModeCategory>
													<xsl:call-template name="vmf:vmf16_inputtoresult">
														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
													</xsl:call-template>
												</com:ColourModeCategory>
											</xsl:for-each>
										</tmk:MarkImage>
									</xsl:for-each>
								</tmk:MarkImageBag>
							</xsl:for-each>
							<xsl:for-each select="ns0:WordMarkSpecification">
								<tmk:WordMarkSpecification>
									<xsl:for-each select="ns0:MarkVerbalElementText">
										<xsl:variable name="var38_languageCode" as="node()?" select="@languageCode"/>
										<tmk:MarkVerbalElementText>
											<xsl:if test="fn:exists($var38_languageCode)">
												<xsl:attribute name="com:languageCode" select="fn:string($var38_languageCode)"/>
											</xsl:if>
											<xsl:sequence select="fn:string(.)"/>
										</tmk:MarkVerbalElementText>
									</xsl:for-each>
									<xsl:for-each select="ns0:MarkSignificantVerbalElement">
										<xsl:variable name="var39_languageCode" as="node()?" select="@languageCode"/>
										<tmk:MarkSignificantVerbalElementText>
											<xsl:if test="fn:exists($var39_languageCode)">
												<xsl:attribute name="com:languageCode" select="fn:string($var39_languageCode)"/>
											</xsl:if>
											<xsl:sequence select="fn:string(.)"/>
										</tmk:MarkSignificantVerbalElementText>
									</xsl:for-each>
									<xsl:for-each select="ns0:MarkVerbalElementSignificantIndicator">
										<tmk:MarkVerbalElementSignificantIndicator>
											<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
										</tmk:MarkVerbalElementSignificantIndicator>
									</xsl:for-each>
									<xsl:for-each select="ns0:MarkTranslation">
										<xsl:variable name="var40_sequenceNumber" as="node()?" select="@sequenceNumber"/>
										<xsl:variable name="var41_languageCode" as="node()?" select="@languageCode"/>
										<tmk:MarkTranslationText>
											<xsl:if test="fn:exists($var41_languageCode)">
												<xsl:attribute name="com:languageCode" select="fn:string($var41_languageCode)"/>
											</xsl:if>
											<xsl:if test="fn:exists($var40_sequenceNumber)">
												<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var40_sequenceNumber)))"/>
											</xsl:if>
											<xsl:sequence select="fn:string(.)"/>
										</tmk:MarkTranslationText>
									</xsl:for-each>
									<xsl:for-each select="ns0:MarkTransliteration">
										<tmk:MarkTransliteration>
											<xsl:sequence select="fn:string(.)"/>
										</tmk:MarkTransliteration>
									</xsl:for-each>
									<xsl:for-each select="ns0:MarkTranscription">
										<tmk:MarkTranscription>
											<xsl:sequence select="fn:string(.)"/>
										</tmk:MarkTranscription>
									</xsl:for-each>
									<xsl:for-each select="ns0:MarkStandardCharacterIndicator">
										<tmk:MarkStandardCharacterIndicator>
											<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
										</tmk:MarkStandardCharacterIndicator>
									</xsl:for-each>
								</tmk:WordMarkSpecification>
							</xsl:for-each>
						</tmk:EarlierMark>
					</xsl:for-each>
				</tmk:EarlierMarkBag>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OpponentDetails/ns0:Opponent">
				<tmk:Plaintiff>
					<xsl:for-each select="ns0:OpponentLegalEntity">
						<com:LegalEntityName>
							<xsl:sequence select="fn:string(.)"/>
						</com:LegalEntityName>
					</xsl:for-each>
					<xsl:for-each select="ns0:OpponentNationalityCode">
						<com:NationalityCode>
							<xsl:sequence select="fn:string(.)"/>
						</com:NationalityCode>
					</xsl:for-each>
					<xsl:for-each select="ns0:OpponentIncorporationCountryCode">
						<com:IncorporationCountryCode>
							<xsl:sequence select="fn:string(.)"/>
						</com:IncorporationCountryCode>
					</xsl:for-each>
					<xsl:for-each select="ns0:OpponentIncorporationState">
						<com:IncorporationState>
							<xsl:sequence select="fn:string(.)"/>
						</com:IncorporationState>
					</xsl:for-each>
					<xsl:for-each select="ns0:Comment">
						<xsl:variable name="var42_languageCode" as="node()?" select="@languageCode"/>
						<com:CommentText>
							<xsl:if test="fn:exists($var42_languageCode)">
								<xsl:attribute name="com:languageCode" select="fn:string($var42_languageCode)"/>
							</xsl:if>
							<xsl:sequence select="fn:string(.)"/>
						</com:CommentText>
					</xsl:for-each>
					<xsl:for-each select="ns0:OpponentEntitlement">
						<tmk:Entitlement>
							<xsl:for-each select="ns0:EntitlementNationalityCode">
								<com:EntitlementNationalityCode>
									<xsl:sequence select="fn:string(.)"/>
								</com:EntitlementNationalityCode>
							</xsl:for-each>
							<xsl:for-each select="ns0:EntitlementEstablishment">
								<com:EntitlementEstablishment>
									<xsl:for-each select="ns0:EntitlementEstablishmentCode">
										<com:EntitlementEstablishmentCode>
											<xsl:sequence select="fn:string(.)"/>
										</com:EntitlementEstablishmentCode>
									</xsl:for-each>
									<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
										<xsl:variable name="var43_resultof_MappingST__AddressBookToST__Contact" as="node()?">
											<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
												<xsl:with-param name="AddressBook" as="node()">
													<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
														<xsl:sequence select="(./@node(), ./node())"/>
													</AddressBookType>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:for-each select="$var43_resultof_MappingST__AddressBookToST__Contact">
											<com:Contact>
												<xsl:sequence select="(./@node(), ./node())"/>
											</com:Contact>
										</xsl:for-each>
									</xsl:for-each>
								</com:EntitlementEstablishment>
							</xsl:for-each>
							<xsl:for-each select="ns0:EntitlementDomiciled">
								<com:EntitlementDomiciled>
									<xsl:for-each select="ns0:EntitlementDomiciledCode">
										<com:EntitlementDomiciledCode>
											<xsl:sequence select="fn:string(.)"/>
										</com:EntitlementDomiciledCode>
									</xsl:for-each>
									<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
										<xsl:variable name="var44_resultof_MappingST__AddressBookToST__Contact" as="node()?">
											<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
												<xsl:with-param name="AddressBook" as="node()">
													<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
														<xsl:sequence select="(./@node(), ./node())"/>
													</AddressBookType>
												</xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:for-each select="$var44_resultof_MappingST__AddressBookToST__Contact">
											<com:Contact>
												<xsl:sequence select="(./@node(), ./node())"/>
											</com:Contact>
										</xsl:for-each>
									</xsl:for-each>
								</com:EntitlementDomiciled>
							</xsl:for-each>
						</tmk:Entitlement>
					</xsl:for-each>
					<xsl:for-each select="ns0:OpponentAddressBook">
						<xsl:variable name="var45_resultof_MappingST__AddressBookToST__Contact" as="node()?">
							<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
								<xsl:with-param name="AddressBook" as="node()">
									<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
										<xsl:sequence select="(./@node(), ./node())"/>
									</AddressBookType>
								</xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:for-each select="$var45_resultof_MappingST__AddressBookToST__Contact">
							<com:Contact>
								<xsl:sequence select="(./@node(), ./node())"/>
							</com:Contact>
						</xsl:for-each>
					</xsl:for-each>
					<xsl:for-each select="ns0:OpponentIdentifier">
						<xsl:variable name="var46_identifierKindCode" as="node()?" select="@identifierKindCode"/>
						<com:PartyIdentifier>
							<xsl:if test="fn:exists($var46_identifierKindCode)">
								<xsl:attribute name="com:officeCode" select="fn:string($var46_identifierKindCode)"/>
							</xsl:if>
							<xsl:sequence select="fn:string(.)"/>
						</com:PartyIdentifier>
					</xsl:for-each>
				</tmk:Plaintiff>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OppositionEventDetails">
				<tmk:OppositionEventBag>
					<xsl:for-each select="ns0:OppositionEvent">
						<tmk:OppositionEvent>
							<xsl:variable name="var48_resultof_filter" as="node()*">
								<xsl:for-each select="ns0:OppositionEventCode">
									<xsl:variable name="var47_resultof_vmf___inputtoresult" as="xs:string?">
										<xsl:call-template name="vmf:vmf55_inputtoresult">
											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:if test="fn:exists($var47_resultof_vmf___inputtoresult)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:for-each select="$var48_resultof_filter">
								<tmk:OppositionEventCategory>
									<xsl:call-template name="vmf:vmf55_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</tmk:OppositionEventCategory>
							</xsl:for-each>
							<xsl:for-each select="ns0:OppositionEventResponseDate">
								<com:OppositionEventResponseDate>
									<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
								</com:OppositionEventResponseDate>
							</xsl:for-each>
							<xsl:for-each select="ns0:Comment">
								<xsl:variable name="var49_languageCode" as="node()?" select="@languageCode"/>
								<com:CommentText>
									<xsl:if test="fn:exists($var49_languageCode)">
										<xsl:attribute name="com:languageCode" select="fn:string($var49_languageCode)"/>
									</xsl:if>
									<xsl:sequence select="fn:string(.)"/>
								</com:CommentText>
							</xsl:for-each>
							<xsl:for-each select="ns0:OppositionEventDate">
								<com:OppositionEventDate>
									<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
								</com:OppositionEventDate>
							</xsl:for-each>
							<xsl:for-each select="ns0:OppositionEventDateTime">
								<com:OppositionEventDateTime>
									<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
								</com:OppositionEventDateTime>
							</xsl:for-each>
						</tmk:OppositionEvent>
					</xsl:for-each>
				</tmk:OppositionEventBag>
			</xsl:for-each>
			<xsl:for-each select="$Opposition/ns0:OppositionDocumentDetails">
				<com:OppositionDocumentBag>
					<xsl:for-each select="ns0:OppositionDocument">
						<com:OppositionDocument>
							<xsl:for-each select="ns0:DocumentLanguageCode">
								<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
							</xsl:for-each>
							<xsl:for-each select="ns0:DocumentName">
								<com:DocumentName>
									<xsl:sequence select="fn:string(.)"/>
								</com:DocumentName>
							</xsl:for-each>
							<xsl:for-each select="ns0:DocumentFilename">
								<com:FileName>
									<xsl:sequence select="fn:string(.)"/>
								</com:FileName>
							</xsl:for-each>
							<xsl:variable name="var51_resultof_filter" as="node()*">
								<xsl:for-each select="ns0:DocumentFileFormat">
									<xsl:variable name="var50_resultof_vmf___inputtoresult" as="xs:string?">
										<xsl:call-template name="vmf:vmf22_inputtoresult">
											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:if test="fn:exists($var50_resultof_vmf___inputtoresult)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:for-each select="$var51_resultof_filter">
								<com:DocumentFormatCategory>
									<xsl:call-template name="vmf:vmf22_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</com:DocumentFormatCategory>
							</xsl:for-each>
							<xsl:for-each select="ns0:DocumentDate">
								<com:DocumentDate>
									<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
								</com:DocumentDate>
							</xsl:for-each>
							<xsl:variable name="var53_resultof_filter" as="node()*">
								<xsl:for-each select="ns0:DocumentMedia">
									<xsl:variable name="var52_resultof_vmf___inputtoresult" as="xs:string?">
										<xsl:call-template name="vmf:vmf23_inputtoresult">
											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:if test="fn:exists($var52_resultof_vmf___inputtoresult)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:for-each select="$var53_resultof_filter">
								<com:DocumentMediaCategory>
									<xsl:call-template name="vmf:vmf23_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</com:DocumentMediaCategory>
							</xsl:for-each>
							<xsl:for-each select="ns0:DocumentLocation">
								<com:DocumentLocationURI>
									<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
								</com:DocumentLocationURI>
							</xsl:for-each>
							<xsl:for-each select="ns0:DocumentVersion">
								<com:DocumentVersion>
									<xsl:sequence select="fn:string(.)"/>
								</com:DocumentVersion>
							</xsl:for-each>
							<xsl:for-each select="ns0:DocumentSizeInByte">
								<com:DocumentSizeQuantity>
									<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
								</com:DocumentSizeQuantity>
							</xsl:for-each>
							<xsl:for-each select="ns0:Comment">
								<xsl:variable name="var54_languageCode" as="node()?" select="@languageCode"/>
								<com:CommentText>
									<xsl:if test="fn:exists($var54_languageCode)">
										<xsl:attribute name="com:languageCode" select="fn:string($var54_languageCode)"/>
									</xsl:if>
									<xsl:sequence select="fn:string(.)"/>
								</com:CommentText>
							</xsl:for-each>
						</com:OppositionDocument>
					</xsl:for-each>
				</com:OppositionDocumentBag>
			</xsl:for-each>
		</tmk:Opposition>
	</xsl:template>
	<xsl:template name="WIPO:MappingST66AddressBookToST96Contact">
		<xsl:param name="AddressBook" select="()"/>
		<xsl:variable name="var9_FormattedNameAddress" as="node()*" select="$AddressBook/ns0:FormattedNameAddress"/>
		<xsl:variable name="var10_ContactInformationDetails" as="node()*" select="$AddressBook/ns0:ContactInformationDetails"/>
		<com:Contact>
			<xsl:for-each select="$AddressBook/ns0:AddressLanguageCode">
				<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string(.)"/>
			</xsl:for-each>
			<com:Name>
				<xsl:for-each select="($var9_FormattedNameAddress/ns0:Name/ns0:FormattedName)[fn:exists(ns0:LastName)]">
					<com:PersonName>
						<com:PersonStructuredName>
							<xsl:for-each select="ns0:NamePrefix">
								<com:NamePrefix>
									<xsl:sequence select="fn:string(.)"/>
								</com:NamePrefix>
							</xsl:for-each>
							<xsl:for-each select="ns0:FirstName">
								<com:FirstName>
									<xsl:sequence select="fn:string(.)"/>
								</com:FirstName>
							</xsl:for-each>
							<xsl:for-each select="ns0:MiddleName">
								<com:MiddleName>
									<xsl:sequence select="fn:string(.)"/>
								</com:MiddleName>
							</xsl:for-each>
							<xsl:for-each select="ns0:LastName">
								<com:LastName>
									<xsl:sequence select="fn:string(.)"/>
								</com:LastName>
							</xsl:for-each>
							<xsl:for-each select="ns0:SecondLastName">
								<com:SecondLastName>
									<xsl:sequence select="fn:string(.)"/>
								</com:SecondLastName>
							</xsl:for-each>
							<xsl:for-each select="ns0:NameSuffix">
								<com:NameSuffix>
									<xsl:sequence select="fn:string(.)"/>
								</com:NameSuffix>
							</xsl:for-each>
							<xsl:for-each select="ns0:NameSynonym">
								<com:PersonOtherName>
									<xsl:sequence select="fn:string(.)"/>
								</com:PersonOtherName>
							</xsl:for-each>
						</com:PersonStructuredName>
					</com:PersonName>
				</xsl:for-each>
				<xsl:for-each select="$var9_FormattedNameAddress/ns0:Name/ns0:FormattedName">
					<xsl:variable name="var1_current" as="node()" select="."/>
					<xsl:for-each select="ns0:OrganizationName">
						<com:OrganizationName>
							<com:OrganizationStandardName>
								<xsl:sequence select="fn:string(.)"/>
							</com:OrganizationStandardName>
							<xsl:for-each select="$var1_current/ns0:OrganizationDepartment">
								<com:OrganizationOtherName>
									<xsl:attribute name="organizationNameCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Department'"/>
									<xsl:sequence select="fn:string(.)"/>
								</com:OrganizationOtherName>
							</xsl:for-each>
						</com:OrganizationName>
					</xsl:for-each>
				</xsl:for-each>
				<xsl:for-each select="$var9_FormattedNameAddress/ns0:Name/ns0:FreeFormatName/ns0:FreeFormatNameDetails/ns0:FreeFormatNameLine">
					<xsl:variable name="var2_languageCode" as="node()?" select="@languageCode"/>
					<com:EntityName>
						<xsl:if test="fn:exists($var2_languageCode)">
							<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string($var2_languageCode)"/>
						</xsl:if>
						<xsl:sequence select="fn:string(.)"/>
					</com:EntityName>
				</xsl:for-each>
			</com:Name>
			<xsl:for-each select="$var9_FormattedNameAddress/ns0:Address">
				<xsl:variable name="var6_current" as="node()" select="."/>
				<com:PostalAddressBag>
					<xsl:for-each select="ns0:FormattedAddress">
						<com:PostalAddress>
							<com:PostalStructuredAddress>
								<xsl:for-each select="ns0:AddressLine">
									<xsl:variable name="var3_sequenceNumber" as="node()?" select="@sequenceNumber"/>
									<com:AddressLineText>
										<xsl:if test="fn:exists($var3_sequenceNumber)">
											<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:concat(xs:string(xs:integer(fn:string($var3_sequenceNumber))), '001')"/>
										</xsl:if>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressStreet">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Street'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressBuilding">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Building'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressPostOfficeBox">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Post office box'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressRoom">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Room'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressFloor">
									<com:AddressLineText>
										<xsl:attribute name="addressLineCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'Floor'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:AddressLineText>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressCity">
									<com:CityName>
										<xsl:sequence select="fn:string(.)"/>
									</com:CityName>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressCounty">
									<com:GeographicRegionName>
										<xsl:attribute name="geographicRegionCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'County'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:GeographicRegionName>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressState">
									<com:GeographicRegionName>
										<xsl:attribute name="geographicRegionCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="'State'"/>
										<xsl:sequence select="fn:string(.)"/>
									</com:GeographicRegionName>
								</xsl:for-each>
								<xsl:for-each select="$var6_current/ns0:AddressCountryCode">
									<com:CountryCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:CountryCode>
								</xsl:for-each>
								<xsl:for-each select="ns0:FormattedAddressCountryCode">
									<com:CountryCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:CountryCode>
								</xsl:for-each>
								<xsl:for-each select="ns0:AddressPostcode">
									<com:PostalCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:PostalCode>
								</xsl:for-each>
							</com:PostalStructuredAddress>
							<xsl:for-each select="$AddressBook/ns0:PostalAddress">
								<com:PostalAddressText>
									<xsl:sequence select="fn:string(.)"/>
								</com:PostalAddressText>
							</xsl:for-each>
							<xsl:for-each select="$var6_current/ns0:FreeFormatAddress/ns0:FreeFormatAddressLine">
								<xsl:variable name="var4_languageCode" as="node()?" select="@languageCode"/>
								<xsl:variable name="var5_sequenceNumber" as="node()?" select="@sequenceNumber"/>
								<com:PostalAddressText>
									<xsl:if test="fn:exists($var4_languageCode)">
										<xsl:attribute name="languageCode" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="fn:string($var4_languageCode)"/>
									</xsl:if>
									<xsl:if test="fn:exists($var5_sequenceNumber)">
										<xsl:attribute name="sequenceNumber" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="xs:string(xs:integer(fn:string($var5_sequenceNumber)))"/>
									</xsl:if>
									<xsl:sequence select="fn:string(.)"/>
								</com:PostalAddressText>
							</xsl:for-each>
						</com:PostalAddress>
					</xsl:for-each>
				</com:PostalAddressBag>
			</xsl:for-each>
			<xsl:for-each select="$var10_ContactInformationDetails/ns0:Fax">
				<com:FaxNumberBag>
					<com:FaxNumber>
						<xsl:sequence select="fn:string(.)"/>
					</com:FaxNumber>
				</com:FaxNumberBag>
			</xsl:for-each>
			<xsl:for-each select="$var10_ContactInformationDetails/ns0:Email">
				<com:EmailAddressBag>
					<com:EmailAddressText>
						<xsl:sequence select="fn:string(.)"/>
					</com:EmailAddressText>
				</com:EmailAddressBag>
			</xsl:for-each>
			<xsl:for-each select="$var10_ContactInformationDetails/ns0:URL">
				<com:WebAddressBag>
					<com:WebAddressURI>
						<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
					</com:WebAddressURI>
				</com:WebAddressBag>
			</xsl:for-each>
			<xsl:for-each select="$var10_ContactInformationDetails/ns0:Phone">
				<xsl:variable name="var8_phoneKind" as="node()?" select="@phoneKind"/>
				<com:PhoneNumberBag>
					<com:PhoneNumber>
						<xsl:if test="fn:exists($var8_phoneKind)">
							<xsl:variable name="var7_resultof_vmf___inputtoresult" as="xs:string?">
								<xsl:call-template name="vmf:vmf56_inputtoresult">
									<xsl:with-param name="input" select="fn:string($var8_phoneKind)" as="xs:string"/>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="fn:exists($var7_resultof_vmf___inputtoresult)">
								<xsl:attribute name="phoneNumberCategory" namespace="http://www.wipo.int/standards/XMLSchema/ST96/Common" select="$var7_resultof_vmf___inputtoresult"/>
							</xsl:if>
						</xsl:if>
						<xsl:sequence select="fn:string(.)"/>
					</com:PhoneNumber>
				</com:PhoneNumberBag>
			</xsl:for-each>
			<xsl:for-each select="$var10_ContactInformationDetails/ns0:OtherElectronicAddress">
				<com:OtherElectronicAddressBag>
					<com:OtherElectronicAddressText>
						<xsl:sequence select="fn:string(.)"/>
					</com:OtherElectronicAddressText>
				</com:OtherElectronicAddressBag>
			</xsl:for-each>
		</com:Contact>
	</xsl:template>
	<xsl:template name="vmf:vmf1_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Trade Mark E-Filing'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
			<xsl:when test="$input='Trade Mark B2B-Filing'">
				<xsl:copy-of select="'Trademark B2B Filing'"/>
			</xsl:when>
			<xsl:when test="$input='Trade Mark Information'">
				<xsl:copy-of select="'Trademark information'"/>
			</xsl:when>
			<xsl:when test="$input='Trade Mark Identifier List'">
				<xsl:copy-of select="'Trademark identifier list'"/>
			</xsl:when>
			<xsl:when test="$input='Trade Mark List'">
				<xsl:copy-of select="'Trademark list'"/>
			</xsl:when>
			<xsl:when test="$input='Opposition E-Filing'">
				<xsl:copy-of select="'Opposition eFiling'"/>
			</xsl:when>
			<xsl:when test="$input='Opposition Information'">
				<xsl:copy-of select="'Opposition information'"/>
			</xsl:when>
			<xsl:when test="$input='Opposition Identifier List'">
				<xsl:copy-of select="'Opposition identifier list'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf2_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Accelerated Registration'">
				<xsl:copy-of select="'Accelerated registration'"/>
			</xsl:when>
			<xsl:when test="$input='Normal'">
				<xsl:copy-of select="'Normal'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf3_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Certification Agreement Date'">
				<xsl:copy-of select="'Certification agreement date'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf4_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Action before Court of Justice pending'">
				<xsl:copy-of select="'Action before court of justice pending'"/>
			</xsl:when>
			<xsl:when test="$input='Appeal pending'">
				<xsl:copy-of select="'Appeal pending'"/>
			</xsl:when>
			<xsl:when test="$input='Application accepted'">
				<xsl:copy-of select="'Application accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Application deemed withdrawn'">
				<xsl:copy-of select="'Application deemed withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Application filed'">
				<xsl:copy-of select="'Application filed'"/>
			</xsl:when>
			<xsl:when test="$input='Application opposed'">
				<xsl:copy-of select="'Application opposed'"/>
			</xsl:when>
			<xsl:when test="$input='Application published'">
				<xsl:copy-of select="'Application published'"/>
			</xsl:when>
			<xsl:when test="$input='Application refused'">
				<xsl:copy-of select="'Application refused'"/>
			</xsl:when>
			<xsl:when test="$input='Application withdrawn'">
				<xsl:copy-of select="'Application withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Classification checked'">
				<xsl:copy-of select="'Classification checked'"/>
			</xsl:when>
			<xsl:when test="$input='Conversion requested'">
				<xsl:copy-of select="'Conversion requested'"/>
			</xsl:when>
			<xsl:when test="$input='Expired'">
				<xsl:copy-of select="'Expired'"/>
			</xsl:when>
			<xsl:when test="$input='Filing date accorded'">
				<xsl:copy-of select="'Filing date accorded'"/>
			</xsl:when>
			<xsl:when test="$input='Interruption of proceedings'">
				<xsl:copy-of select="'Interruption of proceedings'"/>
			</xsl:when>
			<xsl:when test="$input='Invalidity proceeding pending'">
				<xsl:copy-of select="'Invalidity proceeding pending'"/>
			</xsl:when>
			<xsl:when test="$input='Registered'">
				<xsl:copy-of select="'Registered'"/>
			</xsl:when>
			<xsl:when test="$input='Registration cancellation pending'">
				<xsl:copy-of select="'Registration cancellation pending'"/>
			</xsl:when>
			<xsl:when test="$input='Registration cancelled'">
				<xsl:copy-of select="'Registration cancelled'"/>
			</xsl:when>
			<xsl:when test="$input='Registration opposed'">
				<xsl:copy-of select="'Registration opposed'"/>
			</xsl:when>
			<xsl:when test="$input='Registration surrendered'">
				<xsl:copy-of select="'Registration surrendered'"/>
			</xsl:when>
			<xsl:when test="$input='Revocation proceeding pending'">
				<xsl:copy-of select="'Revocation proceeding pending'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf5_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Agreement'">
				<xsl:copy-of select="'Agreement'"/>
			</xsl:when>
			<xsl:when test="$input='Protocol'">
				<xsl:copy-of select="'Protocol'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf6_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Transformation'">
				<xsl:copy-of select="'Transformation'"/>
			</xsl:when>
			<xsl:when test="$input='Renewal'">
				<xsl:copy-of select="'Renewal'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf7_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Certificate'">
				<xsl:copy-of select="'Certificate'"/>
			</xsl:when>
			<xsl:when test="$input='Collective'">
				<xsl:copy-of select="'Collective'"/>
			</xsl:when>
			<xsl:when test="$input='Defensive'">
				<xsl:copy-of select="'Defensive'"/>
			</xsl:when>
			<xsl:when test="$input='Individual'">
				<xsl:copy-of select="'Individual'"/>
			</xsl:when>
			<xsl:when test="$input='Guarantee'">
				<xsl:copy-of select="'Guarantee'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf8_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Word'">
				<xsl:copy-of select="'Word'"/>
			</xsl:when>
			<xsl:when test="$input='Stylized characters'">
				<xsl:copy-of select="'Stylized characters'"/>
			</xsl:when>
			<xsl:when test="$input='Figurative'">
				<xsl:copy-of select="'Figurative'"/>
			</xsl:when>
			<xsl:when test="$input='Combined'">
				<xsl:copy-of select="'Combined'"/>
			</xsl:when>
			<xsl:when test="$input='3-D'">
				<xsl:copy-of select="'Three dimensional'"/>
			</xsl:when>
			<xsl:when test="$input='Colour'">
				<xsl:copy-of select="'Colour'"/>
			</xsl:when>
			<xsl:when test="$input='Sound'">
				<xsl:copy-of select="'Sound'"/>
			</xsl:when>
			<xsl:when test="$input='Hologram'">
				<xsl:copy-of select="'Hologram'"/>
			</xsl:when>
			<xsl:when test="$input='Olfactory'">
				<xsl:copy-of select="'Olfactory'"/>
			</xsl:when>
			<xsl:when test="$input='Motion'">
				<xsl:copy-of select="'Motion'"/>
			</xsl:when>
			<xsl:when test="$input='Municipal'">
				<xsl:copy-of select="' '"/>
			</xsl:when>
			<xsl:when test="$input='Chimney'">
				<xsl:copy-of select="' '"/>
			</xsl:when>
			<xsl:when test="$input='Kennfaden'">
				<xsl:copy-of select="'tracer'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf9_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Arabic to Latin'">
				<xsl:copy-of select="'Arabic to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Armenian to Latin'">
				<xsl:copy-of select="'Armenian to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Chinese to Latin'">
				<xsl:copy-of select="'Chinese to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Cyrillic to Latin'">
				<xsl:copy-of select="'Cyrillic to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Georgian to Latin'">
				<xsl:copy-of select="'Georgian to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Greek to Latin'">
				<xsl:copy-of select="'Greek to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Hebrew to Latin'">
				<xsl:copy-of select="'Hebrew to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Indic to Latin'">
				<xsl:copy-of select="'Indic to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Japanese to Latin'">
				<xsl:copy-of select="'Japanese to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Korean to Latin'">
				<xsl:copy-of select="'Korean to Latin'"/>
			</xsl:when>
			<xsl:when test="$input='Thai to Latin'">
				<xsl:copy-of select="'Thai to Latin'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf10_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='To Lowercase'">
				<xsl:copy-of select="'To lowercase'"/>
			</xsl:when>
			<xsl:when test="$input='To Uppercase'">
				<xsl:copy-of select="'To uppercase'"/>
			</xsl:when>
			<xsl:when test="$input='To Phonetic Code'">
				<xsl:copy-of select="'To phonetic code'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf11_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='JPEG'">
				<xsl:copy-of select="'JPEG'"/>
			</xsl:when>
			<xsl:when test="$input='TIFF'">
				<xsl:copy-of select="'TIFF'"/>
			</xsl:when>
			<xsl:when test="$input='PNG'">
				<xsl:copy-of select="'PNG'"/>
			</xsl:when>
			<xsl:when test="$input='GIF'">
				<xsl:copy-of select="'GIF'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf12_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Centimeter'">
				<xsl:copy-of select="'Cm'"/>
			</xsl:when>
			<xsl:when test="$input='Pixel'">
				<xsl:copy-of select="'Px'"/>
			</xsl:when>
			<xsl:when test="$input='Inch'">
				<xsl:copy-of select="'In'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="'mm'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf13_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Greyscale'">
				<xsl:copy-of select="'Greyscale'"/>
			</xsl:when>
			<xsl:when test="$input='Office Copy'">
				<xsl:copy-of select="'Office copy'"/>
			</xsl:when>
			<xsl:when test="$input='Thumbnail'">
				<xsl:copy-of select="'Thumbnail'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf14_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='JPEG'">
				<xsl:copy-of select="'JPEG'"/>
			</xsl:when>
			<xsl:when test="$input='TIFF'">
				<xsl:copy-of select="'TIFF'"/>
			</xsl:when>
			<xsl:when test="$input='PNG'">
				<xsl:copy-of select="'PNG'"/>
			</xsl:when>
			<xsl:when test="$input='GIF'">
				<xsl:copy-of select="'GIF'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf15_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Centimetre'">
				<xsl:copy-of select="'Cm'"/>
			</xsl:when>
			<xsl:when test="$input='Inch'">
				<xsl:copy-of select="'In'"/>
			</xsl:when>
			<xsl:when test="$input='Pixel'">
				<xsl:copy-of select="'Px'"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy-of select="'mm'"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf16_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Black and White'">
				<xsl:copy-of select="'Black and white'"/>
			</xsl:when>
			<xsl:when test="$input='Greyscale'">
				<xsl:copy-of select="'Greyscale'"/>
			</xsl:when>
			<xsl:when test="$input='Colour'">
				<xsl:copy-of select="'Colour'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf17_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='MP3'">
				<xsl:copy-of select="'MP3'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf18_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Provisional'">
				<xsl:copy-of select="'Provisional'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf19_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Nice'">
				<xsl:copy-of select="'Nice'"/>
			</xsl:when>
			<xsl:when test="$input='Office'">
				<xsl:copy-of select="'Office'"/>
			</xsl:when>
			<xsl:when test="$input='EM-JP-US'">
				<xsl:copy-of select="'EM_JP_US'"/>
			</xsl:when>
			<xsl:when test="$input='EM-US'">
				<xsl:copy-of select="'EM_US'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf20_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Requested'">
				<xsl:copy-of select="'Requested'"/>
			</xsl:when>
			<xsl:when test="$input='Accepted'">
				<xsl:copy-of select="'Accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Refused'">
				<xsl:copy-of select="'Refused'"/>
			</xsl:when>
			<xsl:when test="$input='No longer in use'">
				<xsl:copy-of select="'No longer in use'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf21_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Abandoned'">
				<xsl:copy-of select="'Abandoned'"/>
			</xsl:when>
			<xsl:when test="$input='Accepted'">
				<xsl:copy-of select="'Accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Claimed'">
				<xsl:copy-of select="'Claimed'"/>
			</xsl:when>
			<xsl:when test="$input='Partially Refused'">
				<xsl:copy-of select="'Partially refused'"/>
			</xsl:when>
			<xsl:when test="$input='Refused'">
				<xsl:copy-of select="'Refused'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf22_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='JPEG'">
				<xsl:copy-of select="'JPEG'"/>
			</xsl:when>
			<xsl:when test="$input='TIFF'">
				<xsl:copy-of select="'TIFF'"/>
			</xsl:when>
			<xsl:when test="$input='PNG'">
				<xsl:copy-of select="'PNG'"/>
			</xsl:when>
			<xsl:when test="$input='GIF'">
				<xsl:copy-of select="''"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf23_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Paper'">
				<xsl:copy-of select="'Paper'"/>
			</xsl:when>
			<xsl:when test="$input='Fax'">
				<xsl:copy-of select="'Fax'"/>
			</xsl:when>
			<xsl:when test="$input='File'">
				<xsl:copy-of select="'File'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf24_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Claimed'">
				<xsl:copy-of select="'Claimed'"/>
			</xsl:when>
			<xsl:when test="$input='Accepted'">
				<xsl:copy-of select="'Accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Refused'">
				<xsl:copy-of select="'Refused'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf25_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Madrid'">
				<xsl:copy-of select="'Madrid'"/>
			</xsl:when>
			<xsl:when test="$input='EU'">
				<xsl:copy-of select="'EU'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf26_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Abandoned'">
				<xsl:copy-of select="'Abandoned'"/>
			</xsl:when>
			<xsl:when test="$input='Accepted'">
				<xsl:copy-of select="'Accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Claimed'">
				<xsl:copy-of select="'Claimed'"/>
			</xsl:when>
			<xsl:when test="$input='Partially Refused'">
				<xsl:copy-of select="'Partially refused'"/>
			</xsl:when>
			<xsl:when test="$input='Refused'">
				<xsl:copy-of select="'Refused'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf27_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Amendments to applications'">
				<xsl:copy-of select="'Amendments to applications'"/>
			</xsl:when>
			<xsl:when test="$input='Applications'">
				<xsl:copy-of select="'Applications'"/>
			</xsl:when>
			<xsl:when test="$input='Appointment of a new representative'">
				<xsl:copy-of select="'Appointment of a new representative'"/>
			</xsl:when>
			<xsl:when test="$input='Change of name and address of proprietor'">
				<xsl:copy-of select="'Change of name and address of proprietor'"/>
			</xsl:when>
			<xsl:when test="$input='Change of name and professional address of representative'">
				<xsl:copy-of select="'Change of name and professional address of representative'"/>
			</xsl:when>
			<xsl:when test="$input='Correction of absolute errors on applications'">
				<xsl:copy-of select="'Correction of absolute errors on applications'"/>
			</xsl:when>
			<xsl:when test="$input='Correction of absolute errors on registrations'">
				<xsl:copy-of select="'Correction of absolute errors on registrations'"/>
			</xsl:when>
			<xsl:when test="$input='Correction of relative errors on applications'">
				<xsl:copy-of select="'Correction of relative errors on applications'"/>
			</xsl:when>
			<xsl:when test="$input='Correction of relative errors on registrations'">
				<xsl:copy-of select="'Correction of relative errors on registrations'"/>
			</xsl:when>
			<xsl:when test="$input='Deletion of the representative'">
				<xsl:copy-of select="'Deletion of the representative'"/>
			</xsl:when>
			<xsl:when test="$input='Partial refusals'">
				<xsl:copy-of select="'Partial refusals'"/>
			</xsl:when>
			<xsl:when test="$input='Partial surrender of trade mark'">
				<xsl:copy-of select="'Partial surrender of trademarks'"/>
			</xsl:when>
			<xsl:when test="$input='Partial transfers'">
				<xsl:copy-of select="'Partial transfers'"/>
			</xsl:when>
			<xsl:when test="$input='Registrations with amendments'">
				<xsl:copy-of select="'Registrations with amendments'"/>
			</xsl:when>
			<xsl:when test="$input='Registrations with no amendments'">
				<xsl:copy-of select="'Registrations with no amendments'"/>
			</xsl:when>
			<xsl:when test="$input='Replacement of representative'">
				<xsl:copy-of select="'Replacement of representative'"/>
			</xsl:when>
			<xsl:when test="$input='Restrictions'">
				<xsl:copy-of select="'Restrictions'"/>
			</xsl:when>
			<xsl:when test="$input='Total refusals'">
				<xsl:copy-of select="'Total refusals'"/>
			</xsl:when>
			<xsl:when test="$input='Total surrender of trade mark'">
				<xsl:copy-of select="'Total surrender of trademarks'"/>
			</xsl:when>
			<xsl:when test="$input='Total transfers'">
				<xsl:copy-of select="'Total transfers'"/>
			</xsl:when>
			<xsl:when test="$input='Withdrawals'">
				<xsl:copy-of select="'Withdrawals'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf28_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='General Authorization'">
				<xsl:copy-of select="'General authorization'"/>
			</xsl:when>
			<xsl:when test="$input='Specific Authorization'">
				<xsl:copy-of select="'Specific authorization'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf29_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Already on file'">
				<xsl:copy-of select="'Already on file'"/>
			</xsl:when>
			<xsl:when test="$input='Attached'">
				<xsl:copy-of select="'Attached'"/>
			</xsl:when>
			<xsl:when test="$input='To follow'">
				<xsl:copy-of select="'To follow'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf30_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Appeal Expired'">
				<xsl:copy-of select="'Appeal expired'"/>
			</xsl:when>
			<xsl:when test="$input='Appeal Lapsed'">
				<xsl:copy-of select="'Appeal lapsed'"/>
			</xsl:when>
			<xsl:when test="$input='Appeal Withdrawn'">
				<xsl:copy-of select="'Appeal withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Complementary Renewal'">
				<xsl:copy-of select="'Complementary renewal'"/>
			</xsl:when>
			<xsl:when test="$input='Effect Continuation'">
				<xsl:copy-of select="'Effect continuation'"/>
			</xsl:when>
			<xsl:when test="$input='Final Confirmation Refusal'">
				<xsl:copy-of select="'Final confirmation refusal'"/>
			</xsl:when>
			<xsl:when test="$input='Final Other Decision'">
				<xsl:copy-of select="'Final other decision'"/>
			</xsl:when>
			<xsl:when test="$input='Final Reversing Refusal'">
				<xsl:copy-of select="'Final reversing refusal'"/>
			</xsl:when>
			<xsl:when test="$input='Final Total Refusal'">
				<xsl:copy-of select="'Final total refusal'"/>
			</xsl:when>
			<xsl:when test="$input='Judicial Action'">
				<xsl:copy-of select="'Judicial action'"/>
			</xsl:when>
			<xsl:when test="$input='Limitation'">
				<xsl:copy-of select="'Limitation'"/>
			</xsl:when>
			<xsl:when test="$input='No Effect Limitation'">
				<xsl:copy-of select="'No effect limitation'"/>
			</xsl:when>
			<xsl:when test="$input='Non Renewal'">
				<xsl:copy-of select="'NonRenewal'"/>
			</xsl:when>
			<xsl:when test="$input='Non Renewal Certain Parties'">
				<xsl:copy-of select="'NonRenewal certain parties'"/>
			</xsl:when>
			<xsl:when test="$input='Non Renewal Under Rule 40.3'">
				<xsl:copy-of select="'NonRenewal under rule 40_3'"/>
			</xsl:when>
			<xsl:when test="$input='Partial Cancellation'">
				<xsl:copy-of select="'Partial cancellation'"/>
			</xsl:when>
			<xsl:when test="$input='Partial Ceasing Effect'">
				<xsl:copy-of select="'Partial ceasing effect'"/>
			</xsl:when>
			<xsl:when test="$input='Partial Invalidation'">
				<xsl:copy-of select="'Partial invalidation'"/>
			</xsl:when>
			<xsl:when test="$input='Partial Refusal'">
				<xsl:copy-of select="'Partial refusal'"/>
			</xsl:when>
			<xsl:when test="$input='Protection Granted'">
				<xsl:copy-of select="'Protection granted'"/>
			</xsl:when>
			<xsl:when test="$input='Registration'">
				<xsl:copy-of select="'Registration'"/>
			</xsl:when>
			<xsl:when test="$input='Renewal'">
				<xsl:copy-of select="'Renewal'"/>
			</xsl:when>
			<xsl:when test="$input='Renewal Under Rule 40.3'">
				<xsl:copy-of select="'Renewal under rule 40_3'"/>
			</xsl:when>
			<xsl:when test="$input='Renunciation'">
				<xsl:copy-of select="'Renunciation'"/>
			</xsl:when>
			<xsl:when test="$input='Representative Appointed'">
				<xsl:copy-of select="'Representative appointed'"/>
			</xsl:when>
			<xsl:when test="$input='Second Part Fee Not Paid'">
				<xsl:copy-of select="'Second part fee not paid'"/>
			</xsl:when>
			<xsl:when test="$input='Second Part Fee Paid'">
				<xsl:copy-of select="'Second part fee paid'"/>
			</xsl:when>
			<xsl:when test="$input='Subsequent Designation'">
				<xsl:copy-of select="'Subsequent designation'"/>
			</xsl:when>
			<xsl:when test="$input='Total Cancellation'">
				<xsl:copy-of select="'Total cancellation'"/>
			</xsl:when>
			<xsl:when test="$input='Total Ceasing Effect'">
				<xsl:copy-of select="'Total ceasing effect'"/>
			</xsl:when>
			<xsl:when test="$input='Total Invalidation'">
				<xsl:copy-of select="'Total invalidation'"/>
			</xsl:when>
			<xsl:when test="$input='Total Refusal'">
				<xsl:copy-of select="'Total refusal'"/>
			</xsl:when>
			<xsl:when test="$input='Transfer Refusal'">
				<xsl:copy-of select="'Transfer refusal'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf31_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Record filed'">
				<xsl:copy-of select="'Record filed'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf32_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='List limited to'">
				<xsl:copy-of select="'List limited to'"/>
			</xsl:when>
			<xsl:when test="$input='Remove from list'">
				<xsl:copy-of select="'Remove from list'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf33_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Holder Right Restriction Opposition Period'">
				<xsl:copy-of select="'Holder right restriction opposition period'"/>
			</xsl:when>
			<xsl:when test="$input='Opposition Period'">
				<xsl:copy-of select="'Opposition period'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
			<xsl:when test="$input='Protection Granted Opposition Period'">
				<xsl:copy-of select="'Protection granted opposition period'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf34_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
			<xsl:when test="$input='Partial Transfer'">
				<xsl:copy-of select="'Partial transfer'"/>
			</xsl:when>
			<xsl:when test="$input='Total Transfer'">
				<xsl:copy-of select="'Total transfer'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf35_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Accepted'">
				<xsl:copy-of select="'Accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Rejected'">
				<xsl:copy-of select="'Rejected'"/>
			</xsl:when>
			<xsl:when test="$input='To Check'">
				<xsl:copy-of select="'To check'"/>
			</xsl:when>
			<xsl:when test="$input='Withdrawn'">
				<xsl:copy-of select="'Withdrawn'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf36_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Record filed'">
				<xsl:copy-of select="'Record filed'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf37_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Applicant'">
				<xsl:copy-of select="'Applicant'"/>
			</xsl:when>
			<xsl:when test="$input='Representative'">
				<xsl:copy-of select="'Representative'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf38_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Change applicant name or address'">
				<xsl:copy-of select="'Change applicant name or address'"/>
			</xsl:when>
			<xsl:when test="$input='Holder'">
				<xsl:copy-of select="'Holder'"/>
			</xsl:when>
			<xsl:when test="$input='Licensee'">
				<xsl:copy-of select="'Licensee'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf39_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Record filed'">
				<xsl:copy-of select="'Record filed'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf40_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Licence'">
				<xsl:copy-of select="'Licence'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
			<xsl:when test="$input='Sub-Licence'">
				<xsl:copy-of select="'Sublicence'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf41_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Record filed'">
				<xsl:copy-of select="'Record filed'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf42_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Unknown'">
				<xsl:copy-of select="'Unknown'"/>
			</xsl:when>
			<xsl:when test="$input='Exclusive'">
				<xsl:copy-of select="'Exclusive'"/>
			</xsl:when>
			<xsl:when test="$input='Nonexclusive'">
				<xsl:copy-of select="'NonExclusive'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf43_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Cancelled'">
				<xsl:copy-of select="'Cancelled'"/>
			</xsl:when>
			<xsl:when test="$input='Expired'">
				<xsl:copy-of select="'Expired'"/>
			</xsl:when>
			<xsl:when test="$input='Valid'">
				<xsl:copy-of select="'Valid'"/>
			</xsl:when>
			<xsl:when test="$input='To Verify'">
				<xsl:copy-of select="'To verify'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf44_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Accepted'">
				<xsl:copy-of select="'Accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Rejected'">
				<xsl:copy-of select="'Rejected'"/>
			</xsl:when>
			<xsl:when test="$input='To Check'">
				<xsl:copy-of select="'To check'"/>
			</xsl:when>
			<xsl:when test="$input='Withdrawn'">
				<xsl:copy-of select="'Withdrawn'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf45_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Merger'">
				<xsl:copy-of select="'Merger'"/>
			</xsl:when>
			<xsl:when test="$input='Partial Transfer'">
				<xsl:copy-of select="'Partial transfer'"/>
			</xsl:when>
			<xsl:when test="$input='Short Notation'">
				<xsl:copy-of select="'Short notation'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf46_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Action before Court of Justice pending'">
				<xsl:copy-of select="'Action before court of justice pending'"/>
			</xsl:when>
			<xsl:when test="$input='Appeal pending'">
				<xsl:copy-of select="'Appeal pending'"/>
			</xsl:when>
			<xsl:when test="$input='Application accepted'">
				<xsl:copy-of select="'Application accepted'"/>
			</xsl:when>
			<xsl:when test="$input='Application deemed withdrawn'">
				<xsl:copy-of select="'Application deemed withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Application filed'">
				<xsl:copy-of select="'Application filed'"/>
			</xsl:when>
			<xsl:when test="$input='Application opposed'">
				<xsl:copy-of select="'Application opposed'"/>
			</xsl:when>
			<xsl:when test="$input='Application published'">
				<xsl:copy-of select="'Application published'"/>
			</xsl:when>
			<xsl:when test="$input='Application refused'">
				<xsl:copy-of select="'Application refused'"/>
			</xsl:when>
			<xsl:when test="$input='Application withdrawn'">
				<xsl:copy-of select="'Application withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Classification checked'">
				<xsl:copy-of select="'Classification checked'"/>
			</xsl:when>
			<xsl:when test="$input='Conversion requested'">
				<xsl:copy-of select="'Conversion requested'"/>
			</xsl:when>
			<xsl:when test="$input='Expired'">
				<xsl:copy-of select="'Expired'"/>
			</xsl:when>
			<xsl:when test="$input='Filing date accorded'">
				<xsl:copy-of select="'Filing date accorded'"/>
			</xsl:when>
			<xsl:when test="$input='Interruption of proceedings'">
				<xsl:copy-of select="'Interruption of proceedings'"/>
			</xsl:when>
			<xsl:when test="$input='Invalidity proceeding pending'">
				<xsl:copy-of select="'Invalidity proceeding pending'"/>
			</xsl:when>
			<xsl:when test="$input='Registered'">
				<xsl:copy-of select="'Registered'"/>
			</xsl:when>
			<xsl:when test="$input='Registration cancellation pending'">
				<xsl:copy-of select="'Registration cancellation pending'"/>
			</xsl:when>
			<xsl:when test="$input='Registration cancelled'">
				<xsl:copy-of select="'Registration cancelled'"/>
			</xsl:when>
			<xsl:when test="$input='Registration opposed'">
				<xsl:copy-of select="'Registration opposed'"/>
			</xsl:when>
			<xsl:when test="$input='Registration surrendered'">
				<xsl:copy-of select="'Registration surrendered'"/>
			</xsl:when>
			<xsl:when test="$input='Revocation proceeding pending'">
				<xsl:copy-of select="'Revocation proceeding pending'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf47_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Insert'">
				<xsl:copy-of select="'Insert'"/>
			</xsl:when>
			<xsl:when test="$input='Update'">
				<xsl:copy-of select="'Update'"/>
			</xsl:when>
			<xsl:when test="$input='Delete'">
				<xsl:copy-of select="'Delete'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf48_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Insert'">
				<xsl:copy-of select="'Insert'"/>
			</xsl:when>
			<xsl:when test="$input='Update'">
				<xsl:copy-of select="'Update'"/>
			</xsl:when>
			<xsl:when test="$input='Delete'">
				<xsl:copy-of select="'Delete'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf49_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Association'">
				<xsl:copy-of select="'Association'"/>
			</xsl:when>
			<xsl:when test="$input='Employee'">
				<xsl:copy-of select="'Employee'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
			<xsl:when test="$input='Lawyer'">
				<xsl:copy-of select="'Lawyer'"/>
			</xsl:when>
			<xsl:when test="$input='Professional Representative'">
				<xsl:copy-of select="'Professional representative'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf50_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Filing date'">
				<xsl:copy-of select="'Filing date'"/>
			</xsl:when>
			<xsl:when test="$input='Registration date'">
				<xsl:copy-of select="'Registration date'"/>
			</xsl:when>
			<xsl:when test="$input='Use date'">
				<xsl:copy-of select="'Use date'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf51_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Mark'">
				<xsl:copy-of select="'Mark'"/>
			</xsl:when>
			<xsl:when test="$input='Registered mark with reputation'">
				<xsl:copy-of select="'Registered mark with reputation'"/>
			</xsl:when>
			<xsl:when test="$input='Well-known mark'">
				<xsl:copy-of select="'Well known mark'"/>
			</xsl:when>
			<xsl:when test="$input='Non-registered mark'">
				<xsl:copy-of select="'NonRegistered mark'"/>
			</xsl:when>
			<xsl:when test="$input='Sign used in trade'">
				<xsl:copy-of select="'Sign used in trade'"/>
			</xsl:when>
			<xsl:when test="$input='Mark filed by an agent'">
				<xsl:copy-of select="'Mark filed by an agent'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf52_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Opposition filed'">
				<xsl:copy-of select="'Opposition filed'"/>
			</xsl:when>
			<xsl:when test="$input='Admissibility checked'">
				<xsl:copy-of select="'Admissibility of opposition filing checked'"/>
			</xsl:when>
			<xsl:when test="$input='Cooling-off period'">
				<xsl:copy-of select="'Cooling off period taken'"/>
			</xsl:when>
			<xsl:when test="$input='Commencement of proceeding'">
				<xsl:copy-of select="'Proceedings of opposition commenced'"/>
			</xsl:when>
			<xsl:when test="$input='Agreement between parties'">
				<xsl:copy-of select="'Agreement between parties reached'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM withdrawn'">
				<xsl:copy-of select="'Application or trademark finally withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM limited'">
				<xsl:copy-of select="'Application or trademark finally  limited'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - Opposition withdrawn'">
				<xsl:copy-of select="'Final decision_Opposition withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM rejected by ED'">
				<xsl:copy-of select="'Application or trademark finally rejected in full'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM rejected in part'">
				<xsl:copy-of select="'Application or trademark finally in part'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM rejected'">
				<xsl:copy-of select="' '"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - Opposition rejected'">
				<xsl:copy-of select="'Opposition finally rejected'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - Opposition not duly entered'">
				<xsl:copy-of select="' '"/>
			</xsl:when>
			<xsl:when test="$input='No decision - Opposition not duly entered'">
				<xsl:copy-of select="' '"/>
			</xsl:when>
			<xsl:when test="$input='Opposition closed'">
				<xsl:copy-of select="'Opposition closed'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf53_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Certificate'">
				<xsl:copy-of select="'Certificate'"/>
			</xsl:when>
			<xsl:when test="$input='Collective'">
				<xsl:copy-of select="'Collective'"/>
			</xsl:when>
			<xsl:when test="$input='Defensive'">
				<xsl:copy-of select="'Defensive'"/>
			</xsl:when>
			<xsl:when test="$input='Individual'">
				<xsl:copy-of select="'Individual'"/>
			</xsl:when>
			<xsl:when test="$input='Guarantee'">
				<xsl:copy-of select="'Guarantee'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf54_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Word'">
				<xsl:copy-of select="'Word'"/>
			</xsl:when>
			<xsl:when test="$input='Stylized characters'">
				<xsl:copy-of select="'Stylized characters'"/>
			</xsl:when>
			<xsl:when test="$input='Figurative'">
				<xsl:copy-of select="'Figurative'"/>
			</xsl:when>
			<xsl:when test="$input='Combined'">
				<xsl:copy-of select="'Combined'"/>
			</xsl:when>
			<xsl:when test="$input='3-D'">
				<xsl:copy-of select="'Three dimensional'"/>
			</xsl:when>
			<xsl:when test="$input='Colour'">
				<xsl:copy-of select="'Colour'"/>
			</xsl:when>
			<xsl:when test="$input='Sound'">
				<xsl:copy-of select="'Sound'"/>
			</xsl:when>
			<xsl:when test="$input='Hologram'">
				<xsl:copy-of select="'Hologram'"/>
			</xsl:when>
			<xsl:when test="$input='Olfactory'">
				<xsl:copy-of select="'Olfactory'"/>
			</xsl:when>
			<xsl:when test="$input='Motion'">
				<xsl:copy-of select="'Motion'"/>
			</xsl:when>
			<xsl:when test="$input='Municipal'">
				<xsl:copy-of select="'Municipal'"/>
			</xsl:when>
			<xsl:when test="$input='Chimney'">
				<xsl:copy-of select="'Chimney'"/>
			</xsl:when>
			<xsl:when test="$input='Kennfaden'">
				<xsl:copy-of select="'Kennfaden'"/>
			</xsl:when>
			<xsl:when test="$input='Other'">
				<xsl:copy-of select="'Other'"/>
			</xsl:when>
			<xsl:when test="$input='Undefined'">
				<xsl:copy-of select="'Undefined'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf55_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Opposition filed'">
				<xsl:copy-of select="'Opposition filed'"/>
			</xsl:when>
			<xsl:when test="$input='Admissibility checked'">
				<xsl:copy-of select="'Admissibility checked'"/>
			</xsl:when>
			<xsl:when test="$input='Cooling-off period'">
				<xsl:copy-of select="'Coolingoff period'"/>
			</xsl:when>
			<xsl:when test="$input='Commencement of proceeding'">
				<xsl:copy-of select="'Commencement of proceeding'"/>
			</xsl:when>
			<xsl:when test="$input='Agreement between parties'">
				<xsl:copy-of select="'Agreement between parties'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM withdrawn'">
				<xsl:copy-of select="'Final decision_CTM withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM limited'">
				<xsl:copy-of select="'Final decision_CTM limited'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - Opposition withdrawn'">
				<xsl:copy-of select="'Final decision_Opposition withdrawn'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM rejected by ED'">
				<xsl:copy-of select="'Final decision_CTM rejected by ED'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM rejected in part'">
				<xsl:copy-of select="'Final decision_CTM rejected in part'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - CTM rejected'">
				<xsl:copy-of select="'Final decision_CTM rejected'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - Opposition rejected'">
				<xsl:copy-of select="'Final decision_Opposition rejected'"/>
			</xsl:when>
			<xsl:when test="$input='Final decision - Opposition not duly entered'">
				<xsl:copy-of select="'Final decision_Opposition not duly entered'"/>
			</xsl:when>
			<xsl:when test="$input='No decision - Opposition not duly entered'">
				<xsl:copy-of select="'No decision_Opposition not duly entered'"/>
			</xsl:when>
			<xsl:when test="$input='Opposition closed'">
				<xsl:copy-of select="'Opposition closed'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="vmf:vmf56_inputtoresult">
		<xsl:param name="input" select="()"/>
		<xsl:choose>
			<xsl:when test="$input='Fixed'">
				<xsl:copy-of select="'Business fixed'"/>
			</xsl:when>
			<xsl:when test="$input='Mobile Phone'">
				<xsl:copy-of select="'Business mobile'"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:output method="xml" encoding="UTF-8" byte-order-mark="no" indent="yes"/>
	<xsl:template match="/">
		<tmk:TrademarkTransaction xmlns:tmk="http://www.wipo.int/standards/XMLSchema/ST96/Trademark" xmlns:tbl="http://www.oasis-open.org/tables/exchange/1.0" xmlns:m="http://www.w3.org/1998/Math/MathML" xmlns:com="http://www.wipo.int/standards/XMLSchema/ST96/Common">
			<xsl:attribute name="xsi:schemaLocation" namespace="http://www.w3.org/2001/XMLSchema-instance" select="'http://www.wipo.int/standards/XMLSchema/ST96/Trademark C:/wipo/Annex/VI/V20/ST96Schema/flattened/TrademarkTransaction_V2_0.xsd'"/>
			<xsl:for-each select="ns0:Transaction">
				<xsl:attribute name="com:st96Version" select="'V2_0'"/>
				<xsl:for-each select="ns0:TransactionHeader">
					<com:TransactionHeader>
						<xsl:for-each select="ns0:SenderDetails">
							<com:SenderBag>
								<xsl:for-each select="ns0:RequestIdentifier">
									<com:RequestIdentifier>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestIdentifier>
								</xsl:for-each>
								<xsl:for-each select="ns0:RequestLanguageCode">
									<com:RequestLanguageCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestLanguageCode>
								</xsl:for-each>
								<xsl:for-each select="ns0:RequestXSDVersion">
									<com:RequestXSDVersion>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestXSDVersion>
								</xsl:for-each>
								<xsl:for-each select="ns0:RequestFilename">
									<com:FileName>
										<xsl:sequence select="fn:string(.)"/>
									</com:FileName>
								</xsl:for-each>
								<xsl:for-each select="ns0:RequestStatus">
									<com:RequestStatusCategory>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestStatusCategory>
								</xsl:for-each>
								<xsl:for-each select="ns0:RequestProducer">
									<com:RequestProducer>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestProducer>
								</xsl:for-each>
								<xsl:for-each select="ns0:RequestReceivingOfficeCode">
									<com:RequestReceivingOfficeCode>
										<xsl:sequence select="fn:string(.)"/>
									</com:RequestReceivingOfficeCode>
								</xsl:for-each>
								<xsl:for-each select="ns0:LoginInformation">
									<com:LoginInformation>
										<xsl:for-each select="ns0:Login">
											<com:Login>
												<xsl:sequence select="fn:string(.)"/>
											</com:Login>
										</xsl:for-each>
										<xsl:for-each select="ns0:LoginEmail">
											<com:LoginEmail>
												<xsl:sequence select="fn:string(.)"/>
											</com:LoginEmail>
										</xsl:for-each>
										<xsl:for-each select="ns0:Password">
											<com:Password>
												<xsl:sequence select="fn:string(.)"/>
											</com:Password>
										</xsl:for-each>
									</com:LoginInformation>
								</xsl:for-each>
								<xsl:for-each select="ns0:RequestProducerDate">
									<com:RequestDate>
										<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
									</com:RequestDate>
								</xsl:for-each>
								<xsl:for-each select="ns0:RequestProducerDateTime">
									<com:RequestDateTime>
										<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
									</com:RequestDateTime>
								</xsl:for-each>
							</com:SenderBag>
						</xsl:for-each>
						<xsl:for-each select="ns0:ReceiverDetails">
							<com:ReceiverBag>
								<xsl:for-each select="ns0:ReceiverDateTime">
									<com:ReceiverDateTime>
										<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
									</com:ReceiverDateTime>
								</xsl:for-each>
								<xsl:for-each select="ns0:Comment">
									<xsl:variable name="var1_languageCode" as="node()?" select="@languageCode"/>
									<com:CommentText>
										<xsl:if test="fn:exists($var1_languageCode)">
											<xsl:attribute name="com:languageCode" select="fn:string($var1_languageCode)"/>
										</xsl:if>
										<xsl:sequence select="fn:string(.)"/>
									</com:CommentText>
								</xsl:for-each>
							</com:ReceiverBag>
						</xsl:for-each>
					</com:TransactionHeader>
				</xsl:for-each>
				<xsl:for-each select="ns0:TradeMarkTransactionBody">
					<xsl:variable name="var624_resultof_first" as="node()" select="ns0:TransactionContentDetails"/>
					<xsl:variable name="var623_resultof_first" as="node()" select="$var624_resultof_first/ns0:TransactionData"/>
					<xsl:variable name="var622_resultof_vmf__inputtoresult" as="xs:string?">
						<xsl:call-template name="vmf:vmf1_inputtoresult">
							<xsl:with-param name="input" select="fn:string($var624_resultof_first/ns0:TransactionCode)" as="xs:string"/>
						</xsl:call-template>
					</xsl:variable>
					<tmk:TrademarkTransactionBody>
						<xsl:attribute name="com:st96Version" select="'V2_0'"/>
						<xsl:for-each select="ns0:TransactionErrorDetails">
							<com:TransactionErrorBag>
								<xsl:for-each select="ns0:TransactionError">
									<com:TransactionError>
										<xsl:for-each select="ns0:TransactionErrorCode">
											<com:TransactionErrorCode>
												<xsl:sequence select="fn:string(.)"/>
											</com:TransactionErrorCode>
										</xsl:for-each>
										<xsl:for-each select="ns0:TransactionErrorText">
											<xsl:variable name="var2_languageCode" as="node()?" select="@languageCode"/>
											<com:TransactionErrorText>
												<xsl:if test="fn:exists($var2_languageCode)">
													<xsl:attribute name="com:languageCode" select="fn:string($var2_languageCode)"/>
												</xsl:if>
												<xsl:sequence select="fn:string(.)"/>
											</com:TransactionErrorText>
										</xsl:for-each>
									</com:TransactionError>
								</xsl:for-each>
							</com:TransactionErrorBag>
						</xsl:for-each>
						<tmk:TransactionContentBag>
							<xsl:attribute name="com:st96Version" select="'V2_0'"/>
							<xsl:for-each select="$var624_resultof_first/ns0:TransactionIdentifier">
								<com:TransactionIdentifier>
									<xsl:sequence select="fn:string(.)"/>
								</com:TransactionIdentifier>
							</xsl:for-each>
							<xsl:if test="fn:exists($var622_resultof_vmf__inputtoresult)">
								<com:TransactionCategory>
									<xsl:sequence select="$var622_resultof_vmf__inputtoresult"/>
								</com:TransactionCategory>
							</xsl:if>
							<xsl:variable name="var4_resultof_filter" as="node()?">
								<xsl:for-each select="$var624_resultof_first/ns0:TransactionSubCode">
									<xsl:variable name="var3_resultof_vmf__inputtoresult" as="xs:string?">
										<xsl:call-template name="vmf:vmf2_inputtoresult">
											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
										</xsl:call-template>
									</xsl:variable>
									<xsl:if test="fn:exists($var3_resultof_vmf__inputtoresult)">
										<xsl:sequence select="."/>
									</xsl:if>
								</xsl:for-each>
							</xsl:variable>
							<xsl:for-each select="$var4_resultof_filter">
								<com:TransactionSubCode>
									<xsl:call-template name="vmf:vmf2_inputtoresult">
										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
									</xsl:call-template>
								</com:TransactionSubCode>
							</xsl:for-each>
							<tmk:TransactionData>
								<xsl:attribute name="com:st96Version" select="'V2_0'"/>
								<xsl:for-each select="$var623_resultof_first/ns0:TradeMarkApplication">
									<tmk:TrademarkApplication>
										<xsl:attribute name="com:st96Version" select="'V2_0'"/>
										<xsl:for-each select="ns0:RequestSoftware">
											<com:RequestSoftware>
												<xsl:sequence select="()"/>
											</com:RequestSoftware>
										</xsl:for-each>
										<xsl:for-each select="ns0:ApplicationFormName">
											<tmk:ApplicationFormName>
												<xsl:sequence select="fn:string(.)"/>
											</tmk:ApplicationFormName>
										</xsl:for-each>
										<xsl:for-each select="ns0:RequestSearch">
											<tmk:RequestSearch>
												<xsl:sequence select="()"/>
											</tmk:RequestSearch>
										</xsl:for-each>
										<xsl:for-each select="ns0:RequestExamination">
											<com:RequestExamination>
												<xsl:sequence select="()"/>
											</com:RequestExamination>
										</xsl:for-each>
										<xsl:for-each select="ns0:DocumentIncludedDetails">
											<com:DocumentIncludedBag>
												<xsl:for-each select="ns0:DocumentIncluded">
													<com:DocumentIncluded>
														<xsl:sequence select="()"/>
													</com:DocumentIncluded>
												</xsl:for-each>
											</com:DocumentIncludedBag>
										</xsl:for-each>
										<xsl:for-each select="ns0:TradeMarkDetails">
											<tmk:TrademarkBag>
												<xsl:for-each select="ns0:TradeMark">
													<tmk:Trademark>
														<xsl:for-each select="ns0:RegistrationOfficeCode">
															<com:RegistrationOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RegistrationOfficeCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:ReceivingOfficeCode">
															<com:ReceivingOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:ReceivingOfficeCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:ReceivingOfficeDate">
															<com:ReceivingOfficeDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:ReceivingOfficeDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:ApplicationNumber">
															<com:ApplicationNumber>
																<com:ApplicationNumberText>
																	<xsl:sequence select="fn:string(.)"/>
																</com:ApplicationNumberText>
															</com:ApplicationNumber>
														</xsl:for-each>
														<xsl:for-each select="ns0:RegistrationNumber">
															<com:RegistrationNumber>
																<xsl:sequence select="fn:string(.)"/>
															</com:RegistrationNumber>
														</xsl:for-each>
														<xsl:for-each select="ns0:ApplicationDate">
															<tmk:ApplicationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:ApplicationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:ApplicationDateTime">
															<tmk:ApplicationDateTime>
																<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
															</tmk:ApplicationDateTime>
														</xsl:for-each>
														<xsl:for-each select="ns0:RegistrationDate">
															<com:RegistrationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RegistrationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:OtherDate">
															<tmk:OtherDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:OtherDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:FilingPlace">
															<com:FilingPlace>
																<xsl:sequence select="fn:string(.)"/>
															</com:FilingPlace>
														</xsl:for-each>
														<xsl:for-each select="ns0:ApplicationReference">
															<com:ApplicantFileReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:ApplicantFileReference>
														</xsl:for-each>
														<xsl:for-each select="ns0:ApplicantSideCaseKey">
															<tmk:ApplicantSideCaseIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:ApplicantSideCaseIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:ApplicationLanguageCode">
															<tmk:ApplicationLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:ApplicationLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:SecondLanguageCode">
															<com:SecondLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:SecondLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:CorrespondenceLanguageCode">
															<com:CorrespondenceLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:CorrespondenceLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:ExaminedApplicationNumber">
															<tmk:ExaminedApplicationNumber>
																<com:ApplicationNumberText>
																	<xsl:sequence select="fn:string(.)"/>
																</com:ApplicationNumberText>
															</tmk:ExaminedApplicationNumber>
														</xsl:for-each>
														<xsl:for-each select="ns0:ExpiryDate">
															<com:ExpiryDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:ExpiryDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:TerminationDate">
															<tmk:TerminationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:TerminationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:MarkCurrentStatusCode">
															<tmk:MarkCurrentStatusCode>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:MarkCurrentStatusCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:MarkCurrentStatusDate">
															<tmk:MarkCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:MarkCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:NonUseCancelledIndicator">
															<tmk:NonUseCancelledIndicator>
																<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
															</tmk:NonUseCancelledIndicator>
														</xsl:for-each>
														<xsl:for-each select="ns0:SpecialCircumstanceText">
															<tmk:SpecialCircumstanceText>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:SpecialCircumstanceText>
														</xsl:for-each>
														<xsl:for-each select="ns0:TradeDistinctivenessIndicator">
															<tmk:TradeDistinctivenessIndicator>
																<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
															</tmk:TradeDistinctivenessIndicator>
														</xsl:for-each>
														<xsl:for-each select="ns0:TradeDistinctivenessText">
															<tmk:TradeDistinctivenessText>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:TradeDistinctivenessText>
														</xsl:for-each>
														<xsl:for-each select="ns0:UseRight">
															<tmk:UseRight>
																<xsl:sequence select="()"/>
															</tmk:UseRight>
														</xsl:for-each>
														<xsl:for-each select="ns0:AsItIsProtectionIndicator">
															<tmk:AsItIsProtectionIndicator>
																<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
															</tmk:AsItIsProtectionIndicator>
														</xsl:for-each>
														<xsl:for-each select="ns0:UseRequirementText">
															<tmk:UseRequirementText>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:UseRequirementText>
														</xsl:for-each>
														<xsl:for-each select="ns0:UseLimitationText">
															<tmk:UseLimitationText>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:UseLimitationText>
														</xsl:for-each>
														<xsl:for-each select="ns0:OppositionPeriodStartDate">
															<tmk:OppositionPeriodStartDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:OppositionPeriodStartDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:OppositionPeriodEndDate">
															<tmk:OppositionPeriodEndDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:OppositionPeriodEndDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:Authorization">
															<com:Authorization>
																<xsl:sequence select="()"/>
															</com:Authorization>
														</xsl:for-each>
														<xsl:for-each select="ns0:CorrespondenceAddress">
															<com:CorrespondenceAddress>
																<xsl:sequence select="()"/>
															</com:CorrespondenceAddress>
														</xsl:for-each>
													</tmk:Trademark>
												</xsl:for-each>
											</tmk:TrademarkBag>
										</xsl:for-each>
										<xsl:for-each select="ns0:PaymentDetails">
											<com:PaymentBag>
												<xsl:for-each select="ns0:Payment">
													<com:Payment>
														<xsl:sequence select="()"/>
													</com:Payment>
												</xsl:for-each>
											</com:PaymentBag>
										</xsl:for-each>
										<xsl:for-each select="ns0:ReimbursementDetails">
											<com:ReimbursementBag>
												<xsl:for-each select="ns0:Reimbursement">
													<com:Reimbursement>
														<xsl:sequence select="()"/>
													</com:Reimbursement>
												</xsl:for-each>
											</com:ReimbursementBag>
										</xsl:for-each>
										<xsl:for-each select="ns0:SignatoryDetails">
											<com:SignatureBag>
												<xsl:sequence select="()"/>
											</com:SignatureBag>
										</xsl:for-each>
									</tmk:TrademarkApplication>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:TradeMarkDetails">
									<tmk:TrademarkBag>
										<xsl:for-each select="ns0:TradeMark">
											<xsl:variable name="var373_current" as="node()" select="."/>
											<xsl:variable name="var372_operationCode" as="node()?" select="@operationCode"/>
											<tmk:Trademark>
												<xsl:if test="fn:exists($var372_operationCode)">
													<xsl:attribute name="com:operationCategory" select="fn:string($var372_operationCode)"/>
												</xsl:if>
												<xsl:for-each select="ns0:RegistrationOfficeCode">
													<com:RegistrationOfficeCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:RegistrationOfficeCode>
												</xsl:for-each>
												<xsl:for-each select="ns0:ReceivingOfficeCode">
													<com:ReceivingOfficeCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:ReceivingOfficeCode>
												</xsl:for-each>
												<xsl:for-each select="ns0:ReceivingOfficeDate">
													<com:ReceivingOfficeDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</com:ReceivingOfficeDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:ApplicationNumber">
													<com:ApplicationNumber>
														<com:ApplicationNumberText>
															<xsl:sequence select="fn:string(.)"/>
														</com:ApplicationNumberText>
													</com:ApplicationNumber>
												</xsl:for-each>
												<xsl:for-each select="ns0:RegistrationNumber">
													<com:RegistrationNumber>
														<xsl:sequence select="fn:string(.)"/>
													</com:RegistrationNumber>
												</xsl:for-each>
												<xsl:for-each select="ns0:ApplicationDate">
													<tmk:ApplicationDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:ApplicationDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:ApplicationDateTime">
													<tmk:ApplicationDateTime>
														<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
													</tmk:ApplicationDateTime>
												</xsl:for-each>
												<xsl:for-each select="ns0:RegistrationDate">
													<com:RegistrationDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</com:RegistrationDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:OtherDate">
													<xsl:variable name="var6_otherDateKind" as="node()?" select="@otherDateKind"/>
													<tmk:OtherDate>
														<xsl:if test="fn:exists($var6_otherDateKind)">
															<xsl:variable name="var5_resultof_vmf__inputtoresult" as="xs:string?">
																<xsl:call-template name="vmf:vmf3_inputtoresult">
																	<xsl:with-param name="input" select="fn:string($var6_otherDateKind)" as="xs:string"/>
																</xsl:call-template>
															</xsl:variable>
															<xsl:if test="fn:exists($var5_resultof_vmf__inputtoresult)">
																<xsl:attribute name="tmk:otherDateCategory" select="$var5_resultof_vmf__inputtoresult"/>
															</xsl:if>
														</xsl:if>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:OtherDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:FilingPlace">
													<com:FilingPlace>
														<xsl:sequence select="fn:string(.)"/>
													</com:FilingPlace>
												</xsl:for-each>
												<xsl:for-each select="ns0:ApplicationReference">
													<com:ApplicantFileReference>
														<xsl:sequence select="fn:string(.)"/>
													</com:ApplicantFileReference>
												</xsl:for-each>
												<xsl:for-each select="ns0:ApplicantSideCaseKey">
													<tmk:ApplicantSideCaseIdentifier>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ApplicantSideCaseIdentifier>
												</xsl:for-each>
												<xsl:for-each select="ns0:ApplicationLanguageCode">
													<tmk:ApplicationLanguageCode>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ApplicationLanguageCode>
												</xsl:for-each>
												<xsl:for-each select="ns0:SecondLanguageCode">
													<com:SecondLanguageCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:SecondLanguageCode>
												</xsl:for-each>
												<xsl:for-each select="ns0:CorrespondenceLanguageCode">
													<com:CorrespondenceLanguageCode>
														<xsl:sequence select="fn:string(.)"/>
													</com:CorrespondenceLanguageCode>
												</xsl:for-each>
												<xsl:for-each select="ns0:ExaminedApplicationNumber">
													<tmk:ExaminedApplicationNumber>
														<com:ApplicationNumberText>
															<xsl:sequence select="fn:string(.)"/>
														</com:ApplicationNumberText>
													</tmk:ExaminedApplicationNumber>
												</xsl:for-each>
												<xsl:for-each select="ns0:ExpiryDate">
													<com:ExpiryDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</com:ExpiryDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:TerminationDate">
													<tmk:TerminationDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:TerminationDate>
												</xsl:for-each>
												<xsl:variable name="var8_resultof_filter" as="node()?">
													<xsl:for-each select="ns0:MarkCurrentStatusCode">
														<xsl:variable name="var7_resultof_vmf__inputtoresult" as="xs:string?">
															<xsl:call-template name="vmf:vmf4_inputtoresult">
																<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
															</xsl:call-template>
														</xsl:variable>
														<xsl:if test="fn:exists($var7_resultof_vmf__inputtoresult)">
															<xsl:sequence select="."/>
														</xsl:if>
													</xsl:for-each>
												</xsl:variable>
												<xsl:for-each select="$var8_resultof_filter">
													<tmk:MarkCurrentStatusCode>
														<xsl:call-template name="vmf:vmf4_inputtoresult">
															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
														</xsl:call-template>
													</tmk:MarkCurrentStatusCode>
												</xsl:for-each>
												<xsl:for-each select="ns0:MarkCurrentStatusDate">
													<tmk:MarkCurrentStatusDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:MarkCurrentStatusDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:DesignatedCountryDetails">
													<tmk:DesignatedCountryBag>
														<xsl:for-each select="ns0:DesignatedCountry">
															<tmk:DesignatedCountry>
																<com:DesignatedCountryCode>
																	<xsl:sequence select="fn:string(ns0:DesignatedCountryCode)"/>
																</com:DesignatedCountryCode>
																<xsl:variable name="var10_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:DesignatedUnderCode">
																		<xsl:variable name="var9_resultof_vmf__inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf5_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var9_resultof_vmf__inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var10_resultof_filter">
																	<tmk:MadridSystemCategory>
																		<xsl:call-template name="vmf:vmf5_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</tmk:MadridSystemCategory>
																</xsl:for-each>
															</tmk:DesignatedCountry>
														</xsl:for-each>
													</tmk:DesignatedCountryBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:PreviousRegistrationDetails">
													<tmk:PreviousRegistrationBag>
														<xsl:for-each select="ns0:PreviousRegistration">
															<tmk:PreviousRegistration>
																<xsl:for-each select="ns0:RegistrationOfficeCode">
																	<com:RegistrationOfficeCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:RegistrationOfficeCode>
																</xsl:for-each>
																<tmk:PreviousRegistrationNumber>
																	<xsl:sequence select="fn:string(ns0:PreviousRegistrationNumber)"/>
																</tmk:PreviousRegistrationNumber>
																<xsl:for-each select="ns0:PreviousRegistrationDate">
																	<tmk:PreviousRegistrationDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:PreviousRegistrationDate>
																</xsl:for-each>
																<xsl:variable name="var12_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:PreviousRegistrationBasis">
																		<xsl:variable name="var11_resultof_vmf__inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf6_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var11_resultof_vmf__inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var12_resultof_filter">
																	<tmk:PreviousRegistrationBasisCategory>
																		<xsl:call-template name="vmf:vmf6_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</tmk:PreviousRegistrationBasisCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:PreviousRegistrationCancellationDate">
																	<tmk:PreviousRegistrationCancellationDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:PreviousRegistrationCancellationDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:PreviousRegistrationPriorityDate">
																	<tmk:PreviousRegistrationPriorityDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:PreviousRegistrationPriorityDate>
																</xsl:for-each>
															</tmk:PreviousRegistration>
														</xsl:for-each>
													</tmk:PreviousRegistrationBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:AssociatedMarkDetails">
													<tmk:AssociatedMark>
														<xsl:for-each select="ns0:AssociatedApplicationNumber">
															<tmk:AssociatedApplicationNumber>
																<com:ApplicationNumberText>
																	<xsl:sequence select="fn:string(.)"/>
																</com:ApplicationNumberText>
															</tmk:AssociatedApplicationNumber>
														</xsl:for-each>
													</tmk:AssociatedMark>
												</xsl:for-each>
												<xsl:for-each select="ns0:DivisionalApplicationDetails">
													<tmk:DivisionalApplicationBag>
														<tmk:InitialApplicationNumber>
															<com:ApplicationNumberText>
																<xsl:sequence select="fn:string(ns0:InitialApplicationNumber)"/>
															</com:ApplicationNumberText>
														</tmk:InitialApplicationNumber>
														<xsl:for-each select="ns0:InitialApplicationDate">
															<tmk:InitialApplicationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:InitialApplicationDate>
														</xsl:for-each>
													</tmk:DivisionalApplicationBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:BasicRegistrationApplicationDetails">
													<tmk:BasicRegistrationApplicationBag>
														<xsl:for-each select="ns0:BasicRegistrationApplication">
															<tmk:BasicRegistrationApplication>
																<xsl:for-each select="ns0:RegistrationOfficeCode">
																	<com:RegistrationOfficeCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:RegistrationOfficeCode>
																</xsl:for-each>
																<xsl:for-each select="ns0:BasicApplicationDetails">
																	<tmk:BasicApplicationBag>
																		<xsl:for-each select="ns0:BasicApplication">
																			<tmk:BasicApplication>
																				<tmk:BasicApplicationNumber>
																					<xsl:for-each select="ns0:BasicApplicationNumber">
																						<com:ApplicationNumberText>
																							<xsl:sequence select="fn:string(.)"/>
																						</com:ApplicationNumberText>
																					</xsl:for-each>
																				</tmk:BasicApplicationNumber>
																				<xsl:for-each select="ns0:BasicApplicationDate">
																					<tmk:BasicApplicationDate>
																						<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																					</tmk:BasicApplicationDate>
																				</xsl:for-each>
																			</tmk:BasicApplication>
																		</xsl:for-each>
																	</tmk:BasicApplicationBag>
																</xsl:for-each>
																<xsl:for-each select="ns0:BasicRegistrationDetails">
																	<tmk:BasicRegistrationBag>
																		<xsl:for-each select="ns0:BasicRegistration">
																			<tmk:BasicRegistration>
																				<xsl:for-each select="ns0:BasicRegistrationNumber">
																					<tmk:BasicRegistrationNumber>
																						<xsl:sequence select="fn:string(.)"/>
																					</tmk:BasicRegistrationNumber>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:BasicRegistrationDate">
																					<tmk:BasicRegistrationDate>
																						<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																					</tmk:BasicRegistrationDate>
																				</xsl:for-each>
																			</tmk:BasicRegistration>
																		</xsl:for-each>
																	</tmk:BasicRegistrationBag>
																</xsl:for-each>
															</tmk:BasicRegistrationApplication>
														</xsl:for-each>
													</tmk:BasicRegistrationApplicationBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:InternationalMarkKey">
													<tmk:InternationalMarkIdentifierBag>
														<xsl:for-each select="ns0:Identifier">
															<xsl:variable name="var13_identifierKindCode" as="node()?" select="@identifierKindCode"/>
															<tmk:InternationalMarkIdentifier>
																<xsl:if test="fn:exists($var13_identifierKindCode)">
																	<xsl:attribute name="com:officeCode" select="fn:string($var13_identifierKindCode)"/>
																</xsl:if>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:InternationalMarkIdentifier>
														</xsl:for-each>
													</tmk:InternationalMarkIdentifierBag>
												</xsl:for-each>
												<xsl:variable name="var15_resultof_filter" as="node()?">
													<xsl:for-each select="ns0:KindMark">
														<xsl:variable name="var14_resultof_vmf__inputtoresult" as="xs:string?">
															<xsl:call-template name="vmf:vmf7_inputtoresult">
																<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
															</xsl:call-template>
														</xsl:variable>
														<xsl:if test="fn:exists($var14_resultof_vmf__inputtoresult)">
															<xsl:sequence select="."/>
														</xsl:if>
													</xsl:for-each>
												</xsl:variable>
												<xsl:for-each select="$var15_resultof_filter">
													<tmk:MarkCategory>
														<xsl:call-template name="vmf:vmf7_inputtoresult">
															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
														</xsl:call-template>
													</tmk:MarkCategory>
												</xsl:for-each>
												<xsl:for-each select="ns0:MarkImageDetails/ns0:MarkImage">
													<xsl:variable name="var46_MarkImageRepresentationSize" as="node()?" select="ns0:MarkImageRepresentationSize"/>
													<tmk:MarkRepresentation>
														<xsl:variable name="var17_resultof_filter" as="node()?">
															<xsl:for-each select="$var373_current/ns0:MarkFeature">
																<xsl:variable name="var16_resultof_vmf__inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf8_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var16_resultof_vmf__inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var17_resultof_filter">
															<tmk:MarkFeatureCategory>
																<xsl:call-template name="vmf:vmf8_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</tmk:MarkFeatureCategory>
														</xsl:for-each>
														<tmk:MarkReproduction>
															<xsl:for-each select="$var373_current/ns0:WordMarkSpecification">
																<tmk:WordMarkSpecification>
																	<xsl:for-each select="ns0:MarkVerbalElementText">
																		<xsl:variable name="var18_languageCode" as="node()?" select="@languageCode"/>
																		<tmk:MarkVerbalElementText>
																			<xsl:if test="fn:exists($var18_languageCode)">
																				<xsl:attribute name="com:languageCode" select="fn:string($var18_languageCode)"/>
																			</xsl:if>
																			<xsl:sequence select="fn:string(.)"/>
																		</tmk:MarkVerbalElementText>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkSignificantVerbalElement">
																		<xsl:variable name="var19_languageCode" as="node()?" select="@languageCode"/>
																		<tmk:MarkSignificantVerbalElementText>
																			<xsl:if test="fn:exists($var19_languageCode)">
																				<xsl:attribute name="com:languageCode" select="fn:string($var19_languageCode)"/>
																			</xsl:if>
																			<xsl:sequence select="fn:string(.)"/>
																		</tmk:MarkSignificantVerbalElementText>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkVerbalElementSignificantIndicator">
																		<tmk:MarkVerbalElementSignificantIndicator>
																			<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																		</tmk:MarkVerbalElementSignificantIndicator>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkTranslation">
																		<xsl:variable name="var20_languageCode" as="node()?" select="@languageCode"/>
																		<xsl:variable name="var21_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																		<tmk:MarkTranslationText>
																			<xsl:if test="fn:exists($var20_languageCode)">
																				<xsl:attribute name="com:languageCode" select="fn:string($var20_languageCode)"/>
																			</xsl:if>
																			<xsl:if test="fn:exists($var21_sequenceNumber)">
																				<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var21_sequenceNumber)))"/>
																			</xsl:if>
																			<xsl:sequence select="fn:string(.)"/>
																		</tmk:MarkTranslationText>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkTransliteration">
																		<xsl:variable name="var23_transliterationKind" as="node()?" select="@transliterationKind"/>
																		<tmk:MarkTransliteration>
																			<xsl:if test="fn:exists($var23_transliterationKind)">
																				<xsl:variable name="var22_resultof_vmf__inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf9_inputtoresult">
																						<xsl:with-param name="input" select="fn:string($var23_transliterationKind)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var22_resultof_vmf__inputtoresult)">
																					<xsl:attribute name="tmk:transliterationCategory" select="$var22_resultof_vmf__inputtoresult"/>
																				</xsl:if>
																			</xsl:if>
																			<xsl:sequence select="fn:string(.)"/>
																		</tmk:MarkTransliteration>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkTranscription">
																		<xsl:variable name="var25_transcriptionKind" as="node()?" select="@transcriptionKind"/>
																		<tmk:MarkTranscription>
																			<xsl:if test="fn:exists($var25_transcriptionKind)">
																				<xsl:variable name="var24_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf10_inputtoresult">
																						<xsl:with-param name="input" select="fn:string($var25_transcriptionKind)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var24_resultof_vmf___inputtoresult)">
																					<xsl:attribute name="tmk:transcriptionCategory" select="$var24_resultof_vmf___inputtoresult"/>
																				</xsl:if>
																			</xsl:if>
																			<xsl:sequence select="fn:string(.)"/>
																		</tmk:MarkTranscription>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkStandardCharacterIndicator">
																		<tmk:MarkStandardCharacterIndicator>
																			<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																		</tmk:MarkStandardCharacterIndicator>
																	</xsl:for-each>
																</tmk:WordMarkSpecification>
															</xsl:for-each>
															<tmk:MarkImageBag>
																<tmk:MarkImage>
																	<xsl:for-each select="ns0:MarkImageFilename">
																		<com:FileName>
																			<xsl:sequence select="fn:string(.)"/>
																		</com:FileName>
																	</xsl:for-each>
																	<xsl:variable name="var27_resultof_filter" as="node()?">
																		<xsl:for-each select="ns0:MarkImageFileFormat">
																			<xsl:variable name="var26_resultof_vmf___inputtoresult" as="xs:string?">
																				<xsl:call-template name="vmf:vmf11_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:if test="fn:exists($var26_resultof_vmf___inputtoresult)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:variable>
																	<xsl:for-each select="$var27_resultof_filter">
																		<com:ImageFormatCategory>
																			<xsl:call-template name="vmf:vmf11_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</com:ImageFormatCategory>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkImageColourClaimedText">
																		<xsl:variable name="var28_languageCode" as="node()?" select="@languageCode"/>
																		<xsl:variable name="var29_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																		<tmk:MarkImageColourClaimedText>
																			<xsl:if test="fn:exists($var28_languageCode)">
																				<xsl:attribute name="com:languageCode" select="fn:string($var28_languageCode)"/>
																			</xsl:if>
																			<xsl:if test="fn:exists($var29_sequenceNumber)">
																				<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var29_sequenceNumber)))"/>
																			</xsl:if>
																			<xsl:sequence select="fn:string(.)"/>
																		</tmk:MarkImageColourClaimedText>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkImageColourPartClaimedText">
																		<xsl:variable name="var30_languageCode" as="node()?" select="@languageCode"/>
																		<xsl:variable name="var31_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																		<tmk:MarkImageColourPartClaimedText>
																			<xsl:if test="fn:exists($var30_languageCode)">
																				<xsl:attribute name="com:languageCode" select="fn:string($var30_languageCode)"/>
																			</xsl:if>
																			<xsl:if test="fn:exists($var31_sequenceNumber)">
																				<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var31_sequenceNumber)))"/>
																			</xsl:if>
																			<xsl:sequence select="fn:string(.)"/>
																		</tmk:MarkImageColourPartClaimedText>
																	</xsl:for-each>
																	<xsl:for-each select="$var46_MarkImageRepresentationSize">
																		<xsl:variable name="var32_current" as="node()" select="."/>
																		<xsl:for-each select="ns0:Height">
																			<com:HeightMeasure>
																				<xsl:for-each select="$var32_current/ns0:Unit">
																					<xsl:attribute name="com:measureUnitCode">
																						<xsl:call-template name="vmf:vmf12_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:attribute>
																				</xsl:for-each>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:HeightMeasure>
																		</xsl:for-each>
																	</xsl:for-each>
																	<xsl:for-each select="$var46_MarkImageRepresentationSize">
																		<xsl:variable name="var33_current" as="node()" select="."/>
																		<xsl:for-each select="ns0:Width">
																			<com:WidthMeasure>
																				<xsl:for-each select="$var33_current/ns0:Unit">
																					<xsl:attribute name="com:measureUnitCode">
																						<xsl:call-template name="vmf:vmf12_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:attribute>
																				</xsl:for-each>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:WidthMeasure>
																		</xsl:for-each>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkImageCategory">
																		<tmk:MarkImageClassification>
																			<com:FigurativeElementClassificationBag>
																				<com:NationalFigurativeElementClassificationBag>
																					<xsl:for-each select="ns0:CategoryVersion">
																						<com:NationalClassificationEdition>
																							<xsl:sequence select="fn:string(.)"/>
																						</com:NationalClassificationEdition>
																					</xsl:for-each>
																					<xsl:for-each select="ns0:CategoryCodeDetails/ns0:CategoryCode">
																						<com:NationalFigurativeElementClassification>
																							<xsl:sequence select="fn:string(.)"/>
																						</com:NationalFigurativeElementClassification>
																					</xsl:for-each>
																				</com:NationalFigurativeElementClassificationBag>
																			</com:FigurativeElementClassificationBag>
																		</tmk:MarkImageClassification>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkImageQualityIndicator">
																		<tmk:MarkImageQualityIndicator>
																			<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																		</tmk:MarkImageQualityIndicator>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkImageRenditionDetails">
																		<tmk:MarkImageRenditionBag>
																			<xsl:for-each select="ns0:MarkImageRendition">
																				<xsl:variable name="var40_MarkImageRenditionRepresentati" as="node()?" select="ns0:MarkImageRenditionRepresentationSize"/>
																				<tmk:MarkImageRendition>
																					<xsl:variable name="var35_resultof_filter" as="node()?">
																						<xsl:for-each select="ns0:MarkImageRenditionKind">
																							<xsl:variable name="var34_resultof_vmf___inputtoresult" as="xs:string?">
																								<xsl:call-template name="vmf:vmf13_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:if test="fn:exists($var34_resultof_vmf___inputtoresult)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:for-each>
																					</xsl:variable>
																					<xsl:for-each select="$var35_resultof_filter">
																						<tmk:MarkImageRenditionCategory>
																							<xsl:call-template name="vmf:vmf13_inputtoresult">
																								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																							</xsl:call-template>
																						</tmk:MarkImageRenditionCategory>
																					</xsl:for-each>
																					<xsl:for-each select="ns0:MarkImageRenditionFilename">
																						<com:FileName>
																							<xsl:sequence select="fn:string(.)"/>
																						</com:FileName>
																					</xsl:for-each>
																					<xsl:variable name="var37_resultof_filter" as="node()?">
																						<xsl:for-each select="ns0:MarkImageRenditionFileFormat">
																							<xsl:variable name="var36_resultof_vmf___inputtoresult" as="xs:string?">
																								<xsl:call-template name="vmf:vmf14_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:if test="fn:exists($var36_resultof_vmf___inputtoresult)">
																								<xsl:sequence select="."/>
																							</xsl:if>
																						</xsl:for-each>
																					</xsl:variable>
																					<xsl:for-each select="$var37_resultof_filter">
																						<com:ImageFormatCategory>
																							<xsl:call-template name="vmf:vmf14_inputtoresult">
																								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																							</xsl:call-template>
																						</com:ImageFormatCategory>
																					</xsl:for-each>
																					<xsl:for-each select="ns0:MarkImageRenditionColourMode">
																						<com:ColourModeCategory>
																							<xsl:sequence select="fn:string(.)"/>
																						</com:ColourModeCategory>
																					</xsl:for-each>
																					<xsl:for-each select="$var40_MarkImageRenditionRepresentati">
																						<xsl:variable name="var38_current" as="node()" select="."/>
																						<xsl:for-each select="ns0:Height">
																							<com:HeightMeasure>
																								<xsl:for-each select="$var38_current/ns0:Unit">
																									<xsl:attribute name="com:measureUnitCode">
																										<xsl:call-template name="vmf:vmf15_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																										</xsl:call-template>
																									</xsl:attribute>
																								</xsl:for-each>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:HeightMeasure>
																						</xsl:for-each>
																					</xsl:for-each>
																					<xsl:for-each select="$var40_MarkImageRenditionRepresentati">
																						<xsl:variable name="var39_current" as="node()" select="."/>
																						<xsl:for-each select="ns0:Width">
																							<com:WidthMeasure>
																								<xsl:for-each select="$var39_current/ns0:Unit">
																									<xsl:attribute name="com:measureUnitCode">
																										<xsl:call-template name="vmf:vmf15_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																										</xsl:call-template>
																									</xsl:attribute>
																								</xsl:for-each>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:WidthMeasure>
																						</xsl:for-each>
																					</xsl:for-each>
																				</tmk:MarkImageRendition>
																			</xsl:for-each>
																		</tmk:MarkImageRenditionBag>
																	</xsl:for-each>
																	<xsl:for-each select="ns0:MarkImageColourIndicator">
																		<com:ColourIndicator>
																			<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																		</com:ColourIndicator>
																	</xsl:for-each>
																	<xsl:variable name="var42_resultof_filter" as="node()?">
																		<xsl:for-each select="ns0:MarkImageColourMode">
																			<xsl:variable name="var41_resultof_vmf___inputtoresult" as="xs:string?">
																				<xsl:call-template name="vmf:vmf16_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:if test="fn:exists($var41_resultof_vmf___inputtoresult)">
																				<xsl:sequence select="."/>
																			</xsl:if>
																		</xsl:for-each>
																	</xsl:variable>
																	<xsl:for-each select="$var42_resultof_filter">
																		<com:ColourModeCategory>
																			<xsl:call-template name="vmf:vmf16_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</com:ColourModeCategory>
																	</xsl:for-each>
																</tmk:MarkImage>
															</tmk:MarkImageBag>
															<xsl:for-each select="$var373_current/ns0:MarkSoundDetails">
																<xsl:variable name="var44_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:MarkSound/ns0:MarkSoundFileFormat">
																		<xsl:variable name="var43_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf17_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var43_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<tmk:MarkSoundBag>
																	<tmk:MarkSound>
																		<xsl:for-each select="$var44_resultof_filter">
																			<tmk:SoundFileFormatCategory>
																				<xsl:call-template name="vmf:vmf17_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:SoundFileFormatCategory>
																		</xsl:for-each>
																	</tmk:MarkSound>
																</tmk:MarkSoundBag>
															</xsl:for-each>
														</tmk:MarkReproduction>
														<xsl:for-each select="$var373_current/ns0:MarkDescriptionDetails">
															<xsl:variable name="var45_MarkDescription" as="node()+" select="ns0:MarkDescription"/>
															<tmk:MarkDescriptionBag>
																<xsl:for-each select="$var45_MarkDescription">
																	<tmk:MarkDescriptionText>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:MarkDescriptionText>
																</xsl:for-each>
																<tmk:MarkDescriptionImage>
																	<xsl:for-each select="$var45_MarkDescription[fn:exists(@sequenceNumber)]">
																		<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(@sequenceNumber)))"/>
																	</xsl:for-each>
																</tmk:MarkDescriptionImage>
															</tmk:MarkDescriptionBag>
														</xsl:for-each>
													</tmk:MarkRepresentation>
												</xsl:for-each>
												<xsl:for-each select="ns0:MarkDisclaimerDetails">
													<tmk:MarkDisclaimerBag>
														<xsl:for-each select="ns0:MarkDisclaimer">
															<xsl:variable name="var47_languageCode" as="node()?" select="@languageCode"/>
															<xsl:variable name="var48_sequenceNumber" as="node()?" select="@sequenceNumber"/>
															<tmk:MarkDisclaimerText>
																<xsl:if test="fn:exists($var47_languageCode)">
																	<xsl:attribute name="com:languageCode" select="fn:string($var47_languageCode)"/>
																</xsl:if>
																<xsl:if test="fn:exists($var48_sequenceNumber)">
																	<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var48_sequenceNumber)))"/>
																</xsl:if>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:MarkDisclaimerText>
														</xsl:for-each>
													</tmk:MarkDisclaimerBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:NonUseCancelledIndicator">
													<tmk:NonUseCancelledIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</tmk:NonUseCancelledIndicator>
												</xsl:for-each>
												<xsl:for-each select="ns0:SpecialCircumstanceText">
													<tmk:SpecialCircumstanceText>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:SpecialCircumstanceText>
												</xsl:for-each>
												<xsl:for-each select="ns0:TradeDistinctivenessIndicator">
													<tmk:TradeDistinctivenessIndicator>
														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
													</tmk:TradeDistinctivenessIndicator>
												</xsl:for-each>
												<xsl:for-each select="ns0:TradeDistinctivenessText">
													<xsl:variable name="var49_languageCode" as="node()?" select="@languageCode"/>
													<tmk:TradeDistinctivenessText>
														<xsl:if test="fn:exists($var49_languageCode)">
															<xsl:attribute name="com:languageCode" select="fn:string($var49_languageCode)"/>
														</xsl:if>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:TradeDistinctivenessText>
												</xsl:for-each>
												<xsl:for-each select="ns0:UseRight">
													<tmk:UseRight>
														<xsl:for-each select="ns0:UseRightIndicator">
															<tmk:UseRightIndicator>
																<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
															</tmk:UseRightIndicator>
														</xsl:for-each>
														<xsl:for-each select="ns0:UseRightText">
															<xsl:variable name="var50_languageCode" as="node()?" select="@languageCode"/>
															<tmk:UseRightText>
																<xsl:if test="fn:exists($var50_languageCode)">
																	<xsl:attribute name="com:languageCode" select="fn:string($var50_languageCode)"/>
																</xsl:if>
																<xsl:sequence select="fn:string(.)"/>
															</tmk:UseRightText>
														</xsl:for-each>
														<xsl:for-each select="ns0:UseRightGoodsServices">
															<tmk:UseRightGoodsServices>
																<xsl:for-each select="ns0:ClassificationKindCode">
																	<tmk:ClassificationKindCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:ClassificationKindCode>
																</xsl:for-each>
																<xsl:for-each select="ns0:ClassificationVersion">
																	<com:ClassificationVersion>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:ClassificationVersion>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var51_languageCode" as="node()?" select="@languageCode"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var51_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var51_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
																<xsl:for-each select="ns0:ProposedLeadingClassNumber">
																	<tmk:ProposedLeadingClassNumber>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:ProposedLeadingClassNumber>
																</xsl:for-each>
																<tmk:ClassDescriptionBag>
																	<xsl:for-each select="ns0:ClassDescriptionDetails/ns0:ClassDescription">
																		<tmk:ClassDescription>
																			<xsl:for-each select="ns0:ClassNumber">
																				<tmk:ClassNumber>
																					<xsl:sequence select="fn:string(.)"/>
																				</tmk:ClassNumber>
																			</xsl:for-each>
																			<xsl:variable name="var53_resultof_filter" as="node()?">
																				<xsl:for-each select="ns0:ClassNumberStatusCode">
																					<xsl:variable name="var52_resultof_vmf___inputtoresult" as="xs:string?">
																						<xsl:call-template name="vmf:vmf18_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:if test="fn:exists($var52_resultof_vmf___inputtoresult)">
																						<xsl:sequence select="."/>
																					</xsl:if>
																				</xsl:for-each>
																			</xsl:variable>
																			<xsl:for-each select="$var53_resultof_filter">
																				<tmk:ClassNumberStatusCategory>
																					<xsl:call-template name="vmf:vmf18_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</tmk:ClassNumberStatusCategory>
																			</xsl:for-each>
																			<xsl:for-each select="ns0:GoodsServicesDescription">
																				<xsl:variable name="var54_languageCode" as="node()?" select="@languageCode"/>
																				<xsl:variable name="var55_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																				<tmk:GoodsServicesDescriptionText>
																					<xsl:if test="fn:exists($var54_languageCode)">
																						<xsl:attribute name="com:languageCode" select="fn:string($var54_languageCode)"/>
																					</xsl:if>
																					<xsl:if test="fn:exists($var55_sequenceNumber)">
																						<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var55_sequenceNumber)))"/>
																					</xsl:if>
																					<xsl:sequence select="fn:string(.)"/>
																				</tmk:GoodsServicesDescriptionText>
																			</xsl:for-each>
																			<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																				<tmk:UseNiceHeadingIndicator>
																					<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																				</tmk:UseNiceHeadingIndicator>
																			</xsl:for-each>
																			<xsl:for-each select="ns0:ClassificationTermDetails">
																				<tmk:ClassificationTermBag>
																					<xsl:for-each select="ns0:ClassificationTerm">
																						<xsl:variable name="var63_operationCode" as="node()?" select="@operationCode"/>
																						<tmk:ClassificationTerm>
																							<xsl:if test="fn:exists($var63_operationCode)">
																								<xsl:attribute name="com:operationCategory" select="fn:string($var63_operationCode)"/>
																							</xsl:if>
																							<xsl:for-each select="ns0:ClassificationTermIdentifier">
																								<xsl:variable name="var56_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																								<tmk:ClassificationTermIdentifier>
																									<xsl:if test="fn:exists($var56_identifierKindCode)">
																										<xsl:attribute name="com:officeCode" select="fn:string($var56_identifierKindCode)"/>
																									</xsl:if>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermIdentifier>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermOffice">
																								<tmk:ClassificationTermOfficeCode>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermOfficeCode>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																								<tmk:ClassificationTermOfficeIdentification>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermOfficeIdentification>
																							</xsl:for-each>
																							<xsl:variable name="var58_resultof_filter" as="node()?">
																								<xsl:for-each select="ns0:ClassificationTermSource">
																									<xsl:variable name="var57_resultof_vmf___inputtoresult" as="xs:string?">
																										<xsl:call-template name="vmf:vmf19_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																										</xsl:call-template>
																									</xsl:variable>
																									<xsl:if test="fn:exists($var57_resultof_vmf___inputtoresult)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:for-each>
																							</xsl:variable>
																							<xsl:for-each select="$var58_resultof_filter">
																								<tmk:ClassificationTermSourceCategory>
																									<xsl:call-template name="vmf:vmf19_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</tmk:ClassificationTermSourceCategory>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermEntryDate">
																								<tmk:ClassificationTermEntryDate>
																									<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																								</tmk:ClassificationTermEntryDate>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassNumber">
																								<tmk:ClassNumber>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassNumber>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermText">
																								<xsl:variable name="var59_languageCode" as="node()?" select="@languageCode"/>
																								<tmk:ClassificationTermText>
																									<xsl:if test="fn:exists($var59_languageCode)">
																										<xsl:attribute name="com:languageCode" select="fn:string($var59_languageCode)"/>
																									</xsl:if>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermText>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																								<tmk:ClassificationTermEquivalentGroup>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermEquivalentGroup>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																								<tmk:ClassificationTermReferenceGroup>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermReferenceGroup>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																								<tmk:ClassificationTermTranslationGroup>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermTranslationGroup>
																							</xsl:for-each>
																							<xsl:variable name="var61_resultof_filter" as="node()?">
																								<xsl:for-each select="ns0:ClassificationTermStatus">
																									<xsl:variable name="var60_resultof_vmf___inputtoresult" as="xs:string?">
																										<xsl:call-template name="vmf:vmf20_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																										</xsl:call-template>
																									</xsl:variable>
																									<xsl:if test="fn:exists($var60_resultof_vmf___inputtoresult)">
																										<xsl:sequence select="."/>
																									</xsl:if>
																								</xsl:for-each>
																							</xsl:variable>
																							<xsl:for-each select="$var61_resultof_filter">
																								<xsl:variable name="var62_officeCode" as="node()?" select="@officeCode"/>
																								<tmk:ClassificationTermStatus>
																									<xsl:if test="fn:exists($var62_officeCode)">
																										<xsl:attribute name="com:officeCode" select="fn:string($var62_officeCode)"/>
																									</xsl:if>
																									<xsl:call-template name="vmf:vmf20_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</tmk:ClassificationTermStatus>
																							</xsl:for-each>
																							<xsl:for-each select="$var373_current/ns0:AsItIsProtectionIndicator">
																								<tmk:WIPOBasicNumber>
																									<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																								</tmk:WIPOBasicNumber>
																							</xsl:for-each>
																						</tmk:ClassificationTerm>
																					</xsl:for-each>
																				</tmk:ClassificationTermBag>
																			</xsl:for-each>
																		</tmk:ClassDescription>
																	</xsl:for-each>
																</tmk:ClassDescriptionBag>
															</tmk:UseRightGoodsServices>
														</xsl:for-each>
													</tmk:UseRight>
												</xsl:for-each>
												<xsl:for-each select="ns0:UseRequirementText">
													<xsl:variable name="var64_languageCode" as="node()?" select="@languageCode"/>
													<tmk:UseRequirementText>
														<xsl:if test="fn:exists($var64_languageCode)">
															<xsl:attribute name="com:languageCode" select="fn:string($var64_languageCode)"/>
														</xsl:if>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:UseRequirementText>
												</xsl:for-each>
												<xsl:for-each select="ns0:UseLimitationText">
													<xsl:variable name="var65_languageCode" as="node()?" select="@languageCode"/>
													<tmk:UseLimitationText>
														<xsl:if test="fn:exists($var65_languageCode)">
															<xsl:attribute name="com:languageCode" select="fn:string($var65_languageCode)"/>
														</xsl:if>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:UseLimitationText>
												</xsl:for-each>
												<xsl:for-each select="ns0:Comment">
													<com:CommentText>
														<xsl:sequence select="fn:string(.)"/>
													</com:CommentText>
												</xsl:for-each>
												<xsl:for-each select="ns0:OppositionPeriodStartDate">
													<tmk:OppositionPeriodStartDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:OppositionPeriodStartDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:OppositionPeriodEndDate">
													<tmk:OppositionPeriodEndDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:OppositionPeriodEndDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:GoodsServicesDetails">
													<tmk:GoodsServicesBag>
														<xsl:for-each select="ns0:GoodsServices">
															<tmk:GoodsServices>
																<xsl:for-each select="ns0:ClassificationKindCode">
																	<tmk:ClassificationKindCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:ClassificationKindCode>
																</xsl:for-each>
																<xsl:for-each select="ns0:ClassificationVersion">
																	<com:ClassificationVersion>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:ClassificationVersion>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var66_languageCode" as="node()?" select="@languageCode"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var66_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var66_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
																<xsl:for-each select="ns0:ProposedLeadingClassNumber">
																	<tmk:ProposedLeadingClassNumber>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:ProposedLeadingClassNumber>
																</xsl:for-each>
																<tmk:ClassDescriptionBag>
																	<xsl:for-each select="ns0:ClassDescriptionDetails/ns0:ClassDescription">
																		<tmk:ClassDescription>
																			<xsl:for-each select="ns0:ClassNumber">
																				<tmk:ClassNumber>
																					<xsl:sequence select="fn:string(.)"/>
																				</tmk:ClassNumber>
																			</xsl:for-each>
																			<xsl:for-each select="ns0:ClassNumberStatusCode">
																				<tmk:ClassNumberStatusCategory>
																					<xsl:sequence select="fn:string(.)"/>
																				</tmk:ClassNumberStatusCategory>
																			</xsl:for-each>
																			<xsl:for-each select="ns0:GoodsServicesDescription">
																				<xsl:variable name="var67_languageCode" as="node()?" select="@languageCode"/>
																				<xsl:variable name="var68_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																				<tmk:GoodsServicesDescriptionText>
																					<xsl:if test="fn:exists($var67_languageCode)">
																						<xsl:attribute name="com:languageCode" select="fn:string($var67_languageCode)"/>
																					</xsl:if>
																					<xsl:if test="fn:exists($var68_sequenceNumber)">
																						<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var68_sequenceNumber)))"/>
																					</xsl:if>
																					<xsl:sequence select="fn:string(.)"/>
																				</tmk:GoodsServicesDescriptionText>
																			</xsl:for-each>
																			<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																				<tmk:UseNiceHeadingIndicator>
																					<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																				</tmk:UseNiceHeadingIndicator>
																			</xsl:for-each>
																			<xsl:for-each select="ns0:ClassificationTermDetails">
																				<tmk:ClassificationTermBag>
																					<xsl:for-each select="ns0:ClassificationTerm">
																						<xsl:variable name="var71_operationCode" as="node()?" select="@operationCode"/>
																						<tmk:ClassificationTerm>
																							<xsl:if test="fn:exists($var71_operationCode)">
																								<xsl:attribute name="com:operationCategory" select="fn:string($var71_operationCode)"/>
																							</xsl:if>
																							<xsl:for-each select="ns0:ClassificationTermIdentifier">
																								<tmk:ClassificationTermIdentifier>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermIdentifier>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermOffice">
																								<tmk:ClassificationTermOfficeCode>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermOfficeCode>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																								<tmk:ClassificationTermOfficeIdentification>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermOfficeIdentification>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermSource">
																								<tmk:ClassificationTermSourceCategory>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermSourceCategory>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermEntryDate">
																								<tmk:ClassificationTermEntryDate>
																									<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																								</tmk:ClassificationTermEntryDate>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassNumber">
																								<tmk:ClassNumber>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassNumber>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermText">
																								<xsl:variable name="var69_languageCode" as="node()?" select="@languageCode"/>
																								<tmk:ClassificationTermText>
																									<xsl:if test="fn:exists($var69_languageCode)">
																										<xsl:attribute name="com:languageCode" select="fn:string($var69_languageCode)"/>
																									</xsl:if>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermText>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																								<tmk:ClassificationTermEquivalentGroup>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermEquivalentGroup>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																								<tmk:ClassificationTermReferenceGroup>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermReferenceGroup>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																								<tmk:ClassificationTermTranslationGroup>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermTranslationGroup>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:ClassificationTermStatus">
																								<xsl:variable name="var70_officeCode" as="node()?" select="@officeCode"/>
																								<tmk:ClassificationTermStatus>
																									<xsl:if test="fn:exists($var70_officeCode)">
																										<xsl:attribute name="com:officeCode" select="fn:string($var70_officeCode)"/>
																									</xsl:if>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:ClassificationTermStatus>
																							</xsl:for-each>
																							<xsl:for-each select="ns0:WIPOBasicNumber">
																								<tmk:WIPOBasicNumber>
																									<xsl:sequence select="fn:string(.)"/>
																								</tmk:WIPOBasicNumber>
																							</xsl:for-each>
																						</tmk:ClassificationTerm>
																					</xsl:for-each>
																				</tmk:ClassificationTermBag>
																			</xsl:for-each>
																		</tmk:ClassDescription>
																	</xsl:for-each>
																</tmk:ClassDescriptionBag>
															</tmk:GoodsServices>
														</xsl:for-each>
													</tmk:GoodsServicesBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:PriorityDetails">
													<tmk:PriorityBag>
														<xsl:for-each select="ns0:Priority">
															<tmk:Priority>
																<com:PriorityCountryCode>
																	<xsl:sequence select="fn:string(ns0:PriorityCountryCode)"/>
																</com:PriorityCountryCode>
																<xsl:for-each select="ns0:PriorityNumber">
																	<com:ApplicationNumber>
																		<com:ApplicationNumberText>
																			<xsl:sequence select="fn:string(.)"/>
																		</com:ApplicationNumberText>
																	</com:ApplicationNumber>
																</xsl:for-each>
																<xsl:for-each select="ns0:PriorityDate">
																	<com:PriorityApplicationFilingDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:PriorityApplicationFilingDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:PriorityHolderName">
																	<com:PriorityHolderName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PriorityHolderName>
																</xsl:for-each>
																<xsl:variable name="var73_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:PriorityStatusCode">
																		<xsl:variable name="var72_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf21_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var72_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var73_resultof_filter">
																	<com:PriorityStatusCategory>
																		<xsl:call-template name="vmf:vmf21_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</com:PriorityStatusCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:PriorityStatusDate">
																	<com:PriorityStatusDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:PriorityStatusDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var74_languageCode" as="node()?" select="@languageCode"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var74_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var74_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
																<xsl:for-each select="ns0:PriorityDocument">
																	<com:PriorityDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var76_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var75_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var75_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var76_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var78_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var77_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var77_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var78_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var79_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var79_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var79_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</com:PriorityDocument>
																</xsl:for-each>
																<xsl:for-each select="ns0:PriorityPartialIndicator">
																	<tmk:PriorityPartialIndicator>
																		<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																	</tmk:PriorityPartialIndicator>
																</xsl:for-each>
																<xsl:for-each select="ns0:PriorityPartialGoodsServices">
																	<tmk:PriorityPartialGoodsServices>
																		<xsl:for-each select="ns0:ClassificationKindCode">
																			<tmk:ClassificationKindCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationKindCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationVersion">
																			<com:ClassificationVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:ClassificationVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ProposedLeadingClassNumber">
																			<tmk:ProposedLeadingClassNumber>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ProposedLeadingClassNumber>
																		</xsl:for-each>
																	</tmk:PriorityPartialGoodsServices>
																</xsl:for-each>
															</tmk:Priority>
														</xsl:for-each>
													</tmk:PriorityBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:ExhibitionPriorityDetails">
													<com:ExhibitionPriorityBag>
														<xsl:for-each select="ns0:ExhibitionPriority">
															<com:ExhibitionPriority>
																<xsl:for-each select="ns0:ExhibitionCountryCode">
																	<com:ExhibitionCountryCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:ExhibitionCountryCode>
																</xsl:for-each>
																<xsl:for-each select="ns0:ExhibitionCityName">
																	<com:ExhibitionCityName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:ExhibitionCityName>
																</xsl:for-each>
																<xsl:for-each select="ns0:ExhibitionName">
																	<com:ExhibitionName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:ExhibitionName>
																</xsl:for-each>
																<com:ExhibitionDate>
																	<xsl:sequence select="xs:string(xs:date(fn:string(ns0:ExhibitionDate)))"/>
																</com:ExhibitionDate>
																<xsl:for-each select="ns0:ExhibitionFirstDisplayDate">
																	<com:ExhibitionFirstDisplayDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:ExhibitionFirstDisplayDate>
																</xsl:for-each>
																<xsl:variable name="var81_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:ExhibitionStatusCode">
																		<xsl:variable name="var80_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf24_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var80_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var81_resultof_filter">
																	<com:ExhibitionStatusCategory>
																		<xsl:call-template name="vmf:vmf24_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</com:ExhibitionStatusCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:ExhibitionStatusDate">
																	<com:ExhibitionStatusDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:ExhibitionStatusDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var82_languageCode" as="node()?" select="@languageCode"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var82_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var82_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
																<xsl:for-each select="ns0:ExhibitionDocument">
																	<com:ExhibitionDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var84_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var83_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var83_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var84_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var86_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var85_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var85_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var86_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var87_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var87_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var87_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</com:ExhibitionDocument>
																</xsl:for-each>
															</com:ExhibitionPriority>
														</xsl:for-each>
													</com:ExhibitionPriorityBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:SeniorityDetails">
													<tmk:SeniorityBag>
														<xsl:for-each select="ns0:Seniority">
															<tmk:Seniority>
																<tmk:SeniorityCountryCode>
																	<xsl:sequence select="fn:string(ns0:SeniorityCountryCode)"/>
																</tmk:SeniorityCountryCode>
																<tmk:SeniorityApplicationNumber>
																	<xsl:for-each select="ns0:SeniorityApplicationNumber">
																		<com:ApplicationNumberText>
																			<xsl:sequence select="fn:string(.)"/>
																		</com:ApplicationNumberText>
																	</xsl:for-each>
																</tmk:SeniorityApplicationNumber>
																<xsl:for-each select="ns0:SeniorityApplicationDate">
																	<tmk:SeniorityApplicationDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:SeniorityApplicationDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:SeniorityFilingDate">
																	<tmk:SeniorityFilingDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:SeniorityFilingDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:SeniorityRegistrationNumber">
																	<tmk:SeniorityRegistrationNumber>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:SeniorityRegistrationNumber>
																</xsl:for-each>
																<xsl:for-each select="ns0:SeniorityRegistrationDate">
																	<tmk:SeniorityRegistrationDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:SeniorityRegistrationDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:SeniorityPublicationDate">
																	<tmk:SeniorityPublicationDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:SeniorityPublicationDate>
																</xsl:for-each>
																<xsl:variable name="var89_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:InternationalTradeMarkCode">
																		<xsl:variable name="var88_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf25_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var88_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var89_resultof_filter">
																	<tmk:InternationalTrademarkCategory>
																		<xsl:call-template name="vmf:vmf25_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</tmk:InternationalTrademarkCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:SeniorityPartialIndicator">
																	<tmk:SeniorityPartialIndicator>
																		<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																	</tmk:SeniorityPartialIndicator>
																</xsl:for-each>
																<xsl:for-each select="ns0:SeniorityPartialGoodsServices">
																	<tmk:SeniorityPartialGoodsServices>
																		<xsl:for-each select="ns0:ClassificationKindCode">
																			<tmk:ClassificationKindCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ClassificationKindCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClassificationVersion">
																			<com:ClassificationVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:ClassificationVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ProposedLeadingClassNumber">
																			<tmk:ProposedLeadingClassNumber>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:ProposedLeadingClassNumber>
																		</xsl:for-each>
																	</tmk:SeniorityPartialGoodsServices>
																</xsl:for-each>
																<xsl:variable name="var91_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:SeniorityStatusCode">
																		<xsl:variable name="var90_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf26_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var90_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var91_resultof_filter">
																	<tmk:SeniorityStatusCategory>
																		<xsl:call-template name="vmf:vmf26_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</tmk:SeniorityStatusCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:SeniorityStatusDate">
																	<tmk:SeniorityStatusDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:SeniorityStatusDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var92_languageCode" as="node()?" select="@languageCode"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var92_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var92_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
																<xsl:for-each select="ns0:SeniorityDocument">
																	<tmk:SeniorityDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var94_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var93_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var93_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var94_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var96_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var95_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var95_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var96_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var97_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var97_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var97_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</tmk:SeniorityDocument>
																</xsl:for-each>
															</tmk:Seniority>
														</xsl:for-each>
													</tmk:SeniorityBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:PublicationDetails">
													<tmk:PublicationBag>
														<xsl:for-each select="ns0:Publication">
															<tmk:Publication>
																<com:PublicationIdentifier>
																	<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																</com:PublicationIdentifier>
																<xsl:variable name="var99_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:PublicationSection">
																		<xsl:variable name="var98_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf27_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var98_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var99_resultof_filter">
																	<tmk:PublicationSectionCategory>
																		<xsl:call-template name="vmf:vmf27_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</tmk:PublicationSectionCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:PublicationSubsection">
																	<com:PublicationSubsection>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PublicationSubsection>
																</xsl:for-each>
																<xsl:for-each select="ns0:PublicationDate">
																	<com:PublicationDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:PublicationDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:PublicationPage">
																	<com:PublicationPage>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PublicationPage>
																</xsl:for-each>
															</tmk:Publication>
														</xsl:for-each>
													</tmk:PublicationBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:ApplicantDetails">
													<tmk:ApplicantBag>
														<xsl:for-each select="ns0:ApplicantKey">
															<com:PartyIdentifierBag>
																<xsl:for-each select="ns0:Identifier">
																	<xsl:variable name="var100_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																	<com:PartyIdentifier>
																		<xsl:if test="fn:exists($var100_identifierKindCode)">
																			<xsl:attribute name="com:officeCode" select="fn:string($var100_identifierKindCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PartyIdentifier>
																</xsl:for-each>
															</com:PartyIdentifierBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:Applicant">
															<xsl:variable name="var105_operationCode" as="node()?" select="@operationCode"/>
															<tmk:Applicant>
																<xsl:if test="fn:exists($var105_operationCode)">
																	<xsl:attribute name="com:operationCategory" select="fn:string($var105_operationCode)"/>
																</xsl:if>
																<xsl:for-each select="ns0:ApplicantSequenceNumber">
																	<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantLegalEntity">
																	<com:LegalEntityName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:LegalEntityName>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantNationalityCode">
																	<com:NationalityCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:NationalityCode>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantIncorporationCountryCode">
																	<com:IncorporationCountryCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:IncorporationCountryCode>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantIncorporationState">
																	<com:IncorporationState>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:IncorporationState>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var101_languageCode" as="node()?" select="@languageCode"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var101_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var101_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantEntitlement">
																	<tmk:Entitlement>
																		<xsl:for-each select="ns0:EntitlementNationalityCode">
																			<com:EntitlementNationalityCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:EntitlementNationalityCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:EntitlementEstablishment">
																			<com:EntitlementEstablishment>
																				<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																					<com:EntitlementEstablishmentCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:EntitlementEstablishmentCode>
																				</xsl:for-each>
																			</com:EntitlementEstablishment>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:EntitlementDomiciled">
																			<com:EntitlementDomiciled>
																				<xsl:for-each select="ns0:EntitlementDomiciledCode">
																					<com:EntitlementDomiciledCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:EntitlementDomiciledCode>
																				</xsl:for-each>
																			</com:EntitlementDomiciled>
																		</xsl:for-each>
																	</tmk:Entitlement>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantVersion">
																	<com:Version>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var102_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var102_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var102_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:VersionNumber">
																			<com:VersionNumber>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:VersionNumber>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:VersionDate">
																			<com:VersionDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:VersionDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:VersionDateTime">
																			<com:VersionDateTime>
																				<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																			</com:VersionDateTime>
																		</xsl:for-each>
																	</com:Version>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantIdentifier">
																	<xsl:variable name="var103_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																	<com:PartyIdentifier>
																		<xsl:if test="fn:exists($var103_identifierKindCode)">
																			<xsl:attribute name="com:officeCode" select="fn:string($var103_identifierKindCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PartyIdentifier>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantAddressBook">
																	<xsl:variable name="var104_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																			<xsl:with-param name="AddressBook" as="node()">
																				<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</AddressBookType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var104_resultof_MappingST__AddressBookToST__Contact">
																		<com:Contact>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Contact>
																	</xsl:for-each>
																</xsl:for-each>
															</tmk:Applicant>
														</xsl:for-each>
													</tmk:ApplicantBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:RepresentativeDetails">
													<com:RepresentativeBag>
														<xsl:for-each select="ns0:Representative">
															<xsl:variable name="var106_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																	<xsl:with-param name="Representative" as="node()">
																		<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</RepresentativeType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var106_resultof_MappingST__RepresentativeToST__Representative">
																<com:Representative>
																	<xsl:sequence select="(./@node(), ./node())"/>
																</com:Representative>
															</xsl:for-each>
														</xsl:for-each>
													</com:RepresentativeBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:StaffDetails">
													<com:StaffBag>
														<xsl:for-each select="ns0:Staff">
															<com:Staff>
																<xsl:for-each select="ns0:OfficialTitle">
																	<com:OfficialTitleText>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:OfficialTitleText>
																</xsl:for-each>
																<xsl:for-each select="ns0:StaffIdentifier">
																	<com:PartyIdentifier>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PartyIdentifier>
																</xsl:for-each>
																<xsl:for-each select="ns0:StaffName">
																	<com:StaffName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:StaffName>
																</xsl:for-each>
															</com:Staff>
														</xsl:for-each>
													</com:StaffBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:Authorization">
													<com:Authorization>
														<xsl:for-each select="ns0:AuthorizationIdentifier">
															<com:AuthorizationIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:AuthorizationIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:AuthorizationDate">
															<com:AuthorizationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:AuthorizationDate>
														</xsl:for-each>
														<xsl:variable name="var108_resultof_filter" as="node()?">
															<xsl:for-each select="ns0:AuthorizationKind">
																<xsl:variable name="var107_resultof_vmf___inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf28_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var107_resultof_vmf___inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var108_resultof_filter">
															<com:AuthorizationCategory>
																<xsl:call-template name="vmf:vmf28_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</com:AuthorizationCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:Comment">
															<xsl:variable name="var109_languageCode" as="node()?" select="@languageCode"/>
															<com:CommentText>
																<xsl:if test="fn:exists($var109_languageCode)">
																	<xsl:attribute name="com:languageCode" select="fn:string($var109_languageCode)"/>
																</xsl:if>
																<xsl:sequence select="fn:string(.)"/>
															</com:CommentText>
														</xsl:for-each>
														<xsl:variable name="var111_resultof_filter" as="node()?">
															<xsl:for-each select="ns0:AuthorizationDocumentSupply">
																<xsl:variable name="var110_resultof_vmf___inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf29_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var110_resultof_vmf___inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var111_resultof_filter">
															<com:AuthorizationDocumentSupplyCategory>
																<xsl:call-template name="vmf:vmf29_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</com:AuthorizationDocumentSupplyCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:AuthorizationDocument">
															<com:AuthorizationDocument>
																<xsl:for-each select="ns0:DocumentLanguageCode">
																	<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentName">
																	<com:DocumentName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentName>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentFilename">
																	<com:FileName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:FileName>
																</xsl:for-each>
																<xsl:variable name="var113_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:DocumentFileFormat">
																		<xsl:variable name="var112_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf22_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var112_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var113_resultof_filter">
																	<com:DocumentFormatCategory>
																		<xsl:call-template name="vmf:vmf22_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</com:DocumentFormatCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentDate">
																	<com:DocumentDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:DocumentDate>
																</xsl:for-each>
																<xsl:variable name="var115_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:DocumentMedia">
																		<xsl:variable name="var114_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf23_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var114_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var115_resultof_filter">
																	<com:DocumentMediaCategory>
																		<xsl:call-template name="vmf:vmf23_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</com:DocumentMediaCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentLocation">
																	<com:DocumentLocationURI>
																		<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																	</com:DocumentLocationURI>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentVersion">
																	<com:DocumentVersion>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentVersion>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentSizeInByte">
																	<com:DocumentSizeQuantity>
																		<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																	</com:DocumentSizeQuantity>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var116_languageCode" as="node()?" select="@languageCode"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var116_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var116_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
															</com:AuthorizationDocument>
														</xsl:for-each>
													</com:Authorization>
												</xsl:for-each>
												<xsl:for-each select="ns0:OppositionDetails">
													<tmk:OppositionBag>
														<xsl:for-each select="ns0:Opposition">
															<xsl:variable name="var117_resultof_MappingST__OppositionToST__Opposition" as="node()?">
																<xsl:call-template name="WIPO:MappingST66OppositionToST96Opposition">
																	<xsl:with-param name="Opposition" as="node()">
																		<OppositionType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</OppositionType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var117_resultof_MappingST__OppositionToST__Opposition">
																<tmk:Opposition>
																	<xsl:sequence select="(./@node(), ./node())"/>
																</tmk:Opposition>
															</xsl:for-each>
														</xsl:for-each>
													</tmk:OppositionBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:MarkRecordDetails">
													<tmk:MarkRecordBag>
														<xsl:for-each select="ns0:MarkRecord">
															<tmk:MarkRecord>
																<xsl:for-each select="ns0:BasicRecord">
																	<tmk:BasicRecord>
																		<xsl:for-each select="ns0:RecordIdentifier">
																			<com:RecordIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordFilingDate">
																			<com:RecordFilingDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordFilingDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordNotificationDate">
																			<com:RecordNotificationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordNotificationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEffectiveDate">
																			<com:RecordEffectiveDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEffectiveDate>
																		</xsl:for-each>
																		<xsl:variable name="var119_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:BasicRecordKind">
																				<xsl:variable name="var118_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf30_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var118_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var119_resultof_filter">
																			<tmk:BasicRecordCategory>
																				<xsl:call-template name="vmf:vmf30_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:BasicRecordCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordReference">
																			<com:RecordReference>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordReference>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordLanguageCode">
																			<com:RecordLanguageCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordLanguageCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:TradeMarkKeyDetails">
																			<tmk:TrademarkIdentification>
																				<xsl:for-each select="ns0:TradeMarkKey">
																					<tmk:TrademarkIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var120_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<tmk:TrademarkIdentifier>
																								<xsl:if test="fn:exists($var120_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var120_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:TrademarkIdentifier>
																						</xsl:for-each>
																					</tmk:TrademarkIdentifierBag>
																				</xsl:for-each>
																			</tmk:TrademarkIdentification>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordPublicationDetails">
																			<tmk:RecordPublicationBag>
																				<xsl:for-each select="ns0:RecordPublication">
																					<tmk:RecordPublication>
																						<com:PublicationIdentifier>
																							<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																						</com:PublicationIdentifier>
																						<xsl:variable name="var122_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:PublicationSection">
																								<xsl:variable name="var121_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf27_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var121_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var122_resultof_filter">
																							<tmk:PublicationSectionCategory>
																								<xsl:call-template name="vmf:vmf27_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:PublicationSectionCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationSubsection">
																							<com:PublicationSubsection>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationSubsection>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationDate">
																							<com:PublicationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PublicationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationPage">
																							<com:PublicationPage>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationPage>
																						</xsl:for-each>
																					</tmk:RecordPublication>
																				</xsl:for-each>
																			</tmk:RecordPublicationBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantDetails">
																			<tmk:ClaimantBag>
																				<xsl:for-each select="ns0:ClaimantKey">
																					<com:PartyIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var123_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var123_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var123_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																					</com:PartyIdentifierBag>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:Claimant">
																					<xsl:variable name="var128_operationCode" as="node()?" select="@operationCode"/>
																					<tmk:Claimant>
																						<xsl:if test="fn:exists($var128_operationCode)">
																							<xsl:attribute name="com:operationCategory" select="fn:string($var128_operationCode)"/>
																						</xsl:if>
																						<xsl:for-each select="ns0:ClaimantSequenceNumber">
																							<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantLegalEntity">
																							<com:LegalEntityName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LegalEntityName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantNationalityCode">
																							<com:NationalityCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:NationalityCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																							<com:IncorporationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationCountryCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationState">
																							<com:IncorporationState>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationState>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var124_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var124_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var124_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantEntitlement">
																							<tmk:Entitlement>
																								<xsl:for-each select="ns0:EntitlementNationalityCode">
																									<com:EntitlementNationalityCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:EntitlementNationalityCode>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementEstablishment">
																									<com:EntitlementEstablishment>
																										<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																											<com:EntitlementEstablishmentCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementEstablishmentCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																											<xsl:variable name="var125_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var125_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</com:EntitlementEstablishment>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementDomiciled">
																									<com:EntitlementDomiciled>
																										<xsl:for-each select="ns0:EntitlementDomiciledCode">
																											<com:EntitlementDomiciledCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementDomiciledCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																											<com:Contact>
																												<xsl:sequence select="()"/>
																											</com:Contact>
																										</xsl:for-each>
																									</com:EntitlementDomiciled>
																								</xsl:for-each>
																							</tmk:Entitlement>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIdentifier">
																							<xsl:variable name="var126_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var126_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var126_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantAddressBook">
																							<xsl:variable name="var127_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var127_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</tmk:Claimant>
																				</xsl:for-each>
																			</tmk:ClaimantBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RepresentativeDetails">
																			<com:RepresentativeBag>
																				<xsl:for-each select="ns0:Representative">
																					<xsl:variable name="var129_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																							<xsl:with-param name="Representative" as="node()">
																								<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</RepresentativeType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var129_resultof_MappingST__RepresentativeToST__Representative">
																						<com:Representative>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Representative>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:RepresentativeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDetails">
																			<com:RecordEventBag>
																				<xsl:for-each select="ns0:RecordEvent">
																					<com:RecordEvent>
																						<com:RecordEventCategory>
																							<xsl:sequence select="fn:string(ns0:RecordEventCode)"/>
																						</com:RecordEventCategory>
																						<xsl:for-each select="ns0:RecordEventResponseDate">
																							<com:RecordEventResponseDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventResponseDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var130_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var130_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var130_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDate">
																							<com:RecordEventDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDateTime">
																							<com:RecordEventDateTime>
																								<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																							</com:RecordEventDateTime>
																						</xsl:for-each>
																					</com:RecordEvent>
																				</xsl:for-each>
																			</com:RecordEventBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordDocumentDetails">
																			<com:RecordDocumentBag>
																				<xsl:for-each select="ns0:RecordDocument">
																					<com:RecordDocument>
																						<xsl:for-each select="ns0:DocumentLanguageCode">
																							<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentName">
																							<com:DocumentName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentFilename">
																							<com:FileName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:FileName>
																						</xsl:for-each>
																						<xsl:variable name="var132_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentFileFormat">
																								<xsl:variable name="var131_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf22_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var131_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var132_resultof_filter">
																							<com:DocumentFormatCategory>
																								<xsl:call-template name="vmf:vmf22_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentFormatCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentDate">
																							<com:DocumentDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:DocumentDate>
																						</xsl:for-each>
																						<xsl:variable name="var134_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentMedia">
																								<xsl:variable name="var133_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf23_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var133_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var134_resultof_filter">
																							<com:DocumentMediaCategory>
																								<xsl:call-template name="vmf:vmf23_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentMediaCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentLocation">
																							<com:DocumentLocationURI>
																								<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</com:DocumentLocationURI>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentVersion">
																							<com:DocumentVersion>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentVersion>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentSizeInByte">
																							<com:DocumentSizeQuantity>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:DocumentSizeQuantity>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var135_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var135_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var135_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																					</com:RecordDocument>
																				</xsl:for-each>
																			</com:RecordDocumentBag>
																		</xsl:for-each>
																		<xsl:variable name="var137_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:RecordCurrentStatusCode">
																				<xsl:variable name="var136_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf31_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var136_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var137_resultof_filter">
																			<com:RecordCurrentStatusCategory>
																				<xsl:call-template name="vmf:vmf31_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:RecordCurrentStatusCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordCurrentStatusDate">
																			<com:RecordCurrentStatusDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordCurrentStatusDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:FactDecisionText">
																			<xsl:variable name="var138_languageCode" as="node()?" select="@languageCode"/>
																			<tmk:ReasonDocument>
																				<tmk:FactDecisionText>
																					<xsl:if test="fn:exists($var138_languageCode)">
																						<xsl:attribute name="com:languageCode" select="fn:string($var138_languageCode)"/>
																					</xsl:if>
																					<xsl:sequence select="fn:string(.)"/>
																				</tmk:FactDecisionText>
																			</tmk:ReasonDocument>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordInterestedOfficeCode">
																			<com:RecordInterestedOfficeCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordInterestedOfficeCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordDesignatedCountryDetails">
																			<com:RecordDesignatedCountryCodeBag>
																				<xsl:for-each select="ns0:RecordDesignatedCountryCode">
																					<com:RecordDesignatedCountryCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:RecordDesignatedCountryCode>
																				</xsl:for-each>
																			</com:RecordDesignatedCountryCodeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordUseIntentDetails">
																			<tmk:RecordUseIntentBag>
																				<xsl:for-each select="ns0:RecordUseIntentCountryCode">
																					<tmk:RecordUseIntentCountryCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</tmk:RecordUseIntentCountryCode>
																				</xsl:for-each>
																			</tmk:RecordUseIntentBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:GoodsServicesLimitationDetails">
																			<tmk:GoodsServicesLimitationBag>
																				<xsl:for-each select="ns0:GoodsServicesLimitation">
																					<tmk:GoodsServicesLimitation>
																						<xsl:for-each select="ns0:LimitationCountryDetails">
																							<com:LimitationCountryCodeBag>
																								<xsl:for-each select="ns0:LimitationCountryCode">
																									<com:LimitationCountryCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:LimitationCountryCode>
																								</xsl:for-each>
																							</com:LimitationCountryCodeBag>
																						</xsl:for-each>
																						<xsl:variable name="var140_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																								<xsl:variable name="var139_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf32_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var139_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var140_resultof_filter">
																							<tmk:GoodsServicesLimitationCategory>
																								<xsl:call-template name="vmf:vmf32_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:GoodsServicesLimitationCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var141_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var141_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var141_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																							<tmk:LimitationClassDescriptionBag>
																								<xsl:for-each select="ns0:ClassDescription">
																									<tmk:ClassDescription>
																										<xsl:for-each select="ns0:ClassNumber">
																											<tmk:ClassNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassNumber>
																										</xsl:for-each>
																										<xsl:variable name="var143_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassNumberStatusCode">
																												<xsl:variable name="var142_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf18_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var142_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var143_resultof_filter">
																											<tmk:ClassNumberStatusCategory>
																												<xsl:call-template name="vmf:vmf18_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassNumberStatusCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:GoodsServicesDescription">
																											<xsl:variable name="var144_languageCode" as="node()?" select="@languageCode"/>
																											<xsl:variable name="var145_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																											<tmk:GoodsServicesDescriptionText>
																												<xsl:if test="fn:exists($var144_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var144_languageCode)"/>
																												</xsl:if>
																												<xsl:if test="fn:exists($var145_sequenceNumber)">
																													<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var145_sequenceNumber)))"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:GoodsServicesDescriptionText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																											<tmk:UseNiceHeadingIndicator>
																												<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																											</tmk:UseNiceHeadingIndicator>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermDetails">
																											<tmk:ClassificationTermBag>
																												<xsl:for-each select="ns0:ClassificationTerm">
																													<xsl:variable name="var153_operationCode" as="node()?" select="@operationCode"/>
																													<tmk:ClassificationTerm>
																														<xsl:if test="fn:exists($var153_operationCode)">
																															<xsl:attribute name="com:operationCategory" select="fn:string($var153_operationCode)"/>
																														</xsl:if>
																														<xsl:for-each select="ns0:ClassificationTermIdentifier">
																															<xsl:variable name="var146_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																															<tmk:ClassificationTermIdentifier>
																																<xsl:if test="fn:exists($var146_identifierKindCode)">
																																	<xsl:attribute name="com:officeCode" select="fn:string($var146_identifierKindCode)"/>
																																</xsl:if>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermIdentifier>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermOffice">
																															<tmk:ClassificationTermOfficeCode>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermOfficeCode>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																															<tmk:ClassificationTermOfficeIdentification>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermOfficeIdentification>
																														</xsl:for-each>
																														<xsl:variable name="var148_resultof_filter" as="node()?">
																															<xsl:for-each select="ns0:ClassificationTermSource">
																																<xsl:variable name="var147_resultof_vmf___inputtoresult" as="xs:string?">
																																	<xsl:call-template name="vmf:vmf19_inputtoresult">
																																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																	</xsl:call-template>
																																</xsl:variable>
																																<xsl:if test="fn:exists($var147_resultof_vmf___inputtoresult)">
																																	<xsl:sequence select="."/>
																																</xsl:if>
																															</xsl:for-each>
																														</xsl:variable>
																														<xsl:for-each select="$var148_resultof_filter">
																															<tmk:ClassificationTermSourceCategory>
																																<xsl:call-template name="vmf:vmf19_inputtoresult">
																																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																</xsl:call-template>
																															</tmk:ClassificationTermSourceCategory>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermEntryDate">
																															<tmk:ClassificationTermEntryDate>
																																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																															</tmk:ClassificationTermEntryDate>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassNumber">
																															<tmk:ClassNumber>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassNumber>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermText">
																															<xsl:variable name="var149_languageCode" as="node()?" select="@languageCode"/>
																															<tmk:ClassificationTermText>
																																<xsl:if test="fn:exists($var149_languageCode)">
																																	<xsl:attribute name="com:languageCode" select="fn:string($var149_languageCode)"/>
																																</xsl:if>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermText>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																															<tmk:ClassificationTermEquivalentGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermEquivalentGroup>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																															<tmk:ClassificationTermReferenceGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermReferenceGroup>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																															<tmk:ClassificationTermTranslationGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermTranslationGroup>
																														</xsl:for-each>
																														<xsl:variable name="var151_resultof_filter" as="node()?">
																															<xsl:for-each select="ns0:ClassificationTermStatus">
																																<xsl:variable name="var150_resultof_vmf___inputtoresult" as="xs:string?">
																																	<xsl:call-template name="vmf:vmf20_inputtoresult">
																																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																	</xsl:call-template>
																																</xsl:variable>
																																<xsl:if test="fn:exists($var150_resultof_vmf___inputtoresult)">
																																	<xsl:sequence select="."/>
																																</xsl:if>
																															</xsl:for-each>
																														</xsl:variable>
																														<xsl:for-each select="$var151_resultof_filter">
																															<xsl:variable name="var152_officeCode" as="node()?" select="@officeCode"/>
																															<tmk:ClassificationTermStatus>
																																<xsl:if test="fn:exists($var152_officeCode)">
																																	<xsl:attribute name="com:officeCode" select="fn:string($var152_officeCode)"/>
																																</xsl:if>
																																<xsl:call-template name="vmf:vmf20_inputtoresult">
																																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																</xsl:call-template>
																															</tmk:ClassificationTermStatus>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:WIPOBasicNumber">
																															<tmk:WIPOBasicNumber>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:WIPOBasicNumber>
																														</xsl:for-each>
																													</tmk:ClassificationTerm>
																												</xsl:for-each>
																											</tmk:ClassificationTermBag>
																										</xsl:for-each>
																									</tmk:ClassDescription>
																								</xsl:for-each>
																							</tmk:LimitationClassDescriptionBag>
																						</xsl:for-each>
																					</tmk:GoodsServicesLimitation>
																				</xsl:for-each>
																			</tmk:GoodsServicesLimitationBag>
																		</xsl:for-each>
																	</tmk:BasicRecord>
																</xsl:for-each>
																<xsl:for-each select="ns0:RecordOppositionPeriod">
																	<xsl:variable name="var157_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf33_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordOppositionPeriodKind)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<tmk:RecordOppositionPeriod>
																		<xsl:for-each select="ns0:RecordIdentifier">
																			<com:RecordIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordFilingDate">
																			<com:RecordFilingDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordFilingDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordNotificationDate">
																			<com:RecordNotificationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordNotificationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEffectiveDate">
																			<com:RecordEffectiveDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEffectiveDate>
																		</xsl:for-each>
																		<xsl:if test="fn:exists($var157_resultof_vmf___inputtoresult)">
																			<tmk:RecordOppositionPeriodCategory>
																				<xsl:sequence select="$var157_resultof_vmf___inputtoresult"/>
																			</tmk:RecordOppositionPeriodCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:TradeMarkKeyDetails">
																			<tmk:TrademarkIdentification>
																				<xsl:for-each select="ns0:TradeMarkKey">
																					<tmk:TrademarkIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var154_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<tmk:TrademarkIdentifier>
																								<xsl:if test="fn:exists($var154_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var154_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:TrademarkIdentifier>
																						</xsl:for-each>
																					</tmk:TrademarkIdentifierBag>
																				</xsl:for-each>
																			</tmk:TrademarkIdentification>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordPublicationDetails">
																			<tmk:RecordPublicationBag>
																				<xsl:for-each select="ns0:RecordPublication">
																					<tmk:RecordPublication>
																						<com:PublicationIdentifier>
																							<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																						</com:PublicationIdentifier>
																						<xsl:variable name="var156_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:PublicationSection">
																								<xsl:variable name="var155_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf27_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var155_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var156_resultof_filter">
																							<tmk:PublicationSectionCategory>
																								<xsl:call-template name="vmf:vmf27_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:PublicationSectionCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationSubsection">
																							<com:PublicationSubsection>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationSubsection>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationDate">
																							<com:PublicationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PublicationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationPage">
																							<com:PublicationPage>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationPage>
																						</xsl:for-each>
																					</tmk:RecordPublication>
																				</xsl:for-each>
																			</tmk:RecordPublicationBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordInterestedOfficeCode">
																			<com:RecordInterestedOfficeCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordInterestedOfficeCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordOppositionPeriodStartDate">
																			<tmk:RecordOppositionPeriodStartDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</tmk:RecordOppositionPeriodStartDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordOppositionPeriodEndDate">
																			<tmk:RecordOppositionPeriodEndDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</tmk:RecordOppositionPeriodEndDate>
																		</xsl:for-each>
																	</tmk:RecordOppositionPeriod>
																</xsl:for-each>
																<xsl:for-each select="ns0:RecordTransfer">
																	<xsl:variable name="var198_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf34_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordTransferKind)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<tmk:RecordTransfer>
																		<xsl:for-each select="ns0:RecordIdentifier">
																			<com:RecordIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordFilingDate">
																			<com:RecordFilingDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordFilingDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordNotificationDate">
																			<com:RecordNotificationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordNotificationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEffectiveDate">
																			<com:RecordEffectiveDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEffectiveDate>
																		</xsl:for-each>
																		<xsl:if test="fn:exists($var198_resultof_vmf___inputtoresult)">
																			<com:RecordTransferCategory>
																				<xsl:sequence select="$var198_resultof_vmf___inputtoresult"/>
																			</com:RecordTransferCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordReference">
																			<com:RecordReference>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordReference>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordLanguageCode">
																			<com:RecordLanguageCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordLanguageCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:TradeMarkKeyDetails">
																			<tmk:TrademarkIdentification>
																				<xsl:for-each select="ns0:TradeMarkKey">
																					<tmk:TrademarkIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var158_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<tmk:TrademarkIdentifier>
																								<xsl:if test="fn:exists($var158_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var158_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:TrademarkIdentifier>
																						</xsl:for-each>
																					</tmk:TrademarkIdentifierBag>
																				</xsl:for-each>
																			</tmk:TrademarkIdentification>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordPublicationDetails">
																			<tmk:RecordPublicationBag>
																				<xsl:for-each select="ns0:RecordPublication">
																					<tmk:RecordPublication>
																						<com:PublicationIdentifier>
																							<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																						</com:PublicationIdentifier>
																						<xsl:variable name="var160_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:PublicationSection">
																								<xsl:variable name="var159_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf27_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var159_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var160_resultof_filter">
																							<tmk:PublicationSectionCategory>
																								<xsl:call-template name="vmf:vmf27_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:PublicationSectionCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationSubsection">
																							<com:PublicationSubsection>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationSubsection>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationDate">
																							<com:PublicationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PublicationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationPage">
																							<com:PublicationPage>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationPage>
																						</xsl:for-each>
																					</tmk:RecordPublication>
																				</xsl:for-each>
																			</tmk:RecordPublicationBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantDetails">
																			<tmk:ClaimantBag>
																				<xsl:for-each select="ns0:ClaimantKey">
																					<com:PartyIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var161_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var161_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var161_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																					</com:PartyIdentifierBag>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:Claimant">
																					<xsl:variable name="var166_operationCode" as="node()?" select="@operationCode"/>
																					<tmk:Claimant>
																						<xsl:if test="fn:exists($var166_operationCode)">
																							<xsl:attribute name="com:operationCategory" select="fn:string($var166_operationCode)"/>
																						</xsl:if>
																						<xsl:for-each select="ns0:ClaimantSequenceNumber">
																							<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantLegalEntity">
																							<com:LegalEntityName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LegalEntityName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantNationalityCode">
																							<com:NationalityCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:NationalityCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																							<com:IncorporationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationCountryCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationState">
																							<com:IncorporationState>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationState>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var162_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var162_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var162_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantEntitlement">
																							<tmk:Entitlement>
																								<xsl:for-each select="ns0:EntitlementNationalityCode">
																									<com:EntitlementNationalityCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:EntitlementNationalityCode>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementEstablishment">
																									<com:EntitlementEstablishment>
																										<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																											<com:EntitlementEstablishmentCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementEstablishmentCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																											<xsl:variable name="var163_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var163_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</com:EntitlementEstablishment>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementDomiciled">
																									<com:EntitlementDomiciled>
																										<xsl:for-each select="ns0:EntitlementDomiciledCode">
																											<com:EntitlementDomiciledCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementDomiciledCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																											<com:Contact>
																												<xsl:sequence select="()"/>
																											</com:Contact>
																										</xsl:for-each>
																									</com:EntitlementDomiciled>
																								</xsl:for-each>
																							</tmk:Entitlement>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIdentifier">
																							<xsl:variable name="var164_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var164_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var164_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantAddressBook">
																							<xsl:variable name="var165_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var165_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</tmk:Claimant>
																				</xsl:for-each>
																			</tmk:ClaimantBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RepresentativeDetails">
																			<com:RepresentativeBag>
																				<xsl:for-each select="ns0:Representative">
																					<xsl:variable name="var167_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																							<xsl:with-param name="Representative" as="node()">
																								<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</RepresentativeType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var167_resultof_MappingST__RepresentativeToST__Representative">
																						<com:Representative>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Representative>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:RepresentativeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDetails">
																			<com:RecordEventBag>
																				<xsl:for-each select="ns0:RecordEvent">
																					<xsl:variable name="var169_resultof_vmf___inputtoresult" as="xs:string?">
																						<xsl:call-template name="vmf:vmf35_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:variable>
																					<com:RecordEvent>
																						<xsl:if test="fn:exists($var169_resultof_vmf___inputtoresult)">
																							<com:RecordEventCategory>
																								<xsl:sequence select="$var169_resultof_vmf___inputtoresult"/>
																							</com:RecordEventCategory>
																						</xsl:if>
																						<xsl:for-each select="ns0:RecordEventResponseDate">
																							<com:RecordEventResponseDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventResponseDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var168_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var168_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var168_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDate">
																							<com:RecordEventDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDateTime">
																							<com:RecordEventDateTime>
																								<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																							</com:RecordEventDateTime>
																						</xsl:for-each>
																					</com:RecordEvent>
																				</xsl:for-each>
																			</com:RecordEventBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordDocumentDetails">
																			<com:RecordDocumentBag>
																				<xsl:for-each select="ns0:RecordDocument">
																					<com:RecordDocument>
																						<xsl:for-each select="ns0:DocumentLanguageCode">
																							<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentName">
																							<com:DocumentName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentFilename">
																							<com:FileName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:FileName>
																						</xsl:for-each>
																						<xsl:variable name="var171_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentFileFormat">
																								<xsl:variable name="var170_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf22_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var170_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var171_resultof_filter">
																							<com:DocumentFormatCategory>
																								<xsl:call-template name="vmf:vmf22_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentFormatCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentDate">
																							<com:DocumentDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:DocumentDate>
																						</xsl:for-each>
																						<xsl:variable name="var173_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentMedia">
																								<xsl:variable name="var172_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf23_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var172_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var173_resultof_filter">
																							<com:DocumentMediaCategory>
																								<xsl:call-template name="vmf:vmf23_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentMediaCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentLocation">
																							<com:DocumentLocationURI>
																								<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</com:DocumentLocationURI>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentVersion">
																							<com:DocumentVersion>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentVersion>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentSizeInByte">
																							<com:DocumentSizeQuantity>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:DocumentSizeQuantity>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var174_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var174_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var174_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																					</com:RecordDocument>
																				</xsl:for-each>
																			</com:RecordDocumentBag>
																		</xsl:for-each>
																		<xsl:variable name="var176_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:RecordCurrentStatusCode">
																				<xsl:variable name="var175_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf36_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var175_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var176_resultof_filter">
																			<com:RecordCurrentStatusCategory>
																				<xsl:call-template name="vmf:vmf36_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:RecordCurrentStatusCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordCurrentStatusDate">
																			<com:RecordCurrentStatusDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordCurrentStatusDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:CorrespondenceAddress">
																			<com:CorrespondenceAddress>
																				<xsl:variable name="var178_resultof_filter" as="node()?">
																					<xsl:for-each select="ns0:CorrespondenceAddressParty">
																						<xsl:variable name="var177_resultof_vmf___inputtoresult" as="xs:string?">
																							<xsl:call-template name="vmf:vmf37_inputtoresult">
																								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																							</xsl:call-template>
																						</xsl:variable>
																						<xsl:if test="fn:exists($var177_resultof_vmf___inputtoresult)">
																							<xsl:sequence select="."/>
																						</xsl:if>
																					</xsl:for-each>
																				</xsl:variable>
																				<xsl:for-each select="$var178_resultof_filter">
																					<com:CorrespondenceAddressPartyCategory>
																						<xsl:call-template name="vmf:vmf37_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																						</xsl:call-template>
																					</com:CorrespondenceAddressPartyCategory>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:CorrespondenceAddressIdentifier">
																					<xsl:variable name="var179_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																					<com:PartyIdentifier>
																						<xsl:if test="fn:exists($var179_identifierKindCode)">
																							<xsl:attribute name="com:officeCode" select="fn:string($var179_identifierKindCode)"/>
																						</xsl:if>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:PartyIdentifier>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:CorrespondenceAddressBook">
																					<xsl:variable name="var180_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																							<xsl:with-param name="AddressBook" as="node()">
																								<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</AddressBookType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var180_resultof_MappingST__AddressBookToST__Contact">
																						<com:Contact>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Contact>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:CorrespondenceAddress>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:HolderDetails">
																			<tmk:HolderChangeBag>
																				<xsl:for-each select="ns0:PreviousHolder">
																					<xsl:variable name="var181_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																							<xsl:with-param name="Applicant" as="node()">
																								<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</ApplicantType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var181_resultof_MappingST__ApplicantToST__Applicant">
																						<tmk:PreviousHolderBag>
																							<xsl:sequence select="()"/>
																						</tmk:PreviousHolderBag>
																					</xsl:for-each>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:NewHolder">
																					<xsl:variable name="var182_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																							<xsl:with-param name="Applicant" as="node()">
																								<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</ApplicantType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var182_resultof_MappingST__ApplicantToST__Applicant">
																						<tmk:HolderBag>
																							<xsl:sequence select="()"/>
																						</tmk:HolderBag>
																					</xsl:for-each>
																				</xsl:for-each>
																			</tmk:HolderChangeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:GoodsServicesLimitationDetails">
																			<tmk:GoodsServicesLimitationBag>
																				<xsl:for-each select="ns0:GoodsServicesLimitation">
																					<tmk:GoodsServicesLimitation>
																						<xsl:for-each select="ns0:LimitationCountryDetails">
																							<com:LimitationCountryCodeBag>
																								<xsl:for-each select="ns0:LimitationCountryCode">
																									<com:LimitationCountryCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:LimitationCountryCode>
																								</xsl:for-each>
																							</com:LimitationCountryCodeBag>
																						</xsl:for-each>
																						<xsl:variable name="var184_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																								<xsl:variable name="var183_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf32_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var183_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var184_resultof_filter">
																							<tmk:GoodsServicesLimitationCategory>
																								<xsl:call-template name="vmf:vmf32_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:GoodsServicesLimitationCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var185_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var185_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var185_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																							<tmk:LimitationClassDescriptionBag>
																								<xsl:for-each select="ns0:ClassDescription">
																									<tmk:ClassDescription>
																										<xsl:for-each select="ns0:ClassNumber">
																											<tmk:ClassNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassNumber>
																										</xsl:for-each>
																										<xsl:variable name="var187_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassNumberStatusCode">
																												<xsl:variable name="var186_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf18_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var186_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var187_resultof_filter">
																											<tmk:ClassNumberStatusCategory>
																												<xsl:call-template name="vmf:vmf18_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassNumberStatusCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:GoodsServicesDescription">
																											<xsl:variable name="var188_languageCode" as="node()?" select="@languageCode"/>
																											<xsl:variable name="var189_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																											<tmk:GoodsServicesDescriptionText>
																												<xsl:if test="fn:exists($var188_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var188_languageCode)"/>
																												</xsl:if>
																												<xsl:if test="fn:exists($var189_sequenceNumber)">
																													<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var189_sequenceNumber)))"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:GoodsServicesDescriptionText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																											<tmk:UseNiceHeadingIndicator>
																												<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																											</tmk:UseNiceHeadingIndicator>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermDetails">
																											<tmk:ClassificationTermBag>
																												<xsl:for-each select="ns0:ClassificationTerm">
																													<xsl:variable name="var197_operationCode" as="node()?" select="@operationCode"/>
																													<tmk:ClassificationTerm>
																														<xsl:if test="fn:exists($var197_operationCode)">
																															<xsl:attribute name="com:operationCategory" select="fn:string($var197_operationCode)"/>
																														</xsl:if>
																														<xsl:for-each select="ns0:ClassificationTermIdentifier">
																															<xsl:variable name="var190_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																															<tmk:ClassificationTermIdentifier>
																																<xsl:if test="fn:exists($var190_identifierKindCode)">
																																	<xsl:attribute name="com:officeCode" select="fn:string($var190_identifierKindCode)"/>
																																</xsl:if>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermIdentifier>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermOffice">
																															<tmk:ClassificationTermOfficeCode>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermOfficeCode>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																															<tmk:ClassificationTermOfficeIdentification>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermOfficeIdentification>
																														</xsl:for-each>
																														<xsl:variable name="var192_resultof_filter" as="node()?">
																															<xsl:for-each select="ns0:ClassificationTermSource">
																																<xsl:variable name="var191_resultof_vmf___inputtoresult" as="xs:string?">
																																	<xsl:call-template name="vmf:vmf19_inputtoresult">
																																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																	</xsl:call-template>
																																</xsl:variable>
																																<xsl:if test="fn:exists($var191_resultof_vmf___inputtoresult)">
																																	<xsl:sequence select="."/>
																																</xsl:if>
																															</xsl:for-each>
																														</xsl:variable>
																														<xsl:for-each select="$var192_resultof_filter">
																															<tmk:ClassificationTermSourceCategory>
																																<xsl:call-template name="vmf:vmf19_inputtoresult">
																																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																</xsl:call-template>
																															</tmk:ClassificationTermSourceCategory>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermEntryDate">
																															<tmk:ClassificationTermEntryDate>
																																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																															</tmk:ClassificationTermEntryDate>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassNumber">
																															<tmk:ClassNumber>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassNumber>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermText">
																															<xsl:variable name="var193_languageCode" as="node()?" select="@languageCode"/>
																															<tmk:ClassificationTermText>
																																<xsl:if test="fn:exists($var193_languageCode)">
																																	<xsl:attribute name="com:languageCode" select="fn:string($var193_languageCode)"/>
																																</xsl:if>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermText>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																															<tmk:ClassificationTermEquivalentGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermEquivalentGroup>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																															<tmk:ClassificationTermReferenceGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermReferenceGroup>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																															<tmk:ClassificationTermTranslationGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermTranslationGroup>
																														</xsl:for-each>
																														<xsl:variable name="var195_resultof_filter" as="node()?">
																															<xsl:for-each select="ns0:ClassificationTermStatus">
																																<xsl:variable name="var194_resultof_vmf___inputtoresult" as="xs:string?">
																																	<xsl:call-template name="vmf:vmf20_inputtoresult">
																																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																	</xsl:call-template>
																																</xsl:variable>
																																<xsl:if test="fn:exists($var194_resultof_vmf___inputtoresult)">
																																	<xsl:sequence select="."/>
																																</xsl:if>
																															</xsl:for-each>
																														</xsl:variable>
																														<xsl:for-each select="$var195_resultof_filter">
																															<xsl:variable name="var196_officeCode" as="node()?" select="@officeCode"/>
																															<tmk:ClassificationTermStatus>
																																<xsl:if test="fn:exists($var196_officeCode)">
																																	<xsl:attribute name="com:officeCode" select="fn:string($var196_officeCode)"/>
																																</xsl:if>
																																<xsl:call-template name="vmf:vmf20_inputtoresult">
																																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																</xsl:call-template>
																															</tmk:ClassificationTermStatus>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:WIPOBasicNumber">
																															<tmk:WIPOBasicNumber>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:WIPOBasicNumber>
																														</xsl:for-each>
																													</tmk:ClassificationTerm>
																												</xsl:for-each>
																											</tmk:ClassificationTermBag>
																										</xsl:for-each>
																									</tmk:ClassDescription>
																								</xsl:for-each>
																							</tmk:LimitationClassDescriptionBag>
																						</xsl:for-each>
																					</tmk:GoodsServicesLimitation>
																				</xsl:for-each>
																			</tmk:GoodsServicesLimitationBag>
																		</xsl:for-each>
																	</tmk:RecordTransfer>
																</xsl:for-each>
																<xsl:for-each select="ns0:RecordChangeNameAddress">
																	<xsl:variable name="var224_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf38_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordChangeNameAddressKind)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<tmk:RecordChangeNameAddress>
																		<xsl:for-each select="ns0:RecordIdentifier">
																			<com:RecordIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordFilingDate">
																			<com:RecordFilingDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordFilingDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordNotificationDate">
																			<com:RecordNotificationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordNotificationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEffectiveDate">
																			<com:RecordEffectiveDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEffectiveDate>
																		</xsl:for-each>
																		<xsl:if test="fn:exists($var224_resultof_vmf___inputtoresult)">
																			<com:RecordChangeNameAddressCategory>
																				<xsl:sequence select="$var224_resultof_vmf___inputtoresult"/>
																			</com:RecordChangeNameAddressCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordReference">
																			<com:RecordReference>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordReference>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordLanguageCode">
																			<com:RecordLanguageCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordLanguageCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:TradeMarkKeyDetails">
																			<tmk:TrademarkIdentification>
																				<xsl:for-each select="ns0:TradeMarkKey">
																					<tmk:TrademarkIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var199_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<tmk:TrademarkIdentifier>
																								<xsl:if test="fn:exists($var199_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var199_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:TrademarkIdentifier>
																						</xsl:for-each>
																					</tmk:TrademarkIdentifierBag>
																				</xsl:for-each>
																			</tmk:TrademarkIdentification>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordPublicationDetails">
																			<tmk:RecordPublicationBag>
																				<xsl:for-each select="ns0:RecordPublication">
																					<tmk:RecordPublication>
																						<com:PublicationIdentifier>
																							<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																						</com:PublicationIdentifier>
																						<xsl:variable name="var201_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:PublicationSection">
																								<xsl:variable name="var200_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf27_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var200_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var201_resultof_filter">
																							<tmk:PublicationSectionCategory>
																								<xsl:call-template name="vmf:vmf27_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:PublicationSectionCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationSubsection">
																							<com:PublicationSubsection>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationSubsection>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationDate">
																							<com:PublicationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PublicationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationPage">
																							<com:PublicationPage>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationPage>
																						</xsl:for-each>
																					</tmk:RecordPublication>
																				</xsl:for-each>
																			</tmk:RecordPublicationBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantDetails">
																			<tmk:ClaimantBag>
																				<xsl:for-each select="ns0:ClaimantKey">
																					<com:PartyIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var202_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var202_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var202_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																					</com:PartyIdentifierBag>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:Claimant">
																					<xsl:variable name="var207_operationCode" as="node()?" select="@operationCode"/>
																					<tmk:Claimant>
																						<xsl:if test="fn:exists($var207_operationCode)">
																							<xsl:attribute name="com:operationCategory" select="fn:string($var207_operationCode)"/>
																						</xsl:if>
																						<xsl:for-each select="ns0:ClaimantSequenceNumber">
																							<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantLegalEntity">
																							<com:LegalEntityName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LegalEntityName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantNationalityCode">
																							<com:NationalityCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:NationalityCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																							<com:IncorporationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationCountryCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationState">
																							<com:IncorporationState>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationState>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var203_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var203_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var203_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantEntitlement">
																							<tmk:Entitlement>
																								<xsl:for-each select="ns0:EntitlementNationalityCode">
																									<com:EntitlementNationalityCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:EntitlementNationalityCode>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementEstablishment">
																									<com:EntitlementEstablishment>
																										<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																											<com:EntitlementEstablishmentCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementEstablishmentCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																											<xsl:variable name="var204_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var204_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</com:EntitlementEstablishment>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementDomiciled">
																									<com:EntitlementDomiciled>
																										<xsl:for-each select="ns0:EntitlementDomiciledCode">
																											<com:EntitlementDomiciledCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementDomiciledCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																											<com:Contact>
																												<xsl:sequence select="()"/>
																											</com:Contact>
																										</xsl:for-each>
																									</com:EntitlementDomiciled>
																								</xsl:for-each>
																							</tmk:Entitlement>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIdentifier">
																							<xsl:variable name="var205_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var205_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var205_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantAddressBook">
																							<xsl:variable name="var206_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var206_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</tmk:Claimant>
																				</xsl:for-each>
																			</tmk:ClaimantBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RepresentativeDetails">
																			<com:RepresentativeBag>
																				<xsl:for-each select="ns0:Representative">
																					<xsl:variable name="var208_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																							<xsl:with-param name="Representative" as="node()">
																								<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</RepresentativeType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var208_resultof_MappingST__RepresentativeToST__Representative">
																						<com:Representative>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Representative>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:RepresentativeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDetails">
																			<com:RecordEventBag>
																				<xsl:for-each select="ns0:RecordEvent">
																					<xsl:variable name="var210_resultof_vmf___inputtoresult" as="xs:string?">
																						<xsl:call-template name="vmf:vmf35_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:variable>
																					<com:RecordEvent>
																						<xsl:if test="fn:exists($var210_resultof_vmf___inputtoresult)">
																							<com:RecordEventCategory>
																								<xsl:sequence select="$var210_resultof_vmf___inputtoresult"/>
																							</com:RecordEventCategory>
																						</xsl:if>
																						<xsl:for-each select="ns0:RecordEventResponseDate">
																							<com:RecordEventResponseDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventResponseDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var209_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var209_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var209_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDate">
																							<com:RecordEventDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDateTime">
																							<com:RecordEventDateTime>
																								<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																							</com:RecordEventDateTime>
																						</xsl:for-each>
																					</com:RecordEvent>
																				</xsl:for-each>
																			</com:RecordEventBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordDocumentDetails">
																			<com:RecordDocumentBag>
																				<xsl:for-each select="ns0:RecordDocument">
																					<com:RecordDocument>
																						<xsl:for-each select="ns0:DocumentLanguageCode">
																							<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentName">
																							<com:DocumentName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentFilename">
																							<com:FileName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:FileName>
																						</xsl:for-each>
																						<xsl:variable name="var212_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentFileFormat">
																								<xsl:variable name="var211_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf22_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var211_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var212_resultof_filter">
																							<com:DocumentFormatCategory>
																								<xsl:call-template name="vmf:vmf22_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentFormatCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentDate">
																							<com:DocumentDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:DocumentDate>
																						</xsl:for-each>
																						<xsl:variable name="var214_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentMedia">
																								<xsl:variable name="var213_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf23_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var213_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var214_resultof_filter">
																							<com:DocumentMediaCategory>
																								<xsl:call-template name="vmf:vmf23_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentMediaCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentLocation">
																							<com:DocumentLocationURI>
																								<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</com:DocumentLocationURI>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentVersion">
																							<com:DocumentVersion>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentVersion>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentSizeInByte">
																							<com:DocumentSizeQuantity>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:DocumentSizeQuantity>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var215_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var215_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var215_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																					</com:RecordDocument>
																				</xsl:for-each>
																			</com:RecordDocumentBag>
																		</xsl:for-each>
																		<xsl:variable name="var217_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:RecordCurrentStatusCode">
																				<xsl:variable name="var216_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf39_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var216_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var217_resultof_filter">
																			<com:RecordCurrentStatusCategory>
																				<xsl:call-template name="vmf:vmf39_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:RecordCurrentStatusCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordCurrentStatusDate">
																			<com:RecordCurrentStatusDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordCurrentStatusDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:CorrespondenceAddress">
																			<com:CorrespondenceAddress>
																				<xsl:variable name="var219_resultof_filter" as="node()?">
																					<xsl:for-each select="ns0:CorrespondenceAddressParty">
																						<xsl:variable name="var218_resultof_vmf___inputtoresult" as="xs:string?">
																							<xsl:call-template name="vmf:vmf37_inputtoresult">
																								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																							</xsl:call-template>
																						</xsl:variable>
																						<xsl:if test="fn:exists($var218_resultof_vmf___inputtoresult)">
																							<xsl:sequence select="."/>
																						</xsl:if>
																					</xsl:for-each>
																				</xsl:variable>
																				<xsl:for-each select="$var219_resultof_filter">
																					<com:CorrespondenceAddressPartyCategory>
																						<xsl:call-template name="vmf:vmf37_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																						</xsl:call-template>
																					</com:CorrespondenceAddressPartyCategory>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:CorrespondenceAddressIdentifier">
																					<xsl:variable name="var220_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																					<com:PartyIdentifier>
																						<xsl:if test="fn:exists($var220_identifierKindCode)">
																							<xsl:attribute name="com:officeCode" select="fn:string($var220_identifierKindCode)"/>
																						</xsl:if>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:PartyIdentifier>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:CorrespondenceAddressBook">
																					<xsl:variable name="var221_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																							<xsl:with-param name="AddressBook" as="node()">
																								<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</AddressBookType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var221_resultof_MappingST__AddressBookToST__Contact">
																						<com:Contact>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Contact>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:CorrespondenceAddress>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:HolderDetails">
																			<tmk:HolderChangeBag>
																				<xsl:for-each select="ns0:PreviousHolder">
																					<xsl:variable name="var222_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																							<xsl:with-param name="Applicant" as="node()">
																								<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</ApplicantType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var222_resultof_MappingST__ApplicantToST__Applicant">
																						<tmk:PreviousHolderBag>
																							<xsl:sequence select="()"/>
																						</tmk:PreviousHolderBag>
																					</xsl:for-each>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:NewHolder">
																					<xsl:variable name="var223_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																							<xsl:with-param name="Applicant" as="node()">
																								<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</ApplicantType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var223_resultof_MappingST__ApplicantToST__Applicant">
																						<tmk:HolderBag>
																							<xsl:sequence select="()"/>
																						</tmk:HolderBag>
																					</xsl:for-each>
																				</xsl:for-each>
																			</tmk:HolderChangeBag>
																		</xsl:for-each>
																	</tmk:RecordChangeNameAddress>
																</xsl:for-each>
																<xsl:for-each select="ns0:RecordLicence">
																	<xsl:variable name="var279_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf40_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordLicenceKind)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<tmk:RecordLicence>
																		<xsl:for-each select="ns0:RecordIdentifier">
																			<com:RecordIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordFilingDate">
																			<com:RecordFilingDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordFilingDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordNotificationDate">
																			<com:RecordNotificationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordNotificationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEffectiveDate">
																			<com:RecordEffectiveDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEffectiveDate>
																		</xsl:for-each>
																		<xsl:if test="fn:exists($var279_resultof_vmf___inputtoresult)">
																			<com:RecordLicenceCategory>
																				<xsl:sequence select="$var279_resultof_vmf___inputtoresult"/>
																			</com:RecordLicenceCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordReference">
																			<com:RecordReference>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordReference>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordLanguageCode">
																			<com:RecordLanguageCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordLanguageCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:TradeMarkKeyDetails">
																			<tmk:TrademarkIdentification>
																				<xsl:for-each select="ns0:TradeMarkKey">
																					<tmk:TrademarkIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var225_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<tmk:TrademarkIdentifier>
																								<xsl:if test="fn:exists($var225_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var225_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:TrademarkIdentifier>
																						</xsl:for-each>
																					</tmk:TrademarkIdentifierBag>
																				</xsl:for-each>
																			</tmk:TrademarkIdentification>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordPublicationDetails">
																			<tmk:RecordPublicationBag>
																				<xsl:for-each select="ns0:RecordPublication">
																					<tmk:RecordPublication>
																						<com:PublicationIdentifier>
																							<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																						</com:PublicationIdentifier>
																						<xsl:variable name="var227_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:PublicationSection">
																								<xsl:variable name="var226_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf27_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var226_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var227_resultof_filter">
																							<tmk:PublicationSectionCategory>
																								<xsl:call-template name="vmf:vmf27_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:PublicationSectionCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationSubsection">
																							<com:PublicationSubsection>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationSubsection>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationDate">
																							<com:PublicationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PublicationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationPage">
																							<com:PublicationPage>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationPage>
																						</xsl:for-each>
																					</tmk:RecordPublication>
																				</xsl:for-each>
																			</tmk:RecordPublicationBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantDetails">
																			<tmk:ClaimantBag>
																				<xsl:for-each select="ns0:ClaimantKey">
																					<com:PartyIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var228_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var228_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var228_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																					</com:PartyIdentifierBag>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:Claimant">
																					<xsl:variable name="var233_operationCode" as="node()?" select="@operationCode"/>
																					<tmk:Claimant>
																						<xsl:if test="fn:exists($var233_operationCode)">
																							<xsl:attribute name="com:operationCategory" select="fn:string($var233_operationCode)"/>
																						</xsl:if>
																						<xsl:for-each select="ns0:ClaimantSequenceNumber">
																							<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantLegalEntity">
																							<com:LegalEntityName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LegalEntityName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantNationalityCode">
																							<com:NationalityCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:NationalityCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																							<com:IncorporationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationCountryCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationState">
																							<com:IncorporationState>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationState>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var229_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var229_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var229_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantEntitlement">
																							<tmk:Entitlement>
																								<xsl:for-each select="ns0:EntitlementNationalityCode">
																									<com:EntitlementNationalityCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:EntitlementNationalityCode>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementEstablishment">
																									<com:EntitlementEstablishment>
																										<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																											<com:EntitlementEstablishmentCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementEstablishmentCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																											<xsl:variable name="var230_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var230_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</com:EntitlementEstablishment>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementDomiciled">
																									<com:EntitlementDomiciled>
																										<xsl:for-each select="ns0:EntitlementDomiciledCode">
																											<com:EntitlementDomiciledCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementDomiciledCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																											<com:Contact>
																												<xsl:sequence select="()"/>
																											</com:Contact>
																										</xsl:for-each>
																									</com:EntitlementDomiciled>
																								</xsl:for-each>
																							</tmk:Entitlement>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIdentifier">
																							<xsl:variable name="var231_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var231_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var231_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantAddressBook">
																							<xsl:variable name="var232_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var232_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</tmk:Claimant>
																				</xsl:for-each>
																			</tmk:ClaimantBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RepresentativeDetails">
																			<com:RepresentativeBag>
																				<xsl:for-each select="ns0:Representative">
																					<xsl:variable name="var234_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																							<xsl:with-param name="Representative" as="node()">
																								<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</RepresentativeType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var234_resultof_MappingST__RepresentativeToST__Representative">
																						<com:Representative>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Representative>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:RepresentativeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDetails">
																			<com:RecordEventBag>
																				<xsl:for-each select="ns0:RecordEvent">
																					<xsl:variable name="var236_resultof_vmf___inputtoresult" as="xs:string?">
																						<xsl:call-template name="vmf:vmf35_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:variable>
																					<com:RecordEvent>
																						<xsl:if test="fn:exists($var236_resultof_vmf___inputtoresult)">
																							<com:RecordEventCategory>
																								<xsl:sequence select="$var236_resultof_vmf___inputtoresult"/>
																							</com:RecordEventCategory>
																						</xsl:if>
																						<xsl:for-each select="ns0:RecordEventResponseDate">
																							<com:RecordEventResponseDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventResponseDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var235_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var235_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var235_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDate">
																							<com:RecordEventDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDateTime">
																							<com:RecordEventDateTime>
																								<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																							</com:RecordEventDateTime>
																						</xsl:for-each>
																					</com:RecordEvent>
																				</xsl:for-each>
																			</com:RecordEventBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordDocumentDetails">
																			<com:RecordDocumentBag>
																				<xsl:for-each select="ns0:RecordDocument">
																					<com:RecordDocument>
																						<xsl:for-each select="ns0:DocumentLanguageCode">
																							<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentName">
																							<com:DocumentName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentFilename">
																							<com:FileName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:FileName>
																						</xsl:for-each>
																						<xsl:variable name="var238_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentFileFormat">
																								<xsl:variable name="var237_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf22_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var237_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var238_resultof_filter">
																							<com:DocumentFormatCategory>
																								<xsl:call-template name="vmf:vmf22_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentFormatCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentDate">
																							<com:DocumentDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:DocumentDate>
																						</xsl:for-each>
																						<xsl:variable name="var240_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentMedia">
																								<xsl:variable name="var239_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf23_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var239_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var240_resultof_filter">
																							<com:DocumentMediaCategory>
																								<xsl:call-template name="vmf:vmf23_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentMediaCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentLocation">
																							<com:DocumentLocationURI>
																								<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</com:DocumentLocationURI>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentVersion">
																							<com:DocumentVersion>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentVersion>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentSizeInByte">
																							<com:DocumentSizeQuantity>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:DocumentSizeQuantity>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var241_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var241_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var241_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																					</com:RecordDocument>
																				</xsl:for-each>
																			</com:RecordDocumentBag>
																		</xsl:for-each>
																		<xsl:variable name="var243_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:RecordCurrentStatusCode">
																				<xsl:variable name="var242_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf41_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var242_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var243_resultof_filter">
																			<com:RecordCurrentStatusCategory>
																				<xsl:call-template name="vmf:vmf41_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:RecordCurrentStatusCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordCurrentStatusDate">
																			<com:RecordCurrentStatusDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordCurrentStatusDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordInterestedOfficeCode">
																			<com:RecordInterestedOfficeCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordInterestedOfficeCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordDesignatedCountryDetails">
																			<com:RecordDesignatedCountryCodeBag>
																				<xsl:for-each select="ns0:RecordDesignatedCountryCode">
																					<com:RecordDesignatedCountryCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:RecordDesignatedCountryCode>
																				</xsl:for-each>
																			</com:RecordDesignatedCountryCodeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LicenceDetails">
																			<tmk:LicenceBag>
																				<xsl:for-each select="ns0:Licence">
																					<tmk:Licence>
																						<xsl:for-each select="ns0:LicenceIdentifier">
																							<com:LicenceIdentifier>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LicenceIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenceDate">
																							<com:LicenceDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:LicenceDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenceNumber">
																							<com:LicenceNumber>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LicenceNumber>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenceReference">
																							<com:LicenceReference>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LicenceReference>
																						</xsl:for-each>
																						<xsl:variable name="var245_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:LicenceKind">
																								<xsl:variable name="var244_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf42_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var244_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var245_resultof_filter">
																							<com:LicenceCategory>
																								<xsl:call-template name="vmf:vmf42_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:LicenceCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:SubLicenceIndicator">
																							<com:SublicenceIndicator>
																								<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																							</com:SublicenceIndicator>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RelatedLicenceIdentifier">
																							<com:RelatedLicenceIdentifier>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:RelatedLicenceIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:GoodsServicesLimitationIndicator">
																							<tmk:GoodsServicesLimitationIndicator>
																								<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																							</tmk:GoodsServicesLimitationIndicator>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:GoodsServicesLimitation">
																							<tmk:GoodsServicesLimitation>
																								<xsl:for-each select="ns0:LimitationCountryDetails">
																									<com:LimitationCountryCodeBag>
																										<xsl:for-each select="ns0:LimitationCountryCode">
																											<com:LimitationCountryCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:LimitationCountryCode>
																										</xsl:for-each>
																									</com:LimitationCountryCodeBag>
																								</xsl:for-each>
																								<xsl:variable name="var247_resultof_filter" as="node()?">
																									<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																										<xsl:variable name="var246_resultof_vmf___inputtoresult" as="xs:string?">
																											<xsl:call-template name="vmf:vmf32_inputtoresult">
																												<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																											</xsl:call-template>
																										</xsl:variable>
																										<xsl:if test="fn:exists($var246_resultof_vmf___inputtoresult)">
																											<xsl:sequence select="."/>
																										</xsl:if>
																									</xsl:for-each>
																								</xsl:variable>
																								<xsl:for-each select="$var247_resultof_filter">
																									<tmk:GoodsServicesLimitationCategory>
																										<xsl:call-template name="vmf:vmf32_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																										</xsl:call-template>
																									</tmk:GoodsServicesLimitationCategory>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:Comment">
																									<xsl:variable name="var248_languageCode" as="node()?" select="@languageCode"/>
																									<com:CommentText>
																										<xsl:if test="fn:exists($var248_languageCode)">
																											<xsl:attribute name="com:languageCode" select="fn:string($var248_languageCode)"/>
																										</xsl:if>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:CommentText>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																									<tmk:LimitationClassDescriptionBag>
																										<xsl:for-each select="ns0:ClassDescription">
																											<tmk:ClassDescription>
																												<xsl:for-each select="ns0:ClassNumber">
																													<tmk:ClassNumber>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassNumber>
																												</xsl:for-each>
																												<xsl:variable name="var250_resultof_filter" as="node()?">
																													<xsl:for-each select="ns0:ClassNumberStatusCode">
																														<xsl:variable name="var249_resultof_vmf___inputtoresult" as="xs:string?">
																															<xsl:call-template name="vmf:vmf18_inputtoresult">
																																<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																															</xsl:call-template>
																														</xsl:variable>
																														<xsl:if test="fn:exists($var249_resultof_vmf___inputtoresult)">
																															<xsl:sequence select="."/>
																														</xsl:if>
																													</xsl:for-each>
																												</xsl:variable>
																												<xsl:for-each select="$var250_resultof_filter">
																													<tmk:ClassNumberStatusCategory>
																														<xsl:call-template name="vmf:vmf18_inputtoresult">
																															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																														</xsl:call-template>
																													</tmk:ClassNumberStatusCategory>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:GoodsServicesDescription">
																													<xsl:variable name="var251_languageCode" as="node()?" select="@languageCode"/>
																													<xsl:variable name="var252_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																													<tmk:GoodsServicesDescriptionText>
																														<xsl:if test="fn:exists($var251_languageCode)">
																															<xsl:attribute name="com:languageCode" select="fn:string($var251_languageCode)"/>
																														</xsl:if>
																														<xsl:if test="fn:exists($var252_sequenceNumber)">
																															<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var252_sequenceNumber)))"/>
																														</xsl:if>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:GoodsServicesDescriptionText>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																													<tmk:UseNiceHeadingIndicator>
																														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																													</tmk:UseNiceHeadingIndicator>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermDetails">
																													<tmk:ClassificationTermBag>
																														<xsl:for-each select="ns0:ClassificationTerm">
																															<xsl:variable name="var260_operationCode" as="node()?" select="@operationCode"/>
																															<tmk:ClassificationTerm>
																																<xsl:if test="fn:exists($var260_operationCode)">
																																	<xsl:attribute name="com:operationCategory" select="fn:string($var260_operationCode)"/>
																																</xsl:if>
																																<xsl:for-each select="ns0:ClassificationTermIdentifier">
																																	<xsl:variable name="var253_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																																	<tmk:ClassificationTermIdentifier>
																																		<xsl:if test="fn:exists($var253_identifierKindCode)">
																																			<xsl:attribute name="com:officeCode" select="fn:string($var253_identifierKindCode)"/>
																																		</xsl:if>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermIdentifier>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermOffice">
																																	<tmk:ClassificationTermOfficeCode>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermOfficeCode>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																																	<tmk:ClassificationTermOfficeIdentification>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermOfficeIdentification>
																																</xsl:for-each>
																																<xsl:variable name="var255_resultof_filter" as="node()?">
																																	<xsl:for-each select="ns0:ClassificationTermSource">
																																		<xsl:variable name="var254_resultof_vmf___inputtoresult" as="xs:string?">
																																			<xsl:call-template name="vmf:vmf19_inputtoresult">
																																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																			</xsl:call-template>
																																		</xsl:variable>
																																		<xsl:if test="fn:exists($var254_resultof_vmf___inputtoresult)">
																																			<xsl:sequence select="."/>
																																		</xsl:if>
																																	</xsl:for-each>
																																</xsl:variable>
																																<xsl:for-each select="$var255_resultof_filter">
																																	<tmk:ClassificationTermSourceCategory>
																																		<xsl:call-template name="vmf:vmf19_inputtoresult">
																																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																		</xsl:call-template>
																																	</tmk:ClassificationTermSourceCategory>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermEntryDate">
																																	<tmk:ClassificationTermEntryDate>
																																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																																	</tmk:ClassificationTermEntryDate>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassNumber">
																																	<tmk:ClassNumber>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassNumber>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermText">
																																	<xsl:variable name="var256_languageCode" as="node()?" select="@languageCode"/>
																																	<tmk:ClassificationTermText>
																																		<xsl:if test="fn:exists($var256_languageCode)">
																																			<xsl:attribute name="com:languageCode" select="fn:string($var256_languageCode)"/>
																																		</xsl:if>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermText>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																																	<tmk:ClassificationTermEquivalentGroup>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermEquivalentGroup>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																																	<tmk:ClassificationTermReferenceGroup>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermReferenceGroup>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																																	<tmk:ClassificationTermTranslationGroup>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermTranslationGroup>
																																</xsl:for-each>
																																<xsl:variable name="var258_resultof_filter" as="node()?">
																																	<xsl:for-each select="ns0:ClassificationTermStatus">
																																		<xsl:variable name="var257_resultof_vmf___inputtoresult" as="xs:string?">
																																			<xsl:call-template name="vmf:vmf20_inputtoresult">
																																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																			</xsl:call-template>
																																		</xsl:variable>
																																		<xsl:if test="fn:exists($var257_resultof_vmf___inputtoresult)">
																																			<xsl:sequence select="."/>
																																		</xsl:if>
																																	</xsl:for-each>
																																</xsl:variable>
																																<xsl:for-each select="$var258_resultof_filter">
																																	<xsl:variable name="var259_officeCode" as="node()?" select="@officeCode"/>
																																	<tmk:ClassificationTermStatus>
																																		<xsl:if test="fn:exists($var259_officeCode)">
																																			<xsl:attribute name="com:officeCode" select="fn:string($var259_officeCode)"/>
																																		</xsl:if>
																																		<xsl:call-template name="vmf:vmf20_inputtoresult">
																																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																		</xsl:call-template>
																																	</tmk:ClassificationTermStatus>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:WIPOBasicNumber">
																																	<tmk:WIPOBasicNumber>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:WIPOBasicNumber>
																																</xsl:for-each>
																															</tmk:ClassificationTerm>
																														</xsl:for-each>
																													</tmk:ClassificationTermBag>
																												</xsl:for-each>
																											</tmk:ClassDescription>
																										</xsl:for-each>
																									</tmk:LimitationClassDescriptionBag>
																								</xsl:for-each>
																							</tmk:GoodsServicesLimitation>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:TerritoryLimitationIndicator">
																							<com:TerritoryLimitationIndicator>
																								<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																							</com:TerritoryLimitationIndicator>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:TerritoryLimitationText">
																							<xsl:variable name="var261_languageCode" as="node()?" select="@languageCode"/>
																							<com:TerritoryLimitationText>
																								<xsl:if test="fn:exists($var261_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var261_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:TerritoryLimitationText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PeriodLimitationIndicator">
																							<com:PeriodLimitationIndicator>
																								<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																							</com:PeriodLimitationIndicator>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PeriodLimitationText">
																							<xsl:variable name="var262_languageCode" as="node()?" select="@languageCode"/>
																							<com:PeriodLimitationText>
																								<xsl:if test="fn:exists($var262_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var262_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PeriodLimitationText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PeriodLimitationStartDate">
																							<com:PeriodLimitationStartDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PeriodLimitationStartDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PeriodLimitationEndDate">
																							<com:PeriodLimitationEndDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PeriodLimitationEndDate>
																						</xsl:for-each>
																						<xsl:variable name="var264_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:LicenceStatusCode">
																								<xsl:variable name="var263_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf43_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var263_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var264_resultof_filter">
																							<com:LicenceStatusCategory>
																								<xsl:call-template name="vmf:vmf43_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:LicenceStatusCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenseeDetails">
																							<tmk:LicenseeBag>
																								<xsl:for-each select="ns0:Licensee">
																									<xsl:variable name="var270_operationCode" as="node()?" select="@operationCode"/>
																									<tmk:Licensee>
																										<xsl:if test="fn:exists($var270_operationCode)">
																											<xsl:attribute name="com:operationCategory" select="fn:string($var270_operationCode)"/>
																										</xsl:if>
																										<xsl:for-each select="ns0:LicenseeSequenceNumber">
																											<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenseeLegalEntity">
																											<com:LegalEntityName>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:LegalEntityName>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenseeNationalityCode">
																											<com:NationalityCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:NationalityCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenseeIncorporationCountryCode">
																											<com:IncorporationCountryCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:IncorporationCountryCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenseeIncorporationState">
																											<com:IncorporationState>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:IncorporationState>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:Comment">
																											<xsl:variable name="var265_languageCode" as="node()?" select="@languageCode"/>
																											<com:CommentText>
																												<xsl:if test="fn:exists($var265_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var265_languageCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:CommentText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenseeEntitlement">
																											<tmk:Entitlement>
																												<xsl:for-each select="ns0:EntitlementNationalityCode">
																													<com:EntitlementNationalityCode>
																														<xsl:sequence select="fn:string(.)"/>
																													</com:EntitlementNationalityCode>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:EntitlementEstablishment">
																													<com:EntitlementEstablishment>
																														<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																															<com:EntitlementEstablishmentCode>
																																<xsl:sequence select="fn:string(.)"/>
																															</com:EntitlementEstablishmentCode>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																															<xsl:variable name="var266_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																																<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																																	<xsl:with-param name="AddressBook" as="node()">
																																		<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																																			<xsl:sequence select="(./@node(), ./node())"/>
																																		</AddressBookType>
																																	</xsl:with-param>
																																</xsl:call-template>
																															</xsl:variable>
																															<xsl:for-each select="$var266_resultof_MappingST__AddressBookToST__Contact">
																																<com:Contact>
																																	<xsl:sequence select="(./@node(), ./node())"/>
																																</com:Contact>
																															</xsl:for-each>
																														</xsl:for-each>
																													</com:EntitlementEstablishment>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:EntitlementDomiciled">
																													<com:EntitlementDomiciled>
																														<xsl:for-each select="ns0:EntitlementDomiciledCode">
																															<com:EntitlementDomiciledCode>
																																<xsl:sequence select="fn:string(.)"/>
																															</com:EntitlementDomiciledCode>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																															<xsl:variable name="var267_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																																<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																																	<xsl:with-param name="AddressBook" as="node()">
																																		<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																																			<xsl:sequence select="(./@node(), ./node())"/>
																																		</AddressBookType>
																																	</xsl:with-param>
																																</xsl:call-template>
																															</xsl:variable>
																															<xsl:for-each select="$var267_resultof_MappingST__AddressBookToST__Contact">
																																<com:Contact>
																																	<xsl:sequence select="(./@node(), ./node())"/>
																																</com:Contact>
																															</xsl:for-each>
																														</xsl:for-each>
																													</com:EntitlementDomiciled>
																												</xsl:for-each>
																											</tmk:Entitlement>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenseeIdentifier">
																											<xsl:variable name="var268_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																											<com:PartyIdentifier>
																												<xsl:if test="fn:exists($var268_identifierKindCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var268_identifierKindCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:PartyIdentifier>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenseeAddressBook">
																											<xsl:variable name="var269_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var269_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</tmk:Licensee>
																								</xsl:for-each>
																							</tmk:LicenseeBag>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RepresentativeDetails">
																							<com:RepresentativeBag>
																								<xsl:for-each select="ns0:Representative">
																									<xsl:variable name="var271_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																										<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																											<xsl:with-param name="Representative" as="node()">
																												<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</RepresentativeType>
																											</xsl:with-param>
																										</xsl:call-template>
																									</xsl:variable>
																									<xsl:for-each select="$var271_resultof_MappingST__RepresentativeToST__Representative">
																										<com:Representative>
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</com:Representative>
																									</xsl:for-each>
																								</xsl:for-each>
																							</com:RepresentativeBag>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenceEventDetails">
																							<com:LicenceEventBag>
																								<xsl:for-each select="ns0:LicenceEvent">
																									<xsl:variable name="var273_resultof_vmf___inputtoresult" as="xs:string?">
																										<xsl:call-template name="vmf:vmf44_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(ns0:LicenceEventCode)" as="xs:string"/>
																										</xsl:call-template>
																									</xsl:variable>
																									<com:LicenceEvent>
																										<xsl:if test="fn:exists($var273_resultof_vmf___inputtoresult)">
																											<com:LicenceEventCategory>
																												<xsl:sequence select="$var273_resultof_vmf___inputtoresult"/>
																											</com:LicenceEventCategory>
																										</xsl:if>
																										<xsl:for-each select="ns0:LicenceEventResponseDate">
																											<com:LicenceEventResponseDate>
																												<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																											</com:LicenceEventResponseDate>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:Comment">
																											<xsl:variable name="var272_languageCode" as="node()?" select="@languageCode"/>
																											<com:CommentText>
																												<xsl:if test="fn:exists($var272_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var272_languageCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:CommentText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenceEventDate">
																											<com:LicenceEventDate>
																												<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																											</com:LicenceEventDate>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:LicenceEventDateTime">
																											<com:LicenceEventDateTime>
																												<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																											</com:LicenceEventDateTime>
																										</xsl:for-each>
																									</com:LicenceEvent>
																								</xsl:for-each>
																							</com:LicenceEventBag>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenceDocumentDetails">
																							<com:LicenceDocumentBag>
																								<xsl:for-each select="ns0:LicenceDocument">
																									<com:LicenceDocument>
																										<xsl:for-each select="ns0:DocumentLanguageCode">
																											<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:DocumentName">
																											<com:DocumentName>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:DocumentName>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:DocumentFilename">
																											<com:FileName>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:FileName>
																										</xsl:for-each>
																										<xsl:variable name="var275_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:DocumentFileFormat">
																												<xsl:variable name="var274_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf22_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var274_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var275_resultof_filter">
																											<com:DocumentFormatCategory>
																												<xsl:call-template name="vmf:vmf22_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</com:DocumentFormatCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:DocumentDate">
																											<com:DocumentDate>
																												<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																											</com:DocumentDate>
																										</xsl:for-each>
																										<xsl:variable name="var277_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:DocumentMedia">
																												<xsl:variable name="var276_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf23_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var276_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var277_resultof_filter">
																											<com:DocumentMediaCategory>
																												<xsl:call-template name="vmf:vmf23_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</com:DocumentMediaCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:DocumentLocation">
																											<com:DocumentLocationURI>
																												<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																											</com:DocumentLocationURI>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:DocumentVersion">
																											<com:DocumentVersion>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:DocumentVersion>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:DocumentSizeInByte">
																											<com:DocumentSizeQuantity>
																												<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																											</com:DocumentSizeQuantity>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:Comment">
																											<xsl:variable name="var278_languageCode" as="node()?" select="@languageCode"/>
																											<com:CommentText>
																												<xsl:if test="fn:exists($var278_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var278_languageCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:CommentText>
																										</xsl:for-each>
																									</com:LicenceDocument>
																								</xsl:for-each>
																							</com:LicenceDocumentBag>
																						</xsl:for-each>
																					</tmk:Licence>
																				</xsl:for-each>
																			</tmk:LicenceBag>
																		</xsl:for-each>
																	</tmk:RecordLicence>
																</xsl:for-each>
																<xsl:for-each select="ns0:RecordNationalInternationalReplacement">
																	<tmk:RecordNationalInternationalReplacement>
																		<xsl:for-each select="ns0:RecordIdentifier">
																			<com:RecordIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordFilingDate">
																			<com:RecordFilingDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordFilingDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordNotificationDate">
																			<com:RecordNotificationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordNotificationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEffectiveDate">
																			<com:RecordEffectiveDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEffectiveDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:TradeMarkKeyDetails">
																			<tmk:TrademarkIdentification>
																				<xsl:for-each select="ns0:TradeMarkKey">
																					<tmk:TrademarkIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var280_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<tmk:TrademarkIdentifier>
																								<xsl:if test="fn:exists($var280_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var280_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:TrademarkIdentifier>
																						</xsl:for-each>
																					</tmk:TrademarkIdentifierBag>
																				</xsl:for-each>
																			</tmk:TrademarkIdentification>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordPublicationDetails">
																			<tmk:RecordPublicationBag>
																				<xsl:for-each select="ns0:RecordPublication">
																					<tmk:RecordPublication>
																						<com:PublicationIdentifier>
																							<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																						</com:PublicationIdentifier>
																						<xsl:variable name="var282_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:PublicationSection">
																								<xsl:variable name="var281_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf27_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var281_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var282_resultof_filter">
																							<tmk:PublicationSectionCategory>
																								<xsl:call-template name="vmf:vmf27_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:PublicationSectionCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationSubsection">
																							<com:PublicationSubsection>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationSubsection>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationDate">
																							<com:PublicationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PublicationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationPage">
																							<com:PublicationPage>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationPage>
																						</xsl:for-each>
																					</tmk:RecordPublication>
																				</xsl:for-each>
																			</tmk:RecordPublicationBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantDetails">
																			<tmk:ClaimantBag>
																				<xsl:for-each select="ns0:ClaimantKey">
																					<com:PartyIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var283_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var283_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var283_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																					</com:PartyIdentifierBag>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:Claimant">
																					<xsl:variable name="var288_operationCode" as="node()?" select="@operationCode"/>
																					<tmk:Claimant>
																						<xsl:if test="fn:exists($var288_operationCode)">
																							<xsl:attribute name="com:operationCategory" select="fn:string($var288_operationCode)"/>
																						</xsl:if>
																						<xsl:for-each select="ns0:ClaimantSequenceNumber">
																							<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantLegalEntity">
																							<com:LegalEntityName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LegalEntityName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantNationalityCode">
																							<com:NationalityCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:NationalityCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																							<com:IncorporationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationCountryCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationState">
																							<com:IncorporationState>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationState>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var284_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var284_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var284_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantEntitlement">
																							<tmk:Entitlement>
																								<xsl:for-each select="ns0:EntitlementNationalityCode">
																									<com:EntitlementNationalityCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:EntitlementNationalityCode>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementEstablishment">
																									<com:EntitlementEstablishment>
																										<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																											<com:EntitlementEstablishmentCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementEstablishmentCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																											<xsl:variable name="var285_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var285_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</com:EntitlementEstablishment>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementDomiciled">
																									<com:EntitlementDomiciled>
																										<xsl:for-each select="ns0:EntitlementDomiciledCode">
																											<com:EntitlementDomiciledCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementDomiciledCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																											<com:Contact>
																												<xsl:sequence select="()"/>
																											</com:Contact>
																										</xsl:for-each>
																									</com:EntitlementDomiciled>
																								</xsl:for-each>
																							</tmk:Entitlement>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIdentifier">
																							<xsl:variable name="var286_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var286_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var286_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantAddressBook">
																							<xsl:variable name="var287_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var287_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</tmk:Claimant>
																				</xsl:for-each>
																			</tmk:ClaimantBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RepresentativeDetails">
																			<com:RepresentativeBag>
																				<xsl:for-each select="ns0:Representative">
																					<xsl:variable name="var289_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																							<xsl:with-param name="Representative" as="node()">
																								<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</RepresentativeType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var289_resultof_MappingST__RepresentativeToST__Representative">
																						<com:Representative>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Representative>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:RepresentativeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDetails">
																			<com:RecordEventBag>
																				<xsl:for-each select="ns0:RecordEvent">
																					<xsl:variable name="var291_resultof_vmf___inputtoresult" as="xs:string?">
																						<xsl:call-template name="vmf:vmf35_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:variable>
																					<com:RecordEvent>
																						<xsl:if test="fn:exists($var291_resultof_vmf___inputtoresult)">
																							<com:RecordEventCategory>
																								<xsl:sequence select="$var291_resultof_vmf___inputtoresult"/>
																							</com:RecordEventCategory>
																						</xsl:if>
																						<xsl:for-each select="ns0:RecordEventResponseDate">
																							<com:RecordEventResponseDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventResponseDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var290_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var290_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var290_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDate">
																							<com:RecordEventDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDateTime">
																							<com:RecordEventDateTime>
																								<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																							</com:RecordEventDateTime>
																						</xsl:for-each>
																					</com:RecordEvent>
																				</xsl:for-each>
																			</com:RecordEventBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordDocumentDetails">
																			<com:RecordDocumentBag>
																				<xsl:for-each select="ns0:RecordDocument">
																					<com:RecordDocument>
																						<xsl:for-each select="ns0:DocumentLanguageCode">
																							<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentName">
																							<com:DocumentName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentFilename">
																							<com:FileName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:FileName>
																						</xsl:for-each>
																						<xsl:variable name="var293_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentFileFormat">
																								<xsl:variable name="var292_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf22_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var292_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var293_resultof_filter">
																							<com:DocumentFormatCategory>
																								<xsl:call-template name="vmf:vmf22_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentFormatCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentDate">
																							<com:DocumentDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:DocumentDate>
																						</xsl:for-each>
																						<xsl:variable name="var295_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentMedia">
																								<xsl:variable name="var294_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf23_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var294_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var295_resultof_filter">
																							<com:DocumentMediaCategory>
																								<xsl:call-template name="vmf:vmf23_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentMediaCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentLocation">
																							<com:DocumentLocationURI>
																								<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</com:DocumentLocationURI>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentVersion">
																							<com:DocumentVersion>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentVersion>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentSizeInByte">
																							<com:DocumentSizeQuantity>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:DocumentSizeQuantity>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var296_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var296_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var296_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																					</com:RecordDocument>
																				</xsl:for-each>
																			</com:RecordDocumentBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordInterestedOfficeCode">
																			<com:RecordInterestedOfficeCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordInterestedOfficeCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:GoodsServicesLimitationDetails">
																			<tmk:GoodsServicesLimitationBag>
																				<xsl:for-each select="ns0:GoodsServicesLimitation">
																					<tmk:GoodsServicesLimitation>
																						<xsl:for-each select="ns0:LimitationCountryDetails">
																							<com:LimitationCountryCodeBag>
																								<xsl:for-each select="ns0:LimitationCountryCode">
																									<com:LimitationCountryCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:LimitationCountryCode>
																								</xsl:for-each>
																							</com:LimitationCountryCodeBag>
																						</xsl:for-each>
																						<xsl:variable name="var298_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																								<xsl:variable name="var297_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf32_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var297_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var298_resultof_filter">
																							<tmk:GoodsServicesLimitationCategory>
																								<xsl:call-template name="vmf:vmf32_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:GoodsServicesLimitationCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var299_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var299_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var299_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																							<tmk:LimitationClassDescriptionBag>
																								<xsl:for-each select="ns0:ClassDescription">
																									<tmk:ClassDescription>
																										<xsl:for-each select="ns0:ClassNumber">
																											<tmk:ClassNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassNumber>
																										</xsl:for-each>
																										<xsl:variable name="var301_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassNumberStatusCode">
																												<xsl:variable name="var300_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf18_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var300_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var301_resultof_filter">
																											<tmk:ClassNumberStatusCategory>
																												<xsl:call-template name="vmf:vmf18_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassNumberStatusCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:GoodsServicesDescription">
																											<xsl:variable name="var302_languageCode" as="node()?" select="@languageCode"/>
																											<xsl:variable name="var303_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																											<tmk:GoodsServicesDescriptionText>
																												<xsl:if test="fn:exists($var302_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var302_languageCode)"/>
																												</xsl:if>
																												<xsl:if test="fn:exists($var303_sequenceNumber)">
																													<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var303_sequenceNumber)))"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:GoodsServicesDescriptionText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																											<tmk:UseNiceHeadingIndicator>
																												<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																											</tmk:UseNiceHeadingIndicator>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermDetails">
																											<tmk:ClassificationTermBag>
																												<xsl:for-each select="ns0:ClassificationTerm">
																													<xsl:variable name="var311_operationCode" as="node()?" select="@operationCode"/>
																													<tmk:ClassificationTerm>
																														<xsl:if test="fn:exists($var311_operationCode)">
																															<xsl:attribute name="com:operationCategory" select="fn:string($var311_operationCode)"/>
																														</xsl:if>
																														<xsl:for-each select="ns0:ClassificationTermIdentifier">
																															<xsl:variable name="var304_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																															<tmk:ClassificationTermIdentifier>
																																<xsl:if test="fn:exists($var304_identifierKindCode)">
																																	<xsl:attribute name="com:officeCode" select="fn:string($var304_identifierKindCode)"/>
																																</xsl:if>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermIdentifier>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermOffice">
																															<tmk:ClassificationTermOfficeCode>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermOfficeCode>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																															<tmk:ClassificationTermOfficeIdentification>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermOfficeIdentification>
																														</xsl:for-each>
																														<xsl:variable name="var306_resultof_filter" as="node()?">
																															<xsl:for-each select="ns0:ClassificationTermSource">
																																<xsl:variable name="var305_resultof_vmf___inputtoresult" as="xs:string?">
																																	<xsl:call-template name="vmf:vmf19_inputtoresult">
																																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																	</xsl:call-template>
																																</xsl:variable>
																																<xsl:if test="fn:exists($var305_resultof_vmf___inputtoresult)">
																																	<xsl:sequence select="."/>
																																</xsl:if>
																															</xsl:for-each>
																														</xsl:variable>
																														<xsl:for-each select="$var306_resultof_filter">
																															<tmk:ClassificationTermSourceCategory>
																																<xsl:call-template name="vmf:vmf19_inputtoresult">
																																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																</xsl:call-template>
																															</tmk:ClassificationTermSourceCategory>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermEntryDate">
																															<tmk:ClassificationTermEntryDate>
																																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																															</tmk:ClassificationTermEntryDate>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassNumber">
																															<tmk:ClassNumber>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassNumber>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermText">
																															<xsl:variable name="var307_languageCode" as="node()?" select="@languageCode"/>
																															<tmk:ClassificationTermText>
																																<xsl:if test="fn:exists($var307_languageCode)">
																																	<xsl:attribute name="com:languageCode" select="fn:string($var307_languageCode)"/>
																																</xsl:if>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermText>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																															<tmk:ClassificationTermEquivalentGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermEquivalentGroup>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																															<tmk:ClassificationTermReferenceGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermReferenceGroup>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																															<tmk:ClassificationTermTranslationGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermTranslationGroup>
																														</xsl:for-each>
																														<xsl:variable name="var309_resultof_filter" as="node()?">
																															<xsl:for-each select="ns0:ClassificationTermStatus">
																																<xsl:variable name="var308_resultof_vmf___inputtoresult" as="xs:string?">
																																	<xsl:call-template name="vmf:vmf20_inputtoresult">
																																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																	</xsl:call-template>
																																</xsl:variable>
																																<xsl:if test="fn:exists($var308_resultof_vmf___inputtoresult)">
																																	<xsl:sequence select="."/>
																																</xsl:if>
																															</xsl:for-each>
																														</xsl:variable>
																														<xsl:for-each select="$var309_resultof_filter">
																															<xsl:variable name="var310_officeCode" as="node()?" select="@officeCode"/>
																															<tmk:ClassificationTermStatus>
																																<xsl:if test="fn:exists($var310_officeCode)">
																																	<xsl:attribute name="com:officeCode" select="fn:string($var310_officeCode)"/>
																																</xsl:if>
																																<xsl:call-template name="vmf:vmf20_inputtoresult">
																																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																</xsl:call-template>
																															</tmk:ClassificationTermStatus>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:WIPOBasicNumber">
																															<tmk:WIPOBasicNumber>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:WIPOBasicNumber>
																														</xsl:for-each>
																													</tmk:ClassificationTerm>
																												</xsl:for-each>
																											</tmk:ClassificationTermBag>
																										</xsl:for-each>
																									</tmk:ClassDescription>
																								</xsl:for-each>
																							</tmk:LimitationClassDescriptionBag>
																						</xsl:for-each>
																					</tmk:GoodsServicesLimitation>
																				</xsl:for-each>
																			</tmk:GoodsServicesLimitationBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:NationalMarkDetails">
																			<tmk:NationalMarkBag>
																				<xsl:for-each select="ns0:NationalMark">
																					<tmk:NationalMark>
																						<tmk:NationalMarkRegistrationNumber>
																							<xsl:sequence select="fn:string(ns0:NationalMarkRegistrationNumber)"/>
																						</tmk:NationalMarkRegistrationNumber>
																						<xsl:for-each select="ns0:NationalMarkFilingDate">
																							<tmk:NationalMarkFilingDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</tmk:NationalMarkFilingDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:NationalMarkRegistrationDate">
																							<tmk:NationalMarkRegistrationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</tmk:NationalMarkRegistrationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:NationalMarkPriorityDate">
																							<tmk:NationalMarkPriorityDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</tmk:NationalMarkPriorityDate>
																						</xsl:for-each>
																					</tmk:NationalMark>
																				</xsl:for-each>
																			</tmk:NationalMarkBag>
																		</xsl:for-each>
																	</tmk:RecordNationalInternationalReplacement>
																</xsl:for-each>
																<xsl:for-each select="ns0:RecordShortNotation">
																	<xsl:variable name="var362_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf45_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordShortNotationKind)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<tmk:RecordShortNotation>
																		<xsl:for-each select="ns0:RecordIdentifier">
																			<com:RecordIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordFilingDate">
																			<com:RecordFilingDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordFilingDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordNotificationDate">
																			<com:RecordNotificationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordNotificationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEffectiveDate">
																			<com:RecordEffectiveDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEffectiveDate>
																		</xsl:for-each>
																		<xsl:if test="fn:exists($var362_resultof_vmf___inputtoresult)">
																			<tmk:RecordShortNotationCategory>
																				<xsl:sequence select="$var362_resultof_vmf___inputtoresult"/>
																			</tmk:RecordShortNotationCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordReference">
																			<com:RecordReference>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordReference>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordLanguageCode">
																			<com:RecordLanguageCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordLanguageCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordPublicationDetails">
																			<tmk:RecordPublicationBag>
																				<xsl:for-each select="ns0:RecordPublication">
																					<tmk:RecordPublication>
																						<com:PublicationIdentifier>
																							<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																						</com:PublicationIdentifier>
																						<xsl:variable name="var313_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:PublicationSection">
																								<xsl:variable name="var312_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf27_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var312_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var313_resultof_filter">
																							<tmk:PublicationSectionCategory>
																								<xsl:call-template name="vmf:vmf27_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:PublicationSectionCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationSubsection">
																							<com:PublicationSubsection>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationSubsection>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationDate">
																							<com:PublicationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:PublicationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:PublicationPage">
																							<com:PublicationPage>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PublicationPage>
																						</xsl:for-each>
																					</tmk:RecordPublication>
																				</xsl:for-each>
																			</tmk:RecordPublicationBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantDetails">
																			<tmk:ClaimantBag>
																				<xsl:for-each select="ns0:ClaimantKey">
																					<com:PartyIdentifierBag>
																						<xsl:for-each select="ns0:Identifier">
																							<xsl:variable name="var314_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var314_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var314_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																					</com:PartyIdentifierBag>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:Claimant">
																					<xsl:variable name="var319_operationCode" as="node()?" select="@operationCode"/>
																					<tmk:Claimant>
																						<xsl:if test="fn:exists($var319_operationCode)">
																							<xsl:attribute name="com:operationCategory" select="fn:string($var319_operationCode)"/>
																						</xsl:if>
																						<xsl:for-each select="ns0:ClaimantSequenceNumber">
																							<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantLegalEntity">
																							<com:LegalEntityName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LegalEntityName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantNationalityCode">
																							<com:NationalityCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:NationalityCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																							<com:IncorporationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationCountryCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIncorporationState">
																							<com:IncorporationState>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationState>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var315_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var315_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var315_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantEntitlement">
																							<tmk:Entitlement>
																								<xsl:for-each select="ns0:EntitlementNationalityCode">
																									<com:EntitlementNationalityCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:EntitlementNationalityCode>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementEstablishment">
																									<com:EntitlementEstablishment>
																										<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																											<com:EntitlementEstablishmentCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementEstablishmentCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																											<xsl:variable name="var316_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var316_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</com:EntitlementEstablishment>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementDomiciled">
																									<com:EntitlementDomiciled>
																										<xsl:for-each select="ns0:EntitlementDomiciledCode">
																											<com:EntitlementDomiciledCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementDomiciledCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																											<com:Contact>
																												<xsl:sequence select="()"/>
																											</com:Contact>
																										</xsl:for-each>
																									</com:EntitlementDomiciled>
																								</xsl:for-each>
																							</tmk:Entitlement>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantIdentifier">
																							<xsl:variable name="var317_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var317_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var317_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClaimantAddressBook">
																							<xsl:variable name="var318_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var318_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</tmk:Claimant>
																				</xsl:for-each>
																			</tmk:ClaimantBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RepresentativeDetails">
																			<com:RepresentativeBag>
																				<xsl:for-each select="ns0:Representative">
																					<xsl:variable name="var320_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																							<xsl:with-param name="Representative" as="node()">
																								<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</RepresentativeType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var320_resultof_MappingST__RepresentativeToST__Representative">
																						<com:Representative>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Representative>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:RepresentativeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDetails">
																			<com:RecordEventBag>
																				<xsl:for-each select="ns0:RecordEvent">
																					<xsl:variable name="var322_resultof_vmf___inputtoresult" as="xs:string?">
																						<xsl:call-template name="vmf:vmf35_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:variable>
																					<com:RecordEvent>
																						<xsl:if test="fn:exists($var322_resultof_vmf___inputtoresult)">
																							<com:RecordEventCategory>
																								<xsl:sequence select="$var322_resultof_vmf___inputtoresult"/>
																							</com:RecordEventCategory>
																						</xsl:if>
																						<xsl:for-each select="ns0:RecordEventResponseDate">
																							<com:RecordEventResponseDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventResponseDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var321_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var321_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var321_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDate">
																							<com:RecordEventDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RecordEventDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RecordEventDateTime">
																							<com:RecordEventDateTime>
																								<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																							</com:RecordEventDateTime>
																						</xsl:for-each>
																					</com:RecordEvent>
																				</xsl:for-each>
																			</com:RecordEventBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordDocumentDetails">
																			<com:RecordDocumentBag>
																				<xsl:for-each select="ns0:RecordDocument">
																					<com:RecordDocument>
																						<xsl:for-each select="ns0:DocumentLanguageCode">
																							<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentName">
																							<com:DocumentName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentFilename">
																							<com:FileName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:FileName>
																						</xsl:for-each>
																						<xsl:variable name="var324_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentFileFormat">
																								<xsl:variable name="var323_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf22_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var323_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var324_resultof_filter">
																							<com:DocumentFormatCategory>
																								<xsl:call-template name="vmf:vmf22_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentFormatCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentDate">
																							<com:DocumentDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:DocumentDate>
																						</xsl:for-each>
																						<xsl:variable name="var326_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentMedia">
																								<xsl:variable name="var325_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf23_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var325_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var326_resultof_filter">
																							<com:DocumentMediaCategory>
																								<xsl:call-template name="vmf:vmf23_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentMediaCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentLocation">
																							<com:DocumentLocationURI>
																								<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</com:DocumentLocationURI>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentVersion">
																							<com:DocumentVersion>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentVersion>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentSizeInByte">
																							<com:DocumentSizeQuantity>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:DocumentSizeQuantity>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var327_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var327_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var327_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																					</com:RecordDocument>
																				</xsl:for-each>
																			</com:RecordDocumentBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordInterestedOfficeCode">
																			<com:RecordInterestedOfficeCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RecordInterestedOfficeCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordToRegistration">
																			<tmk:RecordToRegistration>
																				<xsl:for-each select="ns0:RegistrationIdentifier">
																					<tmk:RegistrationIdentifier>
																						<xsl:sequence select="fn:string(.)"/>
																					</tmk:RegistrationIdentifier>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:RegistrationDate">
																					<com:RegistrationDate>
																						<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																					</com:RegistrationDate>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:MarkVerbalElementText">
																					<xsl:variable name="var328_languageCode" as="node()?" select="@languageCode"/>
																					<tmk:MarkVerbalElementText>
																						<xsl:if test="fn:exists($var328_languageCode)">
																							<xsl:attribute name="com:languageCode" select="fn:string($var328_languageCode)"/>
																						</xsl:if>
																						<xsl:sequence select="fn:string(.)"/>
																					</tmk:MarkVerbalElementText>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:DesignatedCountryDetails">
																					<tmk:DesignatedCountryCodeBag>
																						<xsl:for-each select="ns0:DesignatedCountryCode">
																							<com:DesignatedCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DesignatedCountryCode>
																						</xsl:for-each>
																					</tmk:DesignatedCountryCodeBag>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:GoodsServicesLimitation">
																					<tmk:GoodsServicesLimitation>
																						<xsl:for-each select="ns0:LimitationCountryDetails">
																							<com:LimitationCountryCodeBag>
																								<xsl:for-each select="ns0:LimitationCountryCode">
																									<com:LimitationCountryCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:LimitationCountryCode>
																								</xsl:for-each>
																							</com:LimitationCountryCodeBag>
																						</xsl:for-each>
																						<xsl:variable name="var330_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																								<xsl:variable name="var329_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf32_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var329_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var330_resultof_filter">
																							<tmk:GoodsServicesLimitationCategory>
																								<xsl:call-template name="vmf:vmf32_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:GoodsServicesLimitationCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var331_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var331_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var331_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																							<tmk:LimitationClassDescriptionBag>
																								<xsl:for-each select="ns0:ClassDescription">
																									<tmk:ClassDescription>
																										<xsl:for-each select="ns0:ClassNumber">
																											<tmk:ClassNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassNumber>
																										</xsl:for-each>
																										<xsl:variable name="var333_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassNumberStatusCode">
																												<xsl:variable name="var332_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf18_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var332_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var333_resultof_filter">
																											<tmk:ClassNumberStatusCategory>
																												<xsl:call-template name="vmf:vmf18_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassNumberStatusCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:GoodsServicesDescription">
																											<xsl:variable name="var334_languageCode" as="node()?" select="@languageCode"/>
																											<xsl:variable name="var335_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																											<tmk:GoodsServicesDescriptionText>
																												<xsl:if test="fn:exists($var334_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var334_languageCode)"/>
																												</xsl:if>
																												<xsl:if test="fn:exists($var335_sequenceNumber)">
																													<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var335_sequenceNumber)))"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:GoodsServicesDescriptionText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																											<tmk:UseNiceHeadingIndicator>
																												<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																											</tmk:UseNiceHeadingIndicator>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermDetails">
																											<tmk:ClassificationTermBag>
																												<xsl:for-each select="ns0:ClassificationTerm">
																													<xsl:variable name="var343_operationCode" as="node()?" select="@operationCode"/>
																													<tmk:ClassificationTerm>
																														<xsl:if test="fn:exists($var343_operationCode)">
																															<xsl:attribute name="com:operationCategory" select="fn:string($var343_operationCode)"/>
																														</xsl:if>
																														<xsl:for-each select="ns0:ClassificationTermIdentifier">
																															<xsl:variable name="var336_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																															<tmk:ClassificationTermIdentifier>
																																<xsl:if test="fn:exists($var336_identifierKindCode)">
																																	<xsl:attribute name="com:officeCode" select="fn:string($var336_identifierKindCode)"/>
																																</xsl:if>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermIdentifier>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermOffice">
																															<tmk:ClassificationTermOfficeCode>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermOfficeCode>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																															<tmk:ClassificationTermOfficeIdentification>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermOfficeIdentification>
																														</xsl:for-each>
																														<xsl:variable name="var338_resultof_filter" as="node()?">
																															<xsl:for-each select="ns0:ClassificationTermSource">
																																<xsl:variable name="var337_resultof_vmf___inputtoresult" as="xs:string?">
																																	<xsl:call-template name="vmf:vmf19_inputtoresult">
																																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																	</xsl:call-template>
																																</xsl:variable>
																																<xsl:if test="fn:exists($var337_resultof_vmf___inputtoresult)">
																																	<xsl:sequence select="."/>
																																</xsl:if>
																															</xsl:for-each>
																														</xsl:variable>
																														<xsl:for-each select="$var338_resultof_filter">
																															<tmk:ClassificationTermSourceCategory>
																																<xsl:call-template name="vmf:vmf19_inputtoresult">
																																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																</xsl:call-template>
																															</tmk:ClassificationTermSourceCategory>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermEntryDate">
																															<tmk:ClassificationTermEntryDate>
																																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																															</tmk:ClassificationTermEntryDate>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassNumber">
																															<tmk:ClassNumber>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassNumber>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermText">
																															<xsl:variable name="var339_languageCode" as="node()?" select="@languageCode"/>
																															<tmk:ClassificationTermText>
																																<xsl:if test="fn:exists($var339_languageCode)">
																																	<xsl:attribute name="com:languageCode" select="fn:string($var339_languageCode)"/>
																																</xsl:if>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermText>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																															<tmk:ClassificationTermEquivalentGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermEquivalentGroup>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																															<tmk:ClassificationTermReferenceGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermReferenceGroup>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																															<tmk:ClassificationTermTranslationGroup>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:ClassificationTermTranslationGroup>
																														</xsl:for-each>
																														<xsl:variable name="var341_resultof_filter" as="node()?">
																															<xsl:for-each select="ns0:ClassificationTermStatus">
																																<xsl:variable name="var340_resultof_vmf___inputtoresult" as="xs:string?">
																																	<xsl:call-template name="vmf:vmf20_inputtoresult">
																																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																	</xsl:call-template>
																																</xsl:variable>
																																<xsl:if test="fn:exists($var340_resultof_vmf___inputtoresult)">
																																	<xsl:sequence select="."/>
																																</xsl:if>
																															</xsl:for-each>
																														</xsl:variable>
																														<xsl:for-each select="$var341_resultof_filter">
																															<xsl:variable name="var342_officeCode" as="node()?" select="@officeCode"/>
																															<tmk:ClassificationTermStatus>
																																<xsl:if test="fn:exists($var342_officeCode)">
																																	<xsl:attribute name="com:officeCode" select="fn:string($var342_officeCode)"/>
																																</xsl:if>
																																<xsl:call-template name="vmf:vmf20_inputtoresult">
																																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																</xsl:call-template>
																															</tmk:ClassificationTermStatus>
																														</xsl:for-each>
																														<xsl:for-each select="ns0:WIPOBasicNumber">
																															<tmk:WIPOBasicNumber>
																																<xsl:sequence select="fn:string(.)"/>
																															</tmk:WIPOBasicNumber>
																														</xsl:for-each>
																													</tmk:ClassificationTerm>
																												</xsl:for-each>
																											</tmk:ClassificationTermBag>
																										</xsl:for-each>
																									</tmk:ClassDescription>
																								</xsl:for-each>
																							</tmk:LimitationClassDescriptionBag>
																						</xsl:for-each>
																					</tmk:GoodsServicesLimitation>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:ApplicantDetails">
																					<tmk:ApplicantBag>
																						<xsl:for-each select="ns0:Applicant">
																							<xsl:variable name="var344_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																									<xsl:with-param name="Applicant" as="node()">
																										<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</ApplicantType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var344_resultof_MappingST__ApplicantToST__Applicant">
																								<tmk:Applicant>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</tmk:Applicant>
																							</xsl:for-each>
																						</xsl:for-each>
																					</tmk:ApplicantBag>
																				</xsl:for-each>
																			</tmk:RecordToRegistration>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordFromRegistrationDetails">
																			<tmk:RecordFromRegistrationBag>
																				<xsl:for-each select="ns0:RecordFromRegistration">
																					<tmk:RecordFromRegistration>
																						<xsl:for-each select="ns0:RegistrationIdentifier">
																							<tmk:RegistrationIdentifier>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:RegistrationIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:RegistrationDate">
																							<com:RegistrationDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:RegistrationDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:MarkVerbalElementText">
																							<xsl:variable name="var345_languageCode" as="node()?" select="@languageCode"/>
																							<tmk:MarkVerbalElementText>
																								<xsl:if test="fn:exists($var345_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var345_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:MarkVerbalElementText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DesignatedCountryDetails">
																							<tmk:DesignatedCountryCodeBag>
																								<xsl:for-each select="ns0:DesignatedCountryCode">
																									<com:DesignatedCountryCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:DesignatedCountryCode>
																								</xsl:for-each>
																							</tmk:DesignatedCountryCodeBag>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:GoodsServicesLimitation">
																							<tmk:GoodsServicesLimitation>
																								<xsl:for-each select="ns0:LimitationCountryDetails">
																									<com:LimitationCountryCodeBag>
																										<xsl:for-each select="ns0:LimitationCountryCode">
																											<com:LimitationCountryCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:LimitationCountryCode>
																										</xsl:for-each>
																									</com:LimitationCountryCodeBag>
																								</xsl:for-each>
																								<xsl:variable name="var347_resultof_filter" as="node()?">
																									<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																										<xsl:variable name="var346_resultof_vmf___inputtoresult" as="xs:string?">
																											<xsl:call-template name="vmf:vmf32_inputtoresult">
																												<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																											</xsl:call-template>
																										</xsl:variable>
																										<xsl:if test="fn:exists($var346_resultof_vmf___inputtoresult)">
																											<xsl:sequence select="."/>
																										</xsl:if>
																									</xsl:for-each>
																								</xsl:variable>
																								<xsl:for-each select="$var347_resultof_filter">
																									<tmk:GoodsServicesLimitationCategory>
																										<xsl:call-template name="vmf:vmf32_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																										</xsl:call-template>
																									</tmk:GoodsServicesLimitationCategory>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:Comment">
																									<xsl:variable name="var348_languageCode" as="node()?" select="@languageCode"/>
																									<com:CommentText>
																										<xsl:if test="fn:exists($var348_languageCode)">
																											<xsl:attribute name="com:languageCode" select="fn:string($var348_languageCode)"/>
																										</xsl:if>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:CommentText>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																									<tmk:LimitationClassDescriptionBag>
																										<xsl:for-each select="ns0:ClassDescription">
																											<tmk:ClassDescription>
																												<xsl:for-each select="ns0:ClassNumber">
																													<tmk:ClassNumber>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassNumber>
																												</xsl:for-each>
																												<xsl:variable name="var350_resultof_filter" as="node()?">
																													<xsl:for-each select="ns0:ClassNumberStatusCode">
																														<xsl:variable name="var349_resultof_vmf___inputtoresult" as="xs:string?">
																															<xsl:call-template name="vmf:vmf18_inputtoresult">
																																<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																															</xsl:call-template>
																														</xsl:variable>
																														<xsl:if test="fn:exists($var349_resultof_vmf___inputtoresult)">
																															<xsl:sequence select="."/>
																														</xsl:if>
																													</xsl:for-each>
																												</xsl:variable>
																												<xsl:for-each select="$var350_resultof_filter">
																													<tmk:ClassNumberStatusCategory>
																														<xsl:call-template name="vmf:vmf18_inputtoresult">
																															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																														</xsl:call-template>
																													</tmk:ClassNumberStatusCategory>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:GoodsServicesDescription">
																													<xsl:variable name="var351_languageCode" as="node()?" select="@languageCode"/>
																													<xsl:variable name="var352_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																													<tmk:GoodsServicesDescriptionText>
																														<xsl:if test="fn:exists($var351_languageCode)">
																															<xsl:attribute name="com:languageCode" select="fn:string($var351_languageCode)"/>
																														</xsl:if>
																														<xsl:if test="fn:exists($var352_sequenceNumber)">
																															<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var352_sequenceNumber)))"/>
																														</xsl:if>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:GoodsServicesDescriptionText>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																													<tmk:UseNiceHeadingIndicator>
																														<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																													</tmk:UseNiceHeadingIndicator>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermDetails">
																													<tmk:ClassificationTermBag>
																														<xsl:for-each select="ns0:ClassificationTerm">
																															<xsl:variable name="var360_operationCode" as="node()?" select="@operationCode"/>
																															<tmk:ClassificationTerm>
																																<xsl:if test="fn:exists($var360_operationCode)">
																																	<xsl:attribute name="com:operationCategory" select="fn:string($var360_operationCode)"/>
																																</xsl:if>
																																<xsl:for-each select="ns0:ClassificationTermIdentifier">
																																	<xsl:variable name="var353_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																																	<tmk:ClassificationTermIdentifier>
																																		<xsl:if test="fn:exists($var353_identifierKindCode)">
																																			<xsl:attribute name="com:officeCode" select="fn:string($var353_identifierKindCode)"/>
																																		</xsl:if>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermIdentifier>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermOffice">
																																	<tmk:ClassificationTermOfficeCode>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermOfficeCode>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																																	<tmk:ClassificationTermOfficeIdentification>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermOfficeIdentification>
																																</xsl:for-each>
																																<xsl:variable name="var355_resultof_filter" as="node()?">
																																	<xsl:for-each select="ns0:ClassificationTermSource">
																																		<xsl:variable name="var354_resultof_vmf___inputtoresult" as="xs:string?">
																																			<xsl:call-template name="vmf:vmf19_inputtoresult">
																																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																			</xsl:call-template>
																																		</xsl:variable>
																																		<xsl:if test="fn:exists($var354_resultof_vmf___inputtoresult)">
																																			<xsl:sequence select="."/>
																																		</xsl:if>
																																	</xsl:for-each>
																																</xsl:variable>
																																<xsl:for-each select="$var355_resultof_filter">
																																	<tmk:ClassificationTermSourceCategory>
																																		<xsl:call-template name="vmf:vmf19_inputtoresult">
																																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																		</xsl:call-template>
																																	</tmk:ClassificationTermSourceCategory>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermEntryDate">
																																	<tmk:ClassificationTermEntryDate>
																																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																																	</tmk:ClassificationTermEntryDate>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassNumber">
																																	<tmk:ClassNumber>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassNumber>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermText">
																																	<xsl:variable name="var356_languageCode" as="node()?" select="@languageCode"/>
																																	<tmk:ClassificationTermText>
																																		<xsl:if test="fn:exists($var356_languageCode)">
																																			<xsl:attribute name="com:languageCode" select="fn:string($var356_languageCode)"/>
																																		</xsl:if>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermText>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																																	<tmk:ClassificationTermEquivalentGroup>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermEquivalentGroup>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																																	<tmk:ClassificationTermReferenceGroup>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermReferenceGroup>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																																	<tmk:ClassificationTermTranslationGroup>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:ClassificationTermTranslationGroup>
																																</xsl:for-each>
																																<xsl:variable name="var358_resultof_filter" as="node()?">
																																	<xsl:for-each select="ns0:ClassificationTermStatus">
																																		<xsl:variable name="var357_resultof_vmf___inputtoresult" as="xs:string?">
																																			<xsl:call-template name="vmf:vmf20_inputtoresult">
																																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																			</xsl:call-template>
																																		</xsl:variable>
																																		<xsl:if test="fn:exists($var357_resultof_vmf___inputtoresult)">
																																			<xsl:sequence select="."/>
																																		</xsl:if>
																																	</xsl:for-each>
																																</xsl:variable>
																																<xsl:for-each select="$var358_resultof_filter">
																																	<xsl:variable name="var359_officeCode" as="node()?" select="@officeCode"/>
																																	<tmk:ClassificationTermStatus>
																																		<xsl:if test="fn:exists($var359_officeCode)">
																																			<xsl:attribute name="com:officeCode" select="fn:string($var359_officeCode)"/>
																																		</xsl:if>
																																		<xsl:call-template name="vmf:vmf20_inputtoresult">
																																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																																		</xsl:call-template>
																																	</tmk:ClassificationTermStatus>
																																</xsl:for-each>
																																<xsl:for-each select="ns0:WIPOBasicNumber">
																																	<tmk:WIPOBasicNumber>
																																		<xsl:sequence select="fn:string(.)"/>
																																	</tmk:WIPOBasicNumber>
																																</xsl:for-each>
																															</tmk:ClassificationTerm>
																														</xsl:for-each>
																													</tmk:ClassificationTermBag>
																												</xsl:for-each>
																											</tmk:ClassDescription>
																										</xsl:for-each>
																									</tmk:LimitationClassDescriptionBag>
																								</xsl:for-each>
																							</tmk:GoodsServicesLimitation>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ApplicantDetails">
																							<tmk:ApplicantBag>
																								<xsl:for-each select="ns0:Applicant">
																									<xsl:variable name="var361_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																										<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																											<xsl:with-param name="Applicant" as="node()">
																												<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</ApplicantType>
																											</xsl:with-param>
																										</xsl:call-template>
																									</xsl:variable>
																									<xsl:for-each select="$var361_resultof_MappingST__ApplicantToST__Applicant">
																										<tmk:Applicant>
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</tmk:Applicant>
																									</xsl:for-each>
																								</xsl:for-each>
																							</tmk:ApplicantBag>
																						</xsl:for-each>
																					</tmk:RecordFromRegistration>
																				</xsl:for-each>
																			</tmk:RecordFromRegistrationBag>
																		</xsl:for-each>
																	</tmk:RecordShortNotation>
																</xsl:for-each>
															</tmk:MarkRecord>
														</xsl:for-each>
													</tmk:MarkRecordBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:MarkEventDetails">
													<tmk:MarkEventBag>
														<xsl:for-each select="ns0:MarkEvent">
															<xsl:variable name="var364_resultof_vmf___inputtoresult" as="xs:string?">
																<xsl:call-template name="vmf:vmf46_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(ns0:MarkEventCode)" as="xs:string"/>
																</xsl:call-template>
															</xsl:variable>
															<tmk:MarkEvent>
																<xsl:if test="fn:exists($var364_resultof_vmf___inputtoresult)">
																	<tmk:MarkEventCategory>
																		<xsl:sequence select="$var364_resultof_vmf___inputtoresult"/>
																	</tmk:MarkEventCategory>
																</xsl:if>
																<xsl:for-each select="ns0:MarkEventResponseDate">
																	<tmk:MarkEventResponseDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:MarkEventResponseDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var363_languageCode" as="node()?" select="@languageCode"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var363_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var363_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
																<xsl:for-each select="ns0:MarkEventDate">
																	<tmk:MarkEventDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</tmk:MarkEventDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:MarkEventDateTime">
																	<tmk:MarkEventDateTime>
																		<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																	</tmk:MarkEventDateTime>
																</xsl:for-each>
															</tmk:MarkEvent>
														</xsl:for-each>
													</tmk:MarkEventBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:TradeMarkDocumentDetails">
													<tmk:TrademarkDocumentBag>
														<xsl:for-each select="ns0:TradeMarkDocument">
															<tmk:TrademarkDocument>
																<xsl:for-each select="ns0:DocumentLanguageCode">
																	<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentName">
																	<com:DocumentName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentName>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentFilename">
																	<com:FileName>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:FileName>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentFileFormat">
																	<com:DocumentFormatCategory>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentFormatCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentDate">
																	<com:DocumentDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:DocumentDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentMedia">
																	<com:DocumentMediaCategory>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentMediaCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentLocation">
																	<com:DocumentLocationURI>
																		<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																	</com:DocumentLocationURI>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentVersion">
																	<com:DocumentVersion>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:DocumentVersion>
																</xsl:for-each>
																<xsl:for-each select="ns0:DocumentSizeInByte">
																	<com:DocumentSizeQuantity>
																		<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																	</com:DocumentSizeQuantity>
																</xsl:for-each>
																<xsl:for-each select="ns0:Comment">
																	<xsl:variable name="var365_languageCode" as="node()?" select="@languageCode"/>
																	<xsl:variable name="var366_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																	<com:CommentText>
																		<xsl:if test="fn:exists($var365_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var365_languageCode)"/>
																		</xsl:if>
																		<xsl:if test="fn:exists($var366_sequenceNumber)">
																			<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var366_sequenceNumber)))"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:CommentText>
																</xsl:for-each>
															</tmk:TrademarkDocument>
														</xsl:for-each>
													</tmk:TrademarkDocumentBag>
												</xsl:for-each>
												<xsl:for-each select="ns0:TradeMarkVersion">
													<com:Version>
														<xsl:for-each select="ns0:Comment">
															<xsl:variable name="var367_languageCode" as="node()?" select="@languageCode"/>
															<com:CommentText>
																<xsl:if test="fn:exists($var367_languageCode)">
																	<xsl:attribute name="com:languageCode" select="fn:string($var367_languageCode)"/>
																</xsl:if>
																<xsl:sequence select="fn:string(.)"/>
															</com:CommentText>
														</xsl:for-each>
														<xsl:for-each select="ns0:VersionNumber">
															<com:VersionNumber>
																<xsl:sequence select="fn:string(.)"/>
															</com:VersionNumber>
														</xsl:for-each>
														<xsl:for-each select="ns0:VersionDate">
															<com:VersionDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:VersionDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:VersionDateTime">
															<com:VersionDateTime>
																<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
															</com:VersionDateTime>
														</xsl:for-each>
													</com:Version>
												</xsl:for-each>
												<xsl:for-each select="ns0:CorrespondenceAddress">
													<com:CorrespondenceAddress>
														<xsl:variable name="var369_resultof_filter" as="node()?">
															<xsl:for-each select="ns0:CorrespondenceAddressParty">
																<xsl:variable name="var368_resultof_vmf___inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf37_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var368_resultof_vmf___inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var369_resultof_filter">
															<com:CorrespondenceAddressPartyCategory>
																<xsl:call-template name="vmf:vmf37_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</com:CorrespondenceAddressPartyCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:CorrespondenceAddressIdentifier">
															<xsl:variable name="var370_identifierKindCode" as="node()?" select="@identifierKindCode"/>
															<com:PartyIdentifier>
																<xsl:if test="fn:exists($var370_identifierKindCode)">
																	<xsl:attribute name="com:officeCode" select="fn:string($var370_identifierKindCode)"/>
																</xsl:if>
																<xsl:sequence select="fn:string(.)"/>
															</com:PartyIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:CorrespondenceAddressBook">
															<xsl:variable name="var371_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																	<xsl:with-param name="AddressBook" as="node()">
																		<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</AddressBookType>
																	</xsl:with-param>
																</xsl:call-template>
															</xsl:variable>
															<xsl:for-each select="$var371_resultof_MappingST__AddressBookToST__Contact">
																<com:Contact>
																	<xsl:sequence select="(./@node(), ./node())"/>
																</com:Contact>
															</xsl:for-each>
														</xsl:for-each>
													</com:CorrespondenceAddress>
												</xsl:for-each>
											</tmk:Trademark>
										</xsl:for-each>
									</tmk:TrademarkBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:ApplicantDetails">
									<tmk:ApplicantBag>
										<xsl:for-each select="ns0:Applicant">
											<tmk:Applicant>
												<xsl:sequence select="()"/>
											</tmk:Applicant>
										</xsl:for-each>
									</tmk:ApplicantBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:RepresentativeDetails">
									<com:RepresentativeBag>
										<xsl:for-each select="ns0:Representative">
											<com:Representative>
												<xsl:sequence select="()"/>
											</com:Representative>
										</xsl:for-each>
									</com:RepresentativeBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:MarkRecordDetails">
									<tmk:MarkRecordBag>
										<xsl:for-each select="ns0:MarkRecord">
											<tmk:MarkRecord>
												<xsl:for-each select="ns0:BasicRecord">
													<tmk:BasicRecord>
														<xsl:for-each select="ns0:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:variable name="var375_resultof_filter" as="node()?">
															<xsl:for-each select="ns0:BasicRecordKind">
																<xsl:variable name="var374_resultof_vmf___inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf30_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var374_resultof_vmf___inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var375_resultof_filter">
															<tmk:BasicRecordCategory>
																<xsl:call-template name="vmf:vmf30_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</tmk:BasicRecordCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:TradeMarkKeyDetails">
															<tmk:TrademarkIdentification>
																<xsl:for-each select="ns0:TradeMarkKey">
																	<tmk:TrademarkIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var376_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<tmk:TrademarkIdentifier>
																				<xsl:if test="fn:exists($var376_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var376_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:TrademarkIdentifier>
																		</xsl:for-each>
																	</tmk:TrademarkIdentifierBag>
																</xsl:for-each>
															</tmk:TrademarkIdentification>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordPublicationDetails">
															<tmk:RecordPublicationBag>
																<xsl:for-each select="ns0:RecordPublication">
																	<tmk:RecordPublication>
																		<com:PublicationIdentifier>
																			<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																		</com:PublicationIdentifier>
																		<xsl:variable name="var378_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:PublicationSection">
																				<xsl:variable name="var377_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf27_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var377_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var378_resultof_filter">
																			<tmk:PublicationSectionCategory>
																				<xsl:call-template name="vmf:vmf27_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:PublicationSectionCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationSubsection">
																			<com:PublicationSubsection>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationSubsection>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationDate">
																			<com:PublicationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PublicationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationPage">
																			<com:PublicationPage>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationPage>
																		</xsl:for-each>
																	</tmk:RecordPublication>
																</xsl:for-each>
															</tmk:RecordPublicationBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:ClaimantDetails">
															<tmk:ClaimantBag>
																<xsl:for-each select="ns0:ClaimantKey">
																	<com:PartyIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var379_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var379_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var379_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																	</com:PartyIdentifierBag>
																</xsl:for-each>
																<xsl:for-each select="ns0:Claimant">
																	<xsl:variable name="var384_operationCode" as="node()?" select="@operationCode"/>
																	<tmk:Claimant>
																		<xsl:if test="fn:exists($var384_operationCode)">
																			<xsl:attribute name="com:operationCategory" select="fn:string($var384_operationCode)"/>
																		</xsl:if>
																		<xsl:for-each select="ns0:ClaimantSequenceNumber">
																			<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantLegalEntity">
																			<com:LegalEntityName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LegalEntityName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantNationalityCode">
																			<com:NationalityCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:NationalityCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																			<com:IncorporationCountryCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationCountryCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationState">
																			<com:IncorporationState>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationState>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var380_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var380_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var380_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantEntitlement">
																			<tmk:Entitlement>
																				<xsl:for-each select="ns0:EntitlementNationalityCode">
																					<com:EntitlementNationalityCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:EntitlementNationalityCode>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementEstablishment">
																					<com:EntitlementEstablishment>
																						<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																							<com:EntitlementEstablishmentCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementEstablishmentCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																							<xsl:variable name="var381_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var381_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</com:EntitlementEstablishment>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementDomiciled">
																					<com:EntitlementDomiciled>
																						<xsl:for-each select="ns0:EntitlementDomiciledCode">
																							<com:EntitlementDomiciledCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementDomiciledCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																							<com:Contact>
																								<xsl:sequence select="()"/>
																							</com:Contact>
																						</xsl:for-each>
																					</com:EntitlementDomiciled>
																				</xsl:for-each>
																			</tmk:Entitlement>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIdentifier">
																			<xsl:variable name="var382_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var382_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var382_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantAddressBook">
																			<xsl:variable name="var383_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																				<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																					<xsl:with-param name="AddressBook" as="node()">
																						<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</AddressBookType>
																					</xsl:with-param>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:for-each select="$var383_resultof_MappingST__AddressBookToST__Contact">
																				<com:Contact>
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</com:Contact>
																			</xsl:for-each>
																		</xsl:for-each>
																	</tmk:Claimant>
																</xsl:for-each>
															</tmk:ClaimantBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RepresentativeDetails">
															<com:RepresentativeBag>
																<xsl:for-each select="ns0:Representative">
																	<xsl:variable name="var385_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																			<xsl:with-param name="Representative" as="node()">
																				<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</RepresentativeType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var385_resultof_MappingST__RepresentativeToST__Representative">
																		<com:Representative>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Representative>
																	</xsl:for-each>
																</xsl:for-each>
															</com:RepresentativeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEventDetails">
															<com:RecordEventBag>
																<xsl:for-each select="ns0:RecordEvent">
																	<com:RecordEvent>
																		<com:RecordEventCategory>
																			<xsl:sequence select="fn:string(ns0:RecordEventCode)"/>
																		</com:RecordEventCategory>
																		<xsl:for-each select="ns0:RecordEventResponseDate">
																			<com:RecordEventResponseDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventResponseDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var386_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var386_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var386_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDate">
																			<com:RecordEventDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDateTime">
																			<com:RecordEventDateTime>
																				<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																			</com:RecordEventDateTime>
																		</xsl:for-each>
																	</com:RecordEvent>
																</xsl:for-each>
															</com:RecordEventBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordDocumentDetails">
															<com:RecordDocumentBag>
																<xsl:for-each select="ns0:RecordDocument">
																	<com:RecordDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var388_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var387_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var387_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var388_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var390_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var389_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var389_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var390_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var391_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var391_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var391_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</com:RecordDocument>
																</xsl:for-each>
															</com:RecordDocumentBag>
														</xsl:for-each>
														<xsl:variable name="var393_resultof_filter" as="node()?">
															<xsl:for-each select="ns0:RecordCurrentStatusCode">
																<xsl:variable name="var392_resultof_vmf___inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf31_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var392_resultof_vmf___inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var393_resultof_filter">
															<com:RecordCurrentStatusCategory>
																<xsl:call-template name="vmf:vmf31_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</com:RecordCurrentStatusCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordCurrentStatusDate">
															<com:RecordCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:FactDecisionText">
															<xsl:variable name="var394_languageCode" as="node()?" select="@languageCode"/>
															<tmk:ReasonDocument>
																<tmk:FactDecisionText>
																	<xsl:if test="fn:exists($var394_languageCode)">
																		<xsl:attribute name="com:languageCode" select="fn:string($var394_languageCode)"/>
																	</xsl:if>
																	<xsl:sequence select="fn:string(.)"/>
																</tmk:FactDecisionText>
															</tmk:ReasonDocument>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordInterestedOfficeCode">
															<com:RecordInterestedOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordInterestedOfficeCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordDesignatedCountryDetails">
															<com:RecordDesignatedCountryCodeBag>
																<xsl:for-each select="ns0:RecordDesignatedCountryCode">
																	<com:RecordDesignatedCountryCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:RecordDesignatedCountryCode>
																</xsl:for-each>
															</com:RecordDesignatedCountryCodeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordUseIntentDetails">
															<tmk:RecordUseIntentBag>
																<xsl:for-each select="ns0:RecordUseIntentCountryCode">
																	<tmk:RecordUseIntentCountryCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:RecordUseIntentCountryCode>
																</xsl:for-each>
															</tmk:RecordUseIntentBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:GoodsServicesLimitationDetails">
															<tmk:GoodsServicesLimitationBag>
																<xsl:for-each select="ns0:GoodsServicesLimitation">
																	<tmk:GoodsServicesLimitation>
																		<xsl:for-each select="ns0:LimitationCountryDetails">
																			<com:LimitationCountryCodeBag>
																				<xsl:for-each select="ns0:LimitationCountryCode">
																					<com:LimitationCountryCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:LimitationCountryCode>
																				</xsl:for-each>
																			</com:LimitationCountryCodeBag>
																		</xsl:for-each>
																		<xsl:variable name="var396_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																				<xsl:variable name="var395_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf32_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var395_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var396_resultof_filter">
																			<tmk:GoodsServicesLimitationCategory>
																				<xsl:call-template name="vmf:vmf32_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:GoodsServicesLimitationCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var397_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var397_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var397_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																			<tmk:LimitationClassDescriptionBag>
																				<xsl:for-each select="ns0:ClassDescription">
																					<tmk:ClassDescription>
																						<xsl:for-each select="ns0:ClassNumber">
																							<tmk:ClassNumber>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:ClassNumber>
																						</xsl:for-each>
																						<xsl:variable name="var399_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:ClassNumberStatusCode">
																								<xsl:variable name="var398_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf18_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var398_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var399_resultof_filter">
																							<tmk:ClassNumberStatusCategory>
																								<xsl:call-template name="vmf:vmf18_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:ClassNumberStatusCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:GoodsServicesDescription">
																							<xsl:variable name="var400_languageCode" as="node()?" select="@languageCode"/>
																							<xsl:variable name="var401_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																							<tmk:GoodsServicesDescriptionText>
																								<xsl:if test="fn:exists($var400_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var400_languageCode)"/>
																								</xsl:if>
																								<xsl:if test="fn:exists($var401_sequenceNumber)">
																									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var401_sequenceNumber)))"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:GoodsServicesDescriptionText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																							<tmk:UseNiceHeadingIndicator>
																								<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																							</tmk:UseNiceHeadingIndicator>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClassificationTermDetails">
																							<tmk:ClassificationTermBag>
																								<xsl:for-each select="ns0:ClassificationTerm">
																									<xsl:variable name="var409_operationCode" as="node()?" select="@operationCode"/>
																									<tmk:ClassificationTerm>
																										<xsl:if test="fn:exists($var409_operationCode)">
																											<xsl:attribute name="com:operationCategory" select="fn:string($var409_operationCode)"/>
																										</xsl:if>
																										<xsl:for-each select="ns0:ClassificationTermIdentifier">
																											<xsl:variable name="var402_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																											<tmk:ClassificationTermIdentifier>
																												<xsl:if test="fn:exists($var402_identifierKindCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var402_identifierKindCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermIdentifier>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermOffice">
																											<tmk:ClassificationTermOfficeCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermOfficeCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																											<tmk:ClassificationTermOfficeIdentification>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermOfficeIdentification>
																										</xsl:for-each>
																										<xsl:variable name="var404_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassificationTermSource">
																												<xsl:variable name="var403_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf19_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var403_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var404_resultof_filter">
																											<tmk:ClassificationTermSourceCategory>
																												<xsl:call-template name="vmf:vmf19_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassificationTermSourceCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermEntryDate">
																											<tmk:ClassificationTermEntryDate>
																												<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																											</tmk:ClassificationTermEntryDate>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassNumber">
																											<tmk:ClassNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassNumber>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermText">
																											<xsl:variable name="var405_languageCode" as="node()?" select="@languageCode"/>
																											<tmk:ClassificationTermText>
																												<xsl:if test="fn:exists($var405_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var405_languageCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																											<tmk:ClassificationTermEquivalentGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermEquivalentGroup>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																											<tmk:ClassificationTermReferenceGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermReferenceGroup>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																											<tmk:ClassificationTermTranslationGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermTranslationGroup>
																										</xsl:for-each>
																										<xsl:variable name="var407_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassificationTermStatus">
																												<xsl:variable name="var406_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf20_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var406_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var407_resultof_filter">
																											<xsl:variable name="var408_officeCode" as="node()?" select="@officeCode"/>
																											<tmk:ClassificationTermStatus>
																												<xsl:if test="fn:exists($var408_officeCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var408_officeCode)"/>
																												</xsl:if>
																												<xsl:call-template name="vmf:vmf20_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassificationTermStatus>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:WIPOBasicNumber">
																											<tmk:WIPOBasicNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:WIPOBasicNumber>
																										</xsl:for-each>
																									</tmk:ClassificationTerm>
																								</xsl:for-each>
																							</tmk:ClassificationTermBag>
																						</xsl:for-each>
																					</tmk:ClassDescription>
																				</xsl:for-each>
																			</tmk:LimitationClassDescriptionBag>
																		</xsl:for-each>
																	</tmk:GoodsServicesLimitation>
																</xsl:for-each>
															</tmk:GoodsServicesLimitationBag>
														</xsl:for-each>
													</tmk:BasicRecord>
												</xsl:for-each>
												<xsl:for-each select="ns0:RecordOppositionPeriod">
													<xsl:variable name="var413_resultof_vmf___inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf33_inputtoresult">
															<xsl:with-param name="input" select="fn:string(ns0:RecordOppositionPeriodKind)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<tmk:RecordOppositionPeriod>
														<xsl:for-each select="ns0:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:if test="fn:exists($var413_resultof_vmf___inputtoresult)">
															<tmk:RecordOppositionPeriodCategory>
																<xsl:sequence select="$var413_resultof_vmf___inputtoresult"/>
															</tmk:RecordOppositionPeriodCategory>
														</xsl:if>
														<xsl:for-each select="ns0:TradeMarkKeyDetails">
															<tmk:TrademarkIdentification>
																<xsl:for-each select="ns0:TradeMarkKey">
																	<tmk:TrademarkIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var410_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<tmk:TrademarkIdentifier>
																				<xsl:if test="fn:exists($var410_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var410_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:TrademarkIdentifier>
																		</xsl:for-each>
																	</tmk:TrademarkIdentifierBag>
																</xsl:for-each>
															</tmk:TrademarkIdentification>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordPublicationDetails">
															<tmk:RecordPublicationBag>
																<xsl:for-each select="ns0:RecordPublication">
																	<tmk:RecordPublication>
																		<com:PublicationIdentifier>
																			<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																		</com:PublicationIdentifier>
																		<xsl:variable name="var412_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:PublicationSection">
																				<xsl:variable name="var411_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf27_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var411_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var412_resultof_filter">
																			<tmk:PublicationSectionCategory>
																				<xsl:call-template name="vmf:vmf27_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:PublicationSectionCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationSubsection">
																			<com:PublicationSubsection>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationSubsection>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationDate">
																			<com:PublicationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PublicationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationPage">
																			<com:PublicationPage>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationPage>
																		</xsl:for-each>
																	</tmk:RecordPublication>
																</xsl:for-each>
															</tmk:RecordPublicationBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordInterestedOfficeCode">
															<com:RecordInterestedOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordInterestedOfficeCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordOppositionPeriodStartDate">
															<tmk:RecordOppositionPeriodStartDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:RecordOppositionPeriodStartDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordOppositionPeriodEndDate">
															<tmk:RecordOppositionPeriodEndDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</tmk:RecordOppositionPeriodEndDate>
														</xsl:for-each>
													</tmk:RecordOppositionPeriod>
												</xsl:for-each>
												<xsl:for-each select="ns0:RecordTransfer">
													<xsl:variable name="var454_resultof_vmf___inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf34_inputtoresult">
															<xsl:with-param name="input" select="fn:string(ns0:RecordTransferKind)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<tmk:RecordTransfer>
														<xsl:for-each select="ns0:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:if test="fn:exists($var454_resultof_vmf___inputtoresult)">
															<com:RecordTransferCategory>
																<xsl:sequence select="$var454_resultof_vmf___inputtoresult"/>
															</com:RecordTransferCategory>
														</xsl:if>
														<xsl:for-each select="ns0:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:TradeMarkKeyDetails">
															<tmk:TrademarkIdentification>
																<xsl:for-each select="ns0:TradeMarkKey">
																	<tmk:TrademarkIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var414_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<tmk:TrademarkIdentifier>
																				<xsl:if test="fn:exists($var414_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var414_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:TrademarkIdentifier>
																		</xsl:for-each>
																	</tmk:TrademarkIdentifierBag>
																</xsl:for-each>
															</tmk:TrademarkIdentification>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordPublicationDetails">
															<tmk:RecordPublicationBag>
																<xsl:for-each select="ns0:RecordPublication">
																	<tmk:RecordPublication>
																		<com:PublicationIdentifier>
																			<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																		</com:PublicationIdentifier>
																		<xsl:variable name="var416_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:PublicationSection">
																				<xsl:variable name="var415_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf27_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var415_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var416_resultof_filter">
																			<tmk:PublicationSectionCategory>
																				<xsl:call-template name="vmf:vmf27_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:PublicationSectionCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationSubsection">
																			<com:PublicationSubsection>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationSubsection>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationDate">
																			<com:PublicationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PublicationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationPage">
																			<com:PublicationPage>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationPage>
																		</xsl:for-each>
																	</tmk:RecordPublication>
																</xsl:for-each>
															</tmk:RecordPublicationBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:ClaimantDetails">
															<tmk:ClaimantBag>
																<xsl:for-each select="ns0:ClaimantKey">
																	<com:PartyIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var417_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var417_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var417_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																	</com:PartyIdentifierBag>
																</xsl:for-each>
																<xsl:for-each select="ns0:Claimant">
																	<xsl:variable name="var422_operationCode" as="node()?" select="@operationCode"/>
																	<tmk:Claimant>
																		<xsl:if test="fn:exists($var422_operationCode)">
																			<xsl:attribute name="com:operationCategory" select="fn:string($var422_operationCode)"/>
																		</xsl:if>
																		<xsl:for-each select="ns0:ClaimantSequenceNumber">
																			<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantLegalEntity">
																			<com:LegalEntityName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LegalEntityName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantNationalityCode">
																			<com:NationalityCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:NationalityCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																			<com:IncorporationCountryCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationCountryCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationState">
																			<com:IncorporationState>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationState>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var418_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var418_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var418_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantEntitlement">
																			<tmk:Entitlement>
																				<xsl:for-each select="ns0:EntitlementNationalityCode">
																					<com:EntitlementNationalityCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:EntitlementNationalityCode>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementEstablishment">
																					<com:EntitlementEstablishment>
																						<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																							<com:EntitlementEstablishmentCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementEstablishmentCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																							<xsl:variable name="var419_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var419_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</com:EntitlementEstablishment>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementDomiciled">
																					<com:EntitlementDomiciled>
																						<xsl:for-each select="ns0:EntitlementDomiciledCode">
																							<com:EntitlementDomiciledCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementDomiciledCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																							<com:Contact>
																								<xsl:sequence select="()"/>
																							</com:Contact>
																						</xsl:for-each>
																					</com:EntitlementDomiciled>
																				</xsl:for-each>
																			</tmk:Entitlement>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIdentifier">
																			<xsl:variable name="var420_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var420_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var420_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantAddressBook">
																			<xsl:variable name="var421_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																				<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																					<xsl:with-param name="AddressBook" as="node()">
																						<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</AddressBookType>
																					</xsl:with-param>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:for-each select="$var421_resultof_MappingST__AddressBookToST__Contact">
																				<com:Contact>
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</com:Contact>
																			</xsl:for-each>
																		</xsl:for-each>
																	</tmk:Claimant>
																</xsl:for-each>
															</tmk:ClaimantBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RepresentativeDetails">
															<com:RepresentativeBag>
																<xsl:for-each select="ns0:Representative">
																	<xsl:variable name="var423_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																			<xsl:with-param name="Representative" as="node()">
																				<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</RepresentativeType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var423_resultof_MappingST__RepresentativeToST__Representative">
																		<com:Representative>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Representative>
																	</xsl:for-each>
																</xsl:for-each>
															</com:RepresentativeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEventDetails">
															<com:RecordEventBag>
																<xsl:for-each select="ns0:RecordEvent">
																	<xsl:variable name="var425_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf35_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<com:RecordEvent>
																		<xsl:if test="fn:exists($var425_resultof_vmf___inputtoresult)">
																			<com:RecordEventCategory>
																				<xsl:sequence select="$var425_resultof_vmf___inputtoresult"/>
																			</com:RecordEventCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordEventResponseDate">
																			<com:RecordEventResponseDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventResponseDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var424_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var424_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var424_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDate">
																			<com:RecordEventDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDateTime">
																			<com:RecordEventDateTime>
																				<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																			</com:RecordEventDateTime>
																		</xsl:for-each>
																	</com:RecordEvent>
																</xsl:for-each>
															</com:RecordEventBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordDocumentDetails">
															<com:RecordDocumentBag>
																<xsl:for-each select="ns0:RecordDocument">
																	<com:RecordDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var427_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var426_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var426_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var427_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var429_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var428_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var428_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var429_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var430_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var430_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var430_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</com:RecordDocument>
																</xsl:for-each>
															</com:RecordDocumentBag>
														</xsl:for-each>
														<xsl:variable name="var432_resultof_filter" as="node()?">
															<xsl:for-each select="ns0:RecordCurrentStatusCode">
																<xsl:variable name="var431_resultof_vmf___inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf36_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var431_resultof_vmf___inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var432_resultof_filter">
															<com:RecordCurrentStatusCategory>
																<xsl:call-template name="vmf:vmf36_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</com:RecordCurrentStatusCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordCurrentStatusDate">
															<com:RecordCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:CorrespondenceAddress">
															<com:CorrespondenceAddress>
																<xsl:variable name="var434_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:CorrespondenceAddressParty">
																		<xsl:variable name="var433_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf37_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var433_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var434_resultof_filter">
																	<com:CorrespondenceAddressPartyCategory>
																		<xsl:call-template name="vmf:vmf37_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</com:CorrespondenceAddressPartyCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:CorrespondenceAddressIdentifier">
																	<xsl:variable name="var435_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																	<com:PartyIdentifier>
																		<xsl:if test="fn:exists($var435_identifierKindCode)">
																			<xsl:attribute name="com:officeCode" select="fn:string($var435_identifierKindCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PartyIdentifier>
																</xsl:for-each>
																<xsl:for-each select="ns0:CorrespondenceAddressBook">
																	<xsl:variable name="var436_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																			<xsl:with-param name="AddressBook" as="node()">
																				<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</AddressBookType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var436_resultof_MappingST__AddressBookToST__Contact">
																		<com:Contact>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Contact>
																	</xsl:for-each>
																</xsl:for-each>
															</com:CorrespondenceAddress>
														</xsl:for-each>
														<xsl:for-each select="ns0:HolderDetails">
															<tmk:HolderChangeBag>
																<xsl:for-each select="ns0:PreviousHolder">
																	<xsl:variable name="var437_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																			<xsl:with-param name="Applicant" as="node()">
																				<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</ApplicantType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var437_resultof_MappingST__ApplicantToST__Applicant">
																		<tmk:PreviousHolderBag>
																			<xsl:sequence select="()"/>
																		</tmk:PreviousHolderBag>
																	</xsl:for-each>
																</xsl:for-each>
																<xsl:for-each select="ns0:NewHolder">
																	<xsl:variable name="var438_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																			<xsl:with-param name="Applicant" as="node()">
																				<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</ApplicantType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var438_resultof_MappingST__ApplicantToST__Applicant">
																		<tmk:HolderBag>
																			<xsl:sequence select="()"/>
																		</tmk:HolderBag>
																	</xsl:for-each>
																</xsl:for-each>
															</tmk:HolderChangeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:GoodsServicesLimitationDetails">
															<tmk:GoodsServicesLimitationBag>
																<xsl:for-each select="ns0:GoodsServicesLimitation">
																	<tmk:GoodsServicesLimitation>
																		<xsl:for-each select="ns0:LimitationCountryDetails">
																			<com:LimitationCountryCodeBag>
																				<xsl:for-each select="ns0:LimitationCountryCode">
																					<com:LimitationCountryCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:LimitationCountryCode>
																				</xsl:for-each>
																			</com:LimitationCountryCodeBag>
																		</xsl:for-each>
																		<xsl:variable name="var440_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																				<xsl:variable name="var439_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf32_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var439_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var440_resultof_filter">
																			<tmk:GoodsServicesLimitationCategory>
																				<xsl:call-template name="vmf:vmf32_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:GoodsServicesLimitationCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var441_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var441_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var441_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																			<tmk:LimitationClassDescriptionBag>
																				<xsl:for-each select="ns0:ClassDescription">
																					<tmk:ClassDescription>
																						<xsl:for-each select="ns0:ClassNumber">
																							<tmk:ClassNumber>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:ClassNumber>
																						</xsl:for-each>
																						<xsl:variable name="var443_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:ClassNumberStatusCode">
																								<xsl:variable name="var442_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf18_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var442_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var443_resultof_filter">
																							<tmk:ClassNumberStatusCategory>
																								<xsl:call-template name="vmf:vmf18_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:ClassNumberStatusCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:GoodsServicesDescription">
																							<xsl:variable name="var444_languageCode" as="node()?" select="@languageCode"/>
																							<xsl:variable name="var445_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																							<tmk:GoodsServicesDescriptionText>
																								<xsl:if test="fn:exists($var444_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var444_languageCode)"/>
																								</xsl:if>
																								<xsl:if test="fn:exists($var445_sequenceNumber)">
																									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var445_sequenceNumber)))"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:GoodsServicesDescriptionText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																							<tmk:UseNiceHeadingIndicator>
																								<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																							</tmk:UseNiceHeadingIndicator>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClassificationTermDetails">
																							<tmk:ClassificationTermBag>
																								<xsl:for-each select="ns0:ClassificationTerm">
																									<xsl:variable name="var453_operationCode" as="node()?" select="@operationCode"/>
																									<tmk:ClassificationTerm>
																										<xsl:if test="fn:exists($var453_operationCode)">
																											<xsl:attribute name="com:operationCategory" select="fn:string($var453_operationCode)"/>
																										</xsl:if>
																										<xsl:for-each select="ns0:ClassificationTermIdentifier">
																											<xsl:variable name="var446_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																											<tmk:ClassificationTermIdentifier>
																												<xsl:if test="fn:exists($var446_identifierKindCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var446_identifierKindCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermIdentifier>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermOffice">
																											<tmk:ClassificationTermOfficeCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermOfficeCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																											<tmk:ClassificationTermOfficeIdentification>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermOfficeIdentification>
																										</xsl:for-each>
																										<xsl:variable name="var448_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassificationTermSource">
																												<xsl:variable name="var447_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf19_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var447_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var448_resultof_filter">
																											<tmk:ClassificationTermSourceCategory>
																												<xsl:call-template name="vmf:vmf19_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassificationTermSourceCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermEntryDate">
																											<tmk:ClassificationTermEntryDate>
																												<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																											</tmk:ClassificationTermEntryDate>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassNumber">
																											<tmk:ClassNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassNumber>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermText">
																											<xsl:variable name="var449_languageCode" as="node()?" select="@languageCode"/>
																											<tmk:ClassificationTermText>
																												<xsl:if test="fn:exists($var449_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var449_languageCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																											<tmk:ClassificationTermEquivalentGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermEquivalentGroup>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																											<tmk:ClassificationTermReferenceGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermReferenceGroup>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																											<tmk:ClassificationTermTranslationGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermTranslationGroup>
																										</xsl:for-each>
																										<xsl:variable name="var451_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassificationTermStatus">
																												<xsl:variable name="var450_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf20_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var450_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var451_resultof_filter">
																											<xsl:variable name="var452_officeCode" as="node()?" select="@officeCode"/>
																											<tmk:ClassificationTermStatus>
																												<xsl:if test="fn:exists($var452_officeCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var452_officeCode)"/>
																												</xsl:if>
																												<xsl:call-template name="vmf:vmf20_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassificationTermStatus>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:WIPOBasicNumber">
																											<tmk:WIPOBasicNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:WIPOBasicNumber>
																										</xsl:for-each>
																									</tmk:ClassificationTerm>
																								</xsl:for-each>
																							</tmk:ClassificationTermBag>
																						</xsl:for-each>
																					</tmk:ClassDescription>
																				</xsl:for-each>
																			</tmk:LimitationClassDescriptionBag>
																		</xsl:for-each>
																	</tmk:GoodsServicesLimitation>
																</xsl:for-each>
															</tmk:GoodsServicesLimitationBag>
														</xsl:for-each>
													</tmk:RecordTransfer>
												</xsl:for-each>
												<xsl:for-each select="ns0:RecordChangeNameAddress">
													<xsl:variable name="var480_resultof_vmf___inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf38_inputtoresult">
															<xsl:with-param name="input" select="fn:string(ns0:RecordChangeNameAddressKind)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<tmk:RecordChangeNameAddress>
														<xsl:for-each select="ns0:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:if test="fn:exists($var480_resultof_vmf___inputtoresult)">
															<com:RecordChangeNameAddressCategory>
																<xsl:sequence select="$var480_resultof_vmf___inputtoresult"/>
															</com:RecordChangeNameAddressCategory>
														</xsl:if>
														<xsl:for-each select="ns0:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:TradeMarkKeyDetails">
															<tmk:TrademarkIdentification>
																<xsl:for-each select="ns0:TradeMarkKey">
																	<tmk:TrademarkIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var455_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<tmk:TrademarkIdentifier>
																				<xsl:if test="fn:exists($var455_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var455_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:TrademarkIdentifier>
																		</xsl:for-each>
																	</tmk:TrademarkIdentifierBag>
																</xsl:for-each>
															</tmk:TrademarkIdentification>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordPublicationDetails">
															<tmk:RecordPublicationBag>
																<xsl:for-each select="ns0:RecordPublication">
																	<tmk:RecordPublication>
																		<com:PublicationIdentifier>
																			<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																		</com:PublicationIdentifier>
																		<xsl:variable name="var457_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:PublicationSection">
																				<xsl:variable name="var456_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf27_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var456_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var457_resultof_filter">
																			<tmk:PublicationSectionCategory>
																				<xsl:call-template name="vmf:vmf27_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:PublicationSectionCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationSubsection">
																			<com:PublicationSubsection>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationSubsection>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationDate">
																			<com:PublicationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PublicationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationPage">
																			<com:PublicationPage>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationPage>
																		</xsl:for-each>
																	</tmk:RecordPublication>
																</xsl:for-each>
															</tmk:RecordPublicationBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:ClaimantDetails">
															<tmk:ClaimantBag>
																<xsl:for-each select="ns0:ClaimantKey">
																	<com:PartyIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var458_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var458_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var458_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																	</com:PartyIdentifierBag>
																</xsl:for-each>
																<xsl:for-each select="ns0:Claimant">
																	<xsl:variable name="var463_operationCode" as="node()?" select="@operationCode"/>
																	<tmk:Claimant>
																		<xsl:if test="fn:exists($var463_operationCode)">
																			<xsl:attribute name="com:operationCategory" select="fn:string($var463_operationCode)"/>
																		</xsl:if>
																		<xsl:for-each select="ns0:ClaimantSequenceNumber">
																			<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantLegalEntity">
																			<com:LegalEntityName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LegalEntityName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantNationalityCode">
																			<com:NationalityCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:NationalityCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																			<com:IncorporationCountryCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationCountryCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationState">
																			<com:IncorporationState>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationState>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var459_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var459_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var459_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantEntitlement">
																			<tmk:Entitlement>
																				<xsl:for-each select="ns0:EntitlementNationalityCode">
																					<com:EntitlementNationalityCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:EntitlementNationalityCode>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementEstablishment">
																					<com:EntitlementEstablishment>
																						<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																							<com:EntitlementEstablishmentCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementEstablishmentCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																							<xsl:variable name="var460_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var460_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</com:EntitlementEstablishment>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementDomiciled">
																					<com:EntitlementDomiciled>
																						<xsl:for-each select="ns0:EntitlementDomiciledCode">
																							<com:EntitlementDomiciledCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementDomiciledCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																							<com:Contact>
																								<xsl:sequence select="()"/>
																							</com:Contact>
																						</xsl:for-each>
																					</com:EntitlementDomiciled>
																				</xsl:for-each>
																			</tmk:Entitlement>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIdentifier">
																			<xsl:variable name="var461_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var461_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var461_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantAddressBook">
																			<xsl:variable name="var462_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																				<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																					<xsl:with-param name="AddressBook" as="node()">
																						<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</AddressBookType>
																					</xsl:with-param>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:for-each select="$var462_resultof_MappingST__AddressBookToST__Contact">
																				<com:Contact>
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</com:Contact>
																			</xsl:for-each>
																		</xsl:for-each>
																	</tmk:Claimant>
																</xsl:for-each>
															</tmk:ClaimantBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RepresentativeDetails">
															<com:RepresentativeBag>
																<xsl:for-each select="ns0:Representative">
																	<xsl:variable name="var464_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																			<xsl:with-param name="Representative" as="node()">
																				<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</RepresentativeType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var464_resultof_MappingST__RepresentativeToST__Representative">
																		<com:Representative>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Representative>
																	</xsl:for-each>
																</xsl:for-each>
															</com:RepresentativeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEventDetails">
															<com:RecordEventBag>
																<xsl:for-each select="ns0:RecordEvent">
																	<xsl:variable name="var466_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf35_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<com:RecordEvent>
																		<xsl:if test="fn:exists($var466_resultof_vmf___inputtoresult)">
																			<com:RecordEventCategory>
																				<xsl:sequence select="$var466_resultof_vmf___inputtoresult"/>
																			</com:RecordEventCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordEventResponseDate">
																			<com:RecordEventResponseDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventResponseDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var465_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var465_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var465_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDate">
																			<com:RecordEventDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDateTime">
																			<com:RecordEventDateTime>
																				<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																			</com:RecordEventDateTime>
																		</xsl:for-each>
																	</com:RecordEvent>
																</xsl:for-each>
															</com:RecordEventBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordDocumentDetails">
															<com:RecordDocumentBag>
																<xsl:for-each select="ns0:RecordDocument">
																	<com:RecordDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var468_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var467_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var467_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var468_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var470_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var469_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var469_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var470_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var471_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var471_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var471_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</com:RecordDocument>
																</xsl:for-each>
															</com:RecordDocumentBag>
														</xsl:for-each>
														<xsl:variable name="var473_resultof_filter" as="node()?">
															<xsl:for-each select="ns0:RecordCurrentStatusCode">
																<xsl:variable name="var472_resultof_vmf___inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf39_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var472_resultof_vmf___inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var473_resultof_filter">
															<com:RecordCurrentStatusCategory>
																<xsl:call-template name="vmf:vmf39_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</com:RecordCurrentStatusCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordCurrentStatusDate">
															<com:RecordCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:CorrespondenceAddress">
															<com:CorrespondenceAddress>
																<xsl:variable name="var475_resultof_filter" as="node()?">
																	<xsl:for-each select="ns0:CorrespondenceAddressParty">
																		<xsl:variable name="var474_resultof_vmf___inputtoresult" as="xs:string?">
																			<xsl:call-template name="vmf:vmf37_inputtoresult">
																				<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																			</xsl:call-template>
																		</xsl:variable>
																		<xsl:if test="fn:exists($var474_resultof_vmf___inputtoresult)">
																			<xsl:sequence select="."/>
																		</xsl:if>
																	</xsl:for-each>
																</xsl:variable>
																<xsl:for-each select="$var475_resultof_filter">
																	<com:CorrespondenceAddressPartyCategory>
																		<xsl:call-template name="vmf:vmf37_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																		</xsl:call-template>
																	</com:CorrespondenceAddressPartyCategory>
																</xsl:for-each>
																<xsl:for-each select="ns0:CorrespondenceAddressIdentifier">
																	<xsl:variable name="var476_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																	<com:PartyIdentifier>
																		<xsl:if test="fn:exists($var476_identifierKindCode)">
																			<xsl:attribute name="com:officeCode" select="fn:string($var476_identifierKindCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:PartyIdentifier>
																</xsl:for-each>
																<xsl:for-each select="ns0:CorrespondenceAddressBook">
																	<xsl:variable name="var477_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																			<xsl:with-param name="AddressBook" as="node()">
																				<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</AddressBookType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var477_resultof_MappingST__AddressBookToST__Contact">
																		<com:Contact>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Contact>
																	</xsl:for-each>
																</xsl:for-each>
															</com:CorrespondenceAddress>
														</xsl:for-each>
														<xsl:for-each select="ns0:HolderDetails">
															<tmk:HolderChangeBag>
																<xsl:for-each select="ns0:PreviousHolder">
																	<xsl:variable name="var478_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																			<xsl:with-param name="Applicant" as="node()">
																				<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</ApplicantType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var478_resultof_MappingST__ApplicantToST__Applicant">
																		<tmk:PreviousHolderBag>
																			<xsl:sequence select="()"/>
																		</tmk:PreviousHolderBag>
																	</xsl:for-each>
																</xsl:for-each>
																<xsl:for-each select="ns0:NewHolder">
																	<xsl:variable name="var479_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																			<xsl:with-param name="Applicant" as="node()">
																				<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</ApplicantType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var479_resultof_MappingST__ApplicantToST__Applicant">
																		<tmk:HolderBag>
																			<xsl:sequence select="()"/>
																		</tmk:HolderBag>
																	</xsl:for-each>
																</xsl:for-each>
															</tmk:HolderChangeBag>
														</xsl:for-each>
													</tmk:RecordChangeNameAddress>
												</xsl:for-each>
												<xsl:for-each select="ns0:RecordLicence">
													<xsl:variable name="var535_resultof_vmf___inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf40_inputtoresult">
															<xsl:with-param name="input" select="fn:string(ns0:RecordLicenceKind)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<tmk:RecordLicence>
														<xsl:for-each select="ns0:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:if test="fn:exists($var535_resultof_vmf___inputtoresult)">
															<com:RecordLicenceCategory>
																<xsl:sequence select="$var535_resultof_vmf___inputtoresult"/>
															</com:RecordLicenceCategory>
														</xsl:if>
														<xsl:for-each select="ns0:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:TradeMarkKeyDetails">
															<tmk:TrademarkIdentification>
																<xsl:for-each select="ns0:TradeMarkKey">
																	<tmk:TrademarkIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var481_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<tmk:TrademarkIdentifier>
																				<xsl:if test="fn:exists($var481_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var481_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:TrademarkIdentifier>
																		</xsl:for-each>
																	</tmk:TrademarkIdentifierBag>
																</xsl:for-each>
															</tmk:TrademarkIdentification>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordPublicationDetails">
															<tmk:RecordPublicationBag>
																<xsl:for-each select="ns0:RecordPublication">
																	<tmk:RecordPublication>
																		<com:PublicationIdentifier>
																			<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																		</com:PublicationIdentifier>
																		<xsl:variable name="var483_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:PublicationSection">
																				<xsl:variable name="var482_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf27_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var482_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var483_resultof_filter">
																			<tmk:PublicationSectionCategory>
																				<xsl:call-template name="vmf:vmf27_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:PublicationSectionCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationSubsection">
																			<com:PublicationSubsection>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationSubsection>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationDate">
																			<com:PublicationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PublicationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationPage">
																			<com:PublicationPage>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationPage>
																		</xsl:for-each>
																	</tmk:RecordPublication>
																</xsl:for-each>
															</tmk:RecordPublicationBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:ClaimantDetails">
															<tmk:ClaimantBag>
																<xsl:for-each select="ns0:ClaimantKey">
																	<com:PartyIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var484_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var484_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var484_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																	</com:PartyIdentifierBag>
																</xsl:for-each>
																<xsl:for-each select="ns0:Claimant">
																	<xsl:variable name="var489_operationCode" as="node()?" select="@operationCode"/>
																	<tmk:Claimant>
																		<xsl:if test="fn:exists($var489_operationCode)">
																			<xsl:attribute name="com:operationCategory" select="fn:string($var489_operationCode)"/>
																		</xsl:if>
																		<xsl:for-each select="ns0:ClaimantSequenceNumber">
																			<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantLegalEntity">
																			<com:LegalEntityName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LegalEntityName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantNationalityCode">
																			<com:NationalityCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:NationalityCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																			<com:IncorporationCountryCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationCountryCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationState">
																			<com:IncorporationState>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationState>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var485_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var485_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var485_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantEntitlement">
																			<tmk:Entitlement>
																				<xsl:for-each select="ns0:EntitlementNationalityCode">
																					<com:EntitlementNationalityCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:EntitlementNationalityCode>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementEstablishment">
																					<com:EntitlementEstablishment>
																						<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																							<com:EntitlementEstablishmentCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementEstablishmentCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																							<xsl:variable name="var486_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var486_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</com:EntitlementEstablishment>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementDomiciled">
																					<com:EntitlementDomiciled>
																						<xsl:for-each select="ns0:EntitlementDomiciledCode">
																							<com:EntitlementDomiciledCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementDomiciledCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																							<com:Contact>
																								<xsl:sequence select="()"/>
																							</com:Contact>
																						</xsl:for-each>
																					</com:EntitlementDomiciled>
																				</xsl:for-each>
																			</tmk:Entitlement>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIdentifier">
																			<xsl:variable name="var487_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var487_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var487_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantAddressBook">
																			<xsl:variable name="var488_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																				<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																					<xsl:with-param name="AddressBook" as="node()">
																						<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</AddressBookType>
																					</xsl:with-param>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:for-each select="$var488_resultof_MappingST__AddressBookToST__Contact">
																				<com:Contact>
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</com:Contact>
																			</xsl:for-each>
																		</xsl:for-each>
																	</tmk:Claimant>
																</xsl:for-each>
															</tmk:ClaimantBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RepresentativeDetails">
															<com:RepresentativeBag>
																<xsl:for-each select="ns0:Representative">
																	<xsl:variable name="var490_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																			<xsl:with-param name="Representative" as="node()">
																				<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</RepresentativeType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var490_resultof_MappingST__RepresentativeToST__Representative">
																		<com:Representative>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Representative>
																	</xsl:for-each>
																</xsl:for-each>
															</com:RepresentativeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEventDetails">
															<com:RecordEventBag>
																<xsl:for-each select="ns0:RecordEvent">
																	<xsl:variable name="var492_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf35_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<com:RecordEvent>
																		<xsl:if test="fn:exists($var492_resultof_vmf___inputtoresult)">
																			<com:RecordEventCategory>
																				<xsl:sequence select="$var492_resultof_vmf___inputtoresult"/>
																			</com:RecordEventCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordEventResponseDate">
																			<com:RecordEventResponseDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventResponseDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var491_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var491_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var491_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDate">
																			<com:RecordEventDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDateTime">
																			<com:RecordEventDateTime>
																				<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																			</com:RecordEventDateTime>
																		</xsl:for-each>
																	</com:RecordEvent>
																</xsl:for-each>
															</com:RecordEventBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordDocumentDetails">
															<com:RecordDocumentBag>
																<xsl:for-each select="ns0:RecordDocument">
																	<com:RecordDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var494_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var493_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var493_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var494_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var496_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var495_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var495_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var496_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var497_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var497_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var497_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</com:RecordDocument>
																</xsl:for-each>
															</com:RecordDocumentBag>
														</xsl:for-each>
														<xsl:variable name="var499_resultof_filter" as="node()?">
															<xsl:for-each select="ns0:RecordCurrentStatusCode">
																<xsl:variable name="var498_resultof_vmf___inputtoresult" as="xs:string?">
																	<xsl:call-template name="vmf:vmf41_inputtoresult">
																		<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																	</xsl:call-template>
																</xsl:variable>
																<xsl:if test="fn:exists($var498_resultof_vmf___inputtoresult)">
																	<xsl:sequence select="."/>
																</xsl:if>
															</xsl:for-each>
														</xsl:variable>
														<xsl:for-each select="$var499_resultof_filter">
															<com:RecordCurrentStatusCategory>
																<xsl:call-template name="vmf:vmf41_inputtoresult">
																	<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																</xsl:call-template>
															</com:RecordCurrentStatusCategory>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordCurrentStatusDate">
															<com:RecordCurrentStatusDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordCurrentStatusDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordInterestedOfficeCode">
															<com:RecordInterestedOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordInterestedOfficeCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordDesignatedCountryDetails">
															<com:RecordDesignatedCountryCodeBag>
																<xsl:for-each select="ns0:RecordDesignatedCountryCode">
																	<com:RecordDesignatedCountryCode>
																		<xsl:sequence select="fn:string(.)"/>
																	</com:RecordDesignatedCountryCode>
																</xsl:for-each>
															</com:RecordDesignatedCountryCodeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:LicenceDetails">
															<tmk:LicenceBag>
																<xsl:for-each select="ns0:Licence">
																	<tmk:Licence>
																		<xsl:for-each select="ns0:LicenceIdentifier">
																			<com:LicenceIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LicenceIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LicenceDate">
																			<com:LicenceDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:LicenceDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LicenceNumber">
																			<com:LicenceNumber>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LicenceNumber>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LicenceReference">
																			<com:LicenceReference>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LicenceReference>
																		</xsl:for-each>
																		<xsl:variable name="var501_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:LicenceKind">
																				<xsl:variable name="var500_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf42_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var500_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var501_resultof_filter">
																			<com:LicenceCategory>
																				<xsl:call-template name="vmf:vmf42_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:LicenceCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:SubLicenceIndicator">
																			<com:SublicenceIndicator>
																				<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																			</com:SublicenceIndicator>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RelatedLicenceIdentifier">
																			<com:RelatedLicenceIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:RelatedLicenceIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:GoodsServicesLimitationIndicator">
																			<tmk:GoodsServicesLimitationIndicator>
																				<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																			</tmk:GoodsServicesLimitationIndicator>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:GoodsServicesLimitation">
																			<tmk:GoodsServicesLimitation>
																				<xsl:for-each select="ns0:LimitationCountryDetails">
																					<com:LimitationCountryCodeBag>
																						<xsl:for-each select="ns0:LimitationCountryCode">
																							<com:LimitationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LimitationCountryCode>
																						</xsl:for-each>
																					</com:LimitationCountryCodeBag>
																				</xsl:for-each>
																				<xsl:variable name="var503_resultof_filter" as="node()?">
																					<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																						<xsl:variable name="var502_resultof_vmf___inputtoresult" as="xs:string?">
																							<xsl:call-template name="vmf:vmf32_inputtoresult">
																								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																							</xsl:call-template>
																						</xsl:variable>
																						<xsl:if test="fn:exists($var502_resultof_vmf___inputtoresult)">
																							<xsl:sequence select="."/>
																						</xsl:if>
																					</xsl:for-each>
																				</xsl:variable>
																				<xsl:for-each select="$var503_resultof_filter">
																					<tmk:GoodsServicesLimitationCategory>
																						<xsl:call-template name="vmf:vmf32_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																						</xsl:call-template>
																					</tmk:GoodsServicesLimitationCategory>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:Comment">
																					<xsl:variable name="var504_languageCode" as="node()?" select="@languageCode"/>
																					<com:CommentText>
																						<xsl:if test="fn:exists($var504_languageCode)">
																							<xsl:attribute name="com:languageCode" select="fn:string($var504_languageCode)"/>
																						</xsl:if>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:CommentText>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																					<tmk:LimitationClassDescriptionBag>
																						<xsl:for-each select="ns0:ClassDescription">
																							<tmk:ClassDescription>
																								<xsl:for-each select="ns0:ClassNumber">
																									<tmk:ClassNumber>
																										<xsl:sequence select="fn:string(.)"/>
																									</tmk:ClassNumber>
																								</xsl:for-each>
																								<xsl:variable name="var506_resultof_filter" as="node()?">
																									<xsl:for-each select="ns0:ClassNumberStatusCode">
																										<xsl:variable name="var505_resultof_vmf___inputtoresult" as="xs:string?">
																											<xsl:call-template name="vmf:vmf18_inputtoresult">
																												<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																											</xsl:call-template>
																										</xsl:variable>
																										<xsl:if test="fn:exists($var505_resultof_vmf___inputtoresult)">
																											<xsl:sequence select="."/>
																										</xsl:if>
																									</xsl:for-each>
																								</xsl:variable>
																								<xsl:for-each select="$var506_resultof_filter">
																									<tmk:ClassNumberStatusCategory>
																										<xsl:call-template name="vmf:vmf18_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																										</xsl:call-template>
																									</tmk:ClassNumberStatusCategory>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:GoodsServicesDescription">
																									<xsl:variable name="var507_languageCode" as="node()?" select="@languageCode"/>
																									<xsl:variable name="var508_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																									<tmk:GoodsServicesDescriptionText>
																										<xsl:if test="fn:exists($var507_languageCode)">
																											<xsl:attribute name="com:languageCode" select="fn:string($var507_languageCode)"/>
																										</xsl:if>
																										<xsl:if test="fn:exists($var508_sequenceNumber)">
																											<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var508_sequenceNumber)))"/>
																										</xsl:if>
																										<xsl:sequence select="fn:string(.)"/>
																									</tmk:GoodsServicesDescriptionText>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																									<tmk:UseNiceHeadingIndicator>
																										<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																									</tmk:UseNiceHeadingIndicator>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:ClassificationTermDetails">
																									<tmk:ClassificationTermBag>
																										<xsl:for-each select="ns0:ClassificationTerm">
																											<xsl:variable name="var516_operationCode" as="node()?" select="@operationCode"/>
																											<tmk:ClassificationTerm>
																												<xsl:if test="fn:exists($var516_operationCode)">
																													<xsl:attribute name="com:operationCategory" select="fn:string($var516_operationCode)"/>
																												</xsl:if>
																												<xsl:for-each select="ns0:ClassificationTermIdentifier">
																													<xsl:variable name="var509_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																													<tmk:ClassificationTermIdentifier>
																														<xsl:if test="fn:exists($var509_identifierKindCode)">
																															<xsl:attribute name="com:officeCode" select="fn:string($var509_identifierKindCode)"/>
																														</xsl:if>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermIdentifier>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermOffice">
																													<tmk:ClassificationTermOfficeCode>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermOfficeCode>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																													<tmk:ClassificationTermOfficeIdentification>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermOfficeIdentification>
																												</xsl:for-each>
																												<xsl:variable name="var511_resultof_filter" as="node()?">
																													<xsl:for-each select="ns0:ClassificationTermSource">
																														<xsl:variable name="var510_resultof_vmf___inputtoresult" as="xs:string?">
																															<xsl:call-template name="vmf:vmf19_inputtoresult">
																																<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																															</xsl:call-template>
																														</xsl:variable>
																														<xsl:if test="fn:exists($var510_resultof_vmf___inputtoresult)">
																															<xsl:sequence select="."/>
																														</xsl:if>
																													</xsl:for-each>
																												</xsl:variable>
																												<xsl:for-each select="$var511_resultof_filter">
																													<tmk:ClassificationTermSourceCategory>
																														<xsl:call-template name="vmf:vmf19_inputtoresult">
																															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																														</xsl:call-template>
																													</tmk:ClassificationTermSourceCategory>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermEntryDate">
																													<tmk:ClassificationTermEntryDate>
																														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																													</tmk:ClassificationTermEntryDate>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassNumber">
																													<tmk:ClassNumber>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassNumber>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermText">
																													<xsl:variable name="var512_languageCode" as="node()?" select="@languageCode"/>
																													<tmk:ClassificationTermText>
																														<xsl:if test="fn:exists($var512_languageCode)">
																															<xsl:attribute name="com:languageCode" select="fn:string($var512_languageCode)"/>
																														</xsl:if>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermText>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																													<tmk:ClassificationTermEquivalentGroup>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermEquivalentGroup>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																													<tmk:ClassificationTermReferenceGroup>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermReferenceGroup>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																													<tmk:ClassificationTermTranslationGroup>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermTranslationGroup>
																												</xsl:for-each>
																												<xsl:variable name="var514_resultof_filter" as="node()?">
																													<xsl:for-each select="ns0:ClassificationTermStatus">
																														<xsl:variable name="var513_resultof_vmf___inputtoresult" as="xs:string?">
																															<xsl:call-template name="vmf:vmf20_inputtoresult">
																																<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																															</xsl:call-template>
																														</xsl:variable>
																														<xsl:if test="fn:exists($var513_resultof_vmf___inputtoresult)">
																															<xsl:sequence select="."/>
																														</xsl:if>
																													</xsl:for-each>
																												</xsl:variable>
																												<xsl:for-each select="$var514_resultof_filter">
																													<xsl:variable name="var515_officeCode" as="node()?" select="@officeCode"/>
																													<tmk:ClassificationTermStatus>
																														<xsl:if test="fn:exists($var515_officeCode)">
																															<xsl:attribute name="com:officeCode" select="fn:string($var515_officeCode)"/>
																														</xsl:if>
																														<xsl:call-template name="vmf:vmf20_inputtoresult">
																															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																														</xsl:call-template>
																													</tmk:ClassificationTermStatus>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:WIPOBasicNumber">
																													<tmk:WIPOBasicNumber>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:WIPOBasicNumber>
																												</xsl:for-each>
																											</tmk:ClassificationTerm>
																										</xsl:for-each>
																									</tmk:ClassificationTermBag>
																								</xsl:for-each>
																							</tmk:ClassDescription>
																						</xsl:for-each>
																					</tmk:LimitationClassDescriptionBag>
																				</xsl:for-each>
																			</tmk:GoodsServicesLimitation>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:TerritoryLimitationIndicator">
																			<com:TerritoryLimitationIndicator>
																				<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																			</com:TerritoryLimitationIndicator>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:TerritoryLimitationText">
																			<xsl:variable name="var517_languageCode" as="node()?" select="@languageCode"/>
																			<com:TerritoryLimitationText>
																				<xsl:if test="fn:exists($var517_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var517_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:TerritoryLimitationText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PeriodLimitationIndicator">
																			<com:PeriodLimitationIndicator>
																				<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																			</com:PeriodLimitationIndicator>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PeriodLimitationText">
																			<xsl:variable name="var518_languageCode" as="node()?" select="@languageCode"/>
																			<com:PeriodLimitationText>
																				<xsl:if test="fn:exists($var518_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var518_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PeriodLimitationText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PeriodLimitationStartDate">
																			<com:PeriodLimitationStartDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PeriodLimitationStartDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PeriodLimitationEndDate">
																			<com:PeriodLimitationEndDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PeriodLimitationEndDate>
																		</xsl:for-each>
																		<xsl:variable name="var520_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:LicenceStatusCode">
																				<xsl:variable name="var519_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf43_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var519_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var520_resultof_filter">
																			<com:LicenceStatusCategory>
																				<xsl:call-template name="vmf:vmf43_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:LicenceStatusCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LicenseeDetails">
																			<tmk:LicenseeBag>
																				<xsl:for-each select="ns0:Licensee">
																					<xsl:variable name="var526_operationCode" as="node()?" select="@operationCode"/>
																					<tmk:Licensee>
																						<xsl:if test="fn:exists($var526_operationCode)">
																							<xsl:attribute name="com:operationCategory" select="fn:string($var526_operationCode)"/>
																						</xsl:if>
																						<xsl:for-each select="ns0:LicenseeSequenceNumber">
																							<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenseeLegalEntity">
																							<com:LegalEntityName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LegalEntityName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenseeNationalityCode">
																							<com:NationalityCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:NationalityCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenseeIncorporationCountryCode">
																							<com:IncorporationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationCountryCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenseeIncorporationState">
																							<com:IncorporationState>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:IncorporationState>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var521_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var521_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var521_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenseeEntitlement">
																							<tmk:Entitlement>
																								<xsl:for-each select="ns0:EntitlementNationalityCode">
																									<com:EntitlementNationalityCode>
																										<xsl:sequence select="fn:string(.)"/>
																									</com:EntitlementNationalityCode>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementEstablishment">
																									<com:EntitlementEstablishment>
																										<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																											<com:EntitlementEstablishmentCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementEstablishmentCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																											<xsl:variable name="var522_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var522_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</com:EntitlementEstablishment>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:EntitlementDomiciled">
																									<com:EntitlementDomiciled>
																										<xsl:for-each select="ns0:EntitlementDomiciledCode">
																											<com:EntitlementDomiciledCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</com:EntitlementDomiciledCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																											<xsl:variable name="var523_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																												<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																													<xsl:with-param name="AddressBook" as="node()">
																														<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																															<xsl:sequence select="(./@node(), ./node())"/>
																														</AddressBookType>
																													</xsl:with-param>
																												</xsl:call-template>
																											</xsl:variable>
																											<xsl:for-each select="$var523_resultof_MappingST__AddressBookToST__Contact">
																												<com:Contact>
																													<xsl:sequence select="(./@node(), ./node())"/>
																												</com:Contact>
																											</xsl:for-each>
																										</xsl:for-each>
																									</com:EntitlementDomiciled>
																								</xsl:for-each>
																							</tmk:Entitlement>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenseeIdentifier">
																							<xsl:variable name="var524_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																							<com:PartyIdentifier>
																								<xsl:if test="fn:exists($var524_identifierKindCode)">
																									<xsl:attribute name="com:officeCode" select="fn:string($var524_identifierKindCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:PartyIdentifier>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenseeAddressBook">
																							<xsl:variable name="var525_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var525_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</tmk:Licensee>
																				</xsl:for-each>
																			</tmk:LicenseeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RepresentativeDetails">
																			<com:RepresentativeBag>
																				<xsl:for-each select="ns0:Representative">
																					<xsl:variable name="var527_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																							<xsl:with-param name="Representative" as="node()">
																								<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</RepresentativeType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var527_resultof_MappingST__RepresentativeToST__Representative">
																						<com:Representative>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</com:Representative>
																					</xsl:for-each>
																				</xsl:for-each>
																			</com:RepresentativeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LicenceEventDetails">
																			<com:LicenceEventBag>
																				<xsl:for-each select="ns0:LicenceEvent">
																					<xsl:variable name="var529_resultof_vmf___inputtoresult" as="xs:string?">
																						<xsl:call-template name="vmf:vmf44_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(ns0:LicenceEventCode)" as="xs:string"/>
																						</xsl:call-template>
																					</xsl:variable>
																					<com:LicenceEvent>
																						<xsl:if test="fn:exists($var529_resultof_vmf___inputtoresult)">
																							<com:LicenceEventCategory>
																								<xsl:sequence select="$var529_resultof_vmf___inputtoresult"/>
																							</com:LicenceEventCategory>
																						</xsl:if>
																						<xsl:for-each select="ns0:LicenceEventResponseDate">
																							<com:LicenceEventResponseDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:LicenceEventResponseDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var528_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var528_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var528_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenceEventDate">
																							<com:LicenceEventDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:LicenceEventDate>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:LicenceEventDateTime">
																							<com:LicenceEventDateTime>
																								<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																							</com:LicenceEventDateTime>
																						</xsl:for-each>
																					</com:LicenceEvent>
																				</xsl:for-each>
																			</com:LicenceEventBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LicenceDocumentDetails">
																			<com:LicenceDocumentBag>
																				<xsl:for-each select="ns0:LicenceDocument">
																					<com:LicenceDocument>
																						<xsl:for-each select="ns0:DocumentLanguageCode">
																							<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentName">
																							<com:DocumentName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentName>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentFilename">
																							<com:FileName>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:FileName>
																						</xsl:for-each>
																						<xsl:variable name="var531_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentFileFormat">
																								<xsl:variable name="var530_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf22_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var530_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var531_resultof_filter">
																							<com:DocumentFormatCategory>
																								<xsl:call-template name="vmf:vmf22_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentFormatCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentDate">
																							<com:DocumentDate>
																								<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																							</com:DocumentDate>
																						</xsl:for-each>
																						<xsl:variable name="var533_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:DocumentMedia">
																								<xsl:variable name="var532_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf23_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var532_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var533_resultof_filter">
																							<com:DocumentMediaCategory>
																								<xsl:call-template name="vmf:vmf23_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</com:DocumentMediaCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentLocation">
																							<com:DocumentLocationURI>
																								<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																							</com:DocumentLocationURI>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentVersion">
																							<com:DocumentVersion>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:DocumentVersion>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:DocumentSizeInByte">
																							<com:DocumentSizeQuantity>
																								<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																							</com:DocumentSizeQuantity>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:Comment">
																							<xsl:variable name="var534_languageCode" as="node()?" select="@languageCode"/>
																							<com:CommentText>
																								<xsl:if test="fn:exists($var534_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var534_languageCode)"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:CommentText>
																						</xsl:for-each>
																					</com:LicenceDocument>
																				</xsl:for-each>
																			</com:LicenceDocumentBag>
																		</xsl:for-each>
																	</tmk:Licence>
																</xsl:for-each>
															</tmk:LicenceBag>
														</xsl:for-each>
													</tmk:RecordLicence>
												</xsl:for-each>
												<xsl:for-each select="ns0:RecordNationalInternationalReplacement">
													<tmk:RecordNationalInternationalReplacement>
														<xsl:for-each select="ns0:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:TradeMarkKeyDetails">
															<tmk:TrademarkIdentification>
																<xsl:for-each select="ns0:TradeMarkKey">
																	<tmk:TrademarkIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var536_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<tmk:TrademarkIdentifier>
																				<xsl:if test="fn:exists($var536_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var536_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:TrademarkIdentifier>
																		</xsl:for-each>
																	</tmk:TrademarkIdentifierBag>
																</xsl:for-each>
															</tmk:TrademarkIdentification>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordPublicationDetails">
															<tmk:RecordPublicationBag>
																<xsl:for-each select="ns0:RecordPublication">
																	<tmk:RecordPublication>
																		<com:PublicationIdentifier>
																			<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																		</com:PublicationIdentifier>
																		<xsl:variable name="var538_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:PublicationSection">
																				<xsl:variable name="var537_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf27_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var537_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var538_resultof_filter">
																			<tmk:PublicationSectionCategory>
																				<xsl:call-template name="vmf:vmf27_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:PublicationSectionCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationSubsection">
																			<com:PublicationSubsection>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationSubsection>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationDate">
																			<com:PublicationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PublicationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationPage">
																			<com:PublicationPage>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationPage>
																		</xsl:for-each>
																	</tmk:RecordPublication>
																</xsl:for-each>
															</tmk:RecordPublicationBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:ClaimantDetails">
															<tmk:ClaimantBag>
																<xsl:for-each select="ns0:ClaimantKey">
																	<com:PartyIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var539_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var539_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var539_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																	</com:PartyIdentifierBag>
																</xsl:for-each>
																<xsl:for-each select="ns0:Claimant">
																	<xsl:variable name="var544_operationCode" as="node()?" select="@operationCode"/>
																	<tmk:Claimant>
																		<xsl:if test="fn:exists($var544_operationCode)">
																			<xsl:attribute name="com:operationCategory" select="fn:string($var544_operationCode)"/>
																		</xsl:if>
																		<xsl:for-each select="ns0:ClaimantSequenceNumber">
																			<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantLegalEntity">
																			<com:LegalEntityName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LegalEntityName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantNationalityCode">
																			<com:NationalityCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:NationalityCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																			<com:IncorporationCountryCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationCountryCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationState">
																			<com:IncorporationState>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationState>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var540_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var540_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var540_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantEntitlement">
																			<tmk:Entitlement>
																				<xsl:for-each select="ns0:EntitlementNationalityCode">
																					<com:EntitlementNationalityCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:EntitlementNationalityCode>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementEstablishment">
																					<com:EntitlementEstablishment>
																						<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																							<com:EntitlementEstablishmentCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementEstablishmentCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																							<xsl:variable name="var541_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var541_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</com:EntitlementEstablishment>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementDomiciled">
																					<com:EntitlementDomiciled>
																						<xsl:for-each select="ns0:EntitlementDomiciledCode">
																							<com:EntitlementDomiciledCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementDomiciledCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																							<com:Contact>
																								<xsl:sequence select="()"/>
																							</com:Contact>
																						</xsl:for-each>
																					</com:EntitlementDomiciled>
																				</xsl:for-each>
																			</tmk:Entitlement>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIdentifier">
																			<xsl:variable name="var542_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var542_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var542_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantAddressBook">
																			<xsl:variable name="var543_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																				<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																					<xsl:with-param name="AddressBook" as="node()">
																						<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</AddressBookType>
																					</xsl:with-param>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:for-each select="$var543_resultof_MappingST__AddressBookToST__Contact">
																				<com:Contact>
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</com:Contact>
																			</xsl:for-each>
																		</xsl:for-each>
																	</tmk:Claimant>
																</xsl:for-each>
															</tmk:ClaimantBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RepresentativeDetails">
															<com:RepresentativeBag>
																<xsl:for-each select="ns0:Representative">
																	<xsl:variable name="var545_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																			<xsl:with-param name="Representative" as="node()">
																				<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</RepresentativeType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var545_resultof_MappingST__RepresentativeToST__Representative">
																		<com:Representative>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Representative>
																	</xsl:for-each>
																</xsl:for-each>
															</com:RepresentativeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEventDetails">
															<com:RecordEventBag>
																<xsl:for-each select="ns0:RecordEvent">
																	<xsl:variable name="var547_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf35_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<com:RecordEvent>
																		<xsl:if test="fn:exists($var547_resultof_vmf___inputtoresult)">
																			<com:RecordEventCategory>
																				<xsl:sequence select="$var547_resultof_vmf___inputtoresult"/>
																			</com:RecordEventCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordEventResponseDate">
																			<com:RecordEventResponseDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventResponseDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var546_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var546_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var546_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDate">
																			<com:RecordEventDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDateTime">
																			<com:RecordEventDateTime>
																				<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																			</com:RecordEventDateTime>
																		</xsl:for-each>
																	</com:RecordEvent>
																</xsl:for-each>
															</com:RecordEventBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordDocumentDetails">
															<com:RecordDocumentBag>
																<xsl:for-each select="ns0:RecordDocument">
																	<com:RecordDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var549_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var548_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var548_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var549_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var551_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var550_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var550_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var551_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var552_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var552_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var552_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</com:RecordDocument>
																</xsl:for-each>
															</com:RecordDocumentBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordInterestedOfficeCode">
															<com:RecordInterestedOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordInterestedOfficeCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:GoodsServicesLimitationDetails">
															<tmk:GoodsServicesLimitationBag>
																<xsl:for-each select="ns0:GoodsServicesLimitation">
																	<tmk:GoodsServicesLimitation>
																		<xsl:for-each select="ns0:LimitationCountryDetails">
																			<com:LimitationCountryCodeBag>
																				<xsl:for-each select="ns0:LimitationCountryCode">
																					<com:LimitationCountryCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:LimitationCountryCode>
																				</xsl:for-each>
																			</com:LimitationCountryCodeBag>
																		</xsl:for-each>
																		<xsl:variable name="var554_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																				<xsl:variable name="var553_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf32_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var553_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var554_resultof_filter">
																			<tmk:GoodsServicesLimitationCategory>
																				<xsl:call-template name="vmf:vmf32_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:GoodsServicesLimitationCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var555_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var555_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var555_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																			<tmk:LimitationClassDescriptionBag>
																				<xsl:for-each select="ns0:ClassDescription">
																					<tmk:ClassDescription>
																						<xsl:for-each select="ns0:ClassNumber">
																							<tmk:ClassNumber>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:ClassNumber>
																						</xsl:for-each>
																						<xsl:variable name="var557_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:ClassNumberStatusCode">
																								<xsl:variable name="var556_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf18_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var556_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var557_resultof_filter">
																							<tmk:ClassNumberStatusCategory>
																								<xsl:call-template name="vmf:vmf18_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:ClassNumberStatusCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:GoodsServicesDescription">
																							<xsl:variable name="var558_languageCode" as="node()?" select="@languageCode"/>
																							<xsl:variable name="var559_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																							<tmk:GoodsServicesDescriptionText>
																								<xsl:if test="fn:exists($var558_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var558_languageCode)"/>
																								</xsl:if>
																								<xsl:if test="fn:exists($var559_sequenceNumber)">
																									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var559_sequenceNumber)))"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:GoodsServicesDescriptionText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																							<tmk:UseNiceHeadingIndicator>
																								<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																							</tmk:UseNiceHeadingIndicator>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClassificationTermDetails">
																							<tmk:ClassificationTermBag>
																								<xsl:for-each select="ns0:ClassificationTerm">
																									<xsl:variable name="var567_operationCode" as="node()?" select="@operationCode"/>
																									<tmk:ClassificationTerm>
																										<xsl:if test="fn:exists($var567_operationCode)">
																											<xsl:attribute name="com:operationCategory" select="fn:string($var567_operationCode)"/>
																										</xsl:if>
																										<xsl:for-each select="ns0:ClassificationTermIdentifier">
																											<xsl:variable name="var560_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																											<tmk:ClassificationTermIdentifier>
																												<xsl:if test="fn:exists($var560_identifierKindCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var560_identifierKindCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermIdentifier>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermOffice">
																											<tmk:ClassificationTermOfficeCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermOfficeCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																											<tmk:ClassificationTermOfficeIdentification>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermOfficeIdentification>
																										</xsl:for-each>
																										<xsl:variable name="var562_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassificationTermSource">
																												<xsl:variable name="var561_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf19_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var561_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var562_resultof_filter">
																											<tmk:ClassificationTermSourceCategory>
																												<xsl:call-template name="vmf:vmf19_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassificationTermSourceCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermEntryDate">
																											<tmk:ClassificationTermEntryDate>
																												<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																											</tmk:ClassificationTermEntryDate>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassNumber">
																											<tmk:ClassNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassNumber>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermText">
																											<xsl:variable name="var563_languageCode" as="node()?" select="@languageCode"/>
																											<tmk:ClassificationTermText>
																												<xsl:if test="fn:exists($var563_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var563_languageCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																											<tmk:ClassificationTermEquivalentGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermEquivalentGroup>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																											<tmk:ClassificationTermReferenceGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermReferenceGroup>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																											<tmk:ClassificationTermTranslationGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermTranslationGroup>
																										</xsl:for-each>
																										<xsl:variable name="var565_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassificationTermStatus">
																												<xsl:variable name="var564_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf20_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var564_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var565_resultof_filter">
																											<xsl:variable name="var566_officeCode" as="node()?" select="@officeCode"/>
																											<tmk:ClassificationTermStatus>
																												<xsl:if test="fn:exists($var566_officeCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var566_officeCode)"/>
																												</xsl:if>
																												<xsl:call-template name="vmf:vmf20_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassificationTermStatus>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:WIPOBasicNumber">
																											<tmk:WIPOBasicNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:WIPOBasicNumber>
																										</xsl:for-each>
																									</tmk:ClassificationTerm>
																								</xsl:for-each>
																							</tmk:ClassificationTermBag>
																						</xsl:for-each>
																					</tmk:ClassDescription>
																				</xsl:for-each>
																			</tmk:LimitationClassDescriptionBag>
																		</xsl:for-each>
																	</tmk:GoodsServicesLimitation>
																</xsl:for-each>
															</tmk:GoodsServicesLimitationBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:NationalMarkDetails">
															<tmk:NationalMarkBag>
																<xsl:for-each select="ns0:NationalMark">
																	<tmk:NationalMark>
																		<tmk:NationalMarkRegistrationNumber>
																			<xsl:sequence select="fn:string(ns0:NationalMarkRegistrationNumber)"/>
																		</tmk:NationalMarkRegistrationNumber>
																		<xsl:for-each select="ns0:NationalMarkFilingDate">
																			<tmk:NationalMarkFilingDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</tmk:NationalMarkFilingDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:NationalMarkRegistrationDate">
																			<tmk:NationalMarkRegistrationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</tmk:NationalMarkRegistrationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:NationalMarkPriorityDate">
																			<tmk:NationalMarkPriorityDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</tmk:NationalMarkPriorityDate>
																		</xsl:for-each>
																	</tmk:NationalMark>
																</xsl:for-each>
															</tmk:NationalMarkBag>
														</xsl:for-each>
													</tmk:RecordNationalInternationalReplacement>
												</xsl:for-each>
												<xsl:for-each select="ns0:RecordShortNotation">
													<xsl:variable name="var618_resultof_vmf___inputtoresult" as="xs:string?">
														<xsl:call-template name="vmf:vmf45_inputtoresult">
															<xsl:with-param name="input" select="fn:string(ns0:RecordShortNotationKind)" as="xs:string"/>
														</xsl:call-template>
													</xsl:variable>
													<tmk:RecordShortNotation>
														<xsl:for-each select="ns0:RecordIdentifier">
															<com:RecordIdentifier>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordIdentifier>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordFilingDate">
															<com:RecordFilingDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordFilingDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordNotificationDate">
															<com:RecordNotificationDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordNotificationDate>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEffectiveDate">
															<com:RecordEffectiveDate>
																<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
															</com:RecordEffectiveDate>
														</xsl:for-each>
														<xsl:if test="fn:exists($var618_resultof_vmf___inputtoresult)">
															<tmk:RecordShortNotationCategory>
																<xsl:sequence select="$var618_resultof_vmf___inputtoresult"/>
															</tmk:RecordShortNotationCategory>
														</xsl:if>
														<xsl:for-each select="ns0:RecordReference">
															<com:RecordReference>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordReference>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordLanguageCode">
															<com:RecordLanguageCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordLanguageCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordPublicationDetails">
															<tmk:RecordPublicationBag>
																<xsl:for-each select="ns0:RecordPublication">
																	<tmk:RecordPublication>
																		<com:PublicationIdentifier>
																			<xsl:sequence select="fn:string(ns0:PublicationIdentifier)"/>
																		</com:PublicationIdentifier>
																		<xsl:variable name="var569_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:PublicationSection">
																				<xsl:variable name="var568_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf27_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var568_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var569_resultof_filter">
																			<tmk:PublicationSectionCategory>
																				<xsl:call-template name="vmf:vmf27_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:PublicationSectionCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationSubsection">
																			<com:PublicationSubsection>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationSubsection>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationDate">
																			<com:PublicationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:PublicationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:PublicationPage">
																			<com:PublicationPage>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PublicationPage>
																		</xsl:for-each>
																	</tmk:RecordPublication>
																</xsl:for-each>
															</tmk:RecordPublicationBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:ClaimantDetails">
															<tmk:ClaimantBag>
																<xsl:for-each select="ns0:ClaimantKey">
																	<com:PartyIdentifierBag>
																		<xsl:for-each select="ns0:Identifier">
																			<xsl:variable name="var570_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var570_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var570_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																	</com:PartyIdentifierBag>
																</xsl:for-each>
																<xsl:for-each select="ns0:Claimant">
																	<xsl:variable name="var575_operationCode" as="node()?" select="@operationCode"/>
																	<tmk:Claimant>
																		<xsl:if test="fn:exists($var575_operationCode)">
																			<xsl:attribute name="com:operationCategory" select="fn:string($var575_operationCode)"/>
																		</xsl:if>
																		<xsl:for-each select="ns0:ClaimantSequenceNumber">
																			<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string(.)))"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantLegalEntity">
																			<com:LegalEntityName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:LegalEntityName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantNationalityCode">
																			<com:NationalityCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:NationalityCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationCountryCode">
																			<com:IncorporationCountryCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationCountryCode>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIncorporationState">
																			<com:IncorporationState>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:IncorporationState>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var571_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var571_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var571_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantEntitlement">
																			<tmk:Entitlement>
																				<xsl:for-each select="ns0:EntitlementNationalityCode">
																					<com:EntitlementNationalityCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:EntitlementNationalityCode>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementEstablishment">
																					<com:EntitlementEstablishment>
																						<xsl:for-each select="ns0:EntitlementEstablishmentCode">
																							<com:EntitlementEstablishmentCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementEstablishmentCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementEstablishmentAddressBook">
																							<xsl:variable name="var572_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																								<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																									<xsl:with-param name="AddressBook" as="node()">
																										<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																											<xsl:sequence select="(./@node(), ./node())"/>
																										</AddressBookType>
																									</xsl:with-param>
																								</xsl:call-template>
																							</xsl:variable>
																							<xsl:for-each select="$var572_resultof_MappingST__AddressBookToST__Contact">
																								<com:Contact>
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</com:Contact>
																							</xsl:for-each>
																						</xsl:for-each>
																					</com:EntitlementEstablishment>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:EntitlementDomiciled">
																					<com:EntitlementDomiciled>
																						<xsl:for-each select="ns0:EntitlementDomiciledCode">
																							<com:EntitlementDomiciledCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:EntitlementDomiciledCode>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:EntitlementDomiciledAddressBook">
																							<com:Contact>
																								<xsl:sequence select="()"/>
																							</com:Contact>
																						</xsl:for-each>
																					</com:EntitlementDomiciled>
																				</xsl:for-each>
																			</tmk:Entitlement>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantIdentifier">
																			<xsl:variable name="var573_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																			<com:PartyIdentifier>
																				<xsl:if test="fn:exists($var573_identifierKindCode)">
																					<xsl:attribute name="com:officeCode" select="fn:string($var573_identifierKindCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:PartyIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ClaimantAddressBook">
																			<xsl:variable name="var574_resultof_MappingST__AddressBookToST__Contact" as="node()?">
																				<xsl:call-template name="WIPO:MappingST66AddressBookToST96Contact">
																					<xsl:with-param name="AddressBook" as="node()">
																						<AddressBookType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</AddressBookType>
																					</xsl:with-param>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:for-each select="$var574_resultof_MappingST__AddressBookToST__Contact">
																				<com:Contact>
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</com:Contact>
																			</xsl:for-each>
																		</xsl:for-each>
																	</tmk:Claimant>
																</xsl:for-each>
															</tmk:ClaimantBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RepresentativeDetails">
															<com:RepresentativeBag>
																<xsl:for-each select="ns0:Representative">
																	<xsl:variable name="var576_resultof_MappingST__RepresentativeToST__Representative" as="node()?">
																		<xsl:call-template name="WIPO:MappingST66RepresentativeToST96Representative">
																			<xsl:with-param name="Representative" as="node()">
																				<RepresentativeType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</RepresentativeType>
																			</xsl:with-param>
																		</xsl:call-template>
																	</xsl:variable>
																	<xsl:for-each select="$var576_resultof_MappingST__RepresentativeToST__Representative">
																		<com:Representative>
																			<xsl:sequence select="(./@node(), ./node())"/>
																		</com:Representative>
																	</xsl:for-each>
																</xsl:for-each>
															</com:RepresentativeBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordEventDetails">
															<com:RecordEventBag>
																<xsl:for-each select="ns0:RecordEvent">
																	<xsl:variable name="var578_resultof_vmf___inputtoresult" as="xs:string?">
																		<xsl:call-template name="vmf:vmf35_inputtoresult">
																			<xsl:with-param name="input" select="fn:string(ns0:RecordEventCode)" as="xs:string"/>
																		</xsl:call-template>
																	</xsl:variable>
																	<com:RecordEvent>
																		<xsl:if test="fn:exists($var578_resultof_vmf___inputtoresult)">
																			<com:RecordEventCategory>
																				<xsl:sequence select="$var578_resultof_vmf___inputtoresult"/>
																			</com:RecordEventCategory>
																		</xsl:if>
																		<xsl:for-each select="ns0:RecordEventResponseDate">
																			<com:RecordEventResponseDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventResponseDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var577_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var577_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var577_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDate">
																			<com:RecordEventDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RecordEventDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RecordEventDateTime">
																			<com:RecordEventDateTime>
																				<xsl:sequence select="xs:string(xs:dateTime(fn:string(.)))"/>
																			</com:RecordEventDateTime>
																		</xsl:for-each>
																	</com:RecordEvent>
																</xsl:for-each>
															</com:RecordEventBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordDocumentDetails">
															<com:RecordDocumentBag>
																<xsl:for-each select="ns0:RecordDocument">
																	<com:RecordDocument>
																		<xsl:for-each select="ns0:DocumentLanguageCode">
																			<xsl:attribute name="com:languageCode" select="fn:string(.)"/>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentName">
																			<com:DocumentName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentName>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentFilename">
																			<com:FileName>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:FileName>
																		</xsl:for-each>
																		<xsl:variable name="var580_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentFileFormat">
																				<xsl:variable name="var579_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf22_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var579_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var580_resultof_filter">
																			<com:DocumentFormatCategory>
																				<xsl:call-template name="vmf:vmf22_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentFormatCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentDate">
																			<com:DocumentDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:DocumentDate>
																		</xsl:for-each>
																		<xsl:variable name="var582_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:DocumentMedia">
																				<xsl:variable name="var581_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf23_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var581_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var582_resultof_filter">
																			<com:DocumentMediaCategory>
																				<xsl:call-template name="vmf:vmf23_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</com:DocumentMediaCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentLocation">
																			<com:DocumentLocationURI>
																				<xsl:sequence select="xs:string(xs:anyURI(fn:string(.)))"/>
																			</com:DocumentLocationURI>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentVersion">
																			<com:DocumentVersion>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DocumentVersion>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DocumentSizeInByte">
																			<com:DocumentSizeQuantity>
																				<xsl:sequence select="xs:string(xs:integer(fn:string(.)))"/>
																			</com:DocumentSizeQuantity>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var583_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var583_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var583_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																	</com:RecordDocument>
																</xsl:for-each>
															</com:RecordDocumentBag>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordInterestedOfficeCode">
															<com:RecordInterestedOfficeCode>
																<xsl:sequence select="fn:string(.)"/>
															</com:RecordInterestedOfficeCode>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordToRegistration">
															<tmk:RecordToRegistration>
																<xsl:for-each select="ns0:RegistrationIdentifier">
																	<tmk:RegistrationIdentifier>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:RegistrationIdentifier>
																</xsl:for-each>
																<xsl:for-each select="ns0:RegistrationDate">
																	<com:RegistrationDate>
																		<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																	</com:RegistrationDate>
																</xsl:for-each>
																<xsl:for-each select="ns0:MarkVerbalElementText">
																	<xsl:variable name="var584_languageCode" as="node()?" select="@languageCode"/>
																	<tmk:MarkVerbalElementText>
																		<xsl:if test="fn:exists($var584_languageCode)">
																			<xsl:attribute name="com:languageCode" select="fn:string($var584_languageCode)"/>
																		</xsl:if>
																		<xsl:sequence select="fn:string(.)"/>
																	</tmk:MarkVerbalElementText>
																</xsl:for-each>
																<xsl:for-each select="ns0:DesignatedCountryDetails">
																	<tmk:DesignatedCountryCodeBag>
																		<xsl:for-each select="ns0:DesignatedCountryCode">
																			<com:DesignatedCountryCode>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:DesignatedCountryCode>
																		</xsl:for-each>
																	</tmk:DesignatedCountryCodeBag>
																</xsl:for-each>
																<xsl:for-each select="ns0:GoodsServicesLimitation">
																	<tmk:GoodsServicesLimitation>
																		<xsl:for-each select="ns0:LimitationCountryDetails">
																			<com:LimitationCountryCodeBag>
																				<xsl:for-each select="ns0:LimitationCountryCode">
																					<com:LimitationCountryCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:LimitationCountryCode>
																				</xsl:for-each>
																			</com:LimitationCountryCodeBag>
																		</xsl:for-each>
																		<xsl:variable name="var586_resultof_filter" as="node()?">
																			<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																				<xsl:variable name="var585_resultof_vmf___inputtoresult" as="xs:string?">
																					<xsl:call-template name="vmf:vmf32_inputtoresult">
																						<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																					</xsl:call-template>
																				</xsl:variable>
																				<xsl:if test="fn:exists($var585_resultof_vmf___inputtoresult)">
																					<xsl:sequence select="."/>
																				</xsl:if>
																			</xsl:for-each>
																		</xsl:variable>
																		<xsl:for-each select="$var586_resultof_filter">
																			<tmk:GoodsServicesLimitationCategory>
																				<xsl:call-template name="vmf:vmf32_inputtoresult">
																					<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																				</xsl:call-template>
																			</tmk:GoodsServicesLimitationCategory>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:Comment">
																			<xsl:variable name="var587_languageCode" as="node()?" select="@languageCode"/>
																			<com:CommentText>
																				<xsl:if test="fn:exists($var587_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var587_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</com:CommentText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																			<tmk:LimitationClassDescriptionBag>
																				<xsl:for-each select="ns0:ClassDescription">
																					<tmk:ClassDescription>
																						<xsl:for-each select="ns0:ClassNumber">
																							<tmk:ClassNumber>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:ClassNumber>
																						</xsl:for-each>
																						<xsl:variable name="var589_resultof_filter" as="node()?">
																							<xsl:for-each select="ns0:ClassNumberStatusCode">
																								<xsl:variable name="var588_resultof_vmf___inputtoresult" as="xs:string?">
																									<xsl:call-template name="vmf:vmf18_inputtoresult">
																										<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																									</xsl:call-template>
																								</xsl:variable>
																								<xsl:if test="fn:exists($var588_resultof_vmf___inputtoresult)">
																									<xsl:sequence select="."/>
																								</xsl:if>
																							</xsl:for-each>
																						</xsl:variable>
																						<xsl:for-each select="$var589_resultof_filter">
																							<tmk:ClassNumberStatusCategory>
																								<xsl:call-template name="vmf:vmf18_inputtoresult">
																									<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																								</xsl:call-template>
																							</tmk:ClassNumberStatusCategory>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:GoodsServicesDescription">
																							<xsl:variable name="var590_languageCode" as="node()?" select="@languageCode"/>
																							<xsl:variable name="var591_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																							<tmk:GoodsServicesDescriptionText>
																								<xsl:if test="fn:exists($var590_languageCode)">
																									<xsl:attribute name="com:languageCode" select="fn:string($var590_languageCode)"/>
																								</xsl:if>
																								<xsl:if test="fn:exists($var591_sequenceNumber)">
																									<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var591_sequenceNumber)))"/>
																								</xsl:if>
																								<xsl:sequence select="fn:string(.)"/>
																							</tmk:GoodsServicesDescriptionText>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																							<tmk:UseNiceHeadingIndicator>
																								<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																							</tmk:UseNiceHeadingIndicator>
																						</xsl:for-each>
																						<xsl:for-each select="ns0:ClassificationTermDetails">
																							<tmk:ClassificationTermBag>
																								<xsl:for-each select="ns0:ClassificationTerm">
																									<xsl:variable name="var599_operationCode" as="node()?" select="@operationCode"/>
																									<tmk:ClassificationTerm>
																										<xsl:if test="fn:exists($var599_operationCode)">
																											<xsl:attribute name="com:operationCategory" select="fn:string($var599_operationCode)"/>
																										</xsl:if>
																										<xsl:for-each select="ns0:ClassificationTermIdentifier">
																											<xsl:variable name="var592_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																											<tmk:ClassificationTermIdentifier>
																												<xsl:if test="fn:exists($var592_identifierKindCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var592_identifierKindCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermIdentifier>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermOffice">
																											<tmk:ClassificationTermOfficeCode>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermOfficeCode>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																											<tmk:ClassificationTermOfficeIdentification>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermOfficeIdentification>
																										</xsl:for-each>
																										<xsl:variable name="var594_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassificationTermSource">
																												<xsl:variable name="var593_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf19_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var593_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var594_resultof_filter">
																											<tmk:ClassificationTermSourceCategory>
																												<xsl:call-template name="vmf:vmf19_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassificationTermSourceCategory>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermEntryDate">
																											<tmk:ClassificationTermEntryDate>
																												<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																											</tmk:ClassificationTermEntryDate>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassNumber">
																											<tmk:ClassNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassNumber>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermText">
																											<xsl:variable name="var595_languageCode" as="node()?" select="@languageCode"/>
																											<tmk:ClassificationTermText>
																												<xsl:if test="fn:exists($var595_languageCode)">
																													<xsl:attribute name="com:languageCode" select="fn:string($var595_languageCode)"/>
																												</xsl:if>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermText>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																											<tmk:ClassificationTermEquivalentGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermEquivalentGroup>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																											<tmk:ClassificationTermReferenceGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermReferenceGroup>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																											<tmk:ClassificationTermTranslationGroup>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:ClassificationTermTranslationGroup>
																										</xsl:for-each>
																										<xsl:variable name="var597_resultof_filter" as="node()?">
																											<xsl:for-each select="ns0:ClassificationTermStatus">
																												<xsl:variable name="var596_resultof_vmf___inputtoresult" as="xs:string?">
																													<xsl:call-template name="vmf:vmf20_inputtoresult">
																														<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																													</xsl:call-template>
																												</xsl:variable>
																												<xsl:if test="fn:exists($var596_resultof_vmf___inputtoresult)">
																													<xsl:sequence select="."/>
																												</xsl:if>
																											</xsl:for-each>
																										</xsl:variable>
																										<xsl:for-each select="$var597_resultof_filter">
																											<xsl:variable name="var598_officeCode" as="node()?" select="@officeCode"/>
																											<tmk:ClassificationTermStatus>
																												<xsl:if test="fn:exists($var598_officeCode)">
																													<xsl:attribute name="com:officeCode" select="fn:string($var598_officeCode)"/>
																												</xsl:if>
																												<xsl:call-template name="vmf:vmf20_inputtoresult">
																													<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																												</xsl:call-template>
																											</tmk:ClassificationTermStatus>
																										</xsl:for-each>
																										<xsl:for-each select="ns0:WIPOBasicNumber">
																											<tmk:WIPOBasicNumber>
																												<xsl:sequence select="fn:string(.)"/>
																											</tmk:WIPOBasicNumber>
																										</xsl:for-each>
																									</tmk:ClassificationTerm>
																								</xsl:for-each>
																							</tmk:ClassificationTermBag>
																						</xsl:for-each>
																					</tmk:ClassDescription>
																				</xsl:for-each>
																			</tmk:LimitationClassDescriptionBag>
																		</xsl:for-each>
																	</tmk:GoodsServicesLimitation>
																</xsl:for-each>
																<xsl:for-each select="ns0:ApplicantDetails">
																	<tmk:ApplicantBag>
																		<xsl:for-each select="ns0:Applicant">
																			<xsl:variable name="var600_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																				<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																					<xsl:with-param name="Applicant" as="node()">
																						<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</ApplicantType>
																					</xsl:with-param>
																				</xsl:call-template>
																			</xsl:variable>
																			<xsl:for-each select="$var600_resultof_MappingST__ApplicantToST__Applicant">
																				<tmk:Applicant>
																					<xsl:sequence select="(./@node(), ./node())"/>
																				</tmk:Applicant>
																			</xsl:for-each>
																		</xsl:for-each>
																	</tmk:ApplicantBag>
																</xsl:for-each>
															</tmk:RecordToRegistration>
														</xsl:for-each>
														<xsl:for-each select="ns0:RecordFromRegistrationDetails">
															<tmk:RecordFromRegistrationBag>
																<xsl:for-each select="ns0:RecordFromRegistration">
																	<tmk:RecordFromRegistration>
																		<xsl:for-each select="ns0:RegistrationIdentifier">
																			<tmk:RegistrationIdentifier>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:RegistrationIdentifier>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:RegistrationDate">
																			<com:RegistrationDate>
																				<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																			</com:RegistrationDate>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:MarkVerbalElementText">
																			<xsl:variable name="var601_languageCode" as="node()?" select="@languageCode"/>
																			<tmk:MarkVerbalElementText>
																				<xsl:if test="fn:exists($var601_languageCode)">
																					<xsl:attribute name="com:languageCode" select="fn:string($var601_languageCode)"/>
																				</xsl:if>
																				<xsl:sequence select="fn:string(.)"/>
																			</tmk:MarkVerbalElementText>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:DesignatedCountryDetails">
																			<tmk:DesignatedCountryCodeBag>
																				<xsl:for-each select="ns0:DesignatedCountryCode">
																					<com:DesignatedCountryCode>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:DesignatedCountryCode>
																				</xsl:for-each>
																			</tmk:DesignatedCountryCodeBag>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:GoodsServicesLimitation">
																			<tmk:GoodsServicesLimitation>
																				<xsl:for-each select="ns0:LimitationCountryDetails">
																					<com:LimitationCountryCodeBag>
																						<xsl:for-each select="ns0:LimitationCountryCode">
																							<com:LimitationCountryCode>
																								<xsl:sequence select="fn:string(.)"/>
																							</com:LimitationCountryCode>
																						</xsl:for-each>
																					</com:LimitationCountryCodeBag>
																				</xsl:for-each>
																				<xsl:variable name="var603_resultof_filter" as="node()?">
																					<xsl:for-each select="ns0:GoodsServicesLimitationCode">
																						<xsl:variable name="var602_resultof_vmf___inputtoresult" as="xs:string?">
																							<xsl:call-template name="vmf:vmf32_inputtoresult">
																								<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																							</xsl:call-template>
																						</xsl:variable>
																						<xsl:if test="fn:exists($var602_resultof_vmf___inputtoresult)">
																							<xsl:sequence select="."/>
																						</xsl:if>
																					</xsl:for-each>
																				</xsl:variable>
																				<xsl:for-each select="$var603_resultof_filter">
																					<tmk:GoodsServicesLimitationCategory>
																						<xsl:call-template name="vmf:vmf32_inputtoresult">
																							<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																						</xsl:call-template>
																					</tmk:GoodsServicesLimitationCategory>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:Comment">
																					<xsl:variable name="var604_languageCode" as="node()?" select="@languageCode"/>
																					<com:CommentText>
																						<xsl:if test="fn:exists($var604_languageCode)">
																							<xsl:attribute name="com:languageCode" select="fn:string($var604_languageCode)"/>
																						</xsl:if>
																						<xsl:sequence select="fn:string(.)"/>
																					</com:CommentText>
																				</xsl:for-each>
																				<xsl:for-each select="ns0:LimitationClassDescriptionDetails">
																					<tmk:LimitationClassDescriptionBag>
																						<xsl:for-each select="ns0:ClassDescription">
																							<tmk:ClassDescription>
																								<xsl:for-each select="ns0:ClassNumber">
																									<tmk:ClassNumber>
																										<xsl:sequence select="fn:string(.)"/>
																									</tmk:ClassNumber>
																								</xsl:for-each>
																								<xsl:variable name="var606_resultof_filter" as="node()?">
																									<xsl:for-each select="ns0:ClassNumberStatusCode">
																										<xsl:variable name="var605_resultof_vmf___inputtoresult" as="xs:string?">
																											<xsl:call-template name="vmf:vmf18_inputtoresult">
																												<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																											</xsl:call-template>
																										</xsl:variable>
																										<xsl:if test="fn:exists($var605_resultof_vmf___inputtoresult)">
																											<xsl:sequence select="."/>
																										</xsl:if>
																									</xsl:for-each>
																								</xsl:variable>
																								<xsl:for-each select="$var606_resultof_filter">
																									<tmk:ClassNumberStatusCategory>
																										<xsl:call-template name="vmf:vmf18_inputtoresult">
																											<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																										</xsl:call-template>
																									</tmk:ClassNumberStatusCategory>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:GoodsServicesDescription">
																									<xsl:variable name="var607_languageCode" as="node()?" select="@languageCode"/>
																									<xsl:variable name="var608_sequenceNumber" as="node()?" select="@sequenceNumber"/>
																									<tmk:GoodsServicesDescriptionText>
																										<xsl:if test="fn:exists($var607_languageCode)">
																											<xsl:attribute name="com:languageCode" select="fn:string($var607_languageCode)"/>
																										</xsl:if>
																										<xsl:if test="fn:exists($var608_sequenceNumber)">
																											<xsl:attribute name="com:sequenceNumber" select="xs:string(xs:integer(fn:string($var608_sequenceNumber)))"/>
																										</xsl:if>
																										<xsl:sequence select="fn:string(.)"/>
																									</tmk:GoodsServicesDescriptionText>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:UseNiceHeadingIndicator">
																									<tmk:UseNiceHeadingIndicator>
																										<xsl:sequence select="xs:string(xs:boolean(fn:string(.)))"/>
																									</tmk:UseNiceHeadingIndicator>
																								</xsl:for-each>
																								<xsl:for-each select="ns0:ClassificationTermDetails">
																									<tmk:ClassificationTermBag>
																										<xsl:for-each select="ns0:ClassificationTerm">
																											<xsl:variable name="var616_operationCode" as="node()?" select="@operationCode"/>
																											<tmk:ClassificationTerm>
																												<xsl:if test="fn:exists($var616_operationCode)">
																													<xsl:attribute name="com:operationCategory" select="fn:string($var616_operationCode)"/>
																												</xsl:if>
																												<xsl:for-each select="ns0:ClassificationTermIdentifier">
																													<xsl:variable name="var609_identifierKindCode" as="node()?" select="@identifierKindCode"/>
																													<tmk:ClassificationTermIdentifier>
																														<xsl:if test="fn:exists($var609_identifierKindCode)">
																															<xsl:attribute name="com:officeCode" select="fn:string($var609_identifierKindCode)"/>
																														</xsl:if>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermIdentifier>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermOffice">
																													<tmk:ClassificationTermOfficeCode>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermOfficeCode>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermOfficeKey">
																													<tmk:ClassificationTermOfficeIdentification>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermOfficeIdentification>
																												</xsl:for-each>
																												<xsl:variable name="var611_resultof_filter" as="node()?">
																													<xsl:for-each select="ns0:ClassificationTermSource">
																														<xsl:variable name="var610_resultof_vmf___inputtoresult" as="xs:string?">
																															<xsl:call-template name="vmf:vmf19_inputtoresult">
																																<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																															</xsl:call-template>
																														</xsl:variable>
																														<xsl:if test="fn:exists($var610_resultof_vmf___inputtoresult)">
																															<xsl:sequence select="."/>
																														</xsl:if>
																													</xsl:for-each>
																												</xsl:variable>
																												<xsl:for-each select="$var611_resultof_filter">
																													<tmk:ClassificationTermSourceCategory>
																														<xsl:call-template name="vmf:vmf19_inputtoresult">
																															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																														</xsl:call-template>
																													</tmk:ClassificationTermSourceCategory>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermEntryDate">
																													<tmk:ClassificationTermEntryDate>
																														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
																													</tmk:ClassificationTermEntryDate>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassNumber">
																													<tmk:ClassNumber>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassNumber>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermText">
																													<xsl:variable name="var612_languageCode" as="node()?" select="@languageCode"/>
																													<tmk:ClassificationTermText>
																														<xsl:if test="fn:exists($var612_languageCode)">
																															<xsl:attribute name="com:languageCode" select="fn:string($var612_languageCode)"/>
																														</xsl:if>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermText>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
																													<tmk:ClassificationTermEquivalentGroup>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermEquivalentGroup>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
																													<tmk:ClassificationTermReferenceGroup>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermReferenceGroup>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
																													<tmk:ClassificationTermTranslationGroup>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:ClassificationTermTranslationGroup>
																												</xsl:for-each>
																												<xsl:variable name="var614_resultof_filter" as="node()?">
																													<xsl:for-each select="ns0:ClassificationTermStatus">
																														<xsl:variable name="var613_resultof_vmf___inputtoresult" as="xs:string?">
																															<xsl:call-template name="vmf:vmf20_inputtoresult">
																																<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																															</xsl:call-template>
																														</xsl:variable>
																														<xsl:if test="fn:exists($var613_resultof_vmf___inputtoresult)">
																															<xsl:sequence select="."/>
																														</xsl:if>
																													</xsl:for-each>
																												</xsl:variable>
																												<xsl:for-each select="$var614_resultof_filter">
																													<xsl:variable name="var615_officeCode" as="node()?" select="@officeCode"/>
																													<tmk:ClassificationTermStatus>
																														<xsl:if test="fn:exists($var615_officeCode)">
																															<xsl:attribute name="com:officeCode" select="fn:string($var615_officeCode)"/>
																														</xsl:if>
																														<xsl:call-template name="vmf:vmf20_inputtoresult">
																															<xsl:with-param name="input" select="fn:string(.)" as="xs:string"/>
																														</xsl:call-template>
																													</tmk:ClassificationTermStatus>
																												</xsl:for-each>
																												<xsl:for-each select="ns0:WIPOBasicNumber">
																													<tmk:WIPOBasicNumber>
																														<xsl:sequence select="fn:string(.)"/>
																													</tmk:WIPOBasicNumber>
																												</xsl:for-each>
																											</tmk:ClassificationTerm>
																										</xsl:for-each>
																									</tmk:ClassificationTermBag>
																								</xsl:for-each>
																							</tmk:ClassDescription>
																						</xsl:for-each>
																					</tmk:LimitationClassDescriptionBag>
																				</xsl:for-each>
																			</tmk:GoodsServicesLimitation>
																		</xsl:for-each>
																		<xsl:for-each select="ns0:ApplicantDetails">
																			<tmk:ApplicantBag>
																				<xsl:for-each select="ns0:Applicant">
																					<xsl:variable name="var617_resultof_MappingST__ApplicantToST__Applicant" as="node()?">
																						<xsl:call-template name="WIPO:MappingST66ApplicantToST96Applicant">
																							<xsl:with-param name="Applicant" as="node()">
																								<ApplicantType xmlns="http://www.wipo.int/standards/XMLSchema/trademarks">
																									<xsl:sequence select="(./@node(), ./node())"/>
																								</ApplicantType>
																							</xsl:with-param>
																						</xsl:call-template>
																					</xsl:variable>
																					<xsl:for-each select="$var617_resultof_MappingST__ApplicantToST__Applicant">
																						<tmk:Applicant>
																							<xsl:sequence select="(./@node(), ./node())"/>
																						</tmk:Applicant>
																					</xsl:for-each>
																				</xsl:for-each>
																			</tmk:ApplicantBag>
																		</xsl:for-each>
																	</tmk:RecordFromRegistration>
																</xsl:for-each>
															</tmk:RecordFromRegistrationBag>
														</xsl:for-each>
													</tmk:RecordShortNotation>
												</xsl:for-each>
											</tmk:MarkRecord>
										</xsl:for-each>
									</tmk:MarkRecordBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:MarkRecordRelationDetails">
									<tmk:MarkRecordRelationBag>
										<xsl:for-each select="ns0:MarkRecordRelation">
											<tmk:MarkRecordRelation>
												<xsl:sequence select="()"/>
											</tmk:MarkRecordRelation>
										</xsl:for-each>
									</tmk:MarkRecordRelationBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:ClassificationTermDetails">
									<tmk:ClassificationTermBag>
										<xsl:for-each select="ns0:ClassificationTerm">
											<tmk:ClassificationTerm>
												<xsl:for-each select="ns0:ClassificationTermIdentifier">
													<tmk:ClassificationTermIdentifier>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ClassificationTermIdentifier>
												</xsl:for-each>
												<xsl:for-each select="ns0:ClassificationTermEntryDate">
													<tmk:ClassificationTermEntryDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:ClassificationTermEntryDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:ClassNumber">
													<tmk:ClassNumber>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ClassNumber>
												</xsl:for-each>
												<xsl:for-each select="ns0:ClassificationTermText">
													<xsl:variable name="var619_languageCode" as="node()?" select="@languageCode"/>
													<tmk:ClassificationTermText>
														<xsl:if test="fn:exists($var619_languageCode)">
															<xsl:attribute name="com:languageCode" select="fn:string($var619_languageCode)"/>
														</xsl:if>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ClassificationTermText>
												</xsl:for-each>
												<xsl:for-each select="ns0:ClassificationTermEquivalentGroup">
													<tmk:ClassificationTermEquivalentGroup>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ClassificationTermEquivalentGroup>
												</xsl:for-each>
												<xsl:for-each select="ns0:ClassificationTermReferenceGroup">
													<tmk:ClassificationTermReferenceGroup>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ClassificationTermReferenceGroup>
												</xsl:for-each>
												<xsl:for-each select="ns0:ClassificationTermTranslationGroup">
													<tmk:ClassificationTermTranslationGroup>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ClassificationTermTranslationGroup>
												</xsl:for-each>
												<xsl:for-each select="ns0:ClassificationTermStatus">
													<xsl:variable name="var620_officeCode" as="node()?" select="@officeCode"/>
													<tmk:ClassificationTermStatus>
														<xsl:if test="fn:exists($var620_officeCode)">
															<xsl:attribute name="com:officeCode" select="fn:string($var620_officeCode)"/>
														</xsl:if>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:ClassificationTermStatus>
												</xsl:for-each>
												<xsl:for-each select="ns0:WIPOBasicNumber">
													<tmk:WIPOBasicNumber>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:WIPOBasicNumber>
												</xsl:for-each>
											</tmk:ClassificationTerm>
										</xsl:for-each>
									</tmk:ClassificationTermBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:TermSynonymRelationDetails">
									<tmk:TermSynonymRelationBag>
										<xsl:for-each select="ns0:TermSynonymRelation">
											<tmk:TermSynonymRelation>
												<xsl:sequence select="()"/>
											</tmk:TermSynonymRelation>
										</xsl:for-each>
									</tmk:TermSynonymRelationBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:TermTranslationRelationDetails">
									<tmk:TermTranslationRelationBag>
										<xsl:for-each select="ns0:TermTranslationRelation">
											<tmk:TermTranslationRelation>
												<xsl:sequence select="()"/>
											</tmk:TermTranslationRelation>
										</xsl:for-each>
									</tmk:TermTranslationRelationBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:DecisionDetails">
									<tmk:DecisionBag>
										<xsl:for-each select="ns0:Decision">
											<tmk:Decision>
												<tmk:DecisionIdentifier>
													<xsl:sequence select="fn:string(ns0:DecisionIdentifier)"/>
												</tmk:DecisionIdentifier>
												<xsl:for-each select="ns0:DecisionDate">
													<tmk:DecisionDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:DecisionDate>
												</xsl:for-each>
												<xsl:for-each select="ns0:DecisionText">
													<xsl:variable name="var621_languageCode" as="node()?" select="@languageCode"/>
													<tmk:DecisionText>
														<xsl:if test="fn:exists($var621_languageCode)">
															<xsl:attribute name="com:languageCode" select="fn:string($var621_languageCode)"/>
														</xsl:if>
														<xsl:sequence select="fn:string(.)"/>
													</tmk:DecisionText>
												</xsl:for-each>
												<xsl:for-each select="ns0:DecisionCurrentStatusDate">
													<tmk:DecisionCurrentStatusDate>
														<xsl:sequence select="xs:string(xs:date(fn:string(.)))"/>
													</tmk:DecisionCurrentStatusDate>
												</xsl:for-each>
											</tmk:Decision>
										</xsl:for-each>
									</tmk:DecisionBag>
								</xsl:for-each>
								<xsl:for-each select="$var623_resultof_first/ns0:DecisionCaseRelationDetails">
									<tmk:DecisionCaseRelationBag>
										<xsl:for-each select="ns0:DecisionCaseRelation">
											<tmk:DecisionCaseRelation>
												<xsl:sequence select="()"/>
											</tmk:DecisionCaseRelation>
										</xsl:for-each>
									</tmk:DecisionCaseRelationBag>
								</xsl:for-each>
							</tmk:TransactionData>
						</tmk:TransactionContentBag>
					</tmk:TrademarkTransactionBody>
				</xsl:for-each>
			</xsl:for-each>
		</tmk:TrademarkTransaction>
	</xsl:template>
</xsl:stylesheet>
