/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAnnotationItem;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.wipo.xsd2json.schema.builders.types.AbstractJsonSchemaBuilder;
import org.wipo.xsd2json.schema.builders.types.AttributeJsonSchemaBuilder;
import org.wipo.xsd2json.schema.builders.types.ComplexTypeJsonSchemaBuilder;
import org.wipo.xsd2json.schema.builders.types.ElementJsonSchemaBuilder;
import org.wipo.xsd2json.schema.builders.types.GroupTypeJsonSchemaBuilder;
import org.wipo.xsd2json.schema.builders.types.SimpleTypeJsonSchemaBuilder;
import org.wipo.xsd2json.utils.NamingUtils;

public class JsonSchemaBuilder {
    private File xsdFile;
    private Map<String, String> typeRefAnnex;
    private String jsonSchemaExt;
    private String versionTxt;
    private boolean createDefsOnlyEntry;

    public JsonSchemaBuilder(File xsd, Map<String, String> typeRefAnnex, String jsonSchemaExt) {
        this.xsdFile = xsd;
        this.typeRefAnnex = typeRefAnnex;
        this.jsonSchemaExt = jsonSchemaExt;
        this.createDefsOnlyEntry = false;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> createJsonSchema() throws IOException {
        FileInputStream is = new FileInputStream(this.xsdFile);
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        schemaCol.setBaseUri(this.xsdFile.getParent());
        XmlSchema schema = schemaCol.read(new StreamSource(is));
        this.versionTxt = schema.getVersion();
        ArrayList<Map<String, Object>> jsonSchemaList = new ArrayList<Map<String, Object>>();
        if (!(schema.getElements() != null && !schema.getElements().isEmpty() || schema.getAttributes() != null && !schema.getAttributes().isEmpty() || schema.getSchemaTypes() == null || schema.getSchemaTypes().entrySet().isEmpty())) {
            this.createDefsOnlyEntry = true;
        }
        if (schema.getElements() != null && schema.getElements().size() > 0) {
            Object var5_5 = null;
            for (Map.Entry<QName, XmlSchemaElement> entry : schema.getElements().entrySet()) {
                void var5_6;
                AbstractJsonSchemaBuilder elementBuilder = null;
                if (var5_6 == null) {
                    XmlSchemaElement xmlSchemaElement = entry.getValue();
                    XmlSchemaAnnotation schmAntns = schema.getAnnotation();
                    if (schmAntns != null) {
                        for (XmlSchemaAnnotationItem schmAntn : schmAntns.getItems()) {
                            if (!(schmAntn instanceof XmlSchemaAppInfo)) continue;
                            xmlSchemaElement.getAnnotation().getItems().add(schmAntn);
                            elementBuilder = new ElementJsonSchemaBuilder(entry.getValue(), false, 0, false, this.createDefsOnlyEntry, this.xsdFile, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt);
                            break;
                        }
                    }
                } else {
                    elementBuilder = new ElementJsonSchemaBuilder(entry.getValue(), false, 0, false, this.createDefsOnlyEntry, this.xsdFile, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt);
                }
                if (elementBuilder == null) {
                    elementBuilder = new ElementJsonSchemaBuilder(entry.getValue(), false, 0, false, this.createDefsOnlyEntry, this.xsdFile, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt);
                }
                jsonSchemaList.add(elementBuilder.createJsonSchema());
            }
        }
        if (schema.getAttributes() != null && schema.getAttributes().size() > 0) {
            for (Map.Entry<QName, XmlSchemaAnnotated> entry : schema.getAttributes().entrySet()) {
                AttributeJsonSchemaBuilder attributeBuilder = new AttributeJsonSchemaBuilder((XmlSchemaAttribute)entry.getValue(), this.xsdFile, 1L, this.createDefsOnlyEntry, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt);
                jsonSchemaList.add(attributeBuilder.createJsonSchema());
            }
        }
        if (schema.getSchemaTypes() != null && schema.getSchemaTypes().entrySet().size() > 0) {
            for (Map.Entry<QName, XmlSchemaAnnotated> entry : schema.getSchemaTypes().entrySet()) {
                if (entry.getValue() instanceof XmlSchemaSimpleType) {
                    SimpleTypeJsonSchemaBuilder simpleTypeBuilder = new SimpleTypeJsonSchemaBuilder((XmlSchemaSimpleType)entry.getValue(), 1L, this.createDefsOnlyEntry, this.xsdFile, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt);
                    jsonSchemaList.add(simpleTypeBuilder.createJsonSchema());
                }
                if (!(entry.getValue() instanceof XmlSchemaComplexType)) continue;
                XmlSchemaComplexType compTyp = (XmlSchemaComplexType)entry.getValue();
                long mxOcrs = 1L;
                String compTypName = null;
                compTypName = compTyp.getName();
                ComplexTypeJsonSchemaBuilder complexTypeBuilder = new ComplexTypeJsonSchemaBuilder(compTyp, compTypName, mxOcrs, this.createDefsOnlyEntry, this.xsdFile, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt);
                jsonSchemaList.add(complexTypeBuilder.createJsonSchema());
            }
        }
        if (schema.getGroups() != null && schema.getGroups().entrySet().size() > 0) {
            for (Map.Entry<QName, XmlSchemaAnnotated> entry : schema.getGroups().entrySet()) {
                if (!(entry.getValue() instanceof XmlSchemaGroup)) continue;
                GroupTypeJsonSchemaBuilder groupTypeBuilder = new GroupTypeJsonSchemaBuilder((XmlSchemaGroup)entry.getValue(), ((XmlSchemaGroup)entry.getValue()).getParticle().getMaxOccurs(), this.createDefsOnlyEntry, this.xsdFile, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt);
                jsonSchemaList.add(groupTypeBuilder.createJsonSchema());
            }
        }
        return this.createFinalMapFromAllElements(jsonSchemaList);
    }

    private Map<String, Object> createFinalMapFromAllElements(List<Map<String, Object>> jsonSchemaList) {
        LinkedHashMap<String, Object> jsonSchemaMap = new LinkedHashMap<String, Object>();
        jsonSchemaMap.put("$id", NamingUtils.makeLowerCamelCase(this.xsdFile.getName().substring(0, this.xsdFile.getName().toLowerCase().lastIndexOf(".xsd"))).concat(this.jsonSchemaExt));
        jsonSchemaMap.put("$schema", "https://json-schema.org/draft/2020-12/schema");
        jsonSchemaMap.put("type", "object");
        jsonSchemaMap.put("additionalProperties", false);
        jsonSchemaMap.put("properties", new LinkedHashMap());
        jsonSchemaMap.put("required", new ArrayList());
        jsonSchemaMap.put("$defs", new LinkedHashMap());
        for (Map<String, Object> individualMap : jsonSchemaList) {
            if (this.createDefsOnlyEntry) {
                jsonSchemaMap.remove("type");
                jsonSchemaMap.remove("additionalProperties");
                jsonSchemaMap.remove("properties");
                jsonSchemaMap.remove("required");
                ((Map)jsonSchemaMap.get("$defs")).putAll((Map)individualMap.get("$defs"));
                continue;
            }
            Map indvProps = (Map)individualMap.get("properties");
            if (indvProps.containsKey("primitiveType")) {
                if (((Boolean)indvProps.get("primitiveType")).booleanValue() && indvProps.size() == 2) {
                    jsonSchemaMap.remove("type");
                }
                indvProps.remove("primitiveType");
            }
            ((Map)jsonSchemaMap.get("properties")).putAll(indvProps);
            if (individualMap.get("required") != null && ((List)individualMap.get("required")).size() > 0) {
                for (String reqName : (List)individualMap.get("required")) {
                    if (((List)jsonSchemaMap.get("required")).contains(reqName)) continue;
                    ((List)jsonSchemaMap.get("required")).add(reqName);
                }
            }
            ((Map)jsonSchemaMap.get("$defs")).putAll((Map)individualMap.get("$defs"));
        }
        return jsonSchemaMap;
    }

    public File getXsdFile() {
        return this.xsdFile;
    }

    public void setXsdFile(File xsdFile) {
        this.xsdFile = xsdFile;
    }
}

