/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.representation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAnnotationItem;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wipo.xsd2json.utils.JsonTypeUtils;
import org.wipo.xsd2json.utils.NamingUtils;
import org.wipo.xsd2json.utils.XmlUtil;

public class BaseJsonElement {
    protected String name;
    protected String schemaTypeName;
    protected boolean choiceElement;
    protected Map<String, Object> type;
    protected boolean isPrimitivType = false;
    protected String description;
    protected String ref;
    protected List<String> requiredList;
    protected long maxOccurs;
    protected long minOccurs;
    protected long parentMaxOccurs;
    protected List<String> enumList;
    protected Object fixedValue;
    protected boolean createDefsOnlyEntry;
    protected int multipleChoicCntr;
    protected String baseFilePath;
    protected String jsonSchemaExt;
    protected boolean excludeInRequired;
    protected String versionTxt;

    public BaseJsonElement(String name, String schemaTypeName, long minOccurs, long maxOccurs, long parentMaxOccurs, Map<String, String> typeRefAnnex, XmlSchemaAnnotation annotations, List<String> enumList, Object fixedValue, boolean createDefsOnlyEntry, String baseFilePath, String jsonSchemaExt, String versionTxt) {
        this(name, schemaTypeName, false, minOccurs, maxOccurs, parentMaxOccurs, typeRefAnnex, annotations, enumList, fixedValue, createDefsOnlyEntry, -1, false, baseFilePath, jsonSchemaExt, versionTxt);
    }

    public BaseJsonElement(String name, String schemaTypeName, long minOccurs, long maxOccurs, long parentMaxOccurs, Map<String, String> typeRefAnnex, XmlSchemaAnnotation annotations, List<String> enumList, Object fixedValue, boolean createDefsOnlyEntry, int multipleChoicCntr, String baseFilePath, String jsonSchemaExt, String versionTxt) {
        this(name, schemaTypeName, false, minOccurs, maxOccurs, parentMaxOccurs, typeRefAnnex, annotations, enumList, fixedValue, createDefsOnlyEntry, -1, false, baseFilePath, jsonSchemaExt, versionTxt);
    }

    public BaseJsonElement(String name, String schemaTypeName, long minOccurs, long maxOccurs, long parentMaxOccurs, Map<String, String> typeRefAnnex, XmlSchemaAnnotation annotations, List<String> enumList, Object fixedValue, boolean createDefsOnlyEntry, int multipleChoicCntr, boolean excludeInRequired, String baseFilePath, String jsonSchemaExt, String versionTxt) {
        this(name, schemaTypeName, false, minOccurs, maxOccurs, parentMaxOccurs, typeRefAnnex, annotations, enumList, fixedValue, createDefsOnlyEntry, -1, excludeInRequired, baseFilePath, jsonSchemaExt, versionTxt);
    }

    public BaseJsonElement(String name, String schemaTypeName, boolean choiceElement, long minOccurs, long maxOccurs, long parentMaxOccurs, Map<String, String> typeRefAnnex, XmlSchemaAnnotation annotations, List<String> enumList, Object fixedValue, boolean createDefsOnlyEntry, int multipleChoicCntr, boolean excludeInRequired, String baseFilePath, String jsonSchemaExt, String versionTxt) {
        String typePath;
        this.name = name;
        this.schemaTypeName = schemaTypeName;
        this.choiceElement = choiceElement;
        this.maxOccurs = maxOccurs;
        this.minOccurs = minOccurs;
        this.parentMaxOccurs = parentMaxOccurs;
        this.enumList = enumList;
        this.fixedValue = fixedValue;
        this.createDefsOnlyEntry = createDefsOnlyEntry;
        this.multipleChoicCntr = multipleChoicCntr;
        this.versionTxt = versionTxt;
        if (this.maxOccurs <= 1L && parentMaxOccurs > 1L) {
            this.maxOccurs = parentMaxOccurs;
        }
        if ((typePath = typeRefAnnex.get(schemaTypeName)) == null || JsonTypeUtils.primitiveVarType(schemaTypeName) != null) {
            this.type = new LinkedHashMap<String, Object>();
            Map<String, Object> prim = JsonTypeUtils.primitiveVarType(schemaTypeName);
            if (prim != null) {
                this.type.putAll(JsonTypeUtils.primitiveVarType(schemaTypeName));
                if (!this.type.containsKey("anyType")) {
                    this.isPrimitivType = true;
                }
                if (this.ref == null) {
                    this.ref = "#/$defs/".concat(NamingUtils.makeLowerCamelCase(name));
                }
            } else {
                this.type.putAll(JsonTypeUtils.primitiveVarType("string"));
                this.isPrimitivType = true;
            }
        } else {
            String camelCase = NamingUtils.makeLowerCamelCase(schemaTypeName);
            String jsonFilePath = JsonTypeUtils.createJsonFilePathFromXsdFilePath(baseFilePath, typePath);
            String transformedTypePath = "#/$defs/".concat(camelCase);
            if (!baseFilePath.equals(typePath)) {
                transformedTypePath = jsonFilePath.concat(jsonSchemaExt).concat("#/$defs/").concat(camelCase);
            }
            this.ref = transformedTypePath;
        }
        if (annotations != null) {
            for (XmlSchemaAnnotationItem annotation : annotations.getItems()) {
                if (annotation instanceof XmlSchemaDocumentation) {
                    for (Node documentation : XmlUtil.asList(((XmlSchemaDocumentation)annotation).getMarkup())) {
                        String currDesc = "";
                        if (this.description != null) {
                            currDesc = "; ".concat(this.description);
                            this.description = null;
                        }
                        this.description = "Description: ".concat(documentation.getNodeValue()).concat("; Version: ").concat(this.versionTxt).concat(currDesc);
                    }
                }
                if (!(annotation instanceof XmlSchemaAppInfo)) continue;
                XmlSchemaAppInfo appInfoAntn = (XmlSchemaAppInfo)annotation;
                NodeList nodeList = appInfoAntn.getMarkup();
                if (nodeList != null) {
                    for (Node documentation : XmlUtil.asList(nodeList)) {
                        String lclNm = documentation.getLocalName();
                        String txtCntnt = documentation.getTextContent();
                        if (txtCntnt.replace("\\t", "").replace("\\n", "").replace("\\r", "").trim().length() == 0) {
                            txtCntnt = null;
                        }
                        if (lclNm != null) {
                            this.description = String.valueOf(this.description) + "; ".concat(lclNm).concat(": ").concat(txtCntnt);
                            continue;
                        }
                        if (txtCntnt == null) continue;
                        this.description = this.description == null ? "" : String.valueOf(this.description) + "; ";
                        this.description = String.valueOf(this.description) + txtCntnt;
                    }
                    continue;
                }
                if (this.description == null) {
                    this.description = "Version: ".concat(this.versionTxt);
                }
                Map<Object, Object> metaMap = appInfoAntn.getMetaInfoMap();
                for (Map.Entry<Object, Object> mapEntr : metaMap.entrySet()) {
                    this.description = String.valueOf(this.description) + "; ".concat(mapEntr.getKey().toString()).concat(": ").concat(mapEntr.getValue().toString());
                }
            }
        }
        this.excludeInRequired = excludeInRequired;
        this.requiredList = new ArrayList<String>();
        if (minOccurs >= 1L && !excludeInRequired) {
            this.requiredList.add(this.getLowerCamelCaseName());
        }
        this.baseFilePath = baseFilePath;
        this.jsonSchemaExt = jsonSchemaExt;
    }

    public String getLowerCamelCaseName() {
        return NamingUtils.makeLowerCamelCase(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPrimitivType() {
        return this.isPrimitivType;
    }

    public Map<String, Object> getType() {
        return this.type;
    }

    public String getSchemaTypeName() {
        return this.schemaTypeName;
    }

    public void setSchemaTypeName(String schemaTypeName) {
        this.schemaTypeName = schemaTypeName;
    }

    public void setType(Map<String, Object> type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getRef() {
        return this.ref;
    }

    private String getPropertiesRef() {
        return this.isCreateDefsOnlyEntry() ? this.ref : "#/$defs/".concat(NamingUtils.makeLowerCamelCase(this.name));
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public List<String> getRequiredList() {
        return this.requiredList;
    }

    public void setRequiredList(List<String> requiredList) {
        this.requiredList = requiredList;
    }

    public Object getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(Object fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean isCreateDefsOnlyEntry() {
        return this.createDefsOnlyEntry;
    }

    public void setCreateDefsOnlyEntry(boolean createDefsOnlyEntry) {
        this.createDefsOnlyEntry = createDefsOnlyEntry;
    }

    public String getBaseFilePath() {
        return this.baseFilePath;
    }

    public void setBaseFilePath(String baseFilePath) {
        this.baseFilePath = baseFilePath;
    }

    public String getJsonSchemaExt() {
        return this.jsonSchemaExt;
    }

    public void setJsonSchemaExt(String jsonSchemaExt) {
        this.jsonSchemaExt = jsonSchemaExt;
    }

    public String getVersionText() {
        return this.versionTxt;
    }

    public void setVersionText(String verstionTxt) {
        this.versionTxt = verstionTxt;
    }

    public Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> jsonSchemaProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> elmProps = new LinkedHashMap<String, String>();
        elmProps.put("$ref", this.getPropertiesRef());
        jsonSchemaProperties.put(this.getLowerCamelCaseName(), elmProps);
        jsonSchemaProperties.put("primitiveType", this.isPrimitivType);
        return jsonSchemaProperties;
    }

    public Map<String, Object> getDefinitions() {
        LinkedHashMap<String, Object> definitions = new LinkedHashMap<String, Object>();
        Map<String, Object> definitionsMap = this.createDefinitionsMap();
        String lcName = this.getLowerCamelCaseName();
        if (lcName.equals("sequence") && definitionsMap.containsKey("properties")) {
            LinkedHashMap mapEntrs = (LinkedHashMap)definitionsMap.get("properties");
            definitions.putAll(mapEntrs);
        } else if (lcName.endsWith("Choice") || lcName.contains("Choice") && this.multipleChoicCntr > 0 && lcName.endsWith("Choice".concat(String.valueOf(this.multipleChoicCntr)))) {
            definitions.putAll(definitionsMap);
        } else {
            definitions.put(lcName, definitionsMap);
        }
        return definitions;
    }

    protected Map<String, Object> createDefinitionsMap() {
        LinkedHashMap<String, Object> defMap = new LinkedHashMap<String, Object>();
        if (this.maxOccurs > 1L) {
            defMap.put("type", "array");
            defMap.put("minItems", this.minOccurs);
            if (this.maxOccurs != Long.MAX_VALUE) {
                defMap.put("maxItems", this.maxOccurs);
            }
            if (this.type != null) {
                defMap.put("items", this.type);
            } else {
                HashMap<String, String> refMap = new HashMap<String, String>();
                refMap.put("$ref", this.ref);
                defMap.put("items", refMap);
            }
        } else if (this.type != null) {
            defMap.putAll(this.type);
        } else {
            defMap.put("$ref", this.ref);
        }
        if (this.enumList != null) {
            if (this.type != null && this.type.containsKey("type") && (this.type.get("type").equals("integer") || this.type.get("type").equals("number") || this.type.get("type").equals("nonNegativeInteger") || this.type.get("type").equals("positiveInteger") || this.type.get("type").equals("unsignedInteger") || this.type.get("type").equals("base64"))) {
                ArrayList intEnum = new ArrayList();
                try {
                    this.enumList.forEach(strEnt -> intEnum.add(Integer.parseInt(strEnt)));
                    defMap.put("enum", intEnum);
                }
                catch (Exception ex) {
                    defMap.put("enum", this.enumList);
                }
            } else if (this.getSchemaTypeName().equalsIgnoreCase("boolean")) {
                ArrayList boolEnum = new ArrayList();
                try {
                    this.enumList.forEach(strEnt -> boolEnum.add(Boolean.parseBoolean(strEnt)));
                    defMap.put("enum", boolEnum);
                }
                catch (Exception ex) {
                    defMap.put("enum", this.enumList);
                }
            } else {
                defMap.put("enum", this.enumList);
            }
        }
        if (this.fixedValue != null) {
            defMap.put("const", this.fixedValue);
        }
        if (this.description != null) {
            defMap.put("description", this.description);
        }
        return defMap;
    }

    protected Map<String, Object> getPropertiesMap() {
        LinkedHashMap<String, Object> propertiesMap = new LinkedHashMap<String, Object>();
        if (this.maxOccurs > 1L) {
            LinkedHashMap<String, Object> maxOccursMap = new LinkedHashMap<String, Object>();
            maxOccursMap.put("type", "array");
            maxOccursMap.put("minItems", this.minOccurs);
            if (this.maxOccurs != Long.MAX_VALUE) {
                maxOccursMap.put("maxItems", this.maxOccurs);
            }
            if (this.getRef() != null) {
                LinkedHashMap<String, String> refMap = new LinkedHashMap<String, String>();
                refMap.put("$ref", this.getPropertiesRef());
                maxOccursMap.put("items", refMap);
            } else {
                maxOccursMap.put("items", this.getType());
            }
            propertiesMap.put(this.getLowerCamelCaseName(), maxOccursMap);
        } else if (this.getRef() != null) {
            LinkedHashMap<String, String> refMap = new LinkedHashMap<String, String>();
            String ref = this.getPropertiesRef();
            refMap.put("$ref", ref);
            propertiesMap.put(this.getLowerCamelCaseName(), refMap);
        } else {
            propertiesMap.put(this.getLowerCamelCaseName(), this.getType());
        }
        if (this.enumList != null) {
            LinkedHashMap<String, Object> enumsMap = new LinkedHashMap<String, Object>();
            if (this.type != null && this.type.containsKey("type") && (this.type.get("type").equals("integer") || this.type.get("type").equals("number") || this.type.get("type").equals("nonNegativeInteger") || this.type.get("type").equals("positiveInteger") || this.type.get("type").equals("unsignedInteger") || this.type.get("type").equals("base64"))) {
                ArrayList intEnum = new ArrayList();
                try {
                    this.enumList.forEach(strEnt -> intEnum.add(Integer.parseInt(strEnt)));
                    enumsMap.put("type", "integer");
                    enumsMap.put("enum", intEnum);
                }
                catch (Exception ex) {
                    enumsMap.put("enum", this.enumList);
                }
            } else if (this.getSchemaTypeName().equalsIgnoreCase("boolean")) {
                ArrayList boolEnum = new ArrayList();
                try {
                    this.enumList.forEach(strEnt -> boolEnum.add(Boolean.parseBoolean(strEnt)));
                    enumsMap.put("type", "boolean");
                    enumsMap.put("enum", boolEnum);
                }
                catch (Exception ex) {
                    enumsMap.put("enum", this.enumList);
                }
            } else {
                enumsMap.put("type", "string");
                enumsMap.put("enum", this.enumList);
            }
            propertiesMap.put(this.getLowerCamelCaseName(), enumsMap);
        }
        return propertiesMap;
    }

    protected List<String> getAllRequiredList() {
        return this.requiredList;
    }

    protected Map<String, Object> getPropertyForDefinition() {
        return this.getPropertiesMap();
    }
}

