/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.utils.annex;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;

public class XsdTypeUtils {
    public static String getTypeOfAttribute(XmlSchemaAttribute attribute) {
        String attrType;
        String string = attrType = attribute.getSchemaTypeName() != null ? attribute.getSchemaTypeName().getLocalPart() : null;
        if (attrType == null) {
            attrType = attribute.getRef() != null ? (attribute.getRef().getTargetQName() != null ? attribute.getRef().getTargetQName().getLocalPart() : "anySimpleType") : "anySimpleType";
        }
        return attrType;
    }

    public static String getTypeOfElement(XmlSchemaElement element) {
        String elemType;
        String string = elemType = element.getSchemaTypeName() != null ? element.getSchemaTypeName().getLocalPart() : null;
        if (elemType == null) {
            elemType = element.getRef() != null ? (element.getRef().getTargetQName() != null ? element.getRef().getTargetQName().getLocalPart() : "anySimpleType") : "anySimpleType";
        }
        return elemType;
    }

    public static List<String> getTypeOfSimpleType(XmlSchemaSimpleType simpleType) {
        ArrayList<String> allTypesOfSimpleType = new ArrayList<String>();
        allTypesOfSimpleType.add(simpleType.getQName().getLocalPart());
        if (simpleType.getContent() instanceof XmlSchemaSimpleTypeRestriction) {
            String type = simpleType.getQName().getLocalPart();
            allTypesOfSimpleType.add(type);
        }
        if (simpleType.getContent() instanceof XmlSchemaSimpleTypeUnion) {
            QName[] qNameArray = ((XmlSchemaSimpleTypeUnion)simpleType.getContent()).getMemberTypesQNames();
            int n = qNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                QName qname = qNameArray[n2];
                String type = qname.getLocalPart();
                allTypesOfSimpleType.add(type);
                ++n2;
            }
        }
        return allTypesOfSimpleType;
    }

    public static List<String> getTypeOfComplexType(XmlSchemaComplexType complexTypeType) {
        ArrayList<String> allTypesOfComplexType = new ArrayList<String>();
        String type = complexTypeType.getQName().getLocalPart();
        allTypesOfComplexType.add(type);
        for (XmlSchemaAttributeOrGroupRef attr : complexTypeType.getAttributes()) {
            if (attr instanceof XmlSchemaAttribute) {
                allTypesOfComplexType.add(XsdTypeUtils.getTypeOfAttribute((XmlSchemaAttribute)attr));
            }
            if (!(attr instanceof XmlSchemaAttributeGroupRef)) continue;
            throw new RuntimeException("XmlSchemaAttributeGroupRef of complex type is not yet mapped!!!");
        }
        if (complexTypeType.getContentModel() != null) {
            allTypesOfComplexType.addAll(XsdTypeUtils.getTypeOfContentModel(complexTypeType.getContentModel()));
        }
        if (complexTypeType.getParticle() != null) {
            allTypesOfComplexType.addAll(XsdTypeUtils.getTypeOfParticle(complexTypeType.getParticle()));
        }
        return allTypesOfComplexType;
    }

    public static List<String> getTypeOfComplexType(XmlSchemaGroup groupType) {
        ArrayList<String> allTypesOfComplexType = new ArrayList<String>();
        String type = groupType.getQName().getLocalPart();
        allTypesOfComplexType.add(type);
        if (groupType.getParticle() != null) {
            allTypesOfComplexType.addAll(XsdTypeUtils.getTypeOfParticle(groupType.getParticle()));
        }
        return allTypesOfComplexType;
    }

    private static List<String> getTypeOfParticle(XmlSchemaParticle particle) {
        ArrayList<String> allTypesOfParticle = new ArrayList<String>();
        if (particle instanceof XmlSchemaSequence) {
            XmlSchemaSequence resolvedSequence = (XmlSchemaSequence)particle;
            allTypesOfParticle.addAll(XsdTypeUtils.getTypeOfSequence(resolvedSequence));
        }
        if (particle instanceof XmlSchemaChoice) {
            XmlSchemaChoice resolvedChoice = (XmlSchemaChoice)particle;
            allTypesOfParticle.addAll(XsdTypeUtils.getTypeOfChoice(resolvedChoice));
        }
        return allTypesOfParticle;
    }

    private static List<String> getTypeOfChoice(XmlSchemaChoice choice) {
        ArrayList<String> choiceTypesList = new ArrayList<String>();
        for (XmlSchemaChoiceMember item : choice.getItems()) {
            if (item instanceof XmlSchemaElement) {
                choiceTypesList.add(XsdTypeUtils.getTypeOfElement((XmlSchemaElement)item));
            }
            if (item instanceof XmlSchemaChoice) {
                choiceTypesList.addAll(XsdTypeUtils.getTypeOfChoice((XmlSchemaChoice)item));
            }
            if (!(item instanceof XmlSchemaSequence)) continue;
            choiceTypesList.addAll(XsdTypeUtils.getTypeOfSequence((XmlSchemaSequence)item));
        }
        return choiceTypesList;
    }

    private static List<String> getTypeOfSequence(XmlSchemaSequence sequence) {
        ArrayList<String> sequenceTypesList = new ArrayList<String>();
        for (XmlSchemaSequenceMember item : sequence.getItems()) {
            if (item instanceof XmlSchemaElement) {
                sequenceTypesList.add(XsdTypeUtils.getTypeOfElement((XmlSchemaElement)item));
            }
            if (!(item instanceof XmlSchemaChoice)) continue;
            sequenceTypesList.addAll(XsdTypeUtils.getTypeOfChoice((XmlSchemaChoice)item));
        }
        return sequenceTypesList;
    }

    private static List<String> getTypeOfContentModel(XmlSchemaContentModel contentModel) {
        ArrayList<String> allTypesOfContent = new ArrayList<String>();
        if (contentModel instanceof XmlSchemaSimpleContent) {
            allTypesOfContent.addAll(XsdTypeUtils.getTypeOfSimpleContentModel((XmlSchemaSimpleContent)contentModel));
        }
        if (contentModel instanceof XmlSchemaComplexContent) {
            allTypesOfContent.addAll(XsdTypeUtils.getTypeOfComplexContentModel((XmlSchemaComplexContent)contentModel));
        }
        if (contentModel.getContent() instanceof XmlSchemaComplexContentExtension) {
            if (((XmlSchemaComplexContentExtension)contentModel.getContent()).getBaseTypeName() != null) {
                allTypesOfContent.add(XsdTypeUtils.getTypeOfContent(contentModel.getContent()));
            }
            for (XmlSchemaAttributeOrGroupRef attr : ((XmlSchemaComplexContentExtension)contentModel.getContent()).getAttributes()) {
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                allTypesOfContent.add(XsdTypeUtils.getTypeOfAttribute((XmlSchemaAttribute)attr));
            }
        }
        return allTypesOfContent;
    }

    private static List<String> getTypeOfComplexContentModel(XmlSchemaComplexContent complexContentModel) {
        ArrayList<String> allTypesOfContentModel = new ArrayList<String>();
        if (complexContentModel.getContent() instanceof XmlSchemaComplexContentExtension) {
            if (((XmlSchemaComplexContentExtension)complexContentModel.getContent()).getBaseTypeName() != null) {
                allTypesOfContentModel.add(((XmlSchemaComplexContentExtension)complexContentModel.getContent()).getBaseTypeName().getLocalPart());
            }
            for (XmlSchemaAttributeOrGroupRef attr : ((XmlSchemaComplexContentExtension)complexContentModel.getContent()).getAttributes()) {
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                allTypesOfContentModel.add(XsdTypeUtils.getTypeOfAttribute((XmlSchemaAttribute)attr));
            }
            XmlSchemaParticle particle = ((XmlSchemaComplexContentExtension)complexContentModel.getContent()).getParticle();
            if (particle != null) {
                if (particle instanceof XmlSchemaSequence) {
                    allTypesOfContentModel.addAll(XsdTypeUtils.getTypeOfSequence((XmlSchemaSequence)particle));
                }
                if (particle instanceof XmlSchemaChoice) {
                    allTypesOfContentModel.addAll(XsdTypeUtils.getTypeOfChoice((XmlSchemaChoice)particle));
                }
            }
        }
        return allTypesOfContentModel;
    }

    private static List<String> getTypeOfSimpleContentModel(XmlSchemaSimpleContent simpleContentModel) {
        ArrayList<String> allTypesOfContentModel = new ArrayList<String>();
        if (simpleContentModel.getContent() instanceof XmlSchemaSimpleContentExtension) {
            if (((XmlSchemaSimpleContentExtension)simpleContentModel.getContent()).getBaseTypeName() != null) {
                allTypesOfContentModel.add(((XmlSchemaSimpleContentExtension)simpleContentModel.getContent()).getBaseTypeName().getLocalPart());
            }
            for (XmlSchemaAttributeOrGroupRef attr : ((XmlSchemaSimpleContentExtension)simpleContentModel.getContent()).getAttributes()) {
                if (!(attr instanceof XmlSchemaAttribute)) continue;
                allTypesOfContentModel.add(XsdTypeUtils.getTypeOfAttribute((XmlSchemaAttribute)attr));
            }
        }
        return allTypesOfContentModel;
    }

    private static String getTypeOfContent(XmlSchemaContent content) {
        if (content instanceof XmlSchemaComplexContentExtension) {
            return ((XmlSchemaComplexContentExtension)content).getBaseTypeName().getLocalPart();
        }
        return null;
    }
}

