/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.elements;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.wipo.xsd2json.schema.builders.elements.AttributeElementBuilder;
import org.wipo.xsd2json.schema.builders.elements.ChoiceElementBuilder;
import org.wipo.xsd2json.schema.builders.elements.SequenceElementBuilder;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;
import org.wipo.xsd2json.schema.builders.representation.ComplexJsonElement;

public class BaseExtensionElementBuilder {
    XmlSchemaContent baseExtension;
    String baseName;
    boolean mixedContent;
    long parentMaxOccurs;
    boolean createDefsOnlyEntry;
    File xsdFile;
    Map<String, String> typeRefAnnex;
    String jsonSchemaExt;
    String versionTxt;

    public BaseExtensionElementBuilder(XmlSchemaContent baseExtension, String baseName, boolean mixedContent, long parentMaxOccurs, boolean createDefsOnlyEntry, Map<String, String> typeRefAnnex, File xsdFile, String jsonSchemaExt, String versionTxt) {
        this.baseExtension = baseExtension;
        this.baseName = baseName;
        this.mixedContent = mixedContent;
        this.parentMaxOccurs = parentMaxOccurs;
        this.createDefsOnlyEntry = createDefsOnlyEntry;
        this.xsdFile = xsdFile;
        this.typeRefAnnex = typeRefAnnex;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    public BaseJsonElement build() {
        return this.addBaseExtension(this.baseExtension);
    }

    private BaseJsonElement addBaseExtension(XmlSchemaContent extensionElement) {
        XmlSchemaContent restCont;
        XmlSchemaContent extCont;
        ArrayList<BaseJsonElement> properties = new ArrayList<BaseJsonElement>();
        String baseTypeName = null;
        long minOcrs = 0L;
        long maxOcrs = 1L;
        if (extensionElement instanceof XmlSchemaComplexContentExtension) {
            extCont = (XmlSchemaComplexContentExtension)extensionElement;
            baseTypeName = ((XmlSchemaComplexContentExtension)extCont).getBaseTypeName().getLocalPart();
        } else if (extensionElement instanceof XmlSchemaComplexContentRestriction) {
            restCont = (XmlSchemaComplexContentRestriction)extensionElement;
            baseTypeName = ((XmlSchemaComplexContentRestriction)restCont).getBaseTypeName().getLocalPart();
        } else if (extensionElement instanceof XmlSchemaSimpleContentExtension) {
            extCont = (XmlSchemaSimpleContentExtension)extensionElement;
            baseTypeName = ((XmlSchemaSimpleContentExtension)extCont).getBaseTypeName().getLocalPart();
        } else if (extensionElement instanceof XmlSchemaSimpleContentRestriction) {
            restCont = (XmlSchemaSimpleContentRestriction)extensionElement;
            baseTypeName = ((XmlSchemaSimpleContentRestriction)restCont).getBaseTypeName().getLocalPart();
        }
        if (baseTypeName == null || baseTypeName.toLowerCase().equals("anytype") || baseTypeName.toLowerCase().equals("anyuri") || baseTypeName.toLowerCase().equals("base64binary") || baseTypeName.toLowerCase().equals("duration") || baseTypeName.toLowerCase().equals("entities") || baseTypeName.toLowerCase().equals("entity") || baseTypeName.toLowerCase().equals("hexbinary") || baseTypeName.toLowerCase().equals("id") || baseTypeName.toLowerCase().equals("idref") || baseTypeName.toLowerCase().equals("idrefs") || baseTypeName.toLowerCase().equals("language") || baseTypeName.toLowerCase().equals("name") || baseTypeName.toLowerCase().equals("ncname") || baseTypeName.toLowerCase().equals("nmtoken") || baseTypeName.toLowerCase().equals("nmtokens") || baseTypeName.toLowerCase().equals("normalizedstring") || baseTypeName.toLowerCase().equals("notation") || baseTypeName.toLowerCase().equals("qname") || baseTypeName.toLowerCase().equals("string") || baseTypeName.toLowerCase().equals("token") || baseTypeName.toLowerCase().equals("decimal") || baseTypeName.toLowerCase().equals("float") || baseTypeName.toLowerCase().equals("double") || baseTypeName.toLowerCase().equals("byte") || baseTypeName.toLowerCase().equals("int") || baseTypeName.toLowerCase().equals("integer") || baseTypeName.toLowerCase().equals("long") || baseTypeName.toLowerCase().equals("negativeinteger") || baseTypeName.toLowerCase().equals("nonnegativeinteger") || baseTypeName.toLowerCase().equals("nonpositiveinteger") || baseTypeName.toLowerCase().equals("positiveinteger") || baseTypeName.toLowerCase().equals("short") || baseTypeName.toLowerCase().equals("unsignedbyte") || baseTypeName.toLowerCase().equals("unsignedint") || baseTypeName.toLowerCase().equals("unsignedlong") || baseTypeName.toLowerCase().equals("unsignedshort") || baseTypeName.toLowerCase().equals("time") || baseTypeName.toLowerCase().equals("date") || baseTypeName.toLowerCase().equals("datetime") || baseTypeName.toLowerCase().equals("gyear") || baseTypeName.toLowerCase().equals("gday") || baseTypeName.toLowerCase().equals("gmonth") || baseTypeName.toLowerCase().equals("gyearmonth") || baseTypeName.toLowerCase().equals("gmonthday")) {
            baseTypeName = "$";
        }
        BaseJsonElement bje = new BaseJsonElement(baseTypeName, this.getType(extensionElement), minOcrs, maxOcrs, this.mixedContent ? 1L : (this.parentMaxOccurs <= 1L ? maxOcrs : this.parentMaxOccurs), this.typeRefAnnex, null, null, null, this.createDefsOnlyEntry, this.xsdFile.getPath(), this.jsonSchemaExt, this.versionTxt);
        properties.add(bje);
        List<XmlSchemaAttributeOrGroupRef> attributes = this.getAttributesOfContent(extensionElement);
        for (XmlSchemaAttributeOrGroupRef attr : attributes) {
            if (!(attr instanceof XmlSchemaAttribute)) continue;
            AttributeElementBuilder aeb = new AttributeElementBuilder((XmlSchemaAttribute)attr, this.mixedContent ? 1L : (this.parentMaxOccurs <= 1L ? maxOcrs : this.parentMaxOccurs), this.createDefsOnlyEntry, this.xsdFile, this.typeRefAnnex, this.jsonSchemaExt, this.versionTxt);
            properties.add(aeb.build());
        }
        if (extensionElement instanceof XmlSchemaComplexContentExtension && ((XmlSchemaComplexContentExtension)extensionElement).getParticle() != null) {
            BaseJsonElement particleJson = this.getParticlesOfContent(((XmlSchemaComplexContentExtension)extensionElement).getParticle());
            properties.add(particleJson);
        }
        String type = this.getType(extensionElement);
        return new ComplexJsonElement(this.baseName != null ? this.baseName : type, type, true, 0L, 1L, this.parentMaxOccurs, this.mixedContent, this.typeRefAnnex, null, properties, this.xsdFile.getPath(), this.createDefsOnlyEntry, this.jsonSchemaExt, this.versionTxt);
    }

    private BaseJsonElement getParticlesOfContent(XmlSchemaParticle particleElement) {
        if (particleElement instanceof XmlSchemaSequence) {
            SequenceElementBuilder seb = new SequenceElementBuilder((XmlSchemaSequence)particleElement, this.mixedContent, false, 0, this.parentMaxOccurs <= 1L ? ((XmlSchemaSequence)particleElement).getMaxOccurs() : this.parentMaxOccurs, this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
            return seb.build();
        }
        if (particleElement instanceof XmlSchemaChoice) {
            long prntMxOcrs = this.parentMaxOccurs;
            if (this.baseExtension instanceof XmlSchemaComplexContentExtension) {
                XmlSchemaComplexContentExtension complexContentExtension = (XmlSchemaComplexContentExtension)this.baseExtension;
                prntMxOcrs = complexContentExtension.getParticle().getMaxOccurs();
            }
            ChoiceElementBuilder ceb = new ChoiceElementBuilder((XmlSchemaChoice)particleElement, this.mixedContent, 0, prntMxOcrs, this.createDefsOnlyEntry, this.typeRefAnnex, this.xsdFile, this.jsonSchemaExt, this.versionTxt);
            return ceb.build();
        }
        return null;
    }

    private List<XmlSchemaAttributeOrGroupRef> getAttributesOfContent(XmlSchemaContent extensionElement) {
        List<Object> attributes = new ArrayList();
        if (extensionElement instanceof XmlSchemaSimpleContentExtension) {
            attributes = ((XmlSchemaSimpleContentExtension)extensionElement).getAttributes();
        }
        if (extensionElement instanceof XmlSchemaComplexContentExtension) {
            attributes = ((XmlSchemaComplexContentExtension)extensionElement).getAttributes();
        }
        if (extensionElement instanceof XmlSchemaComplexContentRestriction) {
            attributes = ((XmlSchemaComplexContentRestriction)extensionElement).getAttributes();
        }
        return attributes;
    }

    private String getType(XmlSchemaContent extensionElement) {
        String type = null;
        if (extensionElement instanceof XmlSchemaSimpleContentExtension) {
            type = ((XmlSchemaSimpleContentExtension)extensionElement).getBaseTypeName().getLocalPart();
        } else if (extensionElement instanceof XmlSchemaComplexContentExtension) {
            type = ((XmlSchemaComplexContentExtension)extensionElement).getBaseTypeName().getLocalPart();
        } else if (extensionElement instanceof XmlSchemaComplexContentRestriction) {
            type = ((XmlSchemaComplexContentRestriction)extensionElement).getBaseTypeName().getLocalPart();
        }
        return type;
    }
}

