/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.schema.builders.representation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.wipo.xsd2json.schema.builders.representation.BaseJsonElement;
import org.wipo.xsd2json.schema.builders.representation.ChoiceJsonElement;
import org.wipo.xsd2json.schema.builders.representation.ComplexJsonElement;

public class SequenceJsonElement
extends BaseJsonElement {
    private boolean mixedContent;
    private boolean nestedInSequenceComplexType;
    private Map<String, String> typeRefAnnex;
    private List<BaseJsonElement> elementsList;
    private String jsonSchemaExt;
    private String versionTxt;

    public SequenceJsonElement(String name, String schemaTypeName, boolean mixedContent, boolean nestedInSequenceComplexType, long minOccurs, long maxOccurs, long parentMaxOccurs, Map<String, String> typeRefAnnex, XmlSchemaAnnotation annotations, List<BaseJsonElement> elementsList, boolean createDefsOnlyEntry, String baseFilePath, String jsonSchemaExt, String versionTxt) {
        super(name, schemaTypeName, minOccurs, maxOccurs, parentMaxOccurs, typeRefAnnex, annotations, null, null, createDefsOnlyEntry, baseFilePath, jsonSchemaExt, versionTxt);
        if (this.requiredList != null && this.requiredList.contains("sequence")) {
            this.requiredList.remove("sequence");
        }
        this.type = new LinkedHashMap();
        this.type.put("type", "object");
        this.mixedContent = mixedContent;
        this.typeRefAnnex = typeRefAnnex;
        this.nestedInSequenceComplexType = nestedInSequenceComplexType;
        this.elementsList = elementsList;
        this.jsonSchemaExt = jsonSchemaExt;
        this.versionTxt = versionTxt;
    }

    public List<BaseJsonElement> getElementsList() {
        return this.elementsList;
    }

    public void setElementsList(List<BaseJsonElement> elementsList) {
        this.elementsList = elementsList;
    }

    @Override
    protected Map<String, Object> createDefinitionsMap() {
        LinkedHashMap<String, Object> defMap = new LinkedHashMap<String, Object>();
        if (this.elementsList != null) {
            List<String> reqList;
            if (this.mixedContent) {
                BaseJsonElement dlrStrElm = new BaseJsonElement("$", "$", 0L, 1L, this.parentMaxOccurs <= 1L ? 1L : this.parentMaxOccurs, this.typeRefAnnex, null, null, null, this.createDefsOnlyEntry, this.baseFilePath, this.jsonSchemaExt, this.versionTxt);
                this.elementsList.add(dlrStrElm);
            }
            LinkedHashMap<String, Object> propertiesMap = new LinkedHashMap<String, Object>();
            List oneOfEntrs = null;
            Object anyOfEntrs = null;
            for (BaseJsonElement elem : this.elementsList) {
                if (elem instanceof ChoiceJsonElement) {
                    Map<String, Object> compMapEntrs = elem.getDefinitions();
                    if (compMapEntrs.containsKey("oneOf")) {
                        oneOfEntrs = (List)compMapEntrs.get("oneOf");
                        compMapEntrs.remove("oneOf");
                    }
                    if (compMapEntrs.containsKey("anyOf")) {
                        oneOfEntrs = (List)compMapEntrs.get("anyOf");
                        compMapEntrs.remove("anyOf");
                    }
                    propertiesMap.putAll(compMapEntrs);
                    continue;
                }
                propertiesMap.putAll(elem.getDefinitions());
            }
            defMap.put("type", "object");
            defMap.put("additionalProperties", false);
            defMap.put("properties", propertiesMap);
            if (oneOfEntrs != null) {
                defMap.put("oneOf", oneOfEntrs);
            }
            if (anyOfEntrs != null) {
                defMap.put("anyOf", anyOfEntrs);
            }
            if ((reqList = this.getAllRequiredList()) != null && !reqList.isEmpty()) {
                defMap.put("required", reqList);
            }
        }
        return defMap;
    }

    @Override
    protected Map<String, Object> getPropertiesMap() {
        LinkedHashMap<String, Object> propertiesMap = new LinkedHashMap<String, Object>();
        for (BaseJsonElement elem : this.elementsList) {
            if (elem instanceof ComplexJsonElement) {
                if (elem.getRef() != null) {
                    LinkedHashMap<String, String> refMap = new LinkedHashMap<String, String>();
                    refMap.put("$ref", elem.getRef());
                    propertiesMap.put(elem.getLowerCamelCaseName(), refMap);
                    continue;
                }
                propertiesMap.put(elem.getLowerCamelCaseName(), elem.getType());
                continue;
            }
            propertiesMap.putAll(elem.getPropertiesMap());
        }
        return propertiesMap;
    }

    @Override
    public List<String> getAllRequiredList() {
        for (BaseJsonElement elem : this.elementsList) {
            List<String> elemReqList = elem.getRequiredList();
            if (elemReqList == null || elem.minOccurs <= 0L) continue;
            for (String elemReq : elemReqList) {
                if (this.requiredList.contains(elemReq)) continue;
                this.requiredList.add(elemReq);
            }
        }
        return this.requiredList;
    }

    @Override
    protected Map<String, Object> getPropertyForDefinition() {
        LinkedHashMap<String, Object> propDefMap = new LinkedHashMap<String, Object>();
        propDefMap.put("type", "object");
        propDefMap.put("additionalProperties", false);
        propDefMap.put("properties", this.getPropertiesMap());
        List<String> reqList = this.getAllRequiredList();
        if (reqList != null && !reqList.isEmpty()) {
            propDefMap.put("required", reqList);
        }
        return propDefMap;
    }
}

