/*
 * Decompiled with CFR 0.152.
 */
package org.wipo.xsd2json.utils;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.wipo.xsd2json.constants.TypeConstants;
import org.wipo.xsd2json.utils.NamingUtils;

public class JsonTypeUtils {
    public static Map<String, Object> createRefFromXsd(Map<String, String> typeRefAnnex, String varType, File baseXsdFile, String jsonSchemaExt) {
        String typePath = typeRefAnnex.get(varType);
        LinkedHashMap<String, Object> typeMap = new LinkedHashMap<String, Object>();
        if (typePath == null && JsonTypeUtils.primitiveVarType(varType) != null) {
            typeMap.putAll(JsonTypeUtils.primitiveVarType(varType));
        } else {
            String camelCase = NamingUtils.makeLowerCamelCase(varType);
            String jsonFilePath = JsonTypeUtils.createJsonFilePathFromXsdFilePath(baseXsdFile.getPath(), typePath);
            String transformedTypePath = "#/$defs/".concat(camelCase);
            if (!baseXsdFile.getPath().equals(typePath)) {
                transformedTypePath = jsonFilePath.concat(jsonSchemaExt).concat("#/$defs/").concat(camelCase);
            }
            typeMap.put("$ref", transformedTypePath);
        }
        return typeMap;
    }

    public static String createJsonFilePathFromXsdFilePath(String baseXsdFilePath, String typeXsdFile) {
        String[] folders;
        String lastFile;
        String commonSubstringBetween = NamingUtils.findCommonSubstring(baseXsdFilePath, typeXsdFile);
        if (!commonSubstringBetween.endsWith("\\")) {
            String[] words = commonSubstringBetween.split("\\\\");
            String lastWordAfterLastSlash = words[words.length - 1];
            int indexOfLastWord = commonSubstringBetween.lastIndexOf(lastWordAfterLastSlash);
            commonSubstringBetween = commonSubstringBetween.substring(0, indexOfLastWord);
        }
        String baseXsdStrippedFromParent = baseXsdFilePath.replace(commonSubstringBetween, "");
        String splitter = File.separator.replace("\\", "\\\\");
        int numOfSeperator = baseXsdStrippedFromParent.length() - baseXsdStrippedFromParent.replaceAll(splitter, "").length();
        String returnString = typeXsdFile.replace(commonSubstringBetween, "");
        returnString = returnString.replace("\\", "/");
        int i = 0;
        while (i < numOfSeperator) {
            returnString = "../" + returnString;
            ++i;
        }
        if (returnString.startsWith("/")) {
            returnString = returnString.substring(1);
        }
        String lastFileCamel = NamingUtils.makeLowerCamelCase("".equals(lastFile = (folders = (returnString = returnString.replace(".xsd", "")).split("/"))[folders.length - 1]) ? "baseXsdFile.getName()" : lastFile);
        return returnString.replace(lastFile, lastFileCamel);
    }

    public static Map<String, Object> primitiveVarType(String varType) {
        return TypeConstants.primitiveTypeMap.get(varType);
    }
}

